if exists (select * from sysobjects where id = object_id(N'apps') and OBJECTPROPERTY(id, N'IsUserTable') = 1) drop table apps
GO
 
CREATE TABLE apps (

  app_id int IDENTITY,
  primary key(app_id),
  app_name varchar(50) default NULL,
  app_title varchar(100) default NULL,
  app_desc text,
  app_scr_url varchar(150) default NULL,
  app_ord int default NULL,
  app_icon_urlon varchar(150) default NULL,
  app_icon_urloff varchar(150) default NULL,
  app_price_desc text,
  app_price_sc int default NULL,
  app_price_ccs int default NULL,
  app_is_active int default NULL,
  app_icon_url varchar(150) default NULL
);
GO

set IDENTITY_INSERT apps ON;

INSERT INTO apps(app_id,app_name,app_title,app_desc,app_scr_url,app_ord,app_icon_urlon,app_icon_urloff,app_price_desc,app_price_sc,app_price_ccs,app_is_active,app_icon_url)  
VALUES (1,'BugTrack','Bug Tracking System','BugTrack is a basic, yet fully functional web based Bug Tracking system that you may use as a framework to create an expanded system or use ''as is''. Great for small teams working on software projects.<br><br>Features include:<br>- Search by Project, Assigned Person, Priority, Status<br>- Sorting by any of the columns (Bug Name, Project, Priority, Assigned Person, Status)<br>- Login Authentication<br>- Administration of Users<br>- Administration of Priorities<br>- Administration of Projects<br>- Administration of Statuses<br>','images/sn-ss-bugtrack.png',20,'sn-menu-bugtrack','images/sn-menu-bugtrack.gif','Free Source Code<br>No restrictions on the usage, modifications and distribution<br>Also included with CodeCharge',NULL,NULL,1,'images/sn-icon-bugtrack.gif');
GO

INSERT INTO apps(app_id,app_name,app_title,app_desc,app_scr_url,app_ord,app_icon_urlon,app_icon_urloff,app_price_desc,app_price_sc,app_price_ccs,app_is_active,app_icon_url)  
 VALUES (2,'Links','Links','Links is a basic, yet fully functional online Link management system that you may use as a framework to create an expanded system or use ''as is''.<br><br>Features include:<br>- Link information such as Name, Category, Description and URL<br>- List of recently added Links<br>- Description Search by Keyword<br>- Users can add new Links for approval<br>- Multi-level Categories<br>- Administration and Approvals of Links<br>- Administration of Users / Members<br>- Administration of Categories<br>','images/sn-ss-links.png',80,'sn-menu-links','images/sn-menu-links.gif','Free Source Code<br>No restrictions on the usage, modifications and distribution<br>Also included with CodeCharge',NULL,NULL,1,'images/sn-icon-links.gif');
GO

INSERT INTO apps(app_id,app_name,app_title,app_desc,app_scr_url,app_ord,app_icon_urlon,app_icon_urloff,app_price_desc,app_price_sc,app_price_ccs,app_is_active,app_icon_url)
 VALUES (3,'Online Bookstore','Online Bookstore','Online BooksStore is a fully functional online store that you may use as a framework to create an expanded system or use ''as is''. It utilizes VeriSign''s Payflow Link system to verify and charge credit cards.<br><br>Features include:<br>- User Registrations<br>- Product Voting<br>- VeriSign Payflow Link integration<br>- Categories<br>- Shopping Cart<br>- Administration of Members<br>- Administration of Orders<br>- Administration of Items<br>- Administration of Categories<br>- Administration of Credit Card Types.<br>','images/sn-ss-bookstore.png',10,'sn-menu-bookstore','images/sn-menu-bookstore.gif','Free Source Code<br>No restrictions on the usage, modifications and distribution<br>Also included with CodeCharge',NULL,NULL,1,'images/sn-icon-bookstore.gif');
GO

INSERT INTO apps(app_id,app_name,app_title,app_desc,app_scr_url,app_ord,app_icon_urlon,app_icon_urloff,app_price_desc,app_price_sc,app_price_ccs,app_is_active,app_icon_url)
 VALUES (4,'Yellow Pages','Yellow Pages','This is a basic, yet fully functional web-based Yellow Pagesmapplication that you may use as a framework to create an expanded system or use it ''as is''.<br><br>Features include:<br>- Listing information such as Name, Address, City, State, Zip, Category<br>- Multi-level Categories<br>- Search by Name, Address, City, State and Zip Code<br>- Search by Category<br>- Administration of Listings<br>- Administration of Users<br>- Administration of Categories<br>','images/sn-ss-yellowpages.png',150,'sn-menu-yellowpages','images/sn-menu-yellowpages.gif','Free Source Code<br>No restrictions on the usage, modifications and distribution<br>Also included with CodeCharge',NULL,NULL,1,'images/sn-icon-yellowpages.gif');
GO

INSERT INTO apps(app_id,app_name,app_title,app_desc,app_scr_url,app_ord,app_icon_urlon,app_icon_urloff,app_price_desc,app_price_sc,app_price_ccs,app_is_active,app_icon_url)
 VALUES (5,'Classifieds','Classifieds','Online Classifieds is a basic, yet fully functional online classifieds system that you may use as a framework to create an expanded system or use ''as is''.<br><br>Features include:<br>- User Registration<br>- Multi-Level Categories<br>- VeriSign Payflow Link integration<br>- \"My Classifieds\" section<br>- Shopping Cart<br>- Administration of Members<br>- Administration of Categories<br>','images/sn-ss-classifieds.png',30,'sn-menu-classifieds','images/sn-menu-classifieds.gif','Free Source Code<br>No restrictions on the usage, modifications and distribution<br>Also included with CodeCharge',NULL,NULL,1,'images/sn-icon-classifieds.gif');
GO

INSERT INTO apps(app_id,app_name,app_title,app_desc,app_scr_url,app_ord,app_icon_urlon,app_icon_urloff,app_price_desc,app_price_sc,app_price_ccs,app_is_active,app_icon_url)
 VALUES (6,'EmplDir','Employee Directory','EmplDir is a basic, yet fully functional Employee Directory that you may use as a framework to create an expanded system or use ''as is''.<br>It is great online system for small companies.<br><br>Features include:<br>- Front page picture of the \"Employee of the Month\"<br>- Search by Name<br>- Search by Department<br>- Search by Email<br>- Sorting by any of the columns (Name, Title, Department, Work Phone, Email)<br>- Administration of Members<br>- Administration of Departments<br>','images/sn-ss-empldir.png',40,'sn-menu-empldir','images/sn-menu-empldir.gif','Free Source Code<br>No restrictions on the usage, modifications and distribution<br>Also included with CodeCharge',NULL,NULL,1,'images/sn-icon-empldir.gif');
GO

INSERT INTO apps(app_id,app_name,app_title,app_desc,app_scr_url,app_ord,app_icon_urlon,app_icon_urloff,app_price_desc,app_price_sc,app_price_ccs,app_is_active,app_icon_url)
 VALUES (7,'Events','Events','Events is a basic, yet fully functional online Event management system that you may use as a framework to create an expanded system or use ''as is''.<br><br>Features include:<br>- Event information such as Event Name, Date, Category and Presenter<br>- Search by Keyword<br>- Search by Category<br>- Users can add new Events<br>- Administration of Events<br>- Administration of Users / Members<br>- Administration of Categories<br>','images/sn-ss-events.png',50,'sn-menu-events','images/sn-menu-events.gif','Free Source Code<br>No restrictions on the usage, modifications and distribution<br>Also included with CodeCharge',NULL,NULL,1,'images/sn-icon-events.gif');
GO

INSERT INTO apps(app_id,app_name,app_title,app_desc,app_scr_url,app_ord,app_icon_urlon,app_icon_urloff,app_price_desc,app_price_sc,app_price_ccs,app_is_active,app_icon_url)
 VALUES (8,'Forum','Forum','Forum is a basic, yet fully functional Online Discussion Board that you may use as a framework to create an expanded system or use ''as is''.<br><br>Features include:<br>- Discussion Threads with Responses<br>- Search by Keyword<br>- Sorting by any of the columns (Thread, Author, Date)<br>','images/sn-ss-forum.png',60,'sn-menu-forum','images/sn-menu-forum.gif','Free Source Code<br>No restrictions on the usage, modifications and distribution<br>Also included with CodeCharge',NULL,NULL,1,'images/sn-icon-forum.gif');
GO

INSERT INTO apps(app_id,app_name,app_title,app_desc,app_scr_url,app_ord,app_icon_urlon,app_icon_urloff,app_price_desc,app_price_sc,app_price_ccs,app_is_active,app_icon_url)
 VALUES (9,'Ledger','Ledger','Ledger is an example implementation of a web-based ledger, allowing you to track bank deposits and withdrawals and view current balance.<br>','images/sn-ss-ledger.png',70,'sn-menu-ledger','images/sn-menu-ledger.gif','Free Source Code<br>No restrictions on the usage, modifications and distribution<br>Also included with CodeCharge',NULL,NULL,1,'images/sn-icon-ledger.gif');
GO

INSERT INTO apps(app_id,app_name,app_title,app_desc,app_scr_url,app_ord,app_icon_urlon,app_icon_urloff,app_price_desc,app_price_sc,app_price_ccs,app_is_active,app_icon_url)
 VALUES (10,'Metasearch','Metasearch','MetaSearch is a basic Meta-Search system that you may use as a framework to create an expanded system or use ''as is''.<br>It searches Yahoo and/or ABC news sections for specified keyword.<br><br>','images/sn-ss-metasearch.png',90,'sn-menu-metasearch','images/sn-menu-metasearch.gif','Free Source Code<br>No restrictions on the usage, modifications and distribution<br>Also included with CodeCharge',NULL,NULL,1,'images/sn-icon-metasearch.gif');
GO

INSERT INTO apps(app_id,app_name,app_title,app_desc,app_scr_url,app_ord,app_icon_urlon,app_icon_urloff,app_price_desc,app_price_sc,app_price_ccs,app_is_active,app_icon_url)
 VALUES (11,'Portal','Online Portal','Online Portal is a fully functional online web-based Portal that you may use as a framework to create an expanded system or use ''as is''.<br>It is great system for small organizations, clubs, user groups and schools.<br><br>Features include:<br>- Links, Events, News and Articles<br>- List of Club Officers<br>- News section<br>- Keyword and Category search<br>- User Registration<br>- Description Search by Keyword<br>- Users can add new Links for approval<br>- Administration and Approvals of Links<br>- Administration of Events<br>- Administration of Club Officers<br>- Administration of Users / Members<br>','images/sn-ss-portal.png',110,'sn-menu-portal','images/sn-menu-portal.gif','Free Source Code<br>No restrictions on the usage, modifications and distribution<br>Also included with CodeCharge',NULL,NULL,1,'images/sn-icon-portal.gif');
GO

INSERT INTO apps(app_id,app_name,app_title,app_desc,app_scr_url,app_ord,app_icon_urlon,app_icon_urloff,app_price_desc,app_price_sc,app_price_ccs,app_is_active,app_icon_url)
 VALUES (12,'RegForm','Registration Form','Registration form is an example of simple registration form with validation of required fields, great for use on your web site.<br>','images/sn-ss-regform.png',120,'sn-menu-regform','images/sn-menu-regform.gif','Free Source Code<br>No restrictions on the usage, modifications and distribution<br>Also included with CodeCharge',NULL,NULL,1,'images/sn-icon-regform.gif');
GO

INSERT INTO apps(app_id,app_name,app_title,app_desc,app_scr_url,app_ord,app_icon_urlon,app_icon_urloff,app_price_desc,app_price_sc,app_price_ccs,app_is_active,app_icon_url)
 VALUES (13,'TaskMan','Task Manager','TaskMan is a basic, yet fully functional web-based Task Management System that may be used as a framework to create an expanded system or use ''as is''.<br>It is a great application for small companies and organizations.<br><br>Features include:<br>- Task List with Search by Assigned Person<br>- Search Tasks by Priority<br>- Search Tasks by Status<br>- Sorting by any of the columns (Task, Project, Priority, Assigned Person, Status)<br>- Administration of Employees<br>- Administration of Priorities<br>- Administration of Projects<br>- Administration of Statuses<br><br>','images/sn-ss-taskman.png',130,'sn-menu-taskman','images/sn-menu-taskman.gif','Free Source Code<br>No restrictions on the usage, modifications and distribution<br>Also included with CodeCharge',NULL,NULL,1,'images/sn-icon-taskman.gif');
GO

INSERT INTO apps(app_id,app_name,app_title,app_desc,app_scr_url,app_ord,app_icon_urlon,app_icon_urloff,app_price_desc,app_price_sc,app_price_ccs,app_is_active,app_icon_url)
 VALUES (14,'TellAFriend','Tell-A-friend','Web-based Tell-A-Friend application allows users to enter a message and specify who to send it to.<br>The application will automatically send email message.<br>','images/sn-ss-tell-a-friend.png',140,'sn-menu-tellafriend','images/sn-menu-tellafriend.gif','Free Source Code<br>No restrictions on the usage, modifications and distribution<br>Also included with CodeCharge',NULL,NULL,1,'images/sn-icon-tellafriend.gif');
GO

INSERT INTO apps(app_id,app_name,app_title,app_desc,app_scr_url,app_ord,app_icon_urlon,app_icon_urloff,app_price_desc,app_price_sc,app_price_ccs,app_is_active,app_icon_url)
 VALUES (15,'WAP News','WAP News','WAP News is a basic, WAP compatible application outputing information in WML format, to be read on a WAP device, such as wireless phone, or a PDA.<br>','images/sn-ss-newswap.gif',100,'sn-menu-newswap','images/sn-menu-newswap.gif','Free Source Code<br>No restrictions on the usage, modifications and distribution<br>Also included with CodeCharge',NULL,NULL,1,'images/sn-icon-newswap.gif');
GO

set IDENTITY_INSERT apps OFF;

if exists (select * from sysobjects where id = object_id(N'article_catgs') and OBJECTPROPERTY(id, N'IsUserTable') = 1) drop table article_catgs
GO
 
CREATE TABLE article_catgs (

  art_cat_id int IDENTITY,
  primary key(art_cat_id),
  art_cat_name varchar(50) default NULL,
  art_cat_ord int default NULL
);
GO
set IDENTITY_INSERT article_catgs ON;


INSERT INTO article_catgs(art_cat_id,art_cat_name,art_cat_ord) 
 VALUES (1,'Database',20);
GO

INSERT INTO article_catgs(art_cat_id,art_cat_name,art_cat_ord) 
 VALUES (2,'Programming',10);
GO

INSERT INTO article_catgs(art_cat_id,art_cat_name,art_cat_ord) 
 VALUES (3,'CodeCharge',30);
GO

INSERT INTO article_catgs(art_cat_id,art_cat_name,art_cat_ord) 
 VALUES (4,'General',40);
GO

INSERT INTO article_catgs(art_cat_id,art_cat_name,art_cat_ord) 
 VALUES (6,'Tutorials',0);
GO

set IDENTITY_INSERT article_catgs OFF;

if exists (select * from sysobjects where id = object_id(N'article_contents') and OBJECTPROPERTY(id, N'IsUserTable') = 1) drop table article_contents
GO
 
CREATE TABLE article_contents (

  art_content_id int IDENTITY,
  primary key(art_content_id),
  art_id int default NULL,
  art_content_name varchar(100) default NULL,
  art_content text,
  art_content_ord int default NULL
);
GO

set IDENTITY_INSERT article_contents ON;

INSERT INTO article_contents(art_content_id,art_id,art_content_name,art_content,art_content_ord) 
 VALUES (117,22,'CodeCharge Frequently Asked Questions','<style>\r\n<!--\r\n \r\np.MsoNormal, li.MsoNormal, div.MsoNormal\r\n	{\r\n	margin:0in;\r\n	margin-bottom:.0001pt;\r\n	font-size:12.0pt;\r\n	font-family:\"Times New Roman\";}\r\nh1\r\n	{\r\n	margin-top:12.0pt;\r\n	margin-right:0in;\r\n	margin-bottom:3.0pt;\r\n	margin-left:0in;\r\n	page-break-after:avoid;\r\n	font-size:16.0pt;\r\n	font-family:Arial;}\r\nh2\r\n	{\r\n	margin:0in;\r\n	margin-bottom:.0001pt;\r\n	page-break-after:avoid;\r\n	font-size:12.0pt;\r\n	font-family:\"Times New Roman\";}\r\nh3\r\n	{\r\n	margin-top:12.0pt;\r\n	margin-right:0in;\r\n	margin-bottom:3.0pt;\r\n	margin-left:0in;\r\n	page-break-after:avoid;\r\n	font-size:13.0pt;\r\n	font-family:Arial;}\r\nh4\r\n	{\r\n	margin:0in;\r\n	margin-bottom:.0001pt;\r\n	page-break-after:avoid;\r\n	font-size:12.0pt;\r\n	font-family:Arial;\r\n	font-style:italic;}\r\nh5\r\n	{\r\n	margin:0in;\r\n	margin-bottom:.0001pt;\r\n	page-break-after:avoid;\r\n	font-size:11.0pt;\r\n	font-family:Arial;}\r\np.MsoToc1, li.MsoToc1, div.MsoToc1\r\n	{\r\n	margin:0in;\r\n	margin-bottom:.0001pt;\r\n	font-size:12.0pt;\r\n	font-family:\"Times New Roman\";}\r\np.MsoToc2, li.MsoToc2, div.MsoToc2\r\n	{\r\n	margin-top:0in;\r\n	margin-right:0in;\r\n	margin-bottom:0in;\r\n	margin-left:12.0pt;\r\n	margin-bottom:.0001pt;\r\n	font-size:12.0pt;\r\n	font-family:\"Times New Roman\";}\r\np.MsoToc3, li.MsoToc3, div.MsoToc3\r\n	{\r\n	margin-top:0in;\r\n	margin-right:0in;\r\n	margin-bottom:0in;\r\n	margin-left:24.0pt;\r\n	margin-bottom:.0001pt;\r\n	font-size:12.0pt;\r\n	font-family:\"Times New Roman\";}\r\np.MsoToc4, li.MsoToc4, div.MsoToc4\r\n	{\r\n	margin-top:0in;\r\n	margin-right:0in;\r\n	margin-bottom:0in;\r\n	margin-left:.5in;\r\n	margin-bottom:.0001pt;\r\n	font-size:12.0pt;\r\n	font-family:\"Times New Roman\";}\r\np.MsoToc5, li.MsoToc5, div.MsoToc5\r\n	{\r\n	margin-top:0in;\r\n	margin-right:0in;\r\n	margin-bottom:0in;\r\n	margin-left:48.0pt;\r\n	margin-bottom:.0001pt;\r\n	font-size:12.0pt;\r\n	font-family:\"Times New Roman\";}\r\np.MsoToc6, li.MsoToc6, div.MsoToc6\r\n	{\r\n	margin-top:0in;\r\n	margin-right:0in;\r\n	margin-bottom:0in;\r\n	margin-left:60.0pt;\r\n	margin-bottom:.0001pt;\r\n	font-size:12.0pt;\r\n	font-family:\"Times New Roman\";}\r\np.MsoToc7, li.MsoToc7, div.MsoToc7\r\n	{\r\n	margin-top:0in;\r\n	margin-right:0in;\r\n	margin-bottom:0in;\r\n	margin-left:1.0in;\r\n	margin-bottom:.0001pt;\r\n	font-size:12.0pt;\r\n	font-family:\"Times New Roman\";}\r\np.MsoToc8, li.MsoToc8, div.MsoToc8\r\n	{\r\n	margin-top:0in;\r\n	margin-right:0in;\r\n	margin-bottom:0in;\r\n	margin-left:84.0pt;\r\n	margin-bottom:.0001pt;\r\n	font-size:12.0pt;\r\n	font-family:\"Times New Roman\";}\r\np.MsoToc9, li.MsoToc9, div.MsoToc9\r\n	{\r\n	margin-top:0in;\r\n	margin-right:0in;\r\n	margin-bottom:0in;\r\n	margin-left:96.0pt;\r\n	margin-bottom:.0001pt;\r\n	font-size:12.0pt;\r\n	font-family:\"Times New Roman\";}\r\na:link, span.MsoHyperlink\r\n	{color:blue;\r\n	text-decoration:underline;}\r\na:visited, span.MsoHyperlinkFollowed\r\n	{color:purple;\r\n	text-decoration:underline;}\r\n-->\r\n</style>\r\n\r\n<div class=Section1>\r\n\r\n<p class=MsoToc1><span\r\nclass=MsoHyperlink><a href=\"#_Toc517639957\">Adding Javascript</a></span></p>\r\n\r\n<p class=MsoToc3><span\r\nclass=MsoHyperlink><a href=\"#_Toc517639958\">Adding a confirmation dialog box</a></span></p>\r\n\r\n<p class=MsoToc1><span\r\nclass=MsoHyperlink><a href=\"#_Toc517639959\">ASP</a></span></p>\r\n\r\n<p class=MsoToc3><span\r\nclass=MsoHyperlink><a href=\"#_Toc517639960\">ASP Version 2.0 or 3.0</a></span></p>\r\n\r\n<p class=MsoToc3><span\r\nclass=MsoHyperlink><a href=\"#_Toc517639961\">Executing Stored Procedures</a></span></p>\r\n\r\n<p class=MsoToc1><span\r\nclass=MsoHyperlink><a href=\"#_Toc517639962\">Databases and Database Connectivity</a></span></p>\r\n\r\n<p class=MsoToc3><span\r\nclass=MsoHyperlink><a href=\"#_Toc517639963\">DBI Modules</a></span></p>\r\n\r\n<p class=MsoToc3><span\r\nclass=MsoHyperlink><a href=\"#_Toc517639964\">Do I need a database to use\r\nCodeCharge ?</a></span></p>\r\n\r\n<p class=MsoToc3><span\r\nclass=MsoHyperlink><a href=\"#_Toc517639965\">Installing MyODBC</a></span></p>\r\n\r\n<p class=MsoToc3><span\r\nclass=MsoHyperlink><a href=\"#_Toc517639966\">MySQL database connection</a></span></p>\r\n\r\n<p class=MsoToc3><span\r\nclass=MsoHyperlink><a href=\"#_Toc517639967\">Placing a database in a secure\r\nfolder</a></span></p>\r\n\r\n<p class=MsoToc3><span\r\nclass=MsoHyperlink><a href=\"#_Toc517639968\">Using ODBC to configure a database\r\nconnection to a text or csv file</a></span></p>\r\n\r\n<p class=MsoToc3><span\r\nclass=MsoHyperlink><a href=\"#_Toc517639969\">Where to install MyODBC</a></span></p>\r\n\r\n<p class=MsoToc1><span\r\nclass=MsoHyperlink><a href=\"#_Toc517639970\">Errors and troubleshooting</a></span></p>\r\n\r\n<p class=MsoToc3><span\r\nclass=MsoHyperlink><a href=\"#_Toc517639971\">&quot;80004005 &quot;Couldn''t Use\r\n''(unknown)''; File Already in Use</a></span></p>\r\n\r\n<p class=MsoToc3><span\r\nclass=MsoHyperlink><a href=\"#_Toc517639972\">Invalid use of Null Code: 94</a></span></p>\r\n\r\n<p class=MsoToc3><span\r\nclass=MsoHyperlink><a href=\"#_Toc517639973\">Login Errors and Issues - can''t\r\nLogin</a></span></p>\r\n\r\n<p class=MsoToc3><span\r\nclass=MsoHyperlink><a href=\"#_Toc517639974\">Operation Must Use an Updateable\r\nQuery</a></span></p>\r\n\r\n<p class=MsoToc3><span\r\nclass=MsoHyperlink><a href=\"#_Toc517639975\">PHP error :\r\nopen(temp\\/sess_1de7095ab2e3a5ab132abc64c6fccc1b, O_RDWR) failed</a></span></p>\r\n\r\n<p class=MsoToc3><span\r\nclass=MsoHyperlink><a href=\"#_Toc517639976\">Syntax error in INSERT INTO\r\nstatement. (Microsoft JET Database Engine)</a></span></p>\r\n\r\n<p class=MsoToc1><span\r\nclass=MsoHyperlink><a href=\"#_Toc517639977\">General/Other</a></span></p>\r\n\r\n<p class=MsoToc3><span\r\nclass=MsoHyperlink><a href=\"#_Toc517639978\">Displaying HTML content</a></span></p>\r\n\r\n<p class=MsoToc3><span\r\nclass=MsoHyperlink><a href=\"#_Toc517639979\">Editing HTML Template files</a></span></p>\r\n\r\n<p class=MsoToc3><span\r\nclass=MsoHyperlink><a href=\"#_Toc517639980\">Header and Footer Pages</a></span></p>\r\n\r\n<p class=MsoToc3><span\r\nclass=MsoHyperlink><a href=\"#_Toc517639981\">Identity of Logged in User</a></span></p>\r\n\r\n<p class=MsoToc3><span\r\nclass=MsoHyperlink><a href=\"#_Toc517639982\">Images as Field Captions</a></span></p>\r\n\r\n<p class=MsoToc3><span\r\nclass=MsoHyperlink><a href=\"#_Toc517639983\">Norton AntiVirus Problems</a></span></p>\r\n\r\n<p class=MsoToc3><span\r\nclass=MsoHyperlink><a href=\"#_Toc517639984\">Sending Email</a></span></p>\r\n\r\n<p class=MsoToc3><span\r\nclass=MsoHyperlink><a href=\"#_Toc517639985\">Update, Delete Buttons donot appear\r\nin a record form</a></span></p>\r\n\r\n<p class=MsoToc1><span\r\nclass=MsoHyperlink><a href=\"#_Toc517639986\">HTML</a></span></p>\r\n\r\n<p class=MsoToc3><span\r\nclass=MsoHyperlink><a href=\"#_Toc517639987\">Problem with Checkbox Fields</a></span></p>\r\n\r\n<p class=MsoToc1><span\r\nclass=MsoHyperlink><a href=\"#_Toc517639988\">Installation</a></span></p>\r\n\r\n<p class=MsoToc3><span\r\nclass=MsoHyperlink><a href=\"#_Toc517639989\">Activation Failure</a></span></p>\r\n\r\n<p class=MsoToc3><span\r\nclass=MsoHyperlink><a href=\"#_Toc517639990\">Internet Activation</a></span></p>\r\n\r\n<p class=MsoToc1><span\r\nclass=MsoHyperlink><a href=\"#_Toc517639991\">MS Access</a></span></p>\r\n\r\n<p class=MsoToc3><span\r\nclass=MsoHyperlink><a href=\"#_Toc517639992\">Dates in Access</a></span></p>\r\n\r\n<p class=MsoToc1><span\r\nclass=MsoHyperlink><a href=\"#_Toc517639993\">PERL</a></span></p>\r\n\r\n<p class=MsoToc3><span\r\nclass=MsoHyperlink><a href=\"#_Toc517639994\">Global Functions</a></span></p>\r\n\r\n<p class=MsoToc1><span\r\nclass=MsoHyperlink><a href=\"#_Toc517639995\">PHP</a></span></p>\r\n\r\n<p class=MsoToc3><span\r\nclass=MsoHyperlink><a href=\"#_Toc517639996\">PHP password encryption</a></span></p>\r\n\r\n<p class=MsoToc1><span\r\nclass=MsoHyperlink><a href=\"#_Toc517639997\">Product Trial, Purchase and\r\nUpgrades</a></span></p>\r\n\r\n<p class=MsoToc3><span\r\nclass=MsoHyperlink><a href=\"#_Toc517639998\">CodeCharge Standard and\r\nProfessional</a></span></p>\r\n\r\n<p class=MsoToc3><span\r\nclass=MsoHyperlink><a href=\"#_Toc517639999\">Extending the Trial Period</a></span></p>\r\n\r\n<p class=MsoToc3><span\r\nclass=MsoHyperlink><a href=\"#_Toc517640000\">Footer on pages generated using\r\nTrial software</a></span></p>\r\n\r\n<p class=MsoToc1><span\r\nclass=MsoHyperlink><a href=\"#_Toc517640001\">Server/Deployment</a></span></p>\r\n\r\n<p class=MsoToc3><span\r\nclass=MsoHyperlink><a href=\"#_Toc517640002\">ASP on Linux</a></span></p>\r\n\r\n<p class=MsoToc1><span\r\nclass=MsoHyperlink><a href=\"#_Toc517640003\">SQL</a></span></p>\r\n\r\n<p class=MsoToc3><span\r\nclass=MsoHyperlink><a href=\"#_Toc517640004\">Inserting data into multiple tables</a></span></p>\r\n\r\n<p class=MsoToc3><span\r\nclass=MsoHyperlink><a href=\"#_Toc517640005\">Searching using ''AND'' or ''OR''\r\noperators in a search</a></span></p>\r\n\r\n<p class=MsoToc1><span\r\nclass=MsoHyperlink><a href=\"#_Toc517640006\">Using Events</a></span></p>\r\n\r\n<p class=MsoToc3><span\r\nclass=MsoHyperlink><a href=\"#_Toc517640007\">Adding data to two database tables</a></span></p>\r\n\r\n<p class=MsoNormal>&nbsp;</p>\r\n\r\n<h1><a name=\"_Toc517639753\"></a><a name=\"_Toc517639957\">Adding Javascript</a></h1>\r\n\r\n<p class=MsoNormal>&nbsp;</p>\r\n\r\n<h3><a name=\"_Toc517639754\"></a><a name=\"_Toc517639958\">Adding a confirmation dialog box</a></h3>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Summary</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>How to use javascript to launch a confirmation dialog box\r\nwhen a button is clicked.</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Symptoms</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>I would like to add javascript event code which launches a\r\nconfirmation window when the use clicks on the delete button to erase a record.\r\nWhere and how do I add the javascript code necessary to achieve this result.</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Resolution</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>The Header&amp;Footer tab of a forms property window is well\r\nsuited for adding custom HTML and Javascript code. In this particular example,\r\nassuming that the form which contains the delete button is called ''myForm'' ,\r\nthen the following code in the footer section of the Header&amp;Footer tab will\r\nlaunch a dialog window asking the user to confirm the delete action when the\r\ndelete button is pressed.</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&lt;SCRIPT Language=&quot;JavaScript&quot;&gt;</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>if (document.forms[&quot;myForm&quot;])</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>document.myForm.onsubmit=delconf;</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>function delconf() {</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>if (document.myForm.FormAction.value == ''delete'')</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''> return\r\nconfirm(''Delete record?'');</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>}</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&lt;/SCRIPT&gt;</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<b><span style=''font-size:11.0pt;font-family:Arial;''><br clear=all\r\nstyle=''page-break-before:always''>\r\n</span></b>\r\n\r\n<h1><a name=\"_Toc517639755\"></a><a name=\"_Toc517639959\">ASP</a></h1>\r\n\r\n<p class=MsoNormal>&nbsp;</p>\r\n\r\n<h3><a name=\"_Toc517639756\"></a><a name=\"_Toc517639960\">ASP Version 2.0 or 3.0</a></h3>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Summary</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>ASP Version 2.0 or 3.0</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Symptoms</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>When choosing the language for a project, the ASP options\r\nare ''ASP 2.0'' and ''ASP 2.0 &amp; Template''. Is the code that CodeCharge\r\ngenerated ASP 3.0 complaint?</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Resolution</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>The CodeCharge generated code is both ASP 2.0 and ASP 3.0\r\ncomplaint.</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<b><span style=''font-size:16.0pt;font-family:Arial;''><br clear=all style=''\r\npage-break-before:always''>\r\n</span></b>\r\n\r\n<h1>&nbsp;</h1>\r\n\r\n<h3><a name=\"_Toc517639757\"></a><a name=\"_Toc517639961\">Executing Stored Procedures</a></h3>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Summary</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>Executing stored procedures</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Symptoms</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>Does CodeCharge support the execution of database stored\r\nprocecures?</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Resolution</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>Although CodeCharge does not have native support for stored\r\nprocedures, you can write code to call and execute stored procedures from\r\nevents. From the list of available page and form events, select the appropriate\r\none and enter code to call the stored procedure. </span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>You can call the stored procedure using the default\r\nCodeCharge connection object (cn). However, if you need to get resultsets\r\nreturned, you need to use a command object as illustrated below:</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>Set cmd = CreateObject (&quot;ADODB.Command&quot;) </span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>Set rs = CreateObject (&quot;ADODB.Recordset&quot;) </span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>Set fldloop = CreateObject (&quot;ADODB.Field&quot;) </span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>Set param1 = CreateObject (&quot;ADODB.Parameter&quot;) </span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>Set param2 = CreateObject (&quot;ADODB.Parameter&quot;) </span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>Set param3 = CreateObject (&quot;ADODB.Parameter&quot;) </span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>Set cmd.ActiveConnection = cn </span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>cmd.CommandText = &quot;sp_CPU_DEL&quot; </span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>cmd.CommandType = adCmdStoredProc </span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>'' Set up a return parameter. </span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>Set param1 = cmd.CreateParameter(&quot;Return&quot;,\r\nadInteger, adParamReturnValue) </span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>cmd.Parameters.Append param1 </span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>'' Set up an output parameter. </span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>Set param2 = cmd.CreateParameter(&quot;ROWS&quot;,\r\nadInteger, adParamOutput) </span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>cmd.Parameters.Append param2 </span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>'' Set up an input parameter. </span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>Set param3 = cmd.CreateParameter(&quot;I_CPU_ID&quot;,\r\nadInteger, adParamInput) </span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>cmd.Parameters.Append param3 </span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>param3.Value = CPU_ID </span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>'' Execute command, and loop through recordset. </span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>Set rs = cmd.Execute </span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>Dim i As Integer </span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>While Not rs.EOF </span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>For Each fldloop In rs.Fields </span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>'' do something with rs.Fields(i) </span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>i = i + 1 </span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>Next fldloop </span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>i = 0 </span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>rs.MoveNext </span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>Wend </span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>rs.Close </span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''></span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<b><span style=''font-size:11.0pt;font-family:Arial;''><br clear=all\r\nstyle=''page-break-before:always''>\r\n</span></b>\r\n\r\n<h1><a name=\"_Toc517639758\"></a><a name=\"_Toc517639962\">Databases and Database Connectivity</a></h1>\r\n\r\n<p class=MsoNormal>&nbsp;</p>\r\n\r\n<h3><a name=\"_Toc517639759\"></a><a name=\"_Toc517639963\">DBI Modules</a></h3>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Summary</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>Configuring database connection in Perl.</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Symptoms</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>How do I connect to a databse using the PERL language</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Resolution</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>To connect to a database using PERL, you need to download\r\nand install the necessary DBI modules. Refer to the following locations for the\r\nmodules:</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>http://www.cpan.org/modules/by-category/07_Database_Interfaces/</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>http://dbi.symbolstone.org </span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<b><span style=''font-size:16.0pt;font-family:Arial;''><br clear=all style=''\r\npage-break-before:always''>\r\n</span></b>\r\n\r\n<h1>&nbsp;</h1>\r\n\r\n<h3><a name=\"_Toc517639760\"></a><a name=\"_Toc517639964\">Do I need a database to use CodeCharge ?</a></h3>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Summary</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>Do I need a database to use CodeCharge ?</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Symptoms</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>Is it possible to create a CodeCharge Project without using\r\na database?</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Resolution</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>The main purpose of CodeCharge is to allow you to create\r\ndynamic database driven websites. You therefore need to have a database to\r\nconnect to the project so as to achieve this goal. CodeCharge does not create\r\nthe database so you will have to create this yourself. Theoretically, you can create a project\r\nwithout a database but there is little reason why you would want to do so.\r\nCodeCharge will generate error messages when you try to generate a project that\r\nis not connected to a database but you can choose to ignore this message.</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<b><span style=''font-size:16.0pt;font-family:Arial;''><br clear=all style=''\r\npage-break-before:always''>\r\n</span></b>\r\n\r\n<h1>&nbsp;</h1>\r\n\r\n<h3><a name=\"_Toc517639761\"></a><a name=\"_Toc517639965\">Installing MyODBC</a></h3>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Summary</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>Installing MyODBC</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Symptoms</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>Help! How do I install MyODBC to connect to a MySQL server</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Resolution</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>Refer to the tutorials located at http://support.codecharge.com/tutorials.asp\r\nfor comprehensive instructions on how to install and configure MyODBC.</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<b><span style=''font-size:16.0pt;font-family:Arial;''><br clear=all style=''\r\npage-break-before:always''>\r\n</span></b>\r\n\r\n<h1>&nbsp;</h1>\r\n\r\n<h3><a name=\"_Toc517639762\"></a><a name=\"_Toc517639966\">MySQL database connection</a></h3>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Summary</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>How do you connect to a MySQL database ?</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Symptoms</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>What is the procedure of connecting to a MySQL database.</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Resolution</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>You will need to install the MyODBC driver from mysql.com</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>This is only needed during the design time. The generated\r\nprograms should be able to connect directly to the database, by its name.</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>Here are the general steps:</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>(Assuming that you already created your MySQL database)</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>1. Download and install MyODBC from www.mysql.com</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>2. Setup your ODBC connection in Start -&gt; Control Panel\r\n-&gt; ODBC.</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>3. In CodeCharge, click on Properties -&gt; Database, and on\r\nthe Yellow icon that opens OLE Database Providers. Select ODBC and then your\r\nODBC connection name.</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>Until now you should be setup enough to use CodeCharge and\r\naccess the</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>database during the design time.</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>Then:</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>5. You need to add Database Name, Login, Password and\r\nspecify the Database Type (MySQL) before generating the programs.</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>CodeCharge will generate PHPLib, which is the standard\r\nlibrary used for direct database access in PHP programs.</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<b><span style=''font-size:16.0pt;font-family:Arial;''><br clear=all style=''\r\npage-break-before:always''>\r\n</span></b>\r\n\r\n<h1>&nbsp;</h1>\r\n\r\n<h3><a name=\"_Toc517639763\"></a><a name=\"_Toc517639967\">Placing a database in a secure folder</a></h3>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Summary</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>Placing a database in a folder other than that in which the\r\nwebpages reside.</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Symptoms</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>When using Access with a OLEDB 4.0 connection to the\r\ndatabase, you have the option of copying the database to the server. When you\r\ncopy the database to the server, the database is placed in the same folder as\r\nthe web pages and a connection string is created to point to this location. </span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>However, in the interest of security, you might want to\r\nchange the location of the database to a folder which is more secure. </span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Resolution</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>When publishing a project that uses the ''Microsoft JET OLEDB\r\n4.0 Provider'', you can specify a ''Custom Connection String'' to be used in the\r\nserver. The ''Custom Connection String'' is similar to the ''Design Connection\r\nString'' that is used within CodeCharge except that it specifies an alternate\r\nlocation for the database when the pages are generated to the server. For instance if the ''Design Connection\r\nString'' is: </span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>Provider=Microsoft.Jet.OLEDB.4.0;User ID=Admin;Data\r\nSource=E:\\CodeCharge\\Projects\\myProject\\MyDatabase.mdb;Persist Security\r\nInfo=False </span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>and assuming that your pages are placed in a server folder\r\nwith the path: </span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>C:\\Inetpub\\wwwroot\\myProject</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>and you want to have them connect to a database located in:</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>C:\\Inetpub\\Databases</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>you would use the connection string: </span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>Provider=Microsoft.Jet.OLEDB.4.0;User ID=Admin;Data\r\nSource=C:\\Inetpub\\Databases\\MyDatabase.mdb;Persist Security Info=False </span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>By so doing, you bolster the security of your database by\r\nplacing it outside the web server scope. Note that you will be required to\r\nupload the database to the separate folder using an ftp client or similar\r\nmethod since CodeCharge copies the database to the same location as the web\r\npages.</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>Apart from the above said method, you could opt to use an\r\nODBC data source name (DSN) which would allow you to place your database in a\r\nsecure folder and have your project files link to it via an ODBC DSN. </span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<b><span style=''font-size:16.0pt;font-family:Arial;''><br clear=all style=''\r\npage-break-before:always''>\r\n</span></b>\r\n\r\n<h1>&nbsp;</h1>\r\n\r\n<h3><a name=\"_Toc517639764\"></a><a name=\"_Toc517639968\">Using ODBC to configure a database connection to a text or csv\r\nfile</a></h3>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Summary</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>Using ODBC to configure a database connection to a text or\r\ncsv file</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Symptoms</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>Rather than use traditional databases, you might want to use\r\na flatfile database such as a text file containing comma, tab or otherwise\r\ndelimited values.</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Resolution</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>To begin with, create a Text ODBC datasource name (DSN) on\r\nthe windows machine do the following:</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>1. In Control Panels, open the ''Data Sources (ODBC)'' option.</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>2. Click on the ''System DSN'' tab.</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>3. Click on the ''Add'' button.</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>4. From the list, select the ''Microsoft Text Driver (*.txt;\r\n*.csv)'' then click finish.</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>5. In the ''Data Source Name'' field, enter a name for your\r\nDSN such as ''myDSN''</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>6. Optionally enter a description for the DSN.</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>7. De-Select the ''Use Current Directory'' checkbox if it is\r\nchecked.</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>8. Click on the ''Select Directory'' button and navigate to\r\nthe directory where your .csv file is located and click ''Ok''.</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>9. Click ''Ok'' to close the ODBC window.</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>With your ODBC DSN created, you are now ready to connect to\r\nit from within CodeCharge:</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>1. In the Site--&gt;Properties--&gt;Database tab, click on\r\nthe yellow Icon.</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>2. In the ''Provider'' tab, select ''Microsoft OLE DB Provider\r\nfor ODBC Drivers''</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>3. In the ''Connection'' tab, use the ''Use data source name''\r\nlistbox to select the DSN you created above (MyDSN).</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>4. Click on the ''Test Connection'' button to ensure that the\r\nconnection is working.</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>5. Click ''Ok'' to close the window.</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>With this done, you can now go ahead and create pages using\r\nthe data in the .csv file. You might want to read more about using the ODBC\r\ntext driver at:\r\nhttp://msdn.microsoft.com/library/default.asp?URL=/library/psdk/dasdk/odbc4g6r.htm&quot;</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<b><span style=''font-size:16.0pt;font-family:Arial;''><br clear=all style=''\r\npage-break-before:always''>\r\n</span></b>\r\n\r\n<h1>&nbsp;</h1>\r\n\r\n<h3><a name=\"_Toc517639765\"></a><a name=\"_Toc517639969\">Where to install MyODBC</a></h3>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Summary</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>MyODBC installlation location</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Symptoms</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>I am using a MySQL database that is located on a remote ISP''s machine or a machine that I don''t have\r\ndirect access to. I understand that I have to install and configure MyODBC so\r\nas to enable CodeCharge to connect to the MySQL database. Do I have to install\r\nMyODBC on the remote server?</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Resolution</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>You don''t need to install MyODBC on the remote server so be\r\nable to connect to the database using MyODBC. MyODBC is required to be\r\ninstalled only on the local machine\r\nwhere CodeCharge is located. Once you install MyODBC, you can use it to\r\nconfigure a ODBC data source name (DSN) which will link to the MySQL database\r\non the remote server and allow CodeCharge to interact with the database. </span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<b><span style=''font-size:11.0pt;font-family:Arial;''><br clear=all\r\nstyle=''page-break-before:always''>\r\n</span></b>\r\n\r\n<h1><a name=\"_Toc517639766\"></a><a name=\"_Toc517639970\">Errors and troubleshooting</a></h1>\r\n\r\n<p class=MsoNormal>&nbsp;</p>\r\n\r\n<h3><a name=\"_Toc517639767\"></a><a name=\"_Toc517639971\">&quot;80004005 &quot;Couldn''t Use ''(unknown)''; File Already in\r\nUse</a></h3>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Summary</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>Error: &quot;80004005 &quot;Couldn''t Use ''(unknown)''; File\r\nAlready in Use&quot;</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Symptoms</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>When you try running an ASP project, you get the error\r\nmessage: &quot;80004005 &quot;Couldn''t Use ''(unknown)''; File Already in\r\nUse&quot;.</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Resolution</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>This is a Windows NT permissions problem. The account that\r\nis accessing the page doesn''t have sufficient permissions to lock the database.\r\nThe account would be either the anonymous account (by default the\r\nIUSR_&lt;machinename&gt;) or a specific user account if the page has been\r\nsecured for authenticated access. </span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>For further details about this error, please refer to the\r\nfollowing Microsoft knowledge base article </span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>http://support.microsoft.com/support/kb/articles/Q174/9/43.ASP&quot;</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<b><span style=''font-size:16.0pt;font-family:Arial;''><br clear=all style=''\r\npage-break-before:always''>\r\n</span></b>\r\n\r\n<h1>&nbsp;</h1>\r\n\r\n<h3><a name=\"_Toc517639768\"></a><a name=\"_Toc517639972\">Invalid use of Null Code: 94</a></h3>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Summary</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>Error: Invalid use of Null Code: 94</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Symptoms</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>You get the error message &quot;Invalid use of Null Code:\r\n94&quot; when you try to generate pages in CodeCharge</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Resolution</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>to overcome this problem,try the following solutions:</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>1. Upgrade Microsoft Internet Explorer to verion 5.5+</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>2. Install the latest version of the Microsoft Data Access\r\nComponents (MDAC 2.6) from http://www.microsoft.com/data/download_260rtm.htm</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<b><span style=''font-size:16.0pt;font-family:Arial;''><br clear=all style=''\r\npage-break-before:always''>\r\n</span></b>\r\n\r\n<h1>&nbsp;</h1>\r\n\r\n<h3><a name=\"_Toc517639769\"></a><a name=\"_Toc517639973\">Login Errors and Issues - can''t Login</a></h3>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Summary</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>If you create a login page and try to login, the page\r\nreturns you to the logout button instead of the required next page.</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Symptoms</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>Login problems usually result from one of the following:</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>1. The user_id in\r\nyour user table is not a numeric or autoincrement field</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>2. Wrong fields are\r\nassigned in the security section of CodeCharge.</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>3. You used a\r\nreserved keyword when naming your database table or field, for example:</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Resolution</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>1. Verify that the key field in your user table is a\r\nautoincrement, numeric field</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>2. Verify that in Site Properties, Security tab, you select\r\nthe key field in your user table as the Primary Key. You should select a\r\nnumeric, autoincrement field as Primary Key and alphanumeric/text fields for\r\nlogin and password.</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>3. Do not use reserved words like user, password, month,\r\ndate, etc. when naming your fields or tables. These words are reserved keywords\r\nin Visual Basic &amp; ASP, and should not be used in database naming.</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<b><span style=''font-size:16.0pt;font-family:Arial;''><br clear=all style=''\r\npage-break-before:always''>\r\n</span></b>\r\n\r\n<h1>&nbsp;</h1>\r\n\r\n<h3><a name=\"_Toc517639770\"></a><a name=\"_Toc517639974\">Operation Must Use an Updateable Query</a></h3>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Summary</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>ASP Returns Error &quot;Operation Must Use an Updateable\r\nQuery&quot;</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Symptoms</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>When you try to add a new record or update an existing\r\nrecord, you get the Error &quot;message Operation Must Use an Updateable\r\nQuery&quot;.</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Resolution</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>The error you are getting indicates that the database access\r\npermissions are not set correctly. For starters, if you are using Windows NT or\r\n2000, please set the security on the .mdb file and its parent directory to\r\n&quot;full-access&quot;. If you use Windows 95/98/Me, right-click on the .mdb\r\nfile and make sure that &quot;read-only&quot; is unchecked, then do the same on\r\nthe directory where your .mdb file is located. Also, note the following:</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>1) This error may occur if the account being used by\r\nInternet Information Server (IIS), (usually IUSR), does not have the correct\r\nWindows NT permissions for a file-based database or for the folder containing\r\nthe file.</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>2) Use the Windows NT File Monitor to check for file access\r\nfailures. Windows NT File Monitor is available from the following Web site:\r\n&lt;http://www.sysinternals.com&gt;. </span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>3) If you use a network path to the database (UNC or mapped\r\ndrive), check the permissions on the share, the file, and the folder. </span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>4) Check to make sure that the file and the data source name\r\n(DSN) are not marked as Exclusive.</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>5) Make sure no other process uses this mdb file.</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>6) This error may also occur when accessing a local\r\nMicrosoft Access database linked to a table where the table is in an Access\r\ndatabase on a network server. In this situation, please refer to the following\r\narticle in the Microsoft Knowledge Base for a workaround.</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>This error is attributed to the design of Microsoft products\r\nand you can read more about it at:</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>PRB: ASP Returns ''Operation Must Use an Updateable Query''\r\nError</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>http://support.microsoft.com/support/kb/articles/Q175/1/68.ASP</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<b><span style=''font-size:16.0pt;font-family:Arial;''><br clear=all style=''\r\npage-break-before:always''>\r\n</span></b>\r\n\r\n<h1>&nbsp;</h1>\r\n\r\n<h3><a name=\"_Toc517639771\"></a><a name=\"_Toc517639975\">PHP error : open(temp\\/sess_1de7095ab2e3a5ab132abc64c6fccc1b,\r\nO_RDWR) failed</a></h3>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Summary</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>When you try to view a php page, you get the error :\r\n&quot;open(temp\\/sess_1de7095ab2e3a5ab132abc64c6fccc1b, O_RDWR) failed&quot;.</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Symptoms</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>This means that PHP tried to store session information in a\r\ndirectory that does not exist.</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Resolution</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>To rectify the problem, you need to set the value of the\r\nsession_save_path argument in the php.ini file to a valid directory. The\r\nphp.ini file is usually located in your machines system folder or the folder in which php is installed. Open\r\nthis file and set its value to something like:</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>session_save_path = c:/windows/temp</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>Make sure that the directory c:/windows/temp exists on the\r\nmachine. This is where php will store session information needed to maintain\r\nstate. </span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<b><span style=''font-size:16.0pt;font-family:Arial;''><br clear=all style=''\r\npage-break-before:always''>\r\n</span></b>\r\n\r\n<h1>&nbsp;</h1>\r\n\r\n<h3><a name=\"_Toc517639772\"></a><a name=\"_Toc517639976\">Syntax error in INSERT INTO statement. (Microsoft JET Database\r\nEngine)</a></h3>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Summary</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>Syntax error in INSERT INTO statement. (Microsoft JET\r\nDatabase Engine)</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Symptoms</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>When inserting a new record on the page, the following error\r\noccurs: Syntax error in INSERT INTO statement. (Microsoft JET Database Engine).</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>This error may occur when: </span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>1. A database table name has a space ( ) in it, for example\r\n&quot;Job Quotes&quot;.</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>2. A database table or field is named using a reserved\r\nkeyword in Visual Basic / ASP, for example &quot;user&quot;,\r\n&quot;password&quot;, &quot;month&quot;, &quot;date&quot;, etc.</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Resolution</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>Change your database table or field name by renaming it to a\r\nnon-conflicting name, for example rename &quot;Job Quotes&quot; to\r\n&quot;Job_Quotes&quot; or rename &quot;month&quot; to &quot;tblmonth&quot;</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<b><span style=''font-size:11.0pt;font-family:Arial;''><br clear=all\r\nstyle=''page-break-before:always''>\r\n</span></b>\r\n\r\n<h1><a name=\"_Toc517639773\"></a><a name=\"_Toc517639977\">General/Other</a></h1>\r\n\r\n<p class=MsoNormal>&nbsp;</p>\r\n\r\n<h3><a name=\"_Toc517639774\"></a><a name=\"_Toc517639978\">Displaying HTML content</a></h3>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Summary</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>HTML database content.</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Symptoms</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>My database contains a field which holds raw HTML content.\r\nHow do I display this content using CodeCharge?</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Resolution</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>You can use a field of type Label or URL to output raw HTML.\r\nTo specify the field as containing raw HTML, open the field''s property window\r\nand select the ''HTML'' checkbox.</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<b><span style=''font-size:16.0pt;font-family:Arial;''><br clear=all style=''\r\npage-break-before:always''>\r\n</span></b>\r\n\r\n<h1>&nbsp;</h1>\r\n\r\n<h3><a name=\"_Toc517639775\"></a><a name=\"_Toc517639979\">Editing HTML Template files</a></h3>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Summary</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>Editing the HTML templates</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Symptoms</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>Can I edit the generated html templates to change the look\r\nof the page?</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Resolution</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>If your language of choice generates HTML template files,\r\nyou can import this into a HTML editor and edit them to suit your needs.\r\nHowever, in the process of editing the HTML templates, be careful not to change\r\nany of the text that is enclosed is curly braces {Example}. This text acts a a\r\nplaceholder to mark where dynamic content will be included. After the script\r\nfiles retrieve data from the database, they use these placeholders to place the\r\nretrieved data in its appropriate location. </span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>When you open HTML files in some editors (Microsoft\r\nFrontpage Express for example), the editor strips the file of the unknown tag.\r\nThis will potentially make the file unusable so such editors should be avoided.</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<b><span style=''font-size:16.0pt;font-family:Arial;''><br clear=all style=''\r\npage-break-before:always''>\r\n</span></b>\r\n\r\n<h1>&nbsp;</h1>\r\n\r\n<h3><a name=\"_Toc517639776\"></a><a name=\"_Toc517639980\">Header and Footer Pages</a></h3>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Summary</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>The Header and Footer Pages</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Symptoms</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>What are the Header and Footer page for.</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Resolution</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>When you add a page to your project and designate it as a\r\nHeader or a Footer page, the content of that page will appear at the top or\r\nbottom of every other page in you project respectively. The Header and Footer\r\npage are usually used to add navigational content that applies to the entire\r\nsite.</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>A thing to note about Header and Footer pages is that you\r\ncan''t add any event code to these pages. </span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<b><span style=''font-size:16.0pt;font-family:Arial;''><br clear=all style=''\r\npage-break-before:always''>\r\n</span></b>\r\n\r\n<h1>&nbsp;</h1>\r\n\r\n<h3><a name=\"_Toc517639777\"></a><a name=\"_Toc517639981\">Identity of Logged in User</a></h3>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Summary</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>Identifying the logged in user.</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Symptoms</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>How can I capture the identity of the currently logged in\r\nuser?</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Resolution</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>Under the inbuilt CodeCharge login / authentication system,\r\nwhen a user successfully logs in to your website, a session variable called\r\n&quot;UserID&quot; is set which contains the primary key value that uniquely\r\nidentifies the user. Later on in the website, you can capture this session\r\nvariable if you need to know further details about the user or use the value in\r\na another form. </span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>To capture the &quot;UserID&quot; session variable, add an\r\ninput parameter to the form in question and make sure that the variable name is\r\n''UserID''. If you are using a case sensitive language such as PHP, make sure\r\nthat the name appears exactly as shown. For the Type of the input parameter,\r\nselect ''Session'' as opposed to &quot;Param&quot; so that CodeCharge knows that\r\nit is dealing with a session variable and not a form or URL variable which\r\nwould be dealt with differently.</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<b><span style=''font-size:16.0pt;font-family:Arial;''><br clear=all style=''\r\npage-break-before:always''>\r\n</span></b>\r\n\r\n<h1>&nbsp;</h1>\r\n\r\n<h3><a name=\"_Toc517639778\"></a><a name=\"_Toc517639982\">Images as Field Captions</a></h3>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Summary</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>Using images as field captions</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Symptoms</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>Can I use images as field captions?</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Resolution</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>Normally, the caption of a form field contains text which\r\ndescribes the use of the field. However, you can enter HTML code into the\r\n''Caption'' of a field. For instance, if you want an image to be displayed\r\ninstead of plain text, you can enter HTML code like that shown below into the\r\nfield caption:</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&lt;img src = ''./images/my_image.jpg''&gt;</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<b><span style=''font-size:16.0pt;font-family:Arial;''><br clear=all style=''\r\npage-break-before:always''>\r\n</span></b>\r\n\r\n<h1>&nbsp;</h1>\r\n\r\n<h3><a name=\"_Toc517639779\"></a><a name=\"_Toc517639983\">Norton AntiVirus Problems</a></h3>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Summary</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>Norton AntiVirus prevents CodeCharge and/or ASP programs\r\nfrom running</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Symptoms</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>When you run CodeCharge, Norton AntiVirus displays the\r\nfolowing message:</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>Alert</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>File: Program</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>Object: FileSystemObject (FileSystem Object)</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>Activity: OpenTextFile</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>Action:</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>1) Stop this script (recommended)</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>2) Allow this activity once</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>3) Allow the entire script once</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Resolution</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>CodeCharge makes extensive use of JavaScripts, which Norton\r\nAntiVirus detects and prevents from running.</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>To resolve the problem:</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>1. Disable Script Blocking Technology in Norton AntiVirus.\r\nRefer to the site below for instructions:</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>http://service1.symantec.com/SUPPORT/nav.nsf/aab56492973adccd8825694500552355/399a443be88ce25788256a0e0068e180?OpenDocument&amp;Highlight=0,block\r\n</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>2. If you don''t see the option to prevent script blocking,\r\nrun &quot;regedit.exe&quot; and search for Scripting.Filesystemobject, then\r\nclear its value.</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>You may also try removing the file C:\\Program Files\\Common\r\nFiles\\Symantec Shared\\Script Blocking\\scrblock.dll altogether.</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<b><span style=''font-size:16.0pt;font-family:Arial;''><br clear=all style=''\r\npage-break-before:always''>\r\n</span></b>\r\n\r\n<h1>&nbsp;</h1>\r\n\r\n<h3><a name=\"_Toc517639780\"></a><a name=\"_Toc517639984\">Sending Email</a></h3>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Summary</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>Sending Email</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Symptoms</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>How do you send email using the contents of a form and/or\r\ndatabase.</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Resolution</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>Email sending functionality is dependent on the language you\r\nare using as well as the database server that you use to server your pages. The\r\nTellAFriend example application which comes bundled with CodeCharge contain\r\ncode which demonstrates how to implement email functionality. Refer to the\r\nReadme.txt file in the example folder for a listing of code in ASP, Cold Fusion, JSP, Perl and PHP.</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<b><span style=''font-size:16.0pt;font-family:Arial;''><br clear=all style=''\r\npage-break-before:always''>\r\n</span></b>\r\n\r\n<h1>&nbsp;</h1>\r\n\r\n<h3><a name=\"_Toc517639781\"></a><a name=\"_Toc517639985\">Update, Delete Buttons donot appear in a record form</a></h3>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Summary</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>Update, Delete Buttons donot appear in a record form even\r\nthough you have specified that they should be included.</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Symptoms</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>You have a record form for which you have specified that all\r\nthe buttons should be included [Insert, Update, Delete, Cancel]. However, when\r\nyou generate the form and view it, only the ''Insert'' and ''Cancel'' buttons show.</span></p>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&nbsp;</span></p>\r\n\r\n<h5>Resolution</h5>\r\n\r\n<p class=MsoNormal><span style=''font-size:11.0pt;\r\nfont-family:Arial''>The buttons in a ''Record'' form are set to appear\r\nselectively. By this, the ''Update'', ''Delete'' and ''Cancel'' buttons will only\r\nappear if there is some data in the form fields. This is to say that if you\r\nretrieve information from a database or pass the information to the form using\r\na different method, then the three buttons mentioned above will be v',1);
GO

INSERT INTO article_contents(art_content_id,art_id,art_content_name,art_content,art_content_ord) 
 VALUES (122,21,'I. Introduction','\n<div class=Section6>\r\n\r\n<p class=ChapterSubtitle>By way of introduction, let us take a moment to set\r\nthe ground for the exercise ahead.</p>\r\n\r\n<div>\r\n\r\n<table cellspacing=0 cellpadding=0 hspace=0 vspace=0 height=56 align=left>\r\n <tr>\r\n  <td valign=top align=left height=56 style=''padding-top:0in;padding-right:\r\n  3.0pt;padding-bottom:0in;padding-left:3.0pt''>\r\n  <p class=BodyTextKeep style=''line-height:42.05pt;''><span style=''font-size:58.5pt;text-transform:\r\n  uppercase;''>C</span></p>\r\n  </td>\r\n </tr>\r\n</table>\r\n\r\n</div>\r\n\r\n<p class=BodyTextKeep>odeCharge is a revolutionary code-generating tool\r\ndesigned for web developers, Internet consultants, application programmers, and\r\nwebmasters who need to speed up the deployment of database-driven web\r\napplications. Anyone with a little database knowledge can now easily connect a\r\ndatabase to the web by using CodeCharge. You can quickly generate dynamic,\r\nbug-free web sites in almost any programming language. CodeCharge provides the\r\nfastest, easiest way to build web applications that access and update data in\r\nreal time, taking full advantage of ASP, JSP, PHP, Perl, ColdFusion and other\r\nserver technologies to add business logic. You also have the choice of using\r\nvarious relational databases including Oracle, Sybase, MySQL, PostgreSQL,\r\nMicrosoft SQL Server and Microsoft Access. </p>\r\n\r\n<h2 style=''margin-left:0in;text-indent:0in''><a name=\"_Toc516936319\">1.<span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Objective</a></h2>\r\n\r\n<p class=MsoBodyText>This tutorial takes you through the steps of creating an\r\nEvent Management Website with a database backend. The goal of the tutorial is\r\nto provide you with enough information such that you can design websites of\r\nyour own as soon as possible. </p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>In short, the Event Management Website will provide a\r\nrobust environment for managing events. Among the features the website will\r\nhave are: event listing, member registration, email notification to registered\r\nusers, online administration area and varied access to various features based\r\non security level. As mentioned above, you have the choice of implementing the\r\napplication in ASP, JSP, PHP, Cold Fusion or Perl. Regardless of your language\r\nof choice, during the course of the tutorial you will become acquainted with\r\nthe tools and techniques that are involved in the making of a database driven\r\nwebsite. </p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<h2 style=''margin-left:0in;text-indent:0in''><a name=\"_Toc515701413\"></a><a\r\nname=\"_Toc516936320\">2.<span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Prerequisites</a></h2>\r\n\r\n<p class=MsoBodyText>For the most part, this tutorial attempts to provide as\r\nmuch information as possible. However, it is assumed that: </p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''><span style=''font-family:Wingdings''><span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span>You know how to create or setup a basic database (e.g.\r\nMS Access, MySQL)</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''><span style=''font-family:Wingdings''><span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span>You have access to a web server, such as Apache on\r\nLinux or PWS or IIS on Windows.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>If your environment of choice is PHP and MySQL, it is\r\nadvisable that you first read the PHP/MySQL Tutorial located at <span\r\nclass=MsoHyperlink><span style=''font-size:10.0pt;font-family:Arial;''><a\r\nhref=\"http://hotwired.lycos.com/webmonkey/99/21/index2a.html\">http://hotwired.lycos.com/webmonkey/99/21/index2a.html</a>.</span></span></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<h2 style=''margin-left:0in;text-indent:0in''><a name=\"_Toc515701414\"></a><a\r\nname=\"_Toc516936321\">3.<span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Specifications/Goals</a></h2>\r\n\r\n<p class=MsoNormal>&nbsp;</p>\r\n\r\n<p class=MsoBodyText align=left style=''text-align:left''>The specifications\r\nbelow outline the basic features of the planned website:<br><br></p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''><span style=''font-family:Wingdings''><span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span>The website will contain a listing of events and\r\nrelevant details such as event name, date, description and location.</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''><span style=''font-family:Wingdings''><span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span>Users will be able to search the events by event name,\r\nlocation and date range.</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''><span style=''font-family:Wingdings''><span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span>Each event will be assigned a location from a preset\r\nlist of locations such as San Francisco Area, Peninsula, East Bay, etc.</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''><span style=''font-family:Wingdings''><span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span>Users can register to be notified about new events in\r\ntheir area.</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''><span style=''font-family:Wingdings''><span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span>Users will be able to edit their online profiles i.e.\r\nchange their location, email address, name, etc.</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''><span style=''font-family:Wingdings''><span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span>Registered users will be able to submit their own\r\nevents subject to approval by the website administrators or editors.</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''><span style=''font-family:Wingdings''><span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span>The administrators can designate any of the members as\r\neditors, thus allowing them to approve or deactivate events added by regular\r\nmembers.</p>\r\n\r\n<p class=MsoNormal>&nbsp;</p>\r\n\r\n<h2 style=''margin-left:0in;text-indent:0in''><a name=\"_Toc516936322\">4.<span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Conventions</a></h2>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>We have used a number of different styles of text and\r\nlayout in this manual to help differentiate between the different kinds of\r\ninformation. Here are examples of the styles we use and an explanation of what\r\nthey mean:</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''><span style=''font-family:Wingdings''><span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span>Bullets are indented and appear with a box marking each\r\nnew bullet point.</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.25in''>&nbsp;</p>\r\n\r\n<p class=MsoBodyText><b>Important words</b> are in bold type font.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>Words that appear in the programs&#8217; user interface in menus\r\nlike <span class=ScreenMenusNames><u><span style=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>F</span></u></span><span\r\nclass=ScreenMenusNames><span style=''font-size:11.0pt;\r\nfont-family:\"Microsoft Sans Serif\";''>ile</span></span>\r\nand <u><span style=''font-size:11.0pt;font-family:\r\n\"Microsoft Sans Serif\"''>E</span></u><span style=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\"''>dit </span>are in the Microsoft Sans\r\nSerif font.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<div style=''border:solid white .75pt;border-bottom:none;padding:6.0pt 6.0pt 0in 6.0pt;\r\nbackground:#E5E5E5;''>\r\n\r\n<p class=BlockQuotationFirst>Note:</p>\r\n\r\n</div>\r\n\r\n<div style=''border:solid white .75pt;padding:12.0pt 12.0pt 12.0pt 12.0pt;\r\nbackground:#F9F9F9;''>\r\n\r\n<p class=BlockQuotation>Important information comes in boxes like this.</p>\r\n\r\n</div>\r\n\r\n<p class=MsoBodyText>Words that represent user &#8216;<span class=UserSelection><span\r\nstyle=''font-size:11.0pt;font-family:Arial''>input</span></span>&#8217;\r\nor &#8216;<span class=UserSelection><span style=''font-size:11.0pt;font-family:Arial''>selection&#8217;</span></span> are surrounded by single\r\nquotation marks in italicized <span class=UserSelection><span style=''font-size:\r\n11.0pt;font-family:Arial''>Arial</span></span> font. </p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>Keys that you press on the keyboard, like <i>ctrl</i> and <i>Enter</i>,\r\nare in italics.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>Code that you can type into the program and run appears in\r\na gray box: and in the Arial font.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=Code>sWhere=replace(sWhere, &#8216;''&#8216; &amp; GetParam(&#8216;start_date&#8217;) &amp;\r\n&#8216;''&#8216;, &#8216;#&#8217; &amp; GetParam(&#8216;start_date&#8217;) &amp; &#8216;#&#8217;)</p>\r\n\r\n<p class=Code>sWhere=replace(sWhere, &#8216;''&#8216; &amp; GetParam(&#8216;end_date&#8217;) &amp; &#8216;''&#8216;,\r\n&#8216;#&#8217; &amp; GetParam(&#8216;end_date&#8217;) &amp; &#8216;#&#8217;)</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<h2 style=''margin-left:0in;text-indent:0in''><a name=\"_Toc516936323\">5.<span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Customer Support</a></h2>\r\n\r\n<p class=MsoBodyText>If you find a mistake in this document, please check our\r\nwebsite to see if a later revised version has been posted. If not, tell us\r\nabout the problem and we shall do everything we can to answer promptly and\r\nrectify the issue. You can reach our support staff by navigating to our online\r\nsupport site at <span class=MsoHyperlink><span style=''font-size:10.0pt;\r\nfont-family:Arial;''><a\r\nhref=\"http://support.codecharge.com/\">http://support.codecharge.com</a>.</span></span></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n\r\n<\r\n<',1);
GO

INSERT INTO article_contents(art_content_id,art_id,art_content_name,art_content,art_content_ord) 
 VALUES (123,21,'II. Designing the Database','\n<p class=MsoNormal>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>The first thing to do is design the Events database. We demonstrate how to do this using Microsoft Access but this is not to say that you are limited to using only this product. We opted to use Microsoft Access largely due to its availability and ease of use. Note that in our case, we have the database software residing on the local computer. In the event that the database is to be located on a network machine, it would be advisable to set up an ODBC connection to the Access database and then use Microsoft Access as the front-end when creating the necessary tables. Instructions on how to setup an ODBC connection will be provided. Also note that in lieu of using MS Access, we will also provide the necessary SQL scripts if you prefer to create your tables manually, using another database such as MySQL or Microsoft SQL Server. Refer\r\nto <b>Appendix-C</b> for the scripts.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>The database will store all the information that will be made available on the web and in line with the relational database design paradigm, the information will be divided into several tables each representing separate but related entities. For instance, there will be a table for Locations (San Francisco, East Bay, etc), another table for Users/Members (Name, email address) and of course a table for the list of Events.</p>\r\n\r\n<p class=MsoBodyText><br>\r\nOpen MS Access and start by creating a new Access database named &#8216;<span\r\nclass=UserSelection><span style=''font-size:11.0pt;\r\nfont-family:Arial''>Events.mdb&#8217;</span></span>. Save the database file to the folder which will serve as your file repository for the duration of this exercise. Note that this folder is different from the location where you will eventually deploy your website pages. With your database file saved, you will be presented with a window similar to the one shown below:</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText align=center style=''text-align:center''><img border=0 width=480 height=346\r\nsrc=\"./UserImages/yessoftware/image003.gif\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>From among the list of <span class=ScreenMenusNames><span\r\nstyle=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Objects</span></span> in the left pane,\r\nselect <span class=ScreenMenusNames><span style=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Tables</span></span>\r\nthen double click on <span class=ScreenMenusNames><span style=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Create table in Design</span></span> view to bring up the\r\nwindow shown below:</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText align=center style=''text-align:center''><img border=0 width=579 height=352\r\nsrc=\"./UserImages/yessoftware/image004.gif\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>Create the two fields as shown above, making sure to set the &#8216;<span class=UserSelection><span style=''font-size:11.0pt;font-family:Arial''>location_id&#8217;</span></span> field as the primary\r\nkey.  To designate a field(s) as the\r\nprimary key, highlight the field(s) then click on the <img border=0 width=23 height=23\r\nsrc=\"./UserImages/yessoftware/image005.gif\"> button. When done, save the table as &#8216;<span\r\nclass=UserSelection><span style=''font-size:11.0pt;\r\nfont-family:Arial''>locations&#8217;</span></span><b>. </b></p>\r\n\r\n<p class=MsoNormal style=''margin-left:.25in''><b>&nbsp;</b></p>\r\n\r\n<table border=1 cellspacing=0 cellpadding=0 style=''margin-left:.45in;\r\n border-collapse:collapse;border:none;''>\r\n <tr>\r\n  <td width=196 valign=top style=''width:147.0pt;border:solid windowtext .5pt;\r\n  background:#CCCCCC;\r\n  padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText align=center style=''text-align:center''><b>Field</b></p>\r\n  </td>\r\n  <td width=431 valign=top style=''width:323.4pt;border:solid windowtext .5pt;\r\n  border-left:none;background:#CCCCCC;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText align=center style=''text-align:center''><b>Use</b></p>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td width=196 valign=top style=''width:147.0pt;border:solid windowtext .5pt;\r\n  border-top:none;background:#E5E5E5;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText>location_id</p>\r\n  </td>\r\n  <td width=431 valign=top style=''width:323.4pt;border-top:none;border-left:\r\n  none;border-bottom:solid windowtext .5pt;border-right:solid windowtext .5pt;\r\n  background:#F2F2F2;padding:\r\n  0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText>Primary key &#8211; has to be unique for each record</p>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td width=196 valign=top style=''width:147.0pt;border:solid windowtext .5pt;\r\n  border-top:none;background:#E5E5E5;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText>location</p>\r\n  </td>\r\n  <td width=431 valign=top style=''width:323.4pt;border-top:none;border-left:\r\n  none;border-bottom:solid windowtext .5pt;border-right:solid windowtext .5pt;\r\n  background:#F2F2F2;padding:\r\n  0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText>Contains location names such as &#8216;San Francisco&#8217;</p>\r\n  </td>\r\n </tr>\r\n</table>\r\n\r\n<p class=MsoNormal style=''margin-left:.25in''>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>Once again, click on <span class=ScreenMenusNames><span\r\nstyle=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Create table in Design view </span></span>to\r\nadd another table as illustrated below:</p>\r\n\r\n<p class=MsoNormal align=center style=''margin-left:.25in;text-align:center''><br><img border=0 width=517 height=429\r\nsrc=\"./UserImages/yessoftware/image006.jpg\"><br><br></p>\r\n\r\n<p class=MsoBodyText align=left style=''text-align:left''>Designate the &#8216;<span\r\nclass=UserSelection><span style=''font-size:11.0pt;\r\nfont-family:Arial''>member_id&#8217;</span></span> field as the primary key and save\r\nthe table as &#8216;<span class=UserSelection><span style=''font-size:11.0pt;font-family:Arial''>members&#8217;</span></span>.<br><br></p>\r\n\r\n<div align=center>\r\n\r\n<table border=1 cellspacing=0 cellpadding=0 style=''margin-left:.45in;\r\n border-collapse:collapse;border:none;''>\r\n <tr>\r\n  <td width=145 valign=top style=''width:108.6pt;border:solid windowtext .5pt;\r\n  background:#CCCCCC;\r\n  padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText align=center style=''text-align:center''><b>Field</b></p>\r\n  </td>\r\n  <td width=465 valign=top style=''width:348.6pt;border:solid windowtext .5pt;\r\n  border-left:none;background:#CCCCCC;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText align=center style=''text-align:center''><b>Use</b></p>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td width=145 valign=top style=''width:108.6pt;border:solid windowtext .5pt;\r\n  border-top:none;background:#E5E5E5;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText>member_id </p>\r\n  </td>\r\n  <td width=465 valign=top style=''width:348.6pt;border-top:none;border-left:\r\n  none;border-bottom:solid windowtext .5pt;border-right:solid windowtext .5pt;\r\n  background:#F2F2F2;padding:\r\n  0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText>Primary key </p>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td width=145 valign=top style=''width:108.6pt;border:solid windowtext .5pt;\r\n  border-top:none;background:#E5E5E5;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText>member_name</p>\r\n  </td>\r\n  <td width=465 valign=top style=''width:348.6pt;border-top:none;border-left:\r\n  none;border-bottom:solid windowtext .5pt;border-right:solid windowtext .5pt;\r\n  background:#F2F2F2;padding:\r\n  0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText>Members login/username of choice</p>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td width=145 valign=top style=''width:108.6pt;border:solid windowtext .5pt;\r\n  border-top:none;background:#E5E5E5;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText>real_name</p>\r\n  </td>\r\n  <td width=465 valign=top style=''width:348.6pt;border-top:none;border-left:\r\n  none;border-bottom:solid windowtext .5pt;border-right:solid windowtext .5pt;\r\n  background:#F2F2F2;padding:\r\n  0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText>Real names of members such us &#8216;John Smith&#8217;</p>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td width=145 valign=top style=''width:108.6pt;border:solid windowtext .5pt;\r\n  border-top:none;background:#E5E5E5;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText>member_email</p>\r\n  </td>\r\n  <td width=465 valign=top style=''width:348.6pt;border-top:none;border-left:\r\n  none;border-bottom:solid windowtext .5pt;border-right:solid windowtext .5pt;\r\n  background:#F2F2F2;padding:\r\n  0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText>Member email for email notification</p>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td width=145 valign=top style=''width:108.6pt;border:solid windowtext .5pt;\r\n  border-top:none;background:#E5E5E5;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText>location_id</p>\r\n  </td>\r\n  <td width=465 valign=top style=''width:348.6pt;border-top:none;border-left:\r\n  none;border-bottom:solid windowtext .5pt;border-right:solid windowtext .5pt;\r\n  background:#F2F2F2;padding:\r\n  0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText>Members location, which they will select based on the\r\n  locations table</p>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td width=145 valign=top style=''width:108.6pt;border:solid windowtext .5pt;\r\n  border-top:none;background:#E5E5E5;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText>password</p>\r\n  </td>\r\n  <td width=465 valign=top style=''width:348.6pt;border-top:none;border-left:\r\n  none;border-bottom:solid windowtext .5pt;border-right:solid windowtext .5pt;\r\n  background:#F2F2F2;padding:\r\n  0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText>Member password for access to member area(s)</p>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td width=145 valign=top style=''width:108.6pt;border:solid windowtext .5pt;\r\n  border-top:none;background:#E5E5E5;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText>security_level</p>\r\n  </td>\r\n  <td width=465 valign=top style=''width:348.6pt;border-top:none;border-left:\r\n  none;border-bottom:solid windowtext .5pt;border-right:solid windowtext .5pt;\r\n  background:#F2F2F2;padding:\r\n  0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText>Access level, which will be 1 for regular members, 2 for\r\n  editors and 3 for the administrators</p>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td width=145 valign=top style=''width:108.6pt;border:solid windowtext .5pt;\r\n  border-top:none;background:#E5E5E5;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText>date_registered</p>\r\n  </td>\r\n  <td width=465 valign=top style=''width:348.6pt;border-top:none;border-left:\r\n  none;border-bottom:solid windowtext .5pt;border-right:solid windowtext .5pt;\r\n  background:#F2F2F2;padding:\r\n  0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText>Date and time when the user registered; kept for\r\n  statistical reasons</p>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td width=145 valign=top style=''width:108.6pt;border:solid windowtext .5pt;\r\n  border-top:none;background:#E5E5E5;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText>is_notified</p>\r\n  </td>\r\n  <td width=465 valign=top style=''width:348.6pt;border-top:none;border-left:\r\n  none;border-bottom:solid windowtext .5pt;border-right:solid windowtext .5pt;\r\n  background:#F2F2F2;padding:\r\n  0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText>If this field is set to 1, the user will be notified of\r\n  new events in his area</p>\r\n  </td>\r\n </tr>\r\n</table>\r\n\r\n</div>\r\n\r\n<p class=MsoNormal style=''margin-left:.25in''><br><br></p>\r\n\r\n<p class=MsoBodyText>Click on <span class=ScreenMenusNames><span\r\nstyle=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Create table in Design view</span></span>\r\nto add another table as illustrated below:</p>\r\n\r\n<p class=MsoBodyText align=center style=''text-align:center''><br><img border=0 width=539 height=403\r\nsrc=\"./UserImages/yessoftware/image007.jpg\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>Designate the &#8216;<span class=UserSelection><span\r\nstyle=''font-size:11.0pt;font-family:Arial''>event_id&#8217;</span></span>\r\nfield as the primary key and save the table as &#8216;<span class=UserSelection><span\r\nstyle=''font-size:11.0pt;font-family:Arial''>events&#8217;</span></span>.\r\nAs you probably guessed, this table is going to be used to store information\r\nabout the events.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<table border=1 cellspacing=0 cellpadding=0 style=''margin-left:.45in;\r\n border-collapse:collapse;border:none;''>\r\n <tr>\r\n  <td width=180 valign=top style=''width:135.0pt;border:solid windowtext .5pt;\r\n  background:#CCCCCC;\r\n  padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><b>Field</b></p>\r\n  </td>\r\n  <td width=392 valign=top style=''width:294.0pt;border:solid windowtext .5pt;\r\n  border-left:none;background:#CCCCCC;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><b>Use</b></p>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td width=180 valign=top style=''width:135.0pt;border:solid windowtext .5pt;\r\n  border-top:none;background:#E5E5E5;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText>event_id</p>\r\n  </td>\r\n  <td width=392 valign=top style=''width:294.0pt;border-top:none;border-left:\r\n  none;border-bottom:solid windowtext .5pt;border-right:solid windowtext .5pt;\r\n  background:#F2F2F2;padding:\r\n  0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText>Primary Key</p>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td width=180 valign=top style=''width:135.0pt;border:solid windowtext .5pt;\r\n  border-top:none;background:#E5E5E5;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText>event_name</p>\r\n  </td>\r\n  <td width=392 valign=top style=''width:294.0pt;border-top:none;border-left:\r\n  none;border-bottom:solid windowtext .5pt;border-right:solid windowtext .5pt;\r\n  background:#F2F2F2;padding:\r\n  0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText>Name of the event</p>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td width=180 valign=top style=''width:135.0pt;border:solid windowtext .5pt;\r\n  border-top:none;background:#E5E5E5;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText>event_description</p>\r\n  </td>\r\n  <td width=392 valign=top style=''width:294.0pt;border-top:none;border-left:\r\n  none;border-bottom:solid windowtext .5pt;border-right:solid windowtext .5pt;\r\n  background:#F2F2F2;padding:\r\n  0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText>Description of the event</p>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td width=180 valign=top style=''width:135.0pt;border:solid windowtext .5pt;\r\n  border-top:none;background:#E5E5E5;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText>event_date</p>\r\n  </td>\r\n  <td width=392 valign=top style=''width:294.0pt;border-top:none;border-left:\r\n  none;border-bottom:solid windowtext .5pt;border-right:solid windowtext .5pt;\r\n  background:#F2F2F2;padding:\r\n  0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText>Date of the event</p>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td width=180 valign=top style=''width:135.0pt;border:solid windowtext .5pt;\r\n  border-top:none;background:#E5E5E5;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText>location_id</p>\r\n  </td>\r\n  <td width=392 valign=top style=''width:294.0pt;border-top:none;border-left:\r\n  none;border-bottom:solid windowtext .5pt;border-right:solid windowtext .5pt;\r\n  background:#F2F2F2;padding:\r\n  0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText>Event location id, based on the <b>locations</b> table</p>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td width=180 valign=top style=''width:135.0pt;border:solid windowtext .5pt;\r\n  border-top:none;background:#E5E5E5;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText>member_id</p>\r\n  </td>\r\n  <td width=392 valign=top style=''width:294.0pt;border-top:none;border-left:\r\n  none;border-bottom:solid windowtext .5pt;border-right:solid windowtext .5pt;\r\n  background:#F2F2F2;padding:\r\n  0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText>ID of the user/member or the administrator who submitted\r\n  the event</p>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td width=180 valign=top style=''width:135.0pt;border:solid windowtext .5pt;\r\n  border-top:none;background:#E5E5E5;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText>date_update</p>\r\n  </td>\r\n  <td width=392 valign=top style=''width:294.0pt;border-top:none;border-left:\r\n  none;border-bottom:solid windowtext .5pt;border-right:solid windowtext .5pt;\r\n  background:#F2F2F2;padding:\r\n  0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText>Date the event was added or the last date when the event\r\n  was updated</p>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td width=180 valign=top style=''width:135.0pt;border:solid windowtext .5pt;\r\n  border-top:none;background:#E5E5E5;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText>is_active</p>\r\n  </td>\r\n  <td width=392 valign=top style=''width:294.0pt;border-top:none;border-left:\r\n  none;border-bottom:solid windowtext .5pt;border-right:solid windowtext .5pt;\r\n  background:#F2F2F2;padding:\r\n  0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText>Event status. All events added by users are inactive\r\n  until approved by the administrator.</p>\r\n  </td>\r\n </tr>\r\n</table>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>Finally, create one last table called &#8216;<span\r\nclass=UserSelection><span style=''font-size:11.0pt;\r\nfont-family:Arial''>email-register&#8217; </span></span> with the fields shown below:</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText align=center style=''text-align:center''><img border=0 width=539 height=368\r\nsrc=\"./UserImages/yessoftware/image008.jpg\"></p>\r\n\r\n<p class=MsoBodyText align=center style=''text-align:center''>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>Designate the &#8216;<span class=UserSelection><span\r\nstyle=''font-size:11.0pt;font-family:Arial''>email_id&#8217;</span></span>\r\nfield as the primary key and save the table as &#8216;<span class=UserSelection><span\r\nstyle=''font-size:11.0pt;font-family:Arial''>email_register&#8217;</span></span><b>.</b></p>\r\n\r\n<p class=MsoBodyText align=center style=''text-align:center''>&nbsp;</p>\r\n\r\n<div align=center>\r\n\r\n<table border=1 cellspacing=0 cellpadding=0 style=''margin-left:.45in;\r\n border-collapse:collapse;border:none;''>\r\n <tr>\r\n  <td width=124 valign=top style=''width:93.0pt;border:solid windowtext .5pt;\r\n  background:#CCCCCC;\r\n  padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><b>Field</b></p>\r\n  </td>\r\n  <td width=376 valign=top style=''width:282.0pt;border:solid windowtext .5pt;\r\n  border-left:none;background:#CCCCCC;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><b>Use</b></p>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td width=124 valign=top style=''width:93.0pt;border:solid windowtext .5pt;\r\n  border-top:none;background:#E5E5E5;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText>email_id</p>\r\n  </td>\r\n  <td width=376 valign=top style=''width:282.0pt;border-top:none;border-left:\r\n  none;border-bottom:solid windowtext .5pt;border-right:solid windowtext .5pt;\r\n  background:#F2F2F2;padding:\r\n  0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText>Primary Key</p>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td width=124 valign=top style=''width:93.0pt;border:solid windowtext .5pt;\r\n  border-top:none;background:#E5E5E5;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText>email_date</p>\r\n  </td>\r\n  <td width=376 valign=top style=''width:282.0pt;border-top:none;border-left:\r\n  none;border-bottom:solid windowtext .5pt;border-right:solid windowtext .5pt;\r\n  background:#F2F2F2;padding:\r\n  0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText>Date when the email notification was sent out</p>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td width=124 valign=top style=''width:93.0pt;border:solid windowtext .5pt;\r\n  border-top:none;background:#E5E5E5;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText>member_id</p>\r\n  </td>\r\n  <td width=376 valign=top style=''width:282.0pt;border-top:none;border-left:\r\n  none;border-bottom:solid windowtext .5pt;border-right:solid windowtext .5pt;\r\n  background:#F2F2F2;padding:\r\n  0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText>ID of the member who sent out the notifications</p>\r\n  </td>\r\n </tr>\r\n</table>\r\n\r\n</div>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<div style=''border:solid white .75pt;border-bottom:none;padding:6.0pt 6.0pt 0in 6.0pt;\r\nbackground:#E5E5E5;''>\r\n\r\n<p class=BlockQuotationFirst>Note: </p>\r\n\r\n</div>\r\n\r\n<div style=''border:solid white .75pt;padding:12.0pt 12.0pt 12.0pt 12.0pt;\r\nbackground:#F9F9F9;''>\r\n\r\n<p class=BlockQuotation>All the tables above have a primary key which is used to uniquely identify each record. When we come to designing the actual application, you will realize the pivotal importance of the primary key both in its table of origin as well as in related tables.</p>\r\n\r\n</div>\r\n\r\n<p class=MsoBodyText>To create similar tables in other databases, please refer to <b>Appendix C</b> for the scripts which you can run against the database to produce the tables. </p>\r\n\r\n<p class=MsoBodyText align=left style=''text-align:left''> </p>\r\n\r\n<p class=MsoBodyText>Once you have created your database tables, add some sample data. As an alternative to manually entering this data, you could import it from the Access database which comes with the completed project file. You\r\ncould also opt to use the database file that comes with the project file in place of the one you just created. <b>Appendix&#8209;C</b> also contains the script files for inserting the sample data into other databases.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText><b>&nbsp;</b></p>\r\n\r\n<p class=MsoBodyText><b>&nbsp;</b></p>\r\n\r\n<p class=MsoBodyText><b>Locations </b>sample data:</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText align=left style=''text-align:left''><img border=0 width=317 height=224\r\nsrc=\"./UserImages/yessoftware/image009.gif\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText><b>members </b> sample data:</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText align=center style=''text-align:center''><img border=0 width=655 height=104\r\nsrc=\"./UserImages/yessoftware/image011.jpg\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText><b>events </b>sample data:</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText align=center style=''text-align:center''><img border=0 width=655 height=120\r\nsrc=\"./UserImages/yessoftware/image013.jpg\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>You are at liberty to add additional information. Just make sure that the information you enter complies with the data type of the particular fields.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<span style=''font-size:18.0pt;font-family:\"Arial Black\";\r\nletter-spacing:-1.0pt;''><br clear=all style=''page-break-before:always''>\r\n</span>\r\n\r\n<\r\n<',2);
GO

INSERT INTO article_contents(art_content_id,art_id,art_content_name,art_content,art_content_ord) 
 VALUES (124,21,'III. Setting up the Web Server','\n<p class=MsoNormal>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>Central to the development of a web site is the web server without which the web sites could not be published to the Internet. A web server is a program that runs in the background on a computer, listens to requests for web pages and sends (serves) web pages to the computers requesting them. How this is done is beyond the scope of this tutorial but suffice it for now to know that the web server is the intermediary between your web pages and the end user.</p>\r\n\r\n<p class=MsoBodyText><br>\r\nThus, to be able to serve your own pages to the World Wide Web or even to your\r\nown local browser, you will need to install or rent a web server. For the\r\npurpose of developing websites with CodeCharge, it is recommended that you\r\nsetup a web server on the same machine as CodeCharge. Some versions of Windows,\r\nlike NT or 2000 come preinstalled with a web server called Internet Information\r\nServer (IIS). If you use Windows 95, 98 or Me, you have the option of\r\ninstalling the free Personal Web Server (PWS), which is included in &#8216;Windows NT\r\nOption Pack for Windows 95&#8217; and available for download from <a\r\nhref=\"http://download.microsoft.com/msdownload/ntoptionpack/en/x86/win.95/download.exe\"><span\r\nstyle=''font-size:10.0pt;font-family:Arial;''>http://download.microsoft.com/msdownload/ntoptionpack/en/x86/win.95/download.exe</span></a>.\r\nIf you need more help with setting up and understanding PWS, you may find\r\nappropriate tutorials on our web site at <a\r\nhref=\"http://support.codecharge.com/tutorials.asp\"><span style=''font-size:10.0pt;\r\nfont-family:Arial;''>http://support.codecharge.com/tutorials.asp</span></a>.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>If your platform of choice is the PHP/MySQL combo, you may consider installing PHP and MySQL on your Windows desktop to test generated programs locally. Although PHP works with PWS and IIS, you may also consider installing PHP Triad, which is an easy to setup PHP environment including Apache and MySQL, available from <a\r\nhref=\"http://sourceforge.net/projects/phptriad/\"><span style=''font-size:10.0pt;\r\nfont-family:Arial;''>http://sourceforge.net/projects/phptriad/</span></a>.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<span style=''font-size:18.0pt;font-family:\"Arial Black\";\r\nletter-spacing:-1.0pt;''><br clear=all style=''page-break-before:always''>\r\n</span>\r\n\r\n<\r\n<',3);
GO

INSERT INTO article_contents(art_content_id,art_id,art_content_name,art_content,art_content_ord) 
 VALUES (125,21,'IV. Delving into CodeCharge','\n<p class=MsoNormal>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>Now that the database is ready, the stage is set to plunge into CodeCharge and put the database on the web with the help of some logic. When you start CodeCharge, you will initially see a screen with a list of recently opened CodeCharge projects. Select &#8216;Create new site&#8217; as shown below: </p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText align=center style=''text-align:center''><img border=0 width=421 height=207\r\nsrc=\"./UserImages/yessoftware/image014.gif\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>The first thing to do in setting up the site is to\r\nconfigure the site <b>Properties</b>.</p>\r\n\r\n<p class=MsoBodyText><a name=\"_Toc515701419\">&nbsp;</a></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<h3 style=''margin-left:0in;text-indent:0in''><a\r\nname=\"_Toc516936327\">1.1<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>General Properties</a></span></h3>\r\n\r\n<p class=MsoBodyText>Begin by entering general information about the site in\r\nthe <span class=ScreenMenusNames><span style=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>General</span></span>\r\ntab, as shown below.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText align=center style=''text-align:center''><img border=0 width=646 height=250\r\nsrc=\"./UserImages/yessoftware/image016.gif\"><br>\r\n<br><br></p>\r\n\r\n<p class=MsoBodyText>Enter &#8216;<span class=UserSelection><span style=''font-size:\r\n11.0pt;font-family:Arial''>Events</span></span>&#8217; in\r\nthe <span class=ScreenMenusNames><span style=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Project</span></span>\r\nfield. This is the main name of our new site and is also the default <span\r\nclass=ScreenMenusNames><span style=''font-size:11.0pt;\r\nfont-family:\"Microsoft Sans Serif\";''>Title</span></span>\r\nthat will be assigned to all the web pages we will create later.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>Secondly, select the <span class=ScreenMenusNames><span\r\nstyle=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Language</span></span> that will be\r\nused to generate the pages. The one provision here is that this has to be a language supported by your web server. In our case, we chose to use &#8216;<span class=UserSelection><span style=''font-size:11.0pt;\r\nfont-family:Arial''>ASP &amp; Templates&#8217; </span></span> which will be run on Microsoft Internet Information Server (IIS 4.0). If you don&#8217;t have access to an NT machine, you van use Microsoft Personal Web Server. Personal Web Server (PWS) can be easily installed on the same computer as CodeCharge. Please refer to our Personal Web Server (PWS) tutorial for more information about how to set it up. If you so prefer, you may opt to use &#8216;PHP &amp; Templates&#8217; provided that you have a web\r\nserver which can parse PHP files. If your deployment environment is Linux, then you have a strong case for using PHP &amp; MySQL. There are also other languages to choose from including Cold Fusion, JSP or Perl. </p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>You probably have noticed that some of the languages have a <b>Templates</b> option while others don&#8217;t. Unless you are an advanced user or don&#8217;t see the Template option for your language, we recommend that you select the Templates version. Templates are HTML files that are separate from the programming code that runs the website. Templates allow programmers and designers to work independently such that the programmers can continue to manually modify the code, while the designers load the HTML templates into an html editor and modify it by adding graphics, text, changing colors, etc. </p>\r\n\r\n<p class=MsoBodyText><br>\r\nKeep in mind that CodeCharge generated HTML templates contain special tags in curly brackets {} that you should not modify. When the web page is displayed, these special tags are replaced with values from the database.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<h3 style=''margin-left:0in;text-indent:0in''><a name=\"_Toc515701420\"></a><a\r\nname=\"_Toc516936328\">1.2<span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Publishing Settings</a></h3>\r\n\r\n<h4 style=''margin-left:0in;text-indent:0in''><a name=\"_Toc515701421\"></a><a\r\nname=\"_Toc516936329\">1.2.1<span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Publishing Files Locally</a></h4>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>Next, click on the <span class=ScreenMenusNames><span\r\nstyle=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Publishing</span></span> Tab to setup\r\npublishing settings for your website as shown below:</p>\r\n\r\n<p class=MsoBodyText align=center style=''text-align:center''><img border=0 width=641 height=311\r\nsrc=\"./UserImages/yessoftware/image018.gif\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>Publishing generally entails generating the code and placing it on the web server.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>Assuming that you will use IIS or PWS to test your work, select <span class=UserSelection><span style=''font-size:11.0pt;font-family:Arial''>&#8216;Local/Network&#8217;</span></span> from the <span\r\nclass=ScreenMenusNames><span style=''font-size:11.0pt;\r\nfont-family:\"Microsoft Sans Serif\";''>Location</span></span> dropdown list then enter the following path into the <span class=ScreenMenusNames><span style=''font-size:11.0pt;\r\nfont-family:\"Microsoft Sans Serif\";''>Output\r\nCode Path</span></span> field: </p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText align=center style=''text-align:center''><span class=UserSelection><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&#8216;C:\\Inetpub\\wwwroot\\events&#8217;</span></span></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>The default path from which IIS or PWS serves content is <b>C:\\Inetpub\\wwwroot\\</b>\r\nand in a web browser it is equivalent to <a href=\"http://localhost/\"><span\r\nstyle=''font-size:10.0pt;font-family:Arial;''>http://localhost</span></a>.\r\nBy specifying that the files are to be placed in <b>c:\\Inetpub\\wwwroot\\events</b>\r\n, we will be able to test our project by typing the URL <a\r\nhref=\"http://localhost/events\"><span style=''font-size:10.0pt;font-family:Arial;''>http://localhost/events</span></a> into\r\nthe web browser. </p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>Since we are generating the output to the local Windows\r\nmachine, specify <span class=ScreenMenusNames><span style=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Output File Format</span></span> as &#8216;<span\r\nclass=UserSelection><span style=''font-size:11.0pt;\r\nfont-family:Arial''>Windows&#8217;</span></span>.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>And in the <span class=ScreenMenusNames><span\r\nstyle=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Live Site URL</span></span> field enter\r\n<a href=\"http://localhost/events\"><span style=''font-size:10.0pt;font-family:\r\nArial;''>http://localhost/events</span></a>\r\nwhich maps to the server <span class=ScreenMenusNames><span style=''font-size:\r\n11.0pt;font-family:\"Microsoft Sans Serif\";''>Output Code Path </span></span>specified above.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>This finalizes the Local publishing settings.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<h4 style=''margin-left:0in;text-indent:0in''><a name=\"_Toc515701422\"></a><a\r\nname=\"_Toc516936330\">1.2.2<span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Publishing Files to a Remote Server</a></h4>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>If it so happens that during the development phase or later you&#8217;d like to generate and publish your files to an external server, you may change the <span class=ScreenMenusNames><span style=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Location</span></span> to <span class=UserSelection><span\r\nstyle=''font-size:11.0pt;font-family:Arial''>&#8216;FTP&#8217;</span></span>\r\nand enter <span class=ScreenMenusNames><span style=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Publishing </span></span>settings as follows:</p>\r\n\r\n<p class=MsoBodyText><span style=''color:gray''>&nbsp;</span></p>\r\n\r\n<p class=MsoBodyText align=center style=''text-align:center''><span\r\nstyle=''color:gray''><img border=0 width=636 height=369\r\nsrc=\"./UserImages/yessoftware/image020.gif\"></span></p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.25in''><span style=''color:gray''>&nbsp;</span></p>\r\n\r\n<p class=MsoBodyText>The following is an explanation of the available options:</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.25in''><span class=ScreenMenusNames>&nbsp;</span></p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''><span style=''font-family:Wingdings''><span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span><span class=ScreenMenusNames><span style=''font-size:\r\n11.0pt;font-family:\"Microsoft Sans Serif\";''>Passive Mode </span></span>is a commonly used method of transferring files to the server using FTP. Normally, when you connect to an FTP site, the site establishes the data connection to your PC (the client). However, if the site allows passive transfers, you can have your PC establish the data connection. Select this option if transfers are erratic, you keep getting failed data channel errors, or your PC is behind a router-based firewall or gateway requiring passive transfers.</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''><span style=''font-family:Wingdings''><span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span><span class=ScreenMenusNames><span style=''font-size:\r\n11.0pt;font-family:\"Microsoft Sans Serif\";''>Server </span></span>is the address of your server, usually\r\nprovided by the hosting company.</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''><span style=''font-family:Wingdings''><span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span><span class=ScreenMenusNames><span style=''font-size:\r\n11.0pt;font-family:\"Microsoft Sans Serif\";''>Path/Folder</span></span> is the location on the server, where you&#8217;d like to place your files.</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''><span style=''font-family:Wingdings''><span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span><span class=ScreenMenusNames><span style=''font-size:\r\n11.0pt;font-family:\"Microsoft Sans Serif\";''>Login</span></span> and <span class=ScreenMenusNames><span\r\nstyle=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Password</span></span> are your authentication particulars, usually provided by the hosting company.</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''><span style=''font-family:Wingdings''><span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span><span class=ScreenMenusNames><span style=''font-size:\r\n11.0pt;font-family:\"Microsoft Sans Serif\";''>Live Site URL</span></span> is the URL that you enter in\r\nyour browser to view your website.</p>\r\n\r\n<p class=MsoBodyText><span style=''color:gray''>&nbsp;</span></p>\r\n\r\n<h3 style=''margin-left:0in;text-indent:0in''><a name=\"_Toc515701423\"></a><a\r\nname=\"_Toc516936331\">1.3<span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Database Settings</a></h3>\r\n\r\n<p class=MsoBodyText>CodeCharge requires you to specify how it should connect to the database while in design mode (Design Connection), as well as how the generated programs should connect to the database (Server Connection).</p>\r\n\r\n<p class=MsoBodyText><a name=\"_Toc515701424\">&nbsp;</a></p>\r\n\r\n<h4 style=''margin-left:0in;text-indent:0in''><a\r\nname=\"_Toc516936332\">1.3.1<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Connection Types</a></span></h4>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>This section focuses on how to connect CodeCharge to the &#8216;Events&#8217; database we created earlier on. There are several standard methods of connecting to databases, such as Open Database Connectivity (ODBC) and Jet database engine, otherwise known as <b>DSN</b> and <b>DSN-less</b> connections respectively. DSN-less/JET connections are often used when connecting to MS Access, Excel or other file or text based databases. On the other hand, a DSN connection is used with almost all other proprietary databases, such as MS SQL, MySQL, DB2, Oracle, Sybase, etc. As a prerequisite, DSN connections require the appropriate ODBC driver installed on your computer. Most database vendors provide ODBC drivers along with their products and usually, the drivers are installed together with the database software. If this is not the case, you can usually find an appropriate ODBC driver at the vendor&#8217;s site or other sites where freeware drivers are posted.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>There are conflicting reports about the advantages of DSN connections over DSN-less connections. However, if you use MS Access and need to make a choice between the two, here is some information that may aid you in\r\nmaking the correct decision:</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>A<b> DSN-less</b> connection is a little easier to setup in CodeCharge than a DSN/ODBC connection because you don&#8217;t need to define the Data Source Name (DSN) in the system <span class=ScreenMenusNames><span style=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Control Panel</span></span>. A DSN-less connection may also come in handy on the server side since some hosting companies place a limit on the number of DSN connections a client may have. DSN-less connections are not subject to such a limit.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>Although it is disputable whether <b>DSN connections</b> performs better than DSN-less connections, the key advantage of using a DSN is that you may setup the same DSN on multiple machines, for example the development and the server machines, and your programs will work on the configured machines without any changes. You would simply copy the generated files from one computer to another and they should function correctly as long as you defined the same DSN on both computers. On the other hand, if you use a DSN-less connection, you may need to modify your connection string for each\r\ncomputer, either directly in CodeCharge or in the <b>Common.asp </b>file generated by CodeCharge. Often you will use one connection type during design phase and a different one for deployment. </p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>If you use MySQL during design time, you have to use a DSN/ODBC connection when working within CodeCharge. However, the generated web pages don&#8217;t have to use a DSN/ODBC connection. In the case of PHP, CodeCharge\r\ngenerates PHPLib compliant code which allows for direct connection to the database without ODBC. </p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<h4 style=''margin-left:0in;text-indent:0in''><a name=\"_Toc515701425\"></a><a\r\nname=\"_Toc516936333\">1.3.2<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span>Design Connection String</a></h4>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>The design connection string tells CodeCharge how to connect to the database during design phase i.e. while you are creating your site. If you use MS Access, you have the choice of using a DSN or DSN-less connection, both of which we will explain how to create. Otherwise, if for example you use MySQL database, we recommend the DSN/ODBC connection type.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<h5 style=''margin-left:0in;text-indent:0in''><a name=\"_Toc515701426\">DSN-less connection\r\n/ JET</a></h5>\r\n\r\n<p class=MsoBodyText>To setup a DSN-less database connection string, click on the yellow icon <img border=0 width=16 height=16 src=\"./UserImages/yessoftware/image021.gif\"> next to the &#8216;Connection String&#8217; field. This is under the <span class=ScreenMenusNames><span style=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Database </span></span>tab of <span class=ScreenMenusNames><span style=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Site Properties</span></span>. The <span class=ScreenMenusNames><span style=''font-size:11.0pt; font-family:\"Microsoft Sans Serif\";''>Data\r\nLink Properties</span></span> window pops up as shown below.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText align=center style=''text-align:center''><img border=0 width=367 height=460\r\nsrc=\"./UserImages/yessoftware/image022.gif\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>Select &#8216;<span class=UserSelection><span style=''font-size: 11.0pt;font-family:Arial''>Microsoft Jet 4.0 OLE DB Provider&#8217;</span></span> then click on the <span class=ScreenMenusNames><span style=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Connection</span></span> tab at the top of the window and select the database file that you created earlier, as shown below:</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText><img border=0 width=660 height=456\r\nsrc=\"./UserImages/yessoftware/image024.gif\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>Click <span class=ScreenMenusNames><span style=''font-size: 11.0pt;font-family:\"Microsoft Sans Serif\";''>Open</span></span> after selecting the database file (events.mdb) and then click <span class=ScreenMenusNames><span\r\nstyle=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>OK</span></span> to finalize your selection. You should now see some text in the &#8216;Connection String&#8217; field as shown below. </p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText align=center style=''text-align:center''><img border=0 width=660 height=247\r\nsrc=\"./UserImages/yessoftware/image026.gif\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>This completes the setup of your Design Connection String. Please skip to the Server Connection section of this tutorial.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<h5 style=''margin-left:0in;text-indent:0in''><a name=\"_Toc515701427\">DSN\r\nconnection / ODBC</a></h5>\r\n\r\n<p class=MsoBodyText>If you use MySQL, MS SQL, Access, Oracle, etc. you may need to setup your design connection using ODBC. But before you do this, you may also need to download and install the appropriate ODBC driver. The following explains how to setup the MyODBC driver that is often used with MySQL.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText><a name=\"_Toc515701428\"><b>Setting Up MyODBC for MySQL</b></a></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>To connect to MySQL database on the Windows platform, you will need to download the MyODBC Windows driver from <a href=\"http://www.mysql.com/downloads/api-myodbc.html\"><span style=''font-size:\r\n10.0pt;font-family:Arial;''>http://www.mysql.com/downloads/api-myodbc.html</span></a>.\r\nOnce you install it, you will be prompted to enter the information needed to connect to your local or remote MySQL server. You only need to enter the following options:</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''><span style=''font-family:Wingdings''><span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span><span class=ScreenMenusNames><span style=''font-size:\r\n11.0pt;font-family:\"Microsoft Sans Serif\";''>Windows DSN name </span></span>&#8211; any name that you want to\r\ngive to your Data Source Name, in this case, let&#8217;s name it &#8216;events&#8217;.</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''><span style=''font-family:Wingdings''><span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span><span class=ScreenMenusNames><span style=''font-size:\r\n11.0pt;font-family:\"Microsoft Sans Serif\";''>MySQL host (name or IP)</span></span> &#8211; the IP address of\r\nyour MySQL database, which you may usually obtain from your hosting company. If\r\nyour MySQL database is installed on the same computer as CodeCharge, enter &#8216;<span\r\nclass=UserSelection><span style=''font-size:11.0pt;\r\nfont-family:Arial''>localhost</span></span>&#8217;.</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''><span style=''font-family:Wingdings''><span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span><span class=ScreenMenusNames><span style=''font-size:\r\n11.0pt;font-family:\"Microsoft Sans Serif\";''>User</span></span> &#8211; this is the login that you or your\r\nhosting company setup to access your database.</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''><span style=''font-family:Wingdings''><span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span><span class=ScreenMenusNames><span style=''font-size:\r\n11.0pt;font-family:\"Microsoft Sans Serif\";''>Password</span></span> &#8211; this is the password for your\r\ndatabase.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>The screenshot below shows a sample MyODBC setup:</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText align=center style=''text-align:center''><img border=0 width=452 height=482\r\nsrc=\"./UserImages/yessoftware/image028.jpg\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText><a name=\"_Toc515701429\"><b>Creating a DSN (Data Source\r\nName)</b></a></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>In case you need to change or create a new DSN, you may do\r\nso by going to <span class=ScreenMenusNames><span style=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Control Panel</span></span> on your computer (<span\r\nclass=ScreenMenusNames><span style=''font-size:11.0pt;\r\nfont-family:\"Microsoft Sans Serif\";''>Start</span></span>\r\n-&gt; <span class=ScreenMenusNames><span style=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Settings</span></span>\r\n-&gt; <span class=ScreenMenusNames><span style=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Control\r\nPanel</span></span>) and selecting <span class=ScreenMenusNames><span\r\nstyle=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>ODBC Data Sources</span></span>, or\r\nequivalent option. Once there, select the <span class=ScreenMenusNames><span\r\nstyle=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>System DSN</span></span> tab and click <span\r\nclass=ScreenMenusNames><span style=''font-size:11.0pt;\r\nfont-family:\"Microsoft Sans Serif\";''>Add</span></span>\r\nor <span class=ScreenMenusNames><span style=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Configure</span></span>\r\nto setup a DSN for almost any database, as long as you have the appropriate\r\ndrivers installed on your computer:</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText align=center style=''text-align:center''><img border=0 width=659 height=472\r\nsrc=\"./UserImages/yessoftware/image030.gif\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText><a name=\"_Toc515701430\"><b>Back to CodeCharge</b></a></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>Having created the data source name (DSN), we return to\r\nthe CodeCharge database settings to complete the link to the DSN we just\r\ncreated. Click on the yellow icon <img border=0 width=16 height=16\r\nsrc=\"./UserImages/yessoftware/image021.gif\"> next to the <span class=ScreenMenusNames><span\r\nstyle=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Connection String</span></span> field.\r\nYou should see the <span class=ScreenMenusNames><span style=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Data Link Properties</span></span> window where you need to\r\nselect &#8216;<span class=UserSelection><span style=''font-size:11.0pt;font-family:Arial''>Microsoft OLE DB Provider for ODBC Drivers</span></span>&#8217;\r\nunder the <span class=ScreenMenusNames><span style=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Provider</span></span> tab as shown below:</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText align=center style=''text-align:center''><img border=0 width=640 height=443\r\nsrc=\"./UserImages/yessoftware/image032.gif\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>Once you select the ODBC driver to use, click <span\r\nclass=ScreenMenusNames><span style=''font-size:11.0pt;\r\nfont-family:\"Microsoft Sans Serif\";''>Next</span></span>\r\nor click on the <span class=ScreenMenusNames><span style=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Connection</span></span> tab and select your previously\r\ncreated DSN called &#8216;<span class=UserSelection><span style=''font-size:11.0pt;font-family:Arial''>events</span></span>&#8217;. You can\r\nalso provide your database login and password is applicable, as shown below.\r\nWhen done, click on the <span class=ScreenMenusNames><span style=''font-size:\r\n11.0pt;font-family:\"Microsoft Sans Serif\";''>Ok</span></span> button to close the window.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText align=center style=''text-align:center''><img border=0 width=367 height=459\r\nsrc=\"./UserImages/yessoftware/image033.gif\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>You should arrive at the screen below with your <span\r\nclass=ScreenMenusNames><span style=''font-size:11.0pt;\r\nfont-family:\"Microsoft Sans Serif\";''>Design</span></span>\r\n<span class=ScreenMenusNames><span style=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Connection\r\nString</span></span> automatically filled-in based on your previous selections.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText align=center style=''text-align:center''><img border=0 width=659 height=250\r\nsrc=\"./UserImages/yessoftware/image035.gif\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>This completes the setup of your <span\r\nclass=ScreenMenusNames><span style=''font-size:11.0pt;\r\nfont-family:\"Microsoft Sans Serif\";''>Design\r\nConnection String</span></span>.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<h5 style=''margin-left:0in;text-indent:0in''><a name=\"_Toc515701431\">Troubleshooting\r\nDatabase Connection issues</a></h5>\r\n\r\n<p class=MsoBodyText>In case you run into problems in the process of connecting\r\nto the database while using CodeCharge, you may need to install the latest\r\nconnectivity drivers from Microsoft, called MDAC. The latest MDAC 2.6 drivers\r\nare available at <a href=\"http://www.microsoft.com/data/download_260rtm.htm\"><span\r\nstyle=''font-size:10.0pt;font-family:Arial;''>http://www.microsoft.com/data/download_260rtm.htm</span></a>.\r\nAlso make sure that you have a version of Internet Explorer later than or equal\r\nto v5.5.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<h4 style=''margin-left:0in;text-indent:0in''><a name=\"_Toc515701432\"></a><a\r\nname=\"_Toc516936334\">1.3.3<span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Server Connection String</a></h4>\r\n\r\n<h5 style=''margin-left:0in;text-indent:0in''>The server connection string will\r\nbe included in the generated programs to allow them to connect and access data\r\nfrom the database. Depending on your language of choice, CodeCharge provides\r\nseveral options for server side database connectivity.</h5>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<h5 style=''margin-left:0in;text-indent:0in''><a name=\"_Toc515701433\">Server\r\nConnection Strings for use with ASP</a></h5>\r\n\r\n<p class=MsoBodyText><a name=\"_Toc515701434\"><b>Same as Design</b></a></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText align=center style=''text-align:center''><img border=0 width=273 height=48\r\nsrc=\"./UserImages/yessoftware/image036.gif\"></p>\r\n\r\n<p class=MsoBodyText align=center style=''text-align:center''>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>This database connection setting will simply include the\r\ndesign connection string in the generated programs, causing them to use the\r\nexact same database as you used during the design phase. You should use it only\r\nwhen you generate programs on the same computer where you installed CodeCharge\r\nor you have setup similar data source names (DSN) on the design as well as the\r\ndeployment machine.</p>\r\n\r\n<p class=MsoBodyText><a name=\"_Toc515701435\">&nbsp;</a></p>\r\n\r\n<p class=MsoBodyText><b>Custom</b></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText align=center style=''text-align:center''><img border=0 width=365 height=119\r\nsrc=\"./UserImages/yessoftware/image037.gif\"></p>\r\n\r\n<p class=MsoBodyText align=center style=''text-align:center''>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>You may use this setting when you know the connection\r\nstring that you want to use. For example, you may manually copy the design\r\nconnection string here and modify the path where your database is located on\r\nthe server.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText><a name=\"_Toc515701436\"><b>Create Automatically (MS Access\r\nonly)</b></a></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText align=center style=''text-align:center''><img border=0 width=383 height=127\r\nsrc=\"./UserImages/yessoftware/image038.gif\"></p>\r\n\r\n<p class=MsoBodyText align=center style=''text-align:center''>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>If you are publishing your programs to an external server,\r\nyou may want to use this option to automate the database publishing. In this\r\ncase CodeCharge will automatically assume that your database file (.mdb) is\r\nlocated in the same folder as the rest of the programs on the server, and it\r\nwill create the appropriate connection string. However, you may also select\r\n&#8216;Copy the Database&#8217; option and provide a &#8216;Local Database Path&#8217; at least for the\r\nfirst time you publish your site, so that CodeCharge can copy your database to\r\nthe server and assure that the created connection string is valid.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<h5 style=''margin-left:0in;text-indent:0in''><a name=\"_Toc515701437\">Server\r\nConnection for PHP</a></h5>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText align=center style=''text-align:center''><img border=0 width=365 height=202\r\nsrc=\"./UserImages/yessoftware/image039.gif\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>The server connection string for PHP is very\r\nstraightforward. You only need to enter the basic information about your\r\nserver, such as the database name, login and password. You also need to provide\r\nthe IP address of the machine in which the database resides, which is often the\r\nsame as the IP address of your domain name, or &#8216;localhost&#8217; if your database is\r\nhosted locally.  When generating PHP\r\nprograms, CodeCharge will also generate the PHPLib library with connection\r\nsettings based on the above setup. Your server doesn&#8217;t need ODBC or other\r\ndrivers. This is only needed during design time.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<h5 style=''margin-left:0in;text-indent:0in''><a name=\"_Toc515701438\">Server\r\nConnection for ColdFusion</a></h5>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText align=center style=''text-align:center''><img border=0 width=363 height=127\r\nsrc=\"./UserImages/yessoftware/image040.gif\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>When using ColdFusion, you only need to know your Data\r\nSource Name (DSN) and optional Login and Password as shown above. You may\r\ncreate the DSN using the ColdFusion Administrator (<a\r\nhref=\"http://coldfusionserver/CFIDE/administrator\"><span style=''font-size:10.0pt;\r\nfont-family:Arial;''>http://coldfusionserver/CFIDE/administrator</span></a>)</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<h5 style=''margin-left:0in;text-indent:0in''><a name=\"_Toc515701439\">Server\r\nConnection String for Perl</a></h5>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText align=center style=''text-align:center''><img border=0 width=360 height=127\r\nsrc=\"./UserImages/yessoftware/image041.gif\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>Perl uses a database interface module called DBI to\r\nconnect to databases. In CodeCharge, you will need to supply a simple\r\nconnection string specifying the DBI as the connection method, the database\r\ntype (mysql, odbc, etc.) and the name of the database. Refer to <a\r\nhref=\"http://dbi.symbolstone.org/\"><span style=''font-size:10.0pt;font-family:\r\nArial;''>http://dbi.symbolstone.org/</span></a>\r\nfor more information on DBI or read the short guide to DBI at <a\r\nhref=\"http://www.perl.com/pub/1999/10/DBI.html\"><span style=''font-size:10.0pt;\r\nfont-family:Arial;''>http://www.perl.com/pub/1999/10/DBI.html</span></a>.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<h5 style=''margin-left:0in;text-indent:0in''><a name=\"_Toc515701440\">Server\r\nConnection String for JSP</a></h5>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText align=center style=''text-align:center''><img border=0 width=364 height=166\r\nsrc=\"./UserImages/yessoftware/image042.gif\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>When using JSP, it is very common to use the Java Database\r\nConnectivity (JDBC) driver to connect to the database. The proper database\r\nconnection string, also known as URL is usually &#8216;jdbc:(driver\r\ntype):(database)&#8217;. You may also use ODBC in combination with JDBC and use a\r\nconnection string like <b>jdbc:odbc:events </b>as shown above. In addition, you\r\nwill need to supply the class name of your driver, for example <b>sun.jdbc.odbc.</b>JdbcOdbcDriver.\r\nFor more information on establishing JDBC connections, visit <a\r\nhref=\"http://java.sun.com/docs/books/tutorial/jdbc/basics/connecting.html\"><span\r\nstyle=''font-size:10.0pt;font-family:Arial;''>http://java.sun.com/docs/books/tutorial/jdbc/basics/connecting.html</span></a>.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText><b>&nbsp;</b></p>\r\n\r\n<div style=''border:solid white .75pt;border-bottom:none;padding:6.0pt 6.0pt 0in 6.0pt;\r\nbackground:#E5E5E5;''>\r\n\r\n<p class=BlockQuotationFirst>Note: </p>\r\n\r\n</div>\r\n\r\n<div style=''border:solid white .75pt;padding:12.0pt 12.0pt 12.0pt 12.0pt;\r\nbackground:#F9F9F9;''>\r\n\r\n<p class=BlockQuotation>When working with JSP, make sure you enter the Server\r\nSide Application Path in CodeCharge, for example <b>/usr/local/apache/docs</b>\r\nas shown below.</p>\r\n\r\n</div>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText align=center style=''text-align:center''><img border=0 width=659 height=286\r\nsrc=\"./UserImages/yessoftware/image044.gif\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<h3 style=''margin-left:0in;text-indent:0in''><a name=\"_Toc515701441\"></a><a\r\nname=\"_Toc516936335\">1.4<span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Security Settings</a></h3>\r\n\r\n<p class=MsoBodyText>The next step in setting up our dynamic website is the <span\r\nclass=ScreenMenusNames><span style=''font-size:11.0pt;\r\nfont-family:\"Microsoft Sans Serif\";''>Security</span></span>\r\nsection of Site Properties. This is where we specify the database table that\r\nwill be used to verify users&#8217; login and password as well as corresponding\r\nprivileges. This is an optional feature and if the whole website is accessible\r\nto everyone, just leave the <span class=ScreenMenusNames><span\r\nstyle=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Use Authentication</span></span> option\r\nunchecked. In our case, we will use the authentication for the following\r\nreasons:</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''><span style=''font-family:Wingdings''><span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span>Only the members can submit new events to our database</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''><span style=''font-family:Wingdings''><span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span>Only the administrators or editors can approve new\r\nadditions and send out email notifications.</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''><span style=''font-family:Wingdings''><span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span>Only administrators can disable member accounts and add\r\nlocations. </p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>Therefore we will need to authenticate/protect some of the\r\npages by setting up security properties:</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>1.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Check <span class=ScreenMenusNames><span style=''font-size:\r\n11.0pt;font-family:\"Microsoft Sans Serif\";''>Use Authentication</span></span> checkbox then select &#8216;<span\r\nclass=UserSelection><span style=''font-size:11.0pt;\r\nfont-family:Arial''>members</span></span>&#8217; as the <span class=ScreenMenusNames><span\r\nstyle=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>User access table</span></span> because\r\nthis is the table that contains user logins, passwords and security levels.</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>2.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Select &#8216;<span class=UserSelection><span style=''font-size:11.0pt;font-family:Arial''>member_id</span></span>&#8217; as <span\r\nclass=ScreenMenusNames><span style=''font-size:11.0pt;\r\nfont-family:\"Microsoft Sans Serif\";''>Primary\r\nKey</span></span>. The Primary key always has to be numeric and has to be the\r\nkey to the table containing user accounts.</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>3.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Select &#8216;<span class=UserSelection><span style=''font-size:11.0pt;font-family:Arial''>member_name&#8217;</span></span> in the <span\r\nclass=ScreenMenusNames><span style=''font-size:11.0pt;\r\nfont-family:\"Microsoft Sans Serif\";''>Login</span></span>\r\nfield. The users will choose their own member names, and will use them as their\r\nlogin.</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>4.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Select &#8216;<span class=UserSelection><span style=''font-size:11.0pt;font-family:Arial''>password</span></span>&#8217; in the <span\r\nclass=ScreenMenusNames><span style=''font-size:11.0pt;\r\nfont-family:\"Microsoft Sans Serif\";''>Password</span></span>\r\nfield because each member will need a password to access member areas.</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>5.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Select &#8216;<span class=UserSelection><span style=''font-size:11.0pt;font-family:Arial''>security_level&#8217;</span></span> in\r\nthe <span class=ScreenMenusNames><span style=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Security\r\nLevel</span></span> field since members will have a different security level as\r\nwill administrators and editors.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>Once you finish entering all of the above information,\r\nyour screen should look similar to the screen shot below:</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText align=center style=''text-align:center''><img border=0 width=659 height=382\r\nsrc=\"./UserImages/yessoftware/image046.gif\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<h3 style=''margin-left:0in;text-indent:0in''><a name=\"_Toc515701442\"></a><a\r\nname=\"_Toc516936336\">1.5<span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Pages</a></h3>\r\n\r\n<p class=MsoBodyText>The <span class=ScreenMenusNames><span style=''font-size:\r\n11.0pt;font-family:\"Microsoft Sans Serif\";''>Pages</span></span> tab under site properties is used to\r\ndesignate web pages which play a central role in the structure of the website. </p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText align=center style=''text-align:center''><img border=0 width=431 height=141\r\nsrc=\"./UserImages/yessoftware/image047.gif\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText><span class=ScreenMenusNames><span style=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Default Page</span></span> &#8211; This is the first page which a\r\nuser sees when they type the address of the site.</p>\r\n\r\n<p class=MsoBodyText><span class=ScreenMenusNames><span style=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Header Page</span></span> &#8211; The Header page is automatically\r\npre-pended to the top of all the other pages in the website</p>\r\n\r\n<p class=MsoBodyText><span class=UserSelection><span style=''font-size:11.0pt;font-family:Arial''>Footer Page</span></span> &#8211; The\r\nFooter page is automatically  appended\r\nto the bottom of all the other pages in the website</p>\r\n\r\n<p class=MsoBodyText><span class=UserSelection><span style=''font-size:11.0pt;font-family:Arial''>Login Page</span></span> &#8211; The\r\nLogin page presents the user with a form from where they can login so as so\r\naccess pages with restricted access. </p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>At this point, we will not configure this section of site\r\nproperties but will come back to it after creating the initial pages in\r\nCodeCharge. </p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<h3 style=''margin-left:0in;text-indent:0in''><a name=\"_Toc515701443\"></a><a\r\nname=\"_Toc516936337\">1.6<span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Files</a></h3>\r\n\r\n<p class=MsoBodyText>The<span class=ScreenMenusNames><span style=''font-size:\r\n11.0pt;font-family:\"Microsoft Sans Serif\";''> Files </span></span>section  is used to specify a folder which you want to be copied to the\r\nweb server when the pages are generated. This features comes in handy if you\r\nhave a folder which contains site images or other media and you want the folder\r\nto be copied to the deployment machine when the pages are generated. In this\r\ncase, you specify the folder you  want\r\nto be copied in the <span class=ScreenMenusNames><span style=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Source Folder</span></span> field and then specify where you\r\nwant the folder to be copied to in the <span class=ScreenMenusNames><span\r\nstyle=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Destination/Server Folder</span></span>\r\nfield.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText align=center style=''text-align:center''><img border=0 width=447 height=158\r\nsrc=\"./UserImages/yessoftware/image048.gif\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>We will also leave this section unchanged for now. Later\r\nit may contain the path to the directory with images, in case we want to add\r\nimages to our website. </p>\r\n\r\n<p class=MsoBodyText><b>&nbsp;</b></p>\r\n\r\n<p class=MsoBodyText>This concludes the setup of the site properties.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<h5 style=''margin-left:0in;text-indent:0in''><a name=\"_Toc515701444\">Saving the\r\nProject</a></h5>\r\n\r\n<p class=MsoBodyText>Now you may press <i>ctrl</i> + S to save your project, or\r\nselect <span class=ScreenMenusNames><u><span style=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>F</span></u></span><span class=ScreenMenusNames><span\r\nstyle=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>ile / Save</span></span> from the main\r\nmenu. When you save your project for the first time, you will be prompted to\r\nprovide the name of the project. In this case enter &#8216;Events&#8217; as the name.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<h2 style=''margin-left:0in;text-indent:0in''><a name=\"_Toc515701445\"></a><a\r\nname=\"_Toc516936338\">2.<span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Style</a></h2>\r\n\r\n<p class=MsoBodyText>In this section we will setup the basic look and feel of\r\nour website. All that you need to do initially is click &#8216;Load&#8217; and select one\r\nof the predefined styles, either of CSS (Cascading Style Sheets) type or HTML.\r\nCSS allows you to store definitions of each element in a separate file, and\r\nonly output a single tag defining several properties of each HTML element, such\r\nas font size and color, border thickness, background color, etc. The HTML\r\noptions will output much more information to the browser, including set\r\nproperties for each HTML element. Let&#8217;s take a look at each of these options\r\nseparately:</p>\r\n\r\n<p class=MsoBodyText><a name=\"_Toc515701446\">&nbsp;</a></p>\r\n\r\n<h3 style=''margin-left:0in;text-indent:0in''><a\r\nname=\"_Toc516936339\">2.1<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>CSS Styles</a></span></h3>\r\n\r\n<h4 style=''margin-left:0in;text-indent:0in''><a name=\"_Toc515701447\"></a><a\r\nname=\"_Toc516936340\">2.1.1<span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Included in HTML Files</a></h4>\r\n\r\n<p class=MsoBodyText>If you opt to use a CSS style type for your site, for\r\nexample by loading one of the predefined CSS styles such as Artic(CSS).cct,\r\nCodeCharge will produce HTML files that may include the following code around\r\nthe field caption:</p>\r\n\r\n<p class=MsoBodyText><span style=''color:#333399''>&nbsp;</span></p>\r\n\r\n<p class=Code>&lt;td style=&#8216;background-color: #CCCCCC; color: #000000;\r\nborder-style: outset; border-width: 1&#8217;&gt;</p>\r\n\r\n<p class=Code>&lt;font style=&#8216;font-size: 10pt; color: #000000&#8217;&gt;</p>\r\n\r\n<p class=Code>Field Caption Text </p>\r\n\r\n<p class=Code>&lt;/font&gt;</p>\r\n\r\n<p class=Code>&lt;/td&gt;</p>\r\n\r\n<p class=MsoBodyText><span style=''color:#333399''>&nbsp;</span></p>\r\n\r\n<p class=MsoBodyText>The above output will be repeated for each HTML element,\r\neven if similar elements are used multiple times on the same page. This will\r\ncause the HTML files to become large and consequently take longer to load.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<h4 style=''margin-left:0in;text-indent:0in''><a name=\"_Toc515701448\"></a><a\r\nname=\"_Toc516936341\">2.1.2<span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Placed in Separate CSS File</a></h4>\r\n\r\n<p class=MsoBodyText>In the interest of speed and size, you may optimize CSS\r\noutput by selecting the option &#8216;<span class=ScreenMenusNames><span\r\nstyle=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Generate Files containing Styles</span></span>&#8217;.\r\nIn this case CodeCharge will create a separate file called <b>Site.css</b>\r\ncontaining style tags, which includes the definition for each element, for\r\nexample:</p>\r\n\r\n<p class=MsoBodyText><span style=''font-size:11.0pt;''>&nbsp;</span></p>\r\n\r\n<p class=Code>.FieldCaptionTD {background-color: #CCCCCC; color: #000000;\r\nborder-style: outset; border-width: 1}</p>\r\n\r\n<p class=Code>.FieldCaptionFONT {font-size: 10pt; color: #000000}</p>\r\n\r\n<p class=MsoBodyText><span style=''font-size:11.0pt;''>&nbsp;</span></p>\r\n\r\n<p class=MsoBodyText>And the server will output much simplified code, with just\r\na single tag name for each element:</p>\r\n\r\n<p class=MsoBodyText><span style=''font-size:11.0pt;''>&nbsp;</span></p>\r\n\r\n<p class=Code>&lt;td class=&#8216;FieldCaptionTD&#8217;&gt;</p>\r\n\r\n<p class=Code>&lt;font class=&#8216;FieldCaptionFONT&#8217;&gt;</p>\r\n\r\n<p class=Code>Field Caption Text</p>\r\n\r\n<p class=Code>&lt;/font&gt;</p>\r\n\r\n<p class=Code>&lt;/td&gt;</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>The browser will use the definitions such as\r\n&#8216;FieldCaptionTD&#8217; or &#8216;FieldCaptionFONT&#8217; from the .ccs file in place of style tag\r\nnames in .html files. This makes for much less traffic between the server and\r\nthe browser because each set of properties is defined only once.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>Please refer to <b>Appendix A</b> for a list of resources\r\nyou could use to learn more about Cascading Style Sheets</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<h3 style=''margin-left:0in;text-indent:0in''><a name=\"_Toc515701451\"></a><a\r\nname=\"_Toc516936342\">2.2<span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>HTML Styles</a></h3>\r\n\r\n<h4 style=''margin-left:0in;text-indent:0in''><a name=\"_Toc515701452\"></a><a\r\nname=\"_Toc516936343\">2.2.1<span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Included in HTML Files</a></h4>\r\n\r\n<p class=MsoBodyText>The HTML style option is very similar to the CSS style\r\noption when both are used without the <span class=ScreenMenusNames><span\r\nstyle=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Generate Files containing Styles</span></span>\r\noption. The HTML output will include detailed properties for each HTML element,\r\nfor example:</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=Code>&lt;td bgcolor=&#8216;#C0C0C0&#8217;&gt;</p>\r\n\r\n<p class=Code>&lt;font style=&#8216;font-size: 10pt; color: #000000; font-family:\r\nArial, Tahoma, Verdana, Helvetica&#8217;&gt;</p>\r\n\r\n<p class=Code>Field Caption Text</p>\r\n\r\n<p class=Code>&lt;/font&gt;</p>\r\n\r\n<p class=Code>&lt;/td&gt;</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>If there are multiple Field Captions on your page, the\r\nsame set of properties will be repeated for each of the captions and this could\r\nmake the HTML files pretty large.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<h4 style=''margin-left:0in;text-indent:0in''><a name=\"_Toc515701453\"></a><a\r\nname=\"_Toc516936344\">2.2.2<span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Placed in Separate HTML Style Files</a></h4>\r\n\r\n<p class=MsoBodyText>When using the HTML style with the option <span\r\nclass=ScreenMenusNames><span style=''font-size:11.0pt;\r\nfont-family:\"Microsoft Sans Serif\";''>Generate\r\nFiles containing Styles</span></span> selected, the output visible to the user\r\nvia the browser will be no different than when not using this option.  However, the difference will be on the\r\nserver side. The program that generates the web page will use a separate file\r\ncalled <b>Styles.inc</b> which will contain HTML tag definitions such as:</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=Code>styleFieldCaptionTD = &#8216;bgcolor=&#8216;&#8216;#C0C0C0&#8217;&#8217;&#8217;</p>\r\n\r\n<p class=Code>styleFieldCaptionFONT = &#8216;style=&#8216;&#8216;font-size: 10pt; color: #000000;\r\nfont-family: Arial, Tahoma, Verdana, Helvetica&#8217;&#8217;&#8217;</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>And the HTML file on the server will include simplified\r\ntags, like:</p>\r\n\r\n<p class=MsoBodyText><span style=''font-size:11.0pt;\r\nfont-family:\"Courier New\";color:blue''>&nbsp;</span></p>\r\n\r\n<p class=Code>&lt;td {FieldCaptionTD}&gt;</p>\r\n\r\n<p class=Code>&lt;font {FieldCaptionFONT}&gt;</p>\r\n\r\n<p class=Code>Project</p>\r\n\r\n<p class=Code>&lt;/font&gt;</p>\r\n\r\n<p class=Code>&lt;/td&gt;</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>When the web page is requested by the browser, the server\r\nwill read the HTML template file for that page as well as the <b>Styles.inc</b>\r\nfile and will combine them to create output that is the same as when using a\r\nsingle-HTML file. As such, the browser will receive identical HTML content as\r\nthat shown earlier. </p>\r\n\r\n<p class=MsoBodyText><span style=''font-size:11.0pt;\r\nfont-family:\"Courier New\";color:blue''>&nbsp;</span></p>\r\n\r\n<p class=Code>&lt;td bgcolor=&#8216;#C0C0C0&#8217;&gt;</p>\r\n\r\n<p class=Code>&lt;font style=&#8216;font-size: 10pt; color: #000000; font-family:\r\nArial, Tahoma, Verdana, Helvetica&#8217;&gt;</p>\r\n\r\n<p class=Code>Field Caption Text</p>\r\n\r\n<p class=Code>&lt;/font&gt;</p>\r\n\r\n<p class=Code>&lt;/td&gt;</p>\r\n\r\n<p class=MsoBodyText><span style=''font-size:11.0pt;\r\nfont-family:\"Courier New\";color:blue''>&nbsp;</span></p>\r\n\r\n<p class=MsoBodyText>Please refer to <b>Appendix A</b> for a list of resources\r\nyou could use to learn more about HTML.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<h3 style=''margin-left:0in;text-indent:0in''><a name=\"_Toc515701456\"></a><a\r\nname=\"_Toc516936345\">2.3<span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Choosing the Type of Style</a></h3>\r\n\r\n<p class=MsoBodyText>Based on the above information, it is evident that using\r\nCSS styles with the <span class=ScreenMenusNames><span style=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Generate File containing Style</span></span>&#8217; option is the\r\nmost efficient choice. It allows for more compact HTML files by keeping the\r\ndefinitions of various elements in a separate .css file. The only potential\r\nissue is that some older browsers may not be capable of handling Cascading\r\nStyle Sheets correctly. If you have web designers on hand, they may have their\r\nown preferences too. Web designers may wish to modify the generated HTML\r\ntemplates to their liking in which case using the HTML styles is a potentially\r\ngood option.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>In our case, select &#8216;<span class=UserSelection><span\r\nstyle=''font-size:11.0pt;font-family:Arial''>Artic\r\n(CSS)</span></span>&#8217; as the style for our website with the option <span\r\nclass=ScreenMenusNames><span style=''font-size:11.0pt;\r\nfont-family:\"Microsoft Sans Serif\";''>Generate\r\nFile containing Styles</span></span> selected. This will cause the site to use Cascading\r\nStyle Sheets (CSS), thus simplifying the output to the browser. CodeCharge also\r\ndisplays a preview of how different sections of the page will appear in the\r\nbrowser. The screenshot below shows our selection:</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText align=center style=''text-align:center''><img border=0 width=659 height=436\r\nsrc=\"./UserImages/yessoftware/image049.gif\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<\r\n<',4);
GO

INSERT INTO article_contents(art_content_id,art_id,art_content_name,art_content,art_content_ord) 
 VALUES (126,21,'V. Creating CodeCharge Pages - The Public Access Pages','\n<p class=MsoBodyText>The plot gets more interesting here with our arrival to\r\nthe key section of CodeCharge &#8211; creating web pages. In this project, the pages\r\ncan be broadly subdivided into two categories: the public access pages which\r\nwill be visible to all the members and the administrative pages which will be\r\naccessible only to the site administrators and editors. We are going to begin\r\nby creating the public access pages.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>Upon selecting the <b>Pages </b>menu item on the left menu\r\nbar, you will see the following screen:</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText><img border=0 width=659 height=237\r\nsrc=\"./UserImages/yessoftware/image051.gif\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>This screen allows you to add new pages to our web site,\r\neither through the <span class=ScreenMenusNames><span style=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Add Page</span></span> option or by using the <span\r\nclass=ScreenMenusNames><span style=''font-size:11.0pt;\r\nfont-family:\"Microsoft Sans Serif\";''>New\r\nPage Wizard</span></span>.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<h2 style=''margin-left:0in;text-indent:0in''><a name=\"_Toc515701458\"></a><a\r\nname=\"_Toc516936347\">1.<span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Adding New Pages</a></h2>\r\n\r\n<p class=MsoBodyText>To create the first page, click on the <span\r\nclass=ScreenMenusNames><span style=''font-size:11.0pt;\r\nfont-family:\"Microsoft Sans Serif\";''>Add\r\nPage</span></span> option which brings up the page design screen. This is the\r\nmain page design workspace which allows you to semi-visually design your pages.\r\nFor designing web pages, CodeCharge uses a template driven paradigm whereby you\r\ncustomize your pages by filling in various options and adding custom code.\r\nAfter adding a new page, notice in the left dropdown menu bar that the new page\r\nis added to the <b>Pages</b> hierarchy with the default name &#8216;<span\r\nclass=UserSelection><span style=''font-size:11.0pt;\r\nfont-family:Arial''>Page</span></span>&#8217;.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText><img border=0 width=659 height=346\r\nsrc=\"./UserImages/yessoftware/image053.gif\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>You can, and will find it necessary to give this &#8216;<span\r\nclass=UserSelection><span style=''font-size:11.0pt;\r\nfont-family:Arial''>Page</span></span>&#8217; a different name to reflect its use. The\r\nmain page design screen contains information pertaining to the currently\r\nselected page. It is divided into <span class=ScreenMenusNames><span\r\nstyle=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Page</span></span>, <span\r\nclass=ScreenMenusNames><span style=''font-size:11.0pt;\r\nfont-family:\"Microsoft Sans Serif\";''>Forms</span></span>\r\nand <span class=ScreenMenusNames><span style=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Fields\r\n</span></span>components. We will go through each component in detail, but be\r\naware that each page may include multiple forms and each form may include\r\nmultiple fields. For instance, when you create a page, you may place multiple\r\nforms on it such as a search form, a grid form or a record form. Similarly,\r\neach form may include information based on multiple database Fields. For\r\nexample the event list is a form with multiple fields or in other words a table\r\nwith multiple columns.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<h2 style=''margin-left:0in;text-indent:0in''><a name=\"_Toc515701459\"></a><a\r\nname=\"_Toc516936348\">2.<span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Creating the Login Page</a></h2>\r\n\r\n<p class=MsoBodyText>We shall begin by creating what is perhaps the simplest\r\nyet significantly important page &#8211; the Login page. This page is required since\r\nearlier on we selected the <span class=ScreenMenusNames><span style=''font-size:\r\n11.0pt;font-family:\"Microsoft Sans Serif\";''>Authentication</span></span> option in the site properties <span\r\nclass=ScreenMenusNames><span style=''font-size:11.0pt;\r\nfont-family:\"Microsoft Sans Serif\";''>Security</span></span>\r\ntab. This page will prompt users to supply their login and password particulars\r\nand set security privileges based on their security level.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<h3 style=''margin-left:0in;text-indent:0in''><a name=\"_Toc515701460\"></a><a\r\nname=\"_Toc516936349\">2.1<span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Page Component</a></h3>\r\n\r\n<p class=MsoBodyText>The <span class=ScreenMenusNames><span style=''font-size:\r\n11.0pt;font-family:\"Microsoft Sans Serif\";''>Page</span></span> component is the first of the three page\r\ncomponents and appears at the top of the page design template. Use the page\r\ncomponent to set general information about the page, such as <span\r\nclass=ScreenMenusNames><span style=''font-size:11.0pt;\r\nfont-family:\"Microsoft Sans Serif\";''>Name,\r\nTitle </span></span><span class=ScreenMenusNames>and</span><span\r\nclass=ScreenMenusNames><span style=''font-size:11.0pt;\r\nfont-family:\"Microsoft Sans Serif\";''>\r\nSecurity Level:</span></span></p>\r\n\r\n<p class=MsoBodyText align=center style=''text-align:center''><img border=0 width=659 height=188\r\nsrc=\"./UserImages/yessoftware/image055.gif\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>1.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>For the new page, enter &#8216;<span class=UserSelection><span\r\nstyle=''font-size:11.0pt;font-family:Arial''>Login</span></span>&#8217;\r\nas the name of the Page. This will be the name of the generated file, for\r\nexample <b>Login.asp, Login.php and/or Login.html.</b></p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>2.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Next, enter &#8216;<span class=UserSelection><span style=''font-size:\r\n11.0pt;font-family:Arial''>Events &#8211; Login Page&#8217;</span></span>\r\nas the page <span class=ScreenMenusNames><span style=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Title</span></span>. The title will be displayed at the top\r\nof the browser when the page is viewed.</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>3.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span><span class=ScreenMenusNames><span style=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Security Level</span></span> is not needed because this is\r\nthe login Page and doesn&#8217;t need to be protected. We will use the <span\r\nclass=ScreenMenusNames><span style=''font-size:11.0pt;\r\nfont-family:\"Microsoft Sans Serif\";''>Security\r\nLevel</span></span> setting on other pages where we want to force users to\r\nlogin before accessing the page.</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>4.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span><span class=ScreenMenusNames><span style=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Columnar Layout</span></span> is also not needed at this\r\ntime because it controls the way the page looks like when there are multiple\r\nforms on the page. The login page will have only one form and hence there is no\r\nneed to set this option.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>There are also various icons in the <span\r\nclass=ScreenMenusNames><span style=''font-size:11.0pt;\r\nfont-family:\"Microsoft Sans Serif\";''>Page</span></span>\r\ncomponent and although we don&#8217;t need to use then at this point in time, note\r\ntheir respective uses:</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText><a name=\"_Toc515701461\"><b>Page Properties</b></a></p>\r\n\r\n<p class=MsoBodyText><img border=0 width=20 height=21\r\nsrc=\"./UserImages/yessoftware/image056.gif\" alt=\"*\"></p>\r\n\r\n<p class=MsoBodyText>Click on this icon to setup additional page properties,\r\nsuch as custom code to be executed when the page is opened or custom HTML code\r\nto be included on the page.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText><a name=\"_Toc515701462\"><b>Delete Page</b></a></p>\r\n\r\n<p class=MsoBodyText><img border=0 width=20 height=20\r\nsrc=\"./UserImages/yessoftware/image057.gif\" alt=\"*\">       </p>\r\n\r\n<p class=MsoBodyText>Click on this icon to delete the current page. A dialog\r\nbox will appear asking you to confirm the action.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText><a name=\"_Toc515701463\"><b>Generate Page</b></a></p>\r\n\r\n<p class=MsoBodyText><img border=0 width=17 height=19\r\nsrc=\"./UserImages/yessoftware/image058.gif\" alt=\"*\"></p>\r\n\r\n<p class=MsoBodyText>Click on this icon to generate the source files for the\r\ncurrent page.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<h3 style=''margin-left:0in;text-indent:0in''><a name=\"_Toc515701464\"></a><a\r\nname=\"_Toc516936350\">2.2<span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Forms Component</a></h3>\r\n\r\n<p class=MsoBodyText>The <span class=ScreenMenusNames><span style=''font-size:\r\n11.0pt;font-family:\"Microsoft Sans Serif\";''>Forms</span></span> component is directly below the <span\r\nclass=ScreenMenusNames><span style=''font-size:11.0pt;\r\nfont-family:\"Microsoft Sans Serif\";''>Pages\r\n</span></span>component. As mentioned earlier on, some pages will include\r\nmultiple forms such as Search, Grid, Login, etc. Since we are creating just a\r\nsimple login page, we will only include one form at this time &#8211; the login form\r\nas shown below:</p>\r\n\r\n<p class=MsoBodyText align=center style=''text-align:center''><img border=0 width=426 height=156\r\nsrc=\"./UserImages/yessoftware/image059.gif\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText><a name=\"_Toc515701465\"><b>Form Name</b></a></p>\r\n\r\n<p class=MsoBodyText>Enter &#8216;<span class=UserSelection><span style=''font-size:\r\n11.0pt;font-family:Arial''>Login</span></span>&#8217; as the\r\nname of the form. Note that the form name is not visible to you or the user,\r\nbut each form has to have a different name which can be used by a script to\r\nmanipulate the form or the elements within it.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText><a name=\"_Toc515701466\"><b>Form Title</b></a></p>\r\n\r\n<p class=MsoBodyText>Enter the form title as &#8216;<span class=UserSelection><span\r\nstyle=''font-size:11.0pt;font-family:Arial''>Login</span></span>&#8217;.\r\nThe title is displayed to the user and usually appears at the top of the table\r\nwhich contains the form. Note that the title can be omitted is so desired.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText><a name=\"_Toc515701467\"><b>Form Type</b></a></p>\r\n\r\n<p class=MsoBodyText>Choose &#8216;<span class=UserSelection><span style=''font-size:\r\n11.0pt;font-family:Arial''>Login&#8217;</span></span> as the\r\nform type. CodeCharge supports different types of forms, each serving a\r\ndifferent purpose. For example grid forms are used to display multiple records\r\nfrom a database table or query while record forms are used to manipulate\r\nindividual records.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText><a name=\"_Toc515701468\"><b>Form Action</b></a></p>\r\n\r\n<p class=MsoBodyText><span class=ScreenMenusNames><span style=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Form Action</span></span> allows you to specify the\r\ndestination page where the user will be redirected after successfully logging\r\nin. At the moment, since we haven&#8217;t as yet created any other pages, select <span\r\nclass=UserSelection><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&#8216;Login&#8217;</span></span> as the <span class=ScreenMenusNames><span\r\nstyle=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Form Action</span></span> page. </p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>The Login form is probably the easiest form to setup. You\r\nonly need the above 4 entries and your entire login page is ready. CodeCharge\r\nalready knows that the member logins and passwords are stored in the &#8216;<span\r\nclass=UserSelection><span style=''font-size:11.0pt;\r\nfont-family:Arial''>members</span></span>&#8217; table because we entered this\r\ninformation in the <span class=ScreenMenusNames><span style=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Security</span></span> tab of <span class=ScreenMenusNames><span\r\nstyle=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Site Properties</span></span>.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>The screenshot below shows how the Login page shall look\r\nlike once generated. </p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText align=center style=''text-align:center''><img border=0 width=286 height=232\r\nsrc=\"./UserImages/yessoftware/image060.gif\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>The form title is circled in <span style=''color:red''>red</span>\r\nand corresponds to the entry made in the <span class=ScreenMenusNames><span\r\nstyle=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Form Title</span></span> field.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>Apart from the setting we have so far seen, there are\r\nadditional form properties in CodeCharge which we don&#8217;t need to delve into at\r\nthis time. However, as we build more pages, we will undoubtedly make use of\r\nthese features. By way of introduction, the following is a brief overview of\r\nthese features.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText><a name=\"_Toc515701469\"><b>Form Action</b></a></p>\r\n\r\n<p class=MsoBodyText><img border=0 width=146 height=39\r\nsrc=\"./UserImages/yessoftware/image061.gif\"></p>\r\n\r\n<p class=MsoBodyText>Typically, when you submit a form, the form data is sent to\r\nanother page for processing. This recipient page is specified in the <b>Form\r\nAction</b> field. Some forms, such as the Menu form do not need a form action\r\nand hence the field is left blank.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText><a name=\"_Toc515701470\"><b>Form Properties</b></a></p>\r\n\r\n<p class=MsoBodyText><img border=0 width=20 height=21\r\nsrc=\"./UserImages/yessoftware/image056.gif\" alt=\"*\"></p>\r\n\r\n<p class=MsoBodyText>Clicking on this icon brings up the <b>Form Properties</b>\r\nwindow where you can configure other features of the form as well as write\r\ncustom HTML, SQL and Event code. </p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<h3 style=''margin-left:0in;text-indent:0in''><a name=\"_Toc515701471\"></a><a\r\nname=\"_Toc516936351\">2.3<span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Fields Component</a></h3>\r\n\r\n<p class=MsoBodyText>This is the component directly below the <span\r\nclass=ScreenMenusNames><span style=''font-size:11.0pt;\r\nfont-family:\"Microsoft Sans Serif\";''>Forms\r\n</span></span>component. As the name implies, it is used to add fields which\r\ncan be though of as windows for the database data. Depending on your needs, you\r\ncan add various types of fields as will be demonstrated as we add more pages.\r\nUnlike the other pages that we shall create, note that the Login page fields\r\nare created automatically by CodeCharge thus making it unnecessary for us to\r\nadd any fields to it. Our Login page is thus completed.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>Press <i>ctrl </i>+ S to save your project.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<h3 style=''margin-left:0in;text-indent:0in''><a name=\"_Toc515701472\"></a><a\r\nname=\"_Toc516936352\">2.4<span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Generating the Login Page</a></h3>\r\n\r\n<p class=MsoBodyText>If you would like to generate the code and see how the\r\nLogin page looks like in your browser, you will need to go back to the <span\r\nclass=ScreenMenusNames><span style=''font-size:11.0pt;\r\nfont-family:\"Microsoft Sans Serif\";''>Site\r\nProperties</span></span> / <span class=ScreenMenusNames><span style=''font-size:\r\n11.0pt;font-family:\"Microsoft Sans Serif\";''>Pages</span></span> section, and specify the newly created\r\npage as the <span class=ScreenMenusNames><span style=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Login Page</span></span>. While you are at it, also specify\r\nthe<span class=UserSelection><span style=''font-size:11.0pt;font-family:Arial''> &#8216;Login&#8217;</span></span> page as your <span\r\nclass=ScreenMenusNames><span style=''font-size:11.0pt;\r\nfont-family:\"Microsoft Sans Serif\";''>Default\r\nPage</span></span> pending creation of more pages. The <span style=''color:red''>red</span>\r\nportions of the screenshot below illustrate this. </p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText><img border=0 width=662 height=267\r\nsrc=\"./UserImages/yessoftware/image063.gif\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>Once you set up the main pages, click on the <span\r\nclass=ScreenMenusNames><span style=''font-size:11.0pt;\r\nfont-family:\"Microsoft Sans Serif\";''>Home</span></span>\r\nicon <img border=0 width=17 height=17\r\nsrc=\"./UserImages/yessoftware/image064.gif\">,\r\ncircled in <span style=''color:blue''>blue</span> in the above screenshot.</p>\r\n\r\n<p class=MsoBodyText>When you click on the <img border=0 width=17 height=17\r\nsrc=\"./UserImages/yessoftware/image064.gif\"> icon, CodeCharge will automatically generate\r\nthe site and open the default page. </p>\r\n\r\n<p class=MsoBodyText><a name=\"_Toc515701473\">&nbsp;</a></p>\r\n\r\n<h2 style=''margin-left:0in;text-indent:0in''><a\r\nname=\"_Toc516936353\">3.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Creating the Default Page</a></span></h2>\r\n\r\n<p class=MsoBodyText>Having created the first simple page, we proceed to the\r\nmain page of the web site &#8211; the Default Page. To illustrate another technique\r\nfor adding new pages, right click on the &#8216;Pages&#8217; icon on the left dropdown menu\r\nbar, and select <span class=ScreenMenusNames><span style=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Add Page</span></span> as shown below.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText align=center style=''text-align:center''><img border=0 width=301 height=222\r\nsrc=\"./UserImages/yessoftware/image065.gif\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<h3 style=''margin-left:0in;text-indent:0in''><a name=\"_Toc515701474\"></a><a\r\nname=\"_Toc516936354\">3.1<span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Page Component</a></h3>\r\n\r\n<p class=MsoBodyText>Call this new page either <b>Default</b> or <b>Index</b>.\r\nMost servers usually execute such pages automatically when no page is specified\r\nin the URL. For example, if you type a URL such as www.yoursite.com, the server\r\nwill usually try to automatically send the Index.html or Default.html page to\r\nthe browser. If Index.html or Default.html doesn&#8217;t exist, the server may search\r\nfor and execute Index.php or Default.asp, depending on the server&#8217;s\r\nconfiguration. Windows servers are often setup to execute Default.html and then\r\nDefault.asp while Linux servers are usually setup to execute Index.html, and if\r\nnot found &#8211; Index.asp. In our case, naming our page &#8216;Default&#8217; enables the web\r\nserver to find and execute it. </p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>With that done, the top section of your workspace should\r\nnow look like this:</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText><img border=0 width=662 height=190\r\nsrc=\"./UserImages/yessoftware/image067.gif\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<h3 style=''margin-left:0in;text-indent:0in''><a name=\"_Toc515701475\"></a><a\r\nname=\"_Toc516936355\">3.2<span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Forms Component</a></h3>\r\n\r\n<p class=MsoBodyText>With the fundamentals defined, we now move on to the key\r\narea of the Default page. Consider for a while how the main page should look\r\nlike. In the interest of simplicity, we probably should include the list of\r\nevents directly on this page, for example in a table. We should also include a\r\nsearch form at the top so that users can find the events they are interested\r\nin. With that in mind, below is a draft design of the page to be created.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText align=center style=''text-align:center''><img border=0 width=471 height=205\r\nsrc=\"./UserImages/yessoftware/image068.gif\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>The above diagram represents only a general idea of the\r\nDefault page. It is not an actual page or screenshot. Moving on to the actual\r\npage creation, we will need to setup each of the above sections separately in\r\ndistinct forms. Therefore the event search and the event list will each be a\r\nform. The first form to be created will be the search form because it is\r\npositioned at the top of the page.  </p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<h4 style=''margin-left:0in;text-indent:0in''><a name=\"_Toc515701476\"></a><a\r\nname=\"_Toc516936356\">3.2.1<span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>The Search Form</a></h4>\r\n\r\n<p class=MsoBodyText>Setup the search component as follows:</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText><img border=0 width=662 height=303\r\nsrc=\"./UserImages/yessoftware/image070.gif\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>1.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Enter <b>&#8216;</b><span class=UserSelection><span\r\nstyle=''font-size:11.0pt;font-family:Arial''>Search</span></span><b>&#8217;</b>\r\nas the <span class=ScreenMenusNames><span style=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Form\r\nName</span></span> and keep in mind that each form on a page must have a\r\ndifferent name. Also, don&#8217;t use spaces or other special characters in form\r\nnames.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>2.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Select <b>&#8216;</b><span class=UserSelection><span\r\nstyle=''font-size:11.0pt;font-family:Arial''>Search</span></span><b>&#8217;</b>\r\nas the <span class=ScreenMenusNames><span style=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Form\r\nType</span></span><b>. </b><span class=ScreenMenusNames><span style=''font-size:\r\n11.0pt;font-family:\"Microsoft Sans Serif\";''>Search</span></span> is one of six predefined form types in\r\nCodeCharge. As we saw earlier, CodeCharge supports multiple form types, each\r\nserving a different purpose. As you would imagine the search form will be of\r\ntype <span class=ScreenMenusNames><span style=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Search</span></span>\r\nwhich will allow us to specify various search fields by which to search the\r\nevents. </p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>3.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Enter <span class=UserSelection><span style=''font-size:11.0pt;font-family:Arial''>&#8216;Event Search&#8217;</span></span> as\r\nthe <span class=ScreenMenusNames><span style=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Form\r\nTitle</span></span>. This title will be displayed on the page as the heading of\r\nthe search section.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>4.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span><span class=ScreenMenusNames><span style=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Form Action</span></span> is the destination page to be\r\nexecuted when the user searches for something. In our case, the search results\r\nwill be displayed on the same page, so set <span class=ScreenMenusNames><span\r\nstyle=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Form Action</span></span> to <span\r\nclass=UserSelection><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&#8216;Default&#8217;</span></span>where <span\r\nclass=UserSelection><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&#8216;Default&#8217;</span></span> is the name of the page we just\r\ncreated.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>5.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>In the <span class=ScreenMenusNames><span style=''font-size:\r\n11.0pt;font-family:\"Microsoft Sans Serif\";''>Table</span></span>field select <span\r\nclass=UserSelection><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&#8216;events&#8217;</span></span> which is one of the database tables\r\nwe created earlier. </p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<h3 style=''margin-left:0in;text-indent:0in''><a name=\"_Toc515701477\"></a><a\r\nname=\"_Toc516936357\">3.3<span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Fields Component</a></h3>\r\n\r\n<p class=MsoBodyText>Now it&#8217;s time to specify the fields that will be used in\r\nthe search form. As illustrated in the draft design, the users should be able\r\nto search events by event name, location, start date and end date. Click on the\r\nsmall icon next to the <span class=ScreenMenusNames><span style=''font-size:\r\n11.0pt;font-family:\"Microsoft Sans Serif\";''>Fields</span></span> caption as shown in <span\r\nstyle=''color:red''>red</span> below:</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText align=center style=''text-align:center''><img border=0 width=662 height=460\r\nsrc=\"./UserImages/yessoftware/image072.gif\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>You should then be presented with a window that has a list\r\nof fields from the events table as circled in <span style=''color:blue''>blue </span>above.\r\nThere are 3 fields that need to be selected:</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''><span style=''font-family:Wingdings''><span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span>event_name</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''><span style=''font-family:Wingdings''><span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span>event_date</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''><span style=''font-family:Wingdings''><span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span>location_id</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>You may select all these fields at once by holding down\r\nthe <i>Ctrl</i> key on your keyboard while you click on each of the desired\r\nfields. When done, click on the <span class=ScreenMenusNames><span\r\nstyle=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Add</span></span> button after which\r\nyou will see that CodeCharge added all 3 fields into your page as shown below:</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText align=center style=''text-align:center''><img border=0 width=527 height=398\r\nsrc=\"./UserImages/yessoftware/image073.gif\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>Notice that the selected database fields are shown to the\r\nleft, followed by automatically created field <span class=ScreenMenusNames><span\r\nstyle=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Captions</span></span>, which\r\ncorrespond to the field names. Next is the field <span class=ScreenMenusNames><span\r\nstyle=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Type</span></span> and <span\r\nclass=ScreenMenusNames><span style=''font-size:11.0pt;\r\nfont-family:\"Microsoft Sans Serif\";''>Size</span></span>.\r\nAs it is, the page would look similar to the screenshot below if generated and\r\nviewed in a browser.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText align=center style=''text-align:center''><img border=0 width=640 height=70\r\nsrc=\"./UserImages/yessoftware/image075.jpg\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>The form would prompt the user to enter event_name,\r\nevent_date and location_id as search criteria. The form also contains a <span\r\nclass=ScreenMenusNames><span style=''font-size:11.0pt;\r\nfont-family:\"Microsoft Sans Serif\";''>Search</span></span>\r\nbutton which submits the form to the processing (Action) page. Though\r\nfunctional, the page still looks pretty awkward and unfinished. To make it more\r\npresentable, change the field captions to something more appropriate and\r\nunderstandable as shown below.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText align=center style=''text-align:center''><img border=0 width=525 height=134\r\nsrc=\"./UserImages/yessoftware/image076.gif\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>That done, move the <span class=UserSelection><span\r\nstyle=''font-size:11.0pt;font-family:Arial''>&#8216;Start\r\nDate&#8217;</span></span> field to the bottom of the list. You can do this by\r\nclicking on the <span class=UserSelection><span style=''font-size:11.0pt;font-family:Arial''>&#8216;Start Date&#8217;</span></span> caption\r\nand then clicking on the small arrow to the left pointing downwards.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText align=center style=''text-align:center''><img border=0 width=525 height=134\r\nsrc=\"./UserImages/yessoftware/image077.gif\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>The end result should be similar to the screenshot below.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText align=center style=''text-align:center''><img border=0 width=526 height=134\r\nsrc=\"./UserImages/yessoftware/image079.jpg\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>Proceed now to set the size of each of the fields. The\r\n&#8216;size&#8217; field is in the rightmost column. CodeCharge automatically pre-fills the\r\nfield sizes based on information obtained from the database but sometimes it\r\nmay not receive the accurate information or you may simply want the size of the\r\nfield on the page to be different from the database defined size. Enter the\r\nsizes as follows:</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText align=center style=''text-align:center''><img border=0 width=534 height=145\r\nsrc=\"./UserImages/yessoftware/image080.gif\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>This means that the form will show a 25 character long\r\nfield where the user can enter the event name, 10 character long field to enter\r\nthe starting date, and 0 characters for location. Why 0 characters for\r\nlocation? Because the location will be selected from a drop-down list populated\r\nwith only the available locations. </p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<h4 style=''margin-left:0in;text-indent:0in''><a name=\"_Toc515701478\"></a><a\r\nname=\"_Toc516936358\">3.3.1<span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Field Types</a></h4>\r\n\r\n<p class=MsoBodyText>CodeCharge allows you to specify the <span\r\nclass=ScreenMenusNames><span style=''font-size:11.0pt;\r\nfont-family:\"Microsoft Sans Serif\";''>Type</span></span>\r\nof each field in your form. You do so by making a selection in the 3<sup>rd</sup>\r\ncolumn of the <span class=ScreenMenusNames><span style=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Fields</span></span> component of the page template. The\r\nfollowing is an explanation of the different field types.</p>\r\n\r\n<p class=MsoBodyText> </p>\r\n\r\n<p class=MsoBodyText><a name=\"_Toc515701479\"><b>Checkbox Field</b></a></p>\r\n\r\n<p class=MsoBodyText>This field type allows the user to specify a True or False\r\ncondition by checking a box, as shown below:</p>\r\n\r\n<p class=MsoBodyText><img border=0 width=114 height=27\r\nsrc=\"./UserImages/yessoftware/image081.gif\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText><a name=\"_Toc515701480\"><b>Hidden Field</b></a></p>\r\n\r\n<p class=MsoBodyText>As the name implies, this is a hidden field not visible to\r\nthe user but present within the forms html code. It is used primarily to obtain\r\nthe data from the database to be passed to another page.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText><a name=\"_Toc515701481\"><b>Label Field</b></a></p>\r\n\r\n<p class=MsoBodyText>This field type simply displays the database value on the\r\npage as plain text.</p>\r\n\r\n<p class=MsoBodyText><img border=0 width=83 height=24\r\nsrc=\"./UserImages/yessoftware/image082.gif\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText><a name=\"_Toc515701482\"><b>URL Field</b></a></p>\r\n\r\n<p class=MsoBodyText>This field type displays the text from the database as a\r\nclickable link to another page or website:</p>\r\n\r\n<p class=MsoBodyText><img border=0 width=188 height=24\r\nsrc=\"./UserImages/yessoftware/image083.gif\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText><a name=\"_Toc515701483\"><b>Textbox</b></a></p>\r\n\r\n<p class=MsoBodyText>This is the default field type which allows the user to\r\nenter some information into a single field. If used with the caption <span\r\nclass=UserSelection><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&#8216;Name&#8217;</span></span>, it will be displayed in the web page\r\nlike this.</p>\r\n\r\n<p class=MsoBodyText><img border=0 width=236 height=32\r\nsrc=\"./UserImages/yessoftware/image084.gif\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText><a name=\"_Toc515701484\"><b>TextArea Field</b></a></p>\r\n\r\n<p class=MsoBodyText>This field type is similar to the Textbox but with added\r\ncapacity to enable the user to enter larger amounts of information. It usually\r\ncontains several lines and is often connected to memo type fields in the\r\ndatabase. It is displayed on web pages as follows.</p>\r\n\r\n<p class=MsoBodyText><img border=0 width=322 height=64\r\nsrc=\"./UserImages/yessoftware/image085.gif\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>In our Events project, we want the location field to be of\r\ntype <b>Listbox</b> whereby the user will be able to make a selection from a\r\nlist of available options as shown below.</p>\r\n\r\n<p class=MsoBodyText align=center style=''text-align:center''><img border=0 width=616 height=205\r\nsrc=\"./UserImages/yessoftware/image087.jpg\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>To achieve this, select Listbox as the field <span\r\nclass=ScreenMenusNames><span style=''font-size:11.0pt;\r\nfont-family:\"Microsoft Sans Serif\";''>Type</span></span>\r\nas shown below in <span style=''color:red''>red</span>:</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText align=center style=''text-align:center''><img border=0 width=534 height=141\r\nsrc=\"./UserImages/yessoftware/image088.gif\"></p>\r\n\r\n<p class=MsoBodyText><a name=\"_Toc515701485\">&nbsp;</a></p>\r\n\r\n<h4 style=''margin-left:0in;text-indent:0in''><a\r\nname=\"_Toc516936359\">3.3.2<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Field Properties</a></span></h4>\r\n\r\n<p class=MsoBodyText>Click on Field Properties icon <img border=0 width=20 height=21\r\nsrc=\"./UserImages/yessoftware/image056.gif\"> which appears at the far right end of the\r\nlocation_id field, shown above in <span style=''color:blue''>blue</span>. This\r\nshould bring up the field Properties window. Click on the <span\r\nclass=ScreenMenusNames><span style=''font-size:11.0pt;\r\nfont-family:\"Microsoft Sans Serif\";''>List</span></span>tab as shown below in <span style=''color:red''>red</span>.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText align=center style=''text-align:center''><img border=0 width=656 height=200\r\nsrc=\"./UserImages/yessoftware/image090.gif\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>In the <span class=ScreenMenusNames><span\r\nstyle=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>List</span></span>tab, specify\r\nthe following details:</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''><span style=''font-family:Wingdings''><span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span><span class=ScreenMenusNames><span style=''font-size:\r\n11.0pt;font-family:\"Microsoft Sans Serif\";''>Table</span></span>: the table containing the values to be\r\nshown in the drop-down list. In our case &#8211; <span class=UserSelection><span\r\nstyle=''font-size:11.0pt;font-family:Arial''>&#8216;locations&#8217;</span></span>.</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''><span style=''font-family:Wingdings''><span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span><span class=ScreenMenusNames><span style=''font-size:\r\n11.0pt;font-family:\"Microsoft Sans Serif\";''>Primary Key</span></span>: the field containing the table\r\nkey. In our case &#8211;<span class=UserSelection><span style=''font-size:11.0pt;font-family:Arial''>&#8216; location_id&#8217;</span></span></p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''><span style=''font-family:Wingdings''><span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span><span class=ScreenMenusNames><span style=''font-size:\r\n11.0pt;font-family:\"Microsoft Sans Serif\";''>Showing</span></span>: the field that should be shown in the\r\ndrop-down list on the page. In our case &#8211; <span class=UserSelection><span\r\nstyle=''font-size:11.0pt;font-family:Arial''>&#8216;location&#8217;</span></span>.</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''><span style=''font-family:Wingdings''><span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span><span class=ScreenMenusNames><span style=''font-size:\r\n11.0pt;font-family:\"Microsoft Sans Serif\";''>Lookup SQL</span></span> and <span class=ScreenMenusNames><span\r\nstyle=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>List Of Values</span></span> are not\r\nneeded at this time. They can be used to display lists with custom values.</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.25in''>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>Click <span class=ScreenMenusNames><span style=''font-size:\r\n11.0pt;font-family:\"Microsoft Sans Serif\";''>Ok</span></span> to save your configurations and close the\r\nwindow.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>The search form now has most of its components except for\r\nthe <span class=UserSelection><span style=''font-size:11.0pt;font-family:Arial''>&#8216;End Date&#8217;</span></span> field. To remedy this, add a\r\nnew field by clicking on the 2<sup>nd</sup> icon shown below in <span\r\nstyle=''color:red''>red</span>. This will add a blank field to the bottom of the\r\nother form fields.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText align=center style=''text-align:center''><img border=0 width=534 height=167\r\nsrc=\"./UserImages/yessoftware/image091.gif\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>From the <span class=ScreenMenusNames><span\r\nstyle=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Field</span></span> dropdown list,\r\nselect <span class=UserSelection><span style=''font-size:11.0pt;font-family:Arial''>&#8216;event_date&#8217;</span></span> then enter <span\r\nclass=UserSelection><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&#8216;End Date&#8217; </span></span>as the field <span\r\nclass=ScreenMenusNames><span style=''font-size:11.0pt;\r\nfont-family:\"Microsoft Sans Serif\";''>Caption</span></span>\r\nwith <span class=ScreenMenusNames><span style=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Size</span></span>\r\nset to <span class=UserSelection><span style=''font-size:11.0pt;font-family:Arial''>&#8216;10&#8217;</span></span>.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText align=center style=''text-align:center''><img border=0 width=526 height=155\r\nsrc=\"./UserImages/yessoftware/image092.gif\"></p>\r\n\r\n<p class=MsoBodyText align=center style=''text-align:center''>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>We now have all 4 fields for the search section of the\r\npage. To allow the search section to work seamlessly with other sections of the\r\npage, make the following changes. Click on the field properties icon <img border=0 width=20 height=21\r\nsrc=\"./UserImages/yessoftware/image056.gif\"> next to the <span class=UserSelection><span\r\nstyle=''font-size:11.0pt;font-family:Arial''>&#8216;Start\r\nDate&#8217;</span></span> field. In the window that pops up change the <span\r\nclass=ScreenMenusNames><span style=''font-size:11.0pt;\r\nfont-family:\"Microsoft Sans Serif\";''>Name</span></span>\r\nof the current field (&#8216;<span class=UserSelection><span style=''font-size:11.0pt;font-family:Arial''>event_date&#8217;</span></span>) to <span\r\nclass=UserSelection><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&#8216;start_date&#8217;</span></span>.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText align=center style=''text-align:center''><img border=0 width=547 height=279\r\nsrc=\"./UserImages/yessoftware/image094.jpg\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>It is intended that the user will be able to search for\r\nevents beginning at a particular date and/or ending at a particular date.\r\nNaturally, it would be convenient to have field names which reflect the nature\r\nof the data they will contain. It is for this reason that we changed the name\r\nof the field above to start_date. Likewise, change the name of the second <span\r\nclass=UserSelection><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&#8216;event_date&#8217;</span></span> to <span class=UserSelection><span\r\nstyle=''font-size:11.0pt;font-family:Arial''>&#8216;end_date&#8217;</span></span>.\r\nYou can do so by simply clicking on field name in the list of fields then\r\nchanging its name to &#8216;end_date&#8217;. This is illustrated below:</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText align=center style=''text-align:center''><img border=0 width=523 height=303\r\nsrc=\"./UserImages/yessoftware/image095.jpg\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>Click <span class=ScreenMenusNames><span style=''font-size:\r\n11.0pt;font-family:\"Microsoft Sans Serif\";''>Ok</span></span> to save your configuration and close the\r\nwindow.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>At this juncture, the top section the web page is ready\r\nand would look like this if generated and viewed in a browser.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText><img border=0 width=656 height=63\r\nsrc=\"./UserImages/yessoftware/image097.jpg\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>One last detail is to change the orientation of the search\r\nform. Click on the properties icon <img border=0 width=20 height=21\r\nsrc=\"./UserImages/yessoftware/image056.gif\"> as shown below.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText align=center style=''text-align:center''><img border=0 width=543 height=159\r\nsrc=\"./UserImages/yessoftware/image098.gif\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>Once the <span class=ScreenMenusNames><span\r\nstyle=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Form Properties</span></span> window\r\npops up, change <span class=ScreenMenusNames><span style=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Orientation</span></span> from <span class=UserSelection><span\r\nstyle=''font-size:11.0pt;font-family:Arial''>&#8216;Horizontal&#8217;</span></span>\r\nto <span class=UserSelection><span style=''font-size:11.0pt;font-family:Arial''>&#8216;Vertical&#8217;</span></span>as shown below thenclick <span class=ScreenMenusNames><span style=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Ok</span></span> to close the window.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText><img border=0 width=662 height=424\r\nsrc=\"./UserImages/yessoftware/image100.gif\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<h4 style=''margin-left:0in;text-indent:0in''><a name=\"_Toc515701486\"></a><a\r\nname=\"_Toc516936360\">3.3.3<span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Previewing Search Form</a></h4>\r\n\r\n<p class=MsoBodyText>Having completed the search form, go ahead and generate it\r\nto see how the page looks like in your browser. Before you do so, go back to\r\nthe <span class=ScreenMenusNames><span style=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Site\r\nProperties / Pages</span></span> tab and specify <span class=UserSelection><span\r\nstyle=''font-size:11.0pt;font-family:Arial''>&#8216;Default&#8217;</span></span>\r\nas the site <span class=ScreenMenusNames><span style=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Default Page</span></span>. The relevant fields are shown\r\nbelow in <span style=''color:red''>red</span>.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText><img border=0 width=662 height=268\r\nsrc=\"./UserImages/yessoftware/image102.gif\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>Once you set up the default page, click on the <span\r\nclass=ScreenMenusNames><span style=''font-size:11.0pt;\r\nfont-family:\"Microsoft Sans Serif\";''>Home</span></span>\r\nicon <img border=0 width=17 height=17\r\nsrc=\"./UserImages/yessoftware/image064.gif\">,\r\ncircled in <span style=''color:blue''>blue</span> above. CodeCharge will\r\nautomatically generate the site and open the default page. You should see a\r\npage similar to the one shown below:</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText align=center style=''text-align:center''><img border=0 width=503 height=231\r\nsrc=\"./UserImages/yessoftware/image103.jpg\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<h3 style=''margin-left:0in;text-indent:0in''><a name=\"_Toc515701487\"></a><a\r\nname=\"_Toc516936361\">3.4<span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Events Grid Form</a></h3>\r\n\r\n<p class=MsoBodyText>As per our earlier draft of the default page, the next\r\nsection to build is the event list. </p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText align=center style=''text-align:center''><img border=0 width=471 height=205\r\nsrc=\"./UserImages/yessoftware/image068.gif\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>As the name suggests, the event list is simply a grid that\r\nshows a list of available events or events based on previously entered search\r\ncriteria. To start off, add a new form to the default page by clicking on the <span\r\nclass=ScreenMenusNames><span style=''font-size:11.0pt;\r\nfont-family:\"Microsoft Sans Serif\";''>New\r\nForm</span></span> icon circled below.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText><img border=0 width=662 height=477\r\nsrc=\"./UserImages/yessoftware/image105.gif\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText><a name=\"_Toc515701488\">&nbsp;</a></p>\r\n\r\n<h4 style=''margin-left:0in;text-indent:0in''><a\r\nname=\"_Toc516936362\">3.4.1<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Form</a></span>\r\nComponent</h4>\r\n\r\n<p class=MsoBodyText>Configure the new form as shown below:</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText align=center style=''text-align:center''><img border=0 width=526 height=131\r\nsrc=\"./UserImages/yessoftware/image106.gif\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>1.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span><span class=ScreenMenusNames><span style=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Name</span></span>: <span class=UserSelection><span\r\nstyle=''font-size:11.0pt;font-family:Arial''>&#8216;Events&#8217; </span></span>&#8211;\r\nthis is the internal name of the form. It cannot contain spaces and has to be\r\ndifferent from other form names within the same page.</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>2.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span><span class=ScreenMenusNames><span style=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Form Title</span></span>: <span class=UserSelection><span\r\nstyle=''font-size:11.0pt;font-family:Arial''>&#8216;Event\r\nList&#8217;</span></span> &#8211; this is the heading of the form section and will be shown\r\non the page.</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>3.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span><span class=ScreenMenusNames><span style=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Type</span></span>: <span class=UserSelection><span\r\nstyle=''font-size:11.0pt;font-family:Arial''>&#8216;Grid&#8217; </span></span>&#8211;\r\nthis form type is used to display multiple database records with the option to\r\nscroll through large amounts of records, sort them by particular columns and\r\ninsert new records.  </p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>4.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span><span class=ScreenMenusNames><span style=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Form Action</span></span>: <span class=UserSelection><span\r\nstyle=''font-size:11.0pt;font-family:Arial''>&#8216;Default&#8217;</span></span>\r\n&#8211; this is the destination page. If we added a button allowing users to add new\r\nevent types, the form data would be submitted to the page specified in the form\r\naction field. In this particular case, there is no need to have an action page\r\nsince no data will be submitted. However, it is good practice to set <span\r\nclass=ScreenMenusNames><span style=''font-size:11.0pt;\r\nfont-family:\"Microsoft Sans Serif\";''>Form\r\nAction</span></span> to the same page as the one being currently designed. </p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>5.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span><span class=ScreenMenusNames><span style=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Table</span></span>: <span class=UserSelection><span\r\nstyle=''font-size:11.0pt;font-family:Arial''>&#8216;events&#8217; </span></span>&#8211;\r\nthis is the table that contains the events to be browsed.</p>\r\n\r\n<p class=MsoBodyText>Click on <span class=ScreenMenusNames><span\r\nstyle=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Form Properties</span></span> icon <img border=0 width=20 height=21\r\nsrc=\"./UserImages/yessoftware/image056.gif\"> and in the <a name=\"_Toc515701489\"><span\r\nclass=ScreenMenusNames><span style=''font-size:11.0pt;\r\nfont-family:\"Microsoft Sans Serif\";''>Common</span></span>\r\ntab</a> provide additional information as follows:</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>6.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Deselect the <span class=ScreenMenusNames><span\r\nstyle=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Allow Insert</span></span> checkbox\r\nbecause we don&#8217;t want users to add new events</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>7.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Leave <span class=ScreenMenusNames><span style=''font-size:\r\n11.0pt;font-family:\"Microsoft Sans Serif\";''>Allow Sorting</span></span> checked &#8211; this will allow users\r\nto click on the column heading and sort the event list</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>8.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Leave <span class=ScreenMenusNames><span style=''font-size:\r\n11.0pt;font-family:\"Microsoft Sans Serif\";''>Page Scroller</span></span> checked &#8211; this will allow users\r\nto navigate back and forth when there are too many events to be shown on a\r\nsingle page. Accordingly, you can specify the maximum number of <span\r\nclass=ScreenMenusNames><span style=''font-size:11.0pt;\r\nfont-family:\"Microsoft Sans Serif\";''>Records</span></span>\r\nto be shown on a page. The default value is set to 20<b>. </b>Change it to <span\r\nclass=UserSelection><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&#8216;10&#8217;</span></span>.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>The properties window should now look similar to the\r\nscreenshot below.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText align=center style=''text-align:center''><img border=0 width=662 height=424\r\nsrc=\"./UserImages/yessoftware/image108.gif\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>While still in the properties window, click on the <span\r\nclass=ScreenMenusNames><span style=''font-size:11.0pt;\r\nfont-family:\"Microsoft Sans Serif\";''>Input</span></span>\r\ntab to specify all the variables that will be received from other pages or\r\nforms. For instance, when a search is performed in the search form we created\r\nearlier on, the submitted variables are channeled to the grid form which\r\nconsequently displays only those records which satisfy the search criteria.\r\nHowever, as a prelude to this, we have to specify the fields that the grid form\r\nshall be expecting to receive as well as their corresponding database field\r\nnames. </p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<div style=''border:solid white .75pt;border-bottom:none;padding:6.0pt 6.0pt 0in 6.0pt;\r\nbackground:#E5E5E5;''>\r\n\r\n<p class=BlockQuotationFirst>Note:</p>\r\n\r\n</div>\r\n\r\n<div style=''border:solid white .75pt;padding:12.0pt 12.0pt 12.0pt 12.0pt;\r\nbackground:#F9F9F9;''>\r\n\r\n<p class=BlockQuotation>If the input parameters that are passed by a search\r\nform have a one-to-one relationship with the fields in the receiving grid form,\r\nyou don&#8217;t have to specify input parameters. However, you have to specify input\r\nparameters when:</p>\r\n\r\n</div>\r\n\r\n<div style=''border:solid white .75pt;padding:12.0pt 12.0pt 12.0pt 12.0pt;\r\nbackground:#F9F9F9;''>\r\n\r\n<p class=BlockQuotation style=''margin-left:66.0pt;text-indent:-.25in;''><span\r\nstyle=''font-family:Wingdings''><span style=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span>The input parameters have different names from those of\r\nthe fields to which they will be matched in which case you have to specify them\r\nexplicitly. For instance, in our case, we have two fields named &#8216;start_date&#8221;\r\nand &#8216;end_date&#8217; which don&#8217;t correspond to any database fields and hence have to\r\nbe explicitly matched to the &#8216;event_date&#8217; field.</p>\r\n\r\n<p class=BlockQuotation style=''margin-left:66.0pt;text-indent:-.25in;''><span\r\nstyle=''font-family:Wingdings''><span style=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span>If you want to transfer parameters to a third page, you\r\nhave to specify input parameters and make sure the Transfer option is checked.</p>\r\n\r\n</div>\r\n\r\n<p class=MsoBodyText> Click on the <img border=0 width=17 height=19\r\nsrc=\"./UserImages/yessoftware/image109.gif\"> icon in the <b>Input</b> area to add new\r\nInput parameters, as shown below.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText align=center style=''text-align:center''><img border=0 width=662 height=424\r\nsrc=\"./UserImages/yessoftware/image111.gif\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>The following is an exposition on each of the lines added\r\nabove.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText><b>&nbsp;</b></p>\r\n\r\n<p class=MsoBodyText><b>&nbsp;</b></p>\r\n\r\n<p class=MsoBodyText><b>&nbsp;</b></p>\r\n\r\n<p class=MsoBodyText><b>event_name</b></p>\r\n\r\n<p class=MsoBodyText><b>&nbsp;</b></p>\r\n\r\n<p class=MsoBodyText align=center style=''text-align:center''><img border=0 width=631 height=45\r\nsrc=\"./UserImages/yessoftware/image112.gif\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''><span style=''font-family:Wingdings''><span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span>Going back to the events table in the events database,\r\nrecall that one of the fields was called event_name. By specifying event_name\r\nas one of the input parameters, the implication is that the user can search for\r\nevents with particular words in the event_name field of the database.   </p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''><span style=''font-family:Wingdings''><span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span>The <span class=ScreenMenusNames><span\r\nstyle=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Type</span></span> <span\r\nclass=UserSelection><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&#8216;Param&#8217;</span></span> means that this value is received as a\r\nform or URL parameter as opposed to as a session variable.</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''><span style=''font-family:Wingdings''><span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span><span class=ScreenMenusNames><span style=''font-size:\r\n11.0pt;font-family:\"Microsoft Sans Serif\";''>Data Type</span></span> <span class=UserSelection><span\r\nstyle=''font-size:11.0pt;font-family:Arial''>&#8216;Text&#8217;</span></span>\r\nmeans that the variable event_type is a text variable</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''><span style=''font-family:Wingdings''><span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span><span class=ScreenMenusNames><span style=''font-size:\r\n11.0pt;font-family:\"Microsoft Sans Serif\";''>Operation</span></span> <span class=UserSelection><span\r\nstyle=''font-size:11.0pt;font-family:Arial''>&#8216;Like &#8216;% &#8230;\r\n%&#8217;&#8217; </span></span>specifies that the value of event_name will be searched for\r\nin the database using the % wildcard. This wildcard is commonly used to find\r\ntext strings within larger text. For example if you need to find all words\r\ncontaining the letters &#8216;abc&#8217;, you would use the syntax  LIKE &#8216;%abc%&#8217; in the database. In our case,\r\nwhen a user searches for events, they can enter partial word and the results\r\nwill include all events whose event_name contains the subset of words submitted.\r\n</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''><span style=''font-family:Wingdings''><span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span>Leaving the <span class=ScreenMenusNames><span\r\nstyle=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Required</span></span> checkbox\r\nunchecked means that this variable is not required. In the absence of this\r\nvariable, the grid form will simply display all available records. </p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''><span style=''font-family:Wingdings''><span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span>The <span class=ScreenMenusNames><span\r\nstyle=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Transfer</span></span> checkbox is used\r\nto direct CodeCharge to facilitate the transfer of the variable concerned from\r\none page to the next or even to itself. If for example the user clicks on a\r\ncolumn to sort the events, the page will be refreshed but the event_name\r\nvariable will still be available.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText><b>location_id</b></p>\r\n\r\n<p class=MsoBodyText><b>&nbsp;</b></p>\r\n\r\n<p class=MsoBodyText><img border=0 width=632 height=27\r\nsrc=\"./UserImages/yessoftware/image113.gif\"></p>\r\n\r\n<p class=MsoBodyText>This input parameter stipulates that the grid form may\r\nreceive a location_id as part of the search criteria. In this case, the grid\r\nwill display only those records corresponding to the submitted value. The\r\nlocation_id field is defined as numeric in the database table and accordingly,\r\nits corresponding input parameter has to be similarly defined as numeric. We\r\nuse the equal sign (=) in the <span class=ScreenMenusNames><span\r\nstyle=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Operation</span></span> column because\r\nwe want to match the exact location.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText><b>start_date</b></p>\r\n\r\n<p class=MsoBodyText><b>&nbsp;</b></p>\r\n\r\n<p class=MsoBodyText><img border=0 width=630 height=29\r\nsrc=\"./UserImages/yessoftware/image114.gif\"></p>\r\n\r\n<p class=MsoBodyText>The start_date parameter is used to pick only those events\r\nwhich occur on or after a certain date. To achieve this, we use the greater\r\nthan or equal (&gt;=) operator.  </p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText><b>end_date</b></p>\r\n\r\n<p class=MsoBodyText><b>&nbsp;</b></p>\r\n\r\n<p class=MsoBodyText><img border=0 width=634 height=29\r\nsrc=\"./UserImages/yessoftware/image115.gif\"></p>\r\n\r\n<p class=MsoBodyText>Closely resembling the start_date parameter, the end_date\r\nparameter is used to pick only those events which occur on or before a certain\r\ndate. To achieve this we use the less than or equal (&lt;=) operator.  </p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>With the input parameters setup as above, the grid form is\r\npoised to respond to the search criteria passed from the search form which we\r\ncreated earlier on. </p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<div style=''border:solid white .75pt;border-bottom:none;padding:6.0pt 6.0pt 0in 6.0pt;\r\nbackground:#E5E5E5;''>\r\n\r\n<p class=BlockQuotationFirst>Dates in MS Access</p>\r\n\r\n</div>\r\n\r\n<div style=''border:solid white .75pt;padding:12.0pt 12.0pt 12.0pt 12.0pt;\r\nbackground:#F9F9F9;''>\r\n\r\n<p class=BlockQuotation>It is worthwhile to point out that not all databases\r\nhandle dates in the same way. In particular, Microsoft Access has a special way\r\nof handling dates in SQL queries, the downside of which is that the above input\r\nparameters will not work correctly. MS Access requires date values to be\r\nenclosed between a pair of hash marks e.g. \r\n#06/04/01#.  </p>\r\n\r\n</div>\r\n\r\n<p class=MsoBodyText>To accommodate this nuance, we have to convert regular\r\ndates like 06/04/01 to MS Access compatible date format. If you are using MS\r\nAccess, go to the <span class=ScreenMenusNames><span style=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Events</span></span> tab of the F<span\r\nclass=ScreenMenusNames><span style=''font-size:11.0pt;\r\nfont-family:\"Microsoft Sans Serif\";''>orm\r\nProperties</span></span> window and enter the following in the <span\r\nclass=UserSelection><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&#8216;Open&#8217;</span></span> Event:</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=Code>sWhere=replace(sWhere, &quot;''&quot; &amp;\r\nGetParam(&quot;start_date&quot;) &amp; &quot;''&quot;, &quot;#&quot; &amp;\r\nGetParam(&quot;start_date&quot;) &amp; &quot;#&quot;)</p>\r\n\r\n<p class=Code>sWhere=replace(sWhere, &quot;''&quot; &amp;\r\nGetParam(&quot;end_date&quot;) &amp; &quot;''&quot;, &quot;#&quot; &amp;\r\nGetParam(&quot;end_date&quot;) &amp; &quot;#&quot;)</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>The outcome should be similar to the screenshot shown\r\nbelow.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText><img border=0 width=662 height=424\r\nsrc=\"./UserImages/yessoftware/image117.gif\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>As you delve more into designing web pages, you will\r\nundoubtedly encounter instances such as the one above where you have to add\r\nsome custom code to augment the CodeCharge generated code.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>The <b>Open Event</b> is a snippet of programming code or\r\na function that will be executed when the page is opened. Because CodeCharge\r\nstores the WHERE clause in a sWHERE variable, the above code replaces the\r\nCodeCharge generated WHERE clause with one that uses hash marks (#) around the\r\ndates and therefore satisfies the MS Access syntax. The <b>replace</b> function\r\nused above is a standard Visual Basic and ASP function that replaces some text\r\nwith another. The <b>GetParam</b> function is a CodeCharge generated function\r\ntha',5);
GO

INSERT INTO article_contents(art_content_id,art_id,art_content_name,art_content,art_content_ord) 
 VALUES (127,21,'VI. The Administration pages.','\n<h2 style=''margin-left:0in;text-indent:0in''><a name=\"_Toc515701498\"></a><a\r\nname=\"_Toc516936371\">1.<span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Creating the AdminMenu Page.</a></h2>\r\n\r\n<p class=MsoBodyText>The SubmitConfirm page was the last of the pages intended\r\nfor general public use. We shall now proceed to design the administration pages\r\nwhose access shall be limited to administrative and editorial staff. For the\r\npurpose of this application, we shall refer to administrators as those users\r\nwho have level three security clearance and hence can access any of the\r\napplication pages. On the other hand, editors have level two security clearance\r\nand thus can access all the pages except those with an authentication level\r\ngreater than two. More specifically, editors will be able to manipulate the\r\ncontents of the events database table but will not be able to alter the\r\ncontents of the members nor the locations tables.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>The first page we shall create in the series of\r\nadministration pages is the AdminMenu. The page will contain a menu type form\r\nwith fields linking to other administration pages. </p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>1.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Add a new page to the project using the <span\r\nclass=ScreenMenusNames><span style=''font-size:11.0pt;\r\nfont-family:\"Microsoft Sans Serif\";''>Add\r\nPage</span></span> option.</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>2.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Configure the page options as shown below:</p>\r\n\r\n<p class=MsoBodyText><i>&nbsp;</i></p>\r\n\r\n<div align=center>\r\n\r\n<table border=1 cellspacing=0 cellpadding=0 style=''margin-left:1.2in;\r\n background:#F2F2F2;border-collapse:\r\n collapse;border:none;''>\r\n <tr>\r\n  <td width=180 valign=top style=''width:135.0pt;border:solid windowtext .5pt;\r\n  background:#CCCCCC;\r\n  padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><b><span style=''font-family:\"Times New Roman\"''>Property\r\n  Name</span></b></p>\r\n  </td>\r\n  <td width=228 valign=top style=''width:171.0pt;border:solid windowtext .5pt;\r\n  border-left:none;background:#CCCCCC;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><b><span style=''font-family:\"Times New Roman\"''>Value</span></b></p>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td width=180 valign=top style=''width:135.0pt;border:solid windowtext .5pt;\r\n  border-top:none;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>Name</span></p>\r\n  </td>\r\n  <td width=228 valign=top style=''width:171.0pt;border-top:none;border-left:\r\n  none;border-bottom:solid windowtext .5pt;border-right:solid windowtext .5pt;\r\n  padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>AdminMenu</span></p>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td width=180 valign=top style=''width:135.0pt;border:solid windowtext .5pt;\r\n  border-top:none;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>Title</span></p>\r\n  </td>\r\n  <td width=228 valign=top style=''width:171.0pt;border-top:none;border-left:\r\n  none;border-bottom:solid windowtext .5pt;border-right:solid windowtext .5pt;\r\n  padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>Events</span></p>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td width=180 valign=top style=''width:135.0pt;border:solid windowtext .5pt;\r\n  border-top:none;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>Security\r\n  Level</span></p>\r\n  </td>\r\n  <td width=228 valign=top style=''width:171.0pt;border-top:none;border-left:\r\n  none;border-bottom:solid windowtext .5pt;border-right:solid windowtext .5pt;\r\n  padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>2- Medium</span></p>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td width=180 valign=top style=''width:135.0pt;border:solid windowtext .5pt;\r\n  border-top:none;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>Columnar\r\n  Layout</span></p>\r\n  </td>\r\n  <td width=228 valign=top style=''width:171.0pt;border-top:none;border-left:\r\n  none;border-bottom:solid windowtext .5pt;border-right:solid windowtext .5pt;\r\n  padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>Unchecked</span></p>\r\n  </td>\r\n </tr>\r\n</table>\r\n\r\n</div>\r\n\r\n<p class=MsoBodyText><i>&nbsp;</i></p>\r\n\r\n<p class=MsoBodyText>By setting the security level of the page to medium, the\r\nimplication is that administrators as well as editors will be able to access\r\nthe page but it will be out of bounds to ordinary users.</p>\r\n\r\n<p class=MsoBodyText><i>&nbsp;</i></p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>3.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Next, configure the form options as shown below:</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<div align=center>\r\n\r\n<table border=1 cellspacing=0 cellpadding=0 style=''margin-left:1.2in;\r\n background:#F2F2F2;border-collapse:\r\n collapse;border:none;''>\r\n <tr>\r\n  <td width=180 valign=top style=''width:135.0pt;border:solid windowtext .5pt;\r\n  background:#CCCCCC;\r\n  padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><b><span style=''font-family:\"Times New Roman\"''>Property\r\n  Name</span></b></p>\r\n  </td>\r\n  <td width=228 valign=top style=''width:171.0pt;border:solid windowtext .5pt;\r\n  border-left:none;background:#CCCCCC;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><b><span style=''font-family:\"Times New Roman\"''>Value</span></b></p>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td width=180 valign=top style=''width:135.0pt;border:solid windowtext .5pt;\r\n  border-top:none;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>Name</span></p>\r\n  </td>\r\n  <td width=228 valign=top style=''width:171.0pt;border-top:none;border-left:\r\n  none;border-bottom:solid windowtext .5pt;border-right:solid windowtext .5pt;\r\n  padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>AdminMenu</span></p>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td width=180 valign=top style=''width:135.0pt;border:solid windowtext .5pt;\r\n  border-top:none;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>Type</span></p>\r\n  </td>\r\n  <td width=228 valign=top style=''width:171.0pt;border-top:none;border-left:\r\n  none;border-bottom:solid windowtext .5pt;border-right:solid windowtext .5pt;\r\n  padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>Menu</span></p>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td width=180 valign=top style=''width:135.0pt;border:solid windowtext .5pt;\r\n  border-top:none;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>Form Title</span></p>\r\n  </td>\r\n  <td width=228 valign=top style=''width:171.0pt;border-top:none;border-left:\r\n  none;border-bottom:solid windowtext .5pt;border-right:solid windowtext .5pt;\r\n  padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>Administrators\r\n  Menu</span></p>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td width=180 valign=top style=''width:135.0pt;border:solid windowtext .5pt;\r\n  border-top:none;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>Form Action</span></p>\r\n  </td>\r\n  <td width=228 valign=top style=''width:171.0pt;border-top:none;border-left:\r\n  none;border-bottom:solid windowtext .5pt;border-right:solid windowtext .5pt;\r\n  padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>Leave blank</span></p>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td width=180 valign=top style=''width:135.0pt;border:solid windowtext .5pt;\r\n  border-top:none;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>Table</span></p>\r\n  </td>\r\n  <td width=228 valign=top style=''width:171.0pt;border-top:none;border-left:\r\n  none;border-bottom:solid windowtext .5pt;border-right:solid windowtext .5pt;\r\n  padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>Leave blank</span></p>\r\n  </td>\r\n </tr>\r\n</table>\r\n\r\n</div>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>4.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Click on the <img border=0 width=20 height=21\r\nsrc=\"./UserImages/yessoftware/image056.gif\"> icon to open the <span\r\nclass=ScreenMenusNames><span style=''font-size:11.0pt;\r\nfont-family:\"Microsoft Sans Serif\";''>Form\r\nProperties</span></span> window and in the <i>Common</i> tab, change the\r\norientation to <span class=UserSelection><span style=''font-size:11.0pt;font-family:Arial''>&#8216;Vertical&#8217;</span></span>. Click <span\r\nclass=ScreenMenusNames><span style=''font-size:11.0pt;\r\nfont-family:\"Microsoft Sans Serif\";''>Ok</span></span>\r\nto close the window.</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>5.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>In the <span class=ScreenMenusNames><span style=''font-size:\r\n11.0pt;font-family:\"Microsoft Sans Serif\";''>Fields</span></span>section, click on the <img border=0 width=17 height=19\r\nsrc=\"./UserImages/yessoftware/image109.gif\"> icon three times to add three fields.</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>6.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Configure the fields as shown below:</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText align=center style=''text-align:center''><img border=0 width=427 height=135\r\nsrc=\"./UserImages/yessoftware/image141.jpg\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>Since we haven&#8217;t as yet created the pages to be linked to\r\nusing the above three URL fields, we shall return to this form later to do the\r\nnecessary patchwork. We shall also be adding some email functionality to the\r\nAdminMenu page.  </p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<h2 style=''margin-left:0in;text-indent:0in''><a name=\"_Toc515701499\"></a><a\r\nname=\"_Toc516936372\">2.<span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Creating the AdminEventsRecord Page.</a></h2>\r\n\r\n<p class=MsoBodyText>The AdminEventsRecord page shall be used to edit, update\r\nand delete existing event records. \r\nWorking in close conjunction with this page shall be the AdminEventsGrid\r\npage from where a user shall link to the AdminEventsRecord page. As far as\r\nsecurity is concerned, these two pages shall be accessible to administrators as\r\nwell as editors. Use the following procedure to create the AdminEventsRecord\r\npage.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>1.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Open the <span class=ScreenMenusNames><span style=''font-size:\r\n11.0pt;font-family:\"Microsoft Sans Serif\";''>New Page Wizard</span></span><i>.</i></p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>2.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Select <span class=UserSelection><span style=''font-size:11.0pt;font-family:Arial''>&#8216;Record&#8217;</span></span> for <span\r\nclass=ScreenMenusNames><span style=''font-size:11.0pt;\r\nfont-family:\"Microsoft Sans Serif\";''>Page\r\nType</span></span>and set the <span class=ScreenMenusNames><span\r\nstyle=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Security Level</span></span> to <span\r\nclass=UserSelection><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&#8216;2-Medium&#8217;</span></span> then click <span\r\nclass=ScreenMenusNames><span style=''font-size:11.0pt;\r\nfont-family:\"Microsoft Sans Serif\";''>Next.</span></span></p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>3.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>In the <span class=ScreenMenusNames><span style=''font-size:\r\n11.0pt;font-family:\"Microsoft Sans Serif\";''>Record Source</span></span> field select <span\r\nclass=UserSelection><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&#8216;events&#8217;</span></span> and then select <span\r\nclass=UserSelection><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&#8216;event_id&#8217;</span></span> for the <span\r\nclass=ScreenMenusNames><span style=''font-size:11.0pt;\r\nfont-family:\"Microsoft Sans Serif\";''>Primary\r\nKey</span></span> field. Add all the fields from the list of available fields. </p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>4.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Click <span class=ScreenMenusNames><span style=''font-size:\r\n11.0pt;font-family:\"Microsoft Sans Serif\";''>Next</span></span><i>.</i></p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>5.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>In the ensuing screen, ensure that all the options are checked\r\nthen click <span class=ScreenMenusNames><span style=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Next.</span></span></p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>6.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Click <span class=ScreenMenusNames><span style=''font-size:\r\n11.0pt;font-family:\"Microsoft Sans Serif\";''>Finish</span></span> to generate your page</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>Now proceed to customize the generated page as follows:</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>7.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Configure the <span class=ScreenMenusNames><span\r\nstyle=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Page</span></span> component as shown\r\nbelow:</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<div align=center>\r\n\r\n<table border=1 cellspacing=0 cellpadding=0 style=''margin-left:1.2in;\r\n background:#F2F2F2;border-collapse:\r\n collapse;border:none;''>\r\n <tr>\r\n  <td width=180 valign=top style=''width:135.0pt;border:solid windowtext .5pt;\r\n  background:#CCCCCC;\r\n  padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><b><span style=''font-family:\"Times New Roman\"''>Property\r\n  Name</span></b></p>\r\n  </td>\r\n  <td width=228 valign=top style=''width:171.0pt;border:solid windowtext .5pt;\r\n  border-left:none;background:#CCCCCC;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><b><span style=''font-family:\"Times New Roman\"''>Value</span></b></p>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td width=180 valign=top style=''width:135.0pt;border:solid windowtext .5pt;\r\n  border-top:none;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>Name</span></p>\r\n  </td>\r\n  <td width=228 valign=top style=''width:171.0pt;border-top:none;border-left:\r\n  none;border-bottom:solid windowtext .5pt;border-right:solid windowtext .5pt;\r\n  padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>AdminEventsRecord</span></p>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td width=180 valign=top style=''width:135.0pt;border:solid windowtext .5pt;\r\n  border-top:none;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>Title</span></p>\r\n  </td>\r\n  <td width=228 valign=top style=''width:171.0pt;border-top:none;border-left:\r\n  none;border-bottom:solid windowtext .5pt;border-right:solid windowtext .5pt;\r\n  padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>Events</span></p>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td width=180 valign=top style=''width:135.0pt;border:solid windowtext .5pt;\r\n  border-top:none;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>Security\r\n  Level</span></p>\r\n  </td>\r\n  <td width=228 valign=top style=''width:171.0pt;border-top:none;border-left:\r\n  none;border-bottom:solid windowtext .5pt;border-right:solid windowtext .5pt;\r\n  padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>2- Medium</span></p>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td width=180 valign=top style=''width:135.0pt;border:solid windowtext .5pt;\r\n  border-top:none;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>Columnar\r\n  Layout</span></p>\r\n  </td>\r\n  <td width=228 valign=top style=''width:171.0pt;border-top:none;border-left:\r\n  none;border-bottom:solid windowtext .5pt;border-right:solid windowtext .5pt;\r\n  padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>Unchecked</span></p>\r\n  </td>\r\n </tr>\r\n</table>\r\n\r\n</div>\r\n\r\n<p class=MsoBodyText><i>&nbsp;</i></p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>8.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Next, configure the form currently labeled as &#8216;events&#8217; as\r\nshown below:</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<div align=center>\r\n\r\n<table border=1 cellspacing=0 cellpadding=0 style=''margin-left:1.2in;\r\n background:#F2F2F2;border-collapse:\r\n collapse;border:none;''>\r\n <tr>\r\n  <td width=180 valign=top style=''width:135.0pt;border:solid windowtext .5pt;\r\n  background:#CCCCCC;\r\n  padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><b><span style=''font-family:\"Times New Roman\"''>Property\r\n  Name</span></b></p>\r\n  </td>\r\n  <td width=228 valign=top style=''width:171.0pt;border:solid windowtext .5pt;\r\n  border-left:none;background:#CCCCCC;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><b><span style=''font-family:\"Times New Roman\"''>Value</span></b></p>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td width=180 valign=top style=''width:135.0pt;border:solid windowtext .5pt;\r\n  border-top:none;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>Name</span></p>\r\n  </td>\r\n  <td width=228 valign=top style=''width:171.0pt;border-top:none;border-left:\r\n  none;border-bottom:solid windowtext .5pt;border-right:solid windowtext .5pt;\r\n  padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>Events</span></p>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td width=180 valign=top style=''width:135.0pt;border:solid windowtext .5pt;\r\n  border-top:none;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>Type</span></p>\r\n  </td>\r\n  <td width=228 valign=top style=''width:171.0pt;border-top:none;border-left:\r\n  none;border-bottom:solid windowtext .5pt;border-right:solid windowtext .5pt;\r\n  padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>Record</span></p>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td width=180 valign=top style=''width:135.0pt;border:solid windowtext .5pt;\r\n  border-top:none;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>Form Title</span></p>\r\n  </td>\r\n  <td width=228 valign=top style=''width:171.0pt;border-top:none;border-left:\r\n  none;border-bottom:solid windowtext .5pt;border-right:solid windowtext .5pt;\r\n  padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>Event\r\n  Details</span></p>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td width=180 valign=top style=''width:135.0pt;border:solid windowtext .5pt;\r\n  border-top:none;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>Form Action</span></p>\r\n  </td>\r\n  <td width=228 valign=top style=''width:171.0pt;border-top:none;border-left:\r\n  none;border-bottom:solid windowtext .5pt;border-right:solid windowtext .5pt;\r\n  padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>Leave blank\r\n  for now</span></p>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td width=180 valign=top style=''width:135.0pt;border:solid windowtext .5pt;\r\n  border-top:none;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>Table</span></p>\r\n  </td>\r\n  <td width=228 valign=top style=''width:171.0pt;border-top:none;border-left:\r\n  none;border-bottom:solid windowtext .5pt;border-right:solid windowtext .5pt;\r\n  padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>events</span></p>\r\n  </td>\r\n </tr>\r\n</table>\r\n\r\n</div>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>9.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Open the <span class=ScreenMenusNames><span style=''font-size:\r\n11.0pt;font-family:\"Microsoft Sans Serif\";''>Form Properties</span></span> window for the Events form and\r\nin the <span class=ScreenMenusNames><span style=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Input</span></span>\r\ntab, add the parameters shown below. </p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText><img border=0 width=654 height=285\r\nsrc=\"./UserImages/yessoftware/image142.jpg\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>Usually, a form of type Record does not expect to receive\r\ninput parameters since it is mainly used to add new records or edit records\r\nwhich have been retrieved from the database. However, there arises scenarios\r\nwhereby you want to pass parameters from one page to another via an\r\nintermediary page. In our case, when a user does a search in the\r\nAdminEventsGrid then the use proceeds to picks a record to edit in\r\nAdminEventsRecord page, we want that when the user finally returns to the\r\nAdminEventsGrid page, the initial search criteria is maintained so that the\r\ngrid form in that page displays only those records that meet the search\r\ncriteria. For instance, if the user searched for events from a particular\r\nlocation then went ahead to edit one of the pertinent events using the\r\nAdminEventsRecord page, upon returning to the AdminEventsGrid page, the search\r\ncriteria would still be effective since we would have transferred the relevant\r\nparameters back to the AdminEventsRecord page. Later on when we get to creating\r\nthe AdminEventsGrid page, we shall similarly need to specify the same input\r\nparameters for the grid form as well.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>10.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;\r\n</span>After having configured the <span class=ScreenMenusNames><span\r\nstyle=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Input </span></span>parameters, click\r\non the <span class=ScreenMenusNames><span style=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Events\r\n</span></span>tab while still in the <span class=ScreenMenusNames><span\r\nstyle=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Form Properties</span></span>window.\r\nUnder the &#8216;Before Show&#8217; event, add the following code:</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=Code>flddate_update = date()</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>What we are doing here is setting the value of the\r\ndate_update field to the current date. This way, the user does not have to\r\nenter this value manually.</p>\r\n\r\n<p class=MsoBodyText> </p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>11.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;\r\n</span>Click <span class=ScreenMenusNames><span style=''font-size:\r\n11.0pt;font-family:\"Microsoft Sans Serif\";''>Ok</span></span> to close the <span class=ScreenMenusNames><span\r\nstyle=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Form Properties</span></span>window.</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>12.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;\r\n</span>Move next to the<span class=ScreenMenusNames><span\r\nstyle=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Fields </span></span>section and\r\nconfigure the fields as shown below:</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText align=center style=''text-align:center''><img border=0 width=526 height=265\r\nsrc=\"./UserImages/yessoftware/image143.jpg\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>13.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;\r\n</span>Follow <a href=\"#configure_location_id_field\">steps 13-14 of section 6 Chapter 3</a> to link the location_id\r\nfield to the location field of the locations database table.</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>14.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;\r\n</span>Open the <span class=ScreenMenusNames><span style=''font-size:\r\n11.0pt;font-family:\"Microsoft Sans Serif\";''>Field Properties</span></span>window for the\r\nevent_description field.</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>15.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;\r\n</span>Set the <span class=ScreenMenusNames><span style=''font-size:\r\n11.0pt;font-family:\"Microsoft Sans Serif\";''>Rows </span></span>field to <span class=UserSelection><span\r\nstyle=''font-size:11.0pt;font-family:Arial''>&#8216;6&#8217;</span></span>.</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''><a name=\"configure_member_id_field\"></a>16.<span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp; </span>From the list of\r\nfields to the left, select the &#8216;member_id&#8217; field. </p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>17.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;\r\n</span>In the <span class=ScreenMenusNames><span style=''font-size:\r\n11.0pt;font-family:\"Microsoft Sans Serif\";''>List </span></span>tab, make the following configuration so\r\nthat the actual names of the members are displayed in place of the numeric\r\nmember_id field which is retrieved from the events database table.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<div align=center>\r\n\r\n<table border=1 cellspacing=0 cellpadding=0 style=''margin-left:1.2in;\r\n background:#F2F2F2;border-collapse:\r\n collapse;border:none;''>\r\n <tr>\r\n  <td width=180 valign=top style=''width:135.0pt;border:solid windowtext .5pt;\r\n  background:#CCCCCC;\r\n  padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><b><span style=''font-family:\"Times New Roman\"''>Property\r\n  Name</span></b></p>\r\n  </td>\r\n  <td width=228 valign=top style=''width:171.0pt;border:solid windowtext .5pt;\r\n  border-left:none;background:#CCCCCC;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><b><span style=''font-family:\"Times New Roman\"''>Value</span></b></p>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td width=180 valign=top style=''width:135.0pt;border:solid windowtext .5pt;\r\n  border-top:none;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>Table</span></p>\r\n  </td>\r\n  <td width=228 valign=top style=''width:171.0pt;border-top:none;border-left:\r\n  none;border-bottom:solid windowtext .5pt;border-right:solid windowtext .5pt;\r\n  padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>members</span></p>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td width=180 valign=top style=''width:135.0pt;border:solid windowtext .5pt;\r\n  border-top:none;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>Primary Key</span></p>\r\n  </td>\r\n  <td width=228 valign=top style=''width:171.0pt;border-top:none;border-left:\r\n  none;border-bottom:solid windowtext .5pt;border-right:solid windowtext .5pt;\r\n  padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>member_id</span></p>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td width=180 valign=top style=''width:135.0pt;border:solid windowtext .5pt;\r\n  border-top:none;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>Showing</span></p>\r\n  </td>\r\n  <td width=228 valign=top style=''width:171.0pt;border-top:none;border-left:\r\n  none;border-bottom:solid windowtext .5pt;border-right:solid windowtext .5pt;\r\n  padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>real_name</span></p>\r\n  </td>\r\n </tr>\r\n</table>\r\n\r\n</div>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>18.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;\r\n</span>In the events database table, the value of the is_active field\r\nis stored as a numeric value of either 0 or 1. If an event is active, the value\r\nis set to 1 and 0 otherwise. In this form, we want to present this using a\r\ncheckbox field such that when the checkbox is checked, a value of 1 is\r\ntransmitted to the database and when the it is unchecked a value of 0 is sent.\r\nTo set this up, open the <span class=ScreenMenusNames><span style=''font-size:\r\n11.0pt;font-family:\"Microsoft Sans Serif\";''>Field Properties</span></span>window for the\r\nis_active field.</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>19.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;\r\n</span>Ensure that the value of the <span class=ScreenMenusNames><span\r\nstyle=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Checked Value</span></span>field\r\nis set to <span class=UserSelection><span style=''font-size:11.0pt;font-family:Arial''>&#8216;1&#8217;</span></span> and that of the <span\r\nclass=ScreenMenusNames><span style=''font-size:11.0pt;\r\nfont-family:\"Microsoft Sans Serif\";''>Unchecked\r\nValue</span></span> field is set to <span class=UserSelection><span\r\nstyle=''font-size:11.0pt;font-family:Arial''>&#8216;0&#8217;</span></span>\r\nthen click <span class=ScreenMenusNames><span style=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Ok</span></span>to close the window.</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.25in''>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>And with that, we are done with the AdminEventsRecord\r\npage.</p>\r\n\r\n<h2 style=''margin-left:0in;text-indent:0in''><a name=\"_Toc515701500\"></a><a\r\nname=\"_Toc516936373\">3.<span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Creating the AdminEventsGrid Page.</a></h2>\r\n\r\n<p class=MsoBodyText>The AdminEventsGrid page is intended to facilitate online\r\ntraversal and searching of the various events stored in the database. The page\r\nshall be composed of a search form and a grid form to display the results of\r\nthe search. Follow the next procedure to create the AdminEventsGrid page.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>1.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Open the <span class=ScreenMenusNames><span style=''font-size:\r\n11.0pt;font-family:\"Microsoft Sans Serif\";''>New Page Wizard</span></span><i>.</i></p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>2.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Select <span class=UserSelection><span style=''font-size:11.0pt;font-family:Arial''>&#8216;Grid&#8217;</span></span> for <span\r\nclass=ScreenMenusNames><span style=''font-size:11.0pt;\r\nfont-family:\"Microsoft Sans Serif\";''>Page\r\nType</span></span>and set the <span class=ScreenMenusNames><span\r\nstyle=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Security Level</span></span> to <span\r\nclass=UserSelection><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&#8216;2-Medium&#8217;</span></span> then click <span\r\nclass=ScreenMenusNames><span style=''font-size:11.0pt;\r\nfont-family:\"Microsoft Sans Serif\";''>Next.</span></span></p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>3.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>In the <span class=ScreenMenusNames><span style=''font-size:\r\n11.0pt;font-family:\"Microsoft Sans Serif\";''>Record Source</span></span> field, select <span\r\nclass=UserSelection><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&#8216;events&#8217;</span></span> and then select <span\r\nclass=UserSelection><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&#8216;event_id&#8217;</span></span> for the <span\r\nclass=ScreenMenusNames><span style=''font-size:11.0pt;\r\nfont-family:\"Microsoft Sans Serif\";''>Primary\r\nKey</span></span> field.</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>4.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>From the list of available fields, add the following to the\r\ngrid form: <span class=UserSelection><span style=''font-size:11.0pt;font-family:Arial''>&#8216;event_name&#8217;</span></span>, <span\r\nclass=UserSelection><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&#8216;event_date&#8217;</span></span>, \r\n<span class=UserSelection><span style=''font-size:11.0pt;font-family:Arial''>&#8216;location_id&#8217;</span></span> and <span\r\nclass=UserSelection><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&#8216;is_active&#8217;</span></span>.</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>5.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Set the <span class=ScreenMenusNames><span style=''font-size:\r\n11.0pt;font-family:\"Microsoft Sans Serif\";''>Order by</span></span> field to <span class=UserSelection><span\r\nstyle=''font-size:11.0pt;font-family:Arial''>&#8216;event_date&#8217;</span></span>\r\nand click <span class=ScreenMenusNames><span style=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Next.</span></span></p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>6.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Check the <span class=ScreenMenusNames><span style=''font-size:\r\n11.0pt;font-family:\"Microsoft Sans Serif\";''>Use Search</span></span>checkbox so as to add a\r\nsearch form to the page.</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>7.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>From the list of available fields, add the following to the\r\nsearch form: <span class=UserSelection><span style=''font-size:11.0pt;font-family:Arial''>&#8216;event_name&#8217;</span></span>, <span\r\nclass=UserSelection><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&#8216;event_date&#8217;</span></span>, \r\n<span class=UserSelection><span style=''font-size:11.0pt;font-family:Arial''>&#8216;location_id&#8217;</span></span>, <span\r\nclass=UserSelection><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&#8216;member_id&#8217;</span></span> and <span class=UserSelection><span\r\nstyle=''font-size:11.0pt;font-family:Arial''>&#8216;is_active&#8217;</span></span>.</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>8.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Ensure that the <span class=ScreenMenusNames><span\r\nstyle=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Search Type</span></span> radio box is\r\nset to <span class=UserSelection><span style=''font-size:11.0pt;font-family:Arial''>&#8216;And&#8217;</span></span>.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>At this point, you should have a screen similar to the\r\ndiagram below:</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText align=center style=''text-align:center''><img border=0 width=482 height=361\r\nsrc=\"./UserImages/yessoftware/image144.gif\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>9.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Click <span class=ScreenMenusNames><span style=''font-size:\r\n11.0pt;font-family:\"Microsoft Sans Serif\";''>Next</span></span>and in the ensuing page, ensure that\r\nthe <span class=ScreenMenusNames><span style=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Allow\r\nSorting</span></span>and <span class=ScreenMenusNames><span\r\nstyle=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Use page Scroller </span></span>checkboxes\r\nare checked. Set the <span class=ScreenMenusNames><span style=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Records Per Page</span></span> field to <span\r\nclass=UserSelection><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&#8216;20&#8217;</span></span>.</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>10.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;\r\n</span>Click <span class=ScreenMenusNames><span style=''font-size:\r\n11.0pt;font-family:\"Microsoft Sans Serif\";''>Next </span></span>followed by <span class=ScreenMenusNames><span\r\nstyle=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Finish </span></span>to generate the\r\npage.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>Proceed now to customize the page as follows.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>11.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;\r\n</span>Configure the P<span class=ScreenMenusNames><span\r\nstyle=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>age</span></span> component as shown\r\nbelow:</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<div align=center>\r\n\r\n<table border=1 cellspacing=0 cellpadding=0 style=''margin-left:1.2in;\r\n background:#F2F2F2;border-collapse:\r\n collapse;border:none;''>\r\n <tr>\r\n  <td width=180 valign=top style=''width:135.0pt;border:solid windowtext .5pt;\r\n  background:#CCCCCC;\r\n  padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><b><span style=''font-family:\"Times New Roman\"''>Property\r\n  Name</span></b></p>\r\n  </td>\r\n  <td width=228 valign=top style=''width:171.0pt;border:solid windowtext .5pt;\r\n  border-left:none;background:#CCCCCC;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><b><span style=''font-family:\"Times New Roman\"''>Value</span></b></p>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td width=180 valign=top style=''width:135.0pt;border:solid windowtext .5pt;\r\n  border-top:none;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>Name</span></p>\r\n  </td>\r\n  <td width=228 valign=top style=''width:171.0pt;border-top:none;border-left:\r\n  none;border-bottom:solid windowtext .5pt;border-right:solid windowtext .5pt;\r\n  padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>AdminEventsGrid</span></p>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td width=180 valign=top style=''width:135.0pt;border:solid windowtext .5pt;\r\n  border-top:none;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>Title</span></p>\r\n  </td>\r\n  <td width=228 valign=top style=''width:171.0pt;border-top:none;border-left:\r\n  none;border-bottom:solid windowtext .5pt;border-right:solid windowtext .5pt;\r\n  padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>Events</span></p>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td width=180 valign=top style=''width:135.0pt;border:solid windowtext .5pt;\r\n  border-top:none;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>Security\r\n  Level</span></p>\r\n  </td>\r\n  <td width=228 valign=top style=''width:171.0pt;border-top:none;border-left:\r\n  none;border-bottom:solid windowtext .5pt;border-right:solid windowtext .5pt;\r\n  padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>2- Medium</span></p>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td width=180 valign=top style=''width:135.0pt;border:solid windowtext .5pt;\r\n  border-top:none;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>Columnar\r\n  Layout</span></p>\r\n  </td>\r\n  <td width=228 valign=top style=''width:171.0pt;border-top:none;border-left:\r\n  none;border-bottom:solid windowtext .5pt;border-right:solid windowtext .5pt;\r\n  padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>Unchecked</span></p>\r\n  </td>\r\n </tr>\r\n</table>\r\n\r\n</div>\r\n\r\n<p class=MsoBodyText><i>&nbsp;</i></p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>12.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;\r\n</span>Next, configure the Search form options as shown below.</p>\r\n\r\n<p class=MsoBodyText><i>&nbsp;</i></p>\r\n\r\n<div align=center>\r\n\r\n<table border=1 cellspacing=0 cellpadding=0 style=''margin-left:1.2in;\r\n background:#F2F2F2;border-collapse:\r\n collapse;border:none;''>\r\n <tr>\r\n  <td width=180 valign=top style=''width:135.0pt;border:solid windowtext .5pt;\r\n  background:#CCCCCC;\r\n  padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><b><span style=''font-family:\"Times New Roman\"''>Property\r\n  Name</span></b></p>\r\n  </td>\r\n  <td width=228 valign=top style=''width:171.0pt;border:solid windowtext .5pt;\r\n  border-left:none;background:#CCCCCC;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><b><span style=''font-family:\"Times New Roman\"''>Value</span></b></p>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td width=180 valign=top style=''width:135.0pt;border:solid windowtext .5pt;\r\n  border-top:none;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>Name</span></p>\r\n  </td>\r\n  <td width=228 valign=top style=''width:171.0pt;border-top:none;border-left:\r\n  none;border-bottom:solid windowtext .5pt;border-right:solid windowtext .5pt;\r\n  padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>Search</span></p>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td width=180 valign=top style=''width:135.0pt;border:solid windowtext .5pt;\r\n  border-top:none;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>Type</span></p>\r\n  </td>\r\n  <td width=228 valign=top style=''width:171.0pt;border-top:none;border-left:\r\n  none;border-bottom:solid windowtext .5pt;border-right:solid windowtext .5pt;\r\n  padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>Search</span></p>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td width=180 valign=top style=''width:135.0pt;border:solid windowtext .5pt;\r\n  border-top:none;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>Form Title</span></p>\r\n  </td>\r\n  <td width=228 valign=top style=''width:171.0pt;border-top:none;border-left:\r\n  none;border-bottom:solid windowtext .5pt;border-right:solid windowtext .5pt;\r\n  padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>Search\r\n  Events</span></p>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td width=180 valign=top style=''width:135.0pt;border:solid windowtext .5pt;\r\n  border-top:none;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>Form Action</span></p>\r\n  </td>\r\n  <td width=228 valign=top style=''width:171.0pt;border-top:none;border-left:\r\n  none;border-bottom:solid windowtext .5pt;border-right:solid windowtext .5pt;\r\n  padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>AdminEventsGrid</span></p>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td width=180 valign=top style=''width:135.0pt;border:solid windowtext .5pt;\r\n  border-top:none;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>Table</span></p>\r\n  </td>\r\n  <td width=228 valign=top style=''width:171.0pt;border-top:none;border-left:\r\n  none;border-bottom:solid windowtext .5pt;border-right:solid windowtext .5pt;\r\n  padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>events</span></p>\r\n  </td>\r\n </tr>\r\n</table>\r\n\r\n</div>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>13.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;\r\n</span>While still in the Search form, click on the <img border=0 width=20 height=21\r\nsrc=\"./UserImages/yessoftware/image056.gif\"> icon to open the <span\r\nclass=ScreenMenusNames><span style=''font-size:11.0pt;\r\nfont-family:\"Microsoft Sans Serif\";''>Form\r\nProperties</span></span> window and in the <span class=ScreenMenusNames><span\r\nstyle=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Common</span></span> tab, change the\r\norientation to <span class=UserSelection><span style=''font-size:11.0pt;font-family:Arial''>&#8216;Vertical&#8217;</span></span>. Click <span\r\nclass=ScreenMenusNames><span style=''font-size:11.0pt;\r\nfont-family:\"Microsoft Sans Serif\";''>Ok </span></span>to\r\nclose the window.</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>14.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;\r\n</span>In the <span class=ScreenMenusNames><span style=''font-size:\r\n11.0pt;font-family:\"Microsoft Sans Serif\";''>Fields</span></span>section, click on the show\r\nfields <img border=0 width=21 height=19\r\nsrc=\"./UserImages/yessoftware/image120.jpg\"> icon to see a list of the available fields.</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>15.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;\r\n</span>From the list, add another instance of the event_date field.\r\nMomentarily, you shall see why we need a second instance of the event_date\r\nfield.</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>16.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;\r\n</span>In the <span class=ScreenMenusNames><span style=''font-size:\r\n11.0pt;font-family:\"Microsoft Sans Serif\";''>Fields</span></span> section, delete the event_id field\r\nwhich was added by the <span class=ScreenMenusNames><span style=''font-size:\r\n11.0pt;font-family:\"Microsoft Sans Serif\";''>New Page Wizard</span></span>.</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>17.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;\r\n</span>Configure the fields as shown below:</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText align=center style=''text-align:center''><img border=0 width=528 height=212\r\nsrc=\"./UserImages/yessoftware/image145.gif\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>Notice that one of the instances of the event_date field\r\nhas a <span class=ScreenMenusNames><span style=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Caption</span></span>\r\n<span class=UserSelection><span style=''font-size:11.0pt;font-family:Arial''>&#8216;Start Date&#8217;</span></span> while the other has a <span\r\nclass=ScreenMenusNames><span style=''font-size:11.0pt;\r\nfont-family:\"Microsoft Sans Serif\";''>Caption\r\n</span></span><span class=UserSelection><span style=''font-size:11.0pt;font-family:Arial''>&#8216;End Date&#8217;</span></span>. As you\r\nmight imagine, these two fields will be used to search for events that fall\r\nbetween a particular range of dates.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>18.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;\r\n</span>Open the <span class=ScreenMenusNames><span style=''font-size:\r\n11.0pt;font-family:\"Microsoft Sans Serif\";''>Field Properties</span></span>window for the first\r\ninstance of the <span class=UserSelection><span style=''font-size:11.0pt;font-family:Arial''>&#8216;event_date&#8217;</span></span> field\r\nand change the field <span class=ScreenMenusNames><span style=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Name</span></span> to <span class=UserSelection><span\r\nstyle=''font-size:11.0pt;font-family:Arial''>&#8216;start_date&#8217;</span></span>.</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>19.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;\r\n</span>From among the list of available fields, select the second\r\ninstance of the <span class=UserSelection><span style=''font-size:11.0pt;font-family:Arial''>&#8216;event_date&#8217;</span></span> field\r\nand change it&#8217;s <span class=ScreenMenusNames><span style=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Name</span></span>to <span class=UserSelection><span\r\nstyle=''font-size:11.0pt;font-family:Arial''>&#8216;end_date&#8217;</span></span>.</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>20.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;\r\n</span>Change the name of the s_event_name field to event_name, the\r\ns_location_id field to location_id, the s_member_id field to member_id and the\r\ns_is_active field to is_active. This is done so as to make the names consistent\r\nwith the names of the input parameters we configured earlier on.</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>21.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;\r\n</span>Follow <a href=\"#configure_location_id_field\">steps 13-14 of section 6 Chapter 3</a> to link the location_id\r\nfield to the location field of the locations database table.</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>22.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;\r\n</span>Follow <a href=\"#configure_member_id_field\">steps 16-17 of section 2 Chapter 4</a> to link the member_id\r\nfield to the real_name field of the members database table.</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>23.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;\r\n</span>Recall that in the events database table, the value of the\r\nis_active field is stored as a numeric value of either 0 or 1.  In our search form, we shall represent this\r\nby using a listbox which will contain the captions <span class=UserSelection><span\r\nstyle=''font-size:11.0pt;font-family:Arial''>&#8216;Yes&#8217;</span></span>\r\nand <span class=UserSelection><span style=''font-size:11.0pt;font-family:Arial''>&#8216;No&#8217;</span></span> with corresponding values 1 and 0\r\nrespectively. This is to say that if a user selects &#8216;<span class=UserSelection><span\r\nstyle=''font-size:11.0pt;font-family:Arial''>Yes&#8217;,</span></span>\r\na numeric value 1 will be sent to the database and not the string caption <span\r\nclass=UserSelection><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&#8216;Yes&#8217;</span></span>. To configure this, open the <span\r\nclass=ScreenMenusNames><span style=''font-size:11.0pt;\r\nfont-family:\"Microsoft Sans Serif\";''>Field\r\nProperties</span></span>window for the &#8216;is_active&#8217; field.</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>24.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;\r\n</span>In the <span class=ScreenMenusNames><span style=''font-size:\r\n11.0pt;font-family:\"Microsoft Sans Serif\";''>List </span></span>tab, enter the following into the <span\r\nclass=ScreenMenusNames><span style=''font-size:11.0pt;\r\nfont-family:\"Microsoft Sans Serif\";''>List\r\nOf Values</span></span> field then click <span class=ScreenMenusNames><span\r\nstyle=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Ok </span></span>to close the window.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=Code>;;1;Yes;0;No</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>The two semi-colons at the beginning are placed there so\r\nthat there is a blank with no value at the top of the listbox. If these were\r\nomitted, the caption <span class=UserSelection><span style=''font-size:11.0pt;font-family:Arial''>&#8216;Yes&#8217;</span></span> would appear\r\nat the top of the field.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>Moving on, we are now going to configure the events form. </p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>25.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;\r\n</span>Use the table below to adjust the form options:</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<div align=center>\r\n\r\n<table border=1 cellspacing=0 cellpadding=0 style=''margin-left:1.2in;\r\n background:#F2F2F2;border-collapse:\r\n collapse;border:none;''>\r\n <tr>\r\n  <td width=180 valign=top style=''width:135.0pt;border:solid windowtext .5pt;\r\n  background:#CCCCCC;\r\n  padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><b><span style=''font-family:\"Times New Roman\"''>Property\r\n  Name</span></b></p>\r\n  </td>\r\n  <td width=228 valign=top style=''width:171.0pt;border:solid windowtext .5pt;\r\n  border-left:none;background:#CCCCCC;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><b><span style=''font-family:\"Times New Roman\"''>Value</span></b></p>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td width=180 valign=top style=''width:135.0pt;border:solid windowtext .5pt;\r\n  border-top:none;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>Name</span></p>\r\n  </td>\r\n  <td width=228 valign=top style=''width:171.0pt;border-top:none;border-left:\r\n  none;border-bottom:solid windowtext .5pt;border-right:solid windowtext .5pt;\r\n  padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>Events</span></p>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td width=180 valign=top style=''width:135.0pt;border:solid windowtext .5pt;\r\n  border-top:none;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>Type</span></p>\r\n  </td>\r\n  <td width=228 valign=top style=''width:171.0pt;border-top:none;border-left:\r\n  none;border-bottom:solid windowtext .5pt;border-right:solid windowtext .5pt;\r\n  padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>Grid</span></p>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td width=180 valign=top style=''width:135.0pt;border:solid windowtext .5pt;\r\n  border-top:none;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>Form Title</span></p>\r\n  </td>\r\n  <td width=228 valign=top style=''width:171.0pt;border-top:none;border-left:\r\n  none;border-bottom:solid windowtext .5pt;border-right:solid windowtext .5pt;\r\n  padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>Event List</span></p>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td width=180 valign=top style=''width:135.0pt;border:solid windowtext .5pt;\r\n  border-top:none;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>Form Action</span></p>\r\n  </td>\r\n  <td width=228 valign=top style=''width:171.0pt;border-top:none;border-left:\r\n  none;border-bottom:solid windowtext .5pt;border-right:solid windowtext .5pt;\r\n  padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>AdminEventsRecord</span></p>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td width=180 valign=top style=''width:135.0pt;border:solid windowtext .5pt;\r\n  border-top:none;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>Table</span></p>\r\n  </td>\r\n  <td width=228 valign=top style=''width:171.0pt;border-top:none;border-left:\r\n  none;border-bottom:solid windowtext .5pt;border-right:solid windowtext .5pt;\r\n  padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>events</span></p>\r\n  </td>\r\n </tr>\r\n</table>\r\n\r\n</div>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>26.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;\r\n</span>As we mentioned in step 9 of section 9, we need to set input\r\nparameters for the grid form such that a previous search criteria can be\r\nrestored after a record has been edited in the AdminEventsRecord page. To do\r\nthis, open the <span class=ScreenMenusNames><span style=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Form Properties</span></span> window for the Events form.</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>27.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;\r\n</span>Click on the <span class=ScreenMenusNames><span\r\nstyle=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Input </span></span>tab and configure\r\ninput parameters as shown below:</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText><img border=0 width=653 height=211\r\nsrc=\"./UserImages/yessoftware/image146.jpg\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>28.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;\r\n</span>If you are using the MS Access database, click on the <span\r\nclass=ScreenMenusNames><span style=''font-size:11.0pt;\r\nfont-family:\"Microsoft Sans Serif\";''>Events\r\n</span></span>tab and in the <span class=UserSelection><span style=''font-size:\r\n11.0pt;font-family:Arial''>&#8216;Open&#8217;</span></span> event,\r\nenter the following code:</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=Code>sWhere=replace(sWhere, &quot;''&quot; &amp;\r\nGetParam(&quot;start_date&quot;) &amp; &quot;''&quot;, &quot;#&quot; &amp;\r\nGetParam(&quot;start_date&quot;) &amp; &quot;#&quot;)</p>\r\n\r\n<p class=Code>sWhere=replace(sWhere, &quot;''&quot; &amp; GetParam(&quot;end_date&quot;)\r\n&amp; &quot;''&quot;, &quot;#&quot; &amp; GetParam(&quot;end_date&quot;) &amp;\r\n&quot;#&quot;)</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>We have to do this since the MS Access database expects to\r\nreceive date values enclosed within hash marks.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>29.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;\r\n</span>Click on the <span class=ScreenMenusNames><span\r\nstyle=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Common</span></span> tab and ensure\r\nthat the <span class=ScreenMenusNames><span style=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Allow\r\nInsert</span></span> option is checked.</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>30.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;\r\n</span>Click <span class=ScreenMenusNames><span style=''font-size:\r\n11.0pt;font-family:\"Microsoft Sans Serif\";''>Ok</span></span> to close the <span class=ScreenMenusNames><span\r\nstyle=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Form Properties</span></span> window.</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>31.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;\r\n</span>Next, use the diagram below to set the <span\r\nclass=ScreenMenusNames><span style=''font-size:11.0pt;\r\nfont-family:\"Microsoft Sans Serif\";''>Captions\r\n</span></span>and<span class=ScreenMenusNames><span style=''font-size:\r\n11.0pt;font-family:\"Microsoft Sans Serif\";''>Type</span></span> of the form fields.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText align=center style=''text-align:center''><img border=0 width=533 height=180\r\nsrc=\"./UserImages/yessoftware/image148.jpg\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>32.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;\r\n</span>Open the <span class=ScreenMenusNames><span style=''font-size:\r\n11.0pt;font-family:\"Microsoft Sans Serif\";''>Form Properties</span></span> dialog box for the <span\r\nclass=UserSelection><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&#8216;event_name&#8217;</span></span> field.</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>33.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;\r\n</span>In the <span class=ScreenMenusNames><span style=''font-size:\r\n11.0pt;font-family:\"Microsoft Sans Serif\";''>Page Link</span></span> field, select <span\r\nclass=UserSelection><span style=''font-size:11.0pt;\r\nfont-family:Arial''>&#8216;AdminEventsRecord&#8217;</span></span> page so that once records\r\nhave been displayed in the grid form, the user can pick a particular record to\r\nbe edited in the AdminEventsRecord page.</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>34.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;\r\n</span>To enable the AdminEventsRecord page to know what record is to\r\nbe edited, we have to pass a parameter to it telling it the primary key of the\r\nrecord it shall need to retrieve. So click on the <span class=ScreenMenusNames><span\r\nstyle=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Output </span></span>tab and add a\r\nparameter as shown below:</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.25in''>&nbsp;</p>\r\n\r\n<p class=MsoBodyText align=center style=''text-align:center''><img border=0 width=340 height=153\r\nsrc=\"./UserImages/yessoftware/image149.jpg\"></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>35.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;\r\n</span>Click <span class=ScreenMenusNames><span style=''font-size:\r\n11.0pt;font-family:\"Microsoft Sans Serif\";''>Ok </span></span>to close the window.</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>36.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;\r\n</span>As we have done a couple of times before, we need to link the\r\nlocation_id field to the location field of the locations database table. So\r\nfar, we have done this in the case where the location_id field is of <span\r\nclass=ScreenMenusNames><span style=''font-size:11.0pt;\r\nfont-family:\"Microsoft Sans Serif\";''>Type\r\n</span></span>Listbox. However, this time round, we are dealing with a Label\r\nfield and hence a slightly different approach is required. Open the <span\r\nclass=ScreenMenusNames><span style=''font-size:11.0pt;\r\nfont-family:\"Microsoft Sans Serif\";''>Form\r\nProperties</span></span> window for the member_id field. </p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>37.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;\r\n</span>Notice that instead of a <span class=ScreenMenusNames><span\r\nstyle=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>List</span></span> tab as is usually the case, we now have\r\na  <span class=ScreenMenusNames><span\r\nstyle=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Join</span></span> tab. Click on the <span\r\nclass=ScreenMenusNames><span style=''font-size:11.0pt;\r\nfont-family:\"Microsoft Sans Serif\";''>Join</span></span>\r\ntab and make the following configuration. </p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<div align=center>\r\n\r\n<table border=1 cellspacing=0 cellpadding=0 style=''margin-left:1.2in;\r\n background:#F2F2F2;border-collapse:\r\n collapse;border:none;''>\r\n <tr>\r\n  <td width=180 valign=top style=''width:135.0pt;border:solid windowtext .5pt;\r\n  background:#CCCCCC;\r\n  padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><b><span style=''font-family:\"Times New Roman\"''>Property\r\n  Name</span></b></p>\r\n  </td>\r\n  <td width=228 valign=top style=''width:171.0pt;border:solid windowtext .5pt;\r\n  border-left:none;background:#CCCCCC;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><b><span style=''font-family:\"Times New Roman\"''>Value</span></b></p>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td width=180 valign=top style=''width:135.0pt;border:solid windowtext .5pt;\r\n  border-top:none;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>Table</span></p>\r\n  </td>\r\n  <td width=228 valign=top style=''width:171.0pt;border-top:none;border-left:\r\n  none;border-bottom:solid windowtext .5pt;border-right:solid windowtext .5pt;\r\n  padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>locations</span></p>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td width=180 valign=top style=''width:135.0pt;border:solid windowtext .5pt;\r\n  border-top:none;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>Primary Key</span></p>\r\n  </td>\r\n  <td width=228 valign=top style=''width:171.0pt;border-top:none;border-left:\r\n  none;border-bottom:solid windowtext .5pt;border-right:solid windowtext .5pt;\r\n  padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>location_id</span></p>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td width=180 valign=top style=''width:135.0pt;border:solid windowtext .5pt;\r\n  border-top:none;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>Showing</span></p>\r\n  </td>\r\n  <td width=228 valign=top style=''width:171.0pt;border-top:none;border-left:\r\n  none;border-bottom:solid windowtext .5pt;border-right:solid windowtext .5pt;\r\n  padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><span style=''font-family:\"Times New Roman\"''>location</span></p>\r\n  </td>\r\n </tr>\r\n</table>\r\n\r\n</div>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.5in;text-indent:-.25in;''>38.<span style=''font:7.0pt \"Times New Roman\"''>&nbsp;\r\n</span>Select the member_id field from the list of fields and click\r\non the <span class=ScreenMenusNames><span style=''font-size:11.0pt;font-family:\"Microsoft Sans Serif\";''>Join</span></span>\r\ntab. Configure the join as follows:</p>\r\n\r\n<p class=MsoBodyText style=''margin-left:.25in''>&nbsp;</p>\r\n\r\n<div align=center>\r\n\r\n<table border=1 cellspacing=0 cellpadding=0 style=''margin-left:1.2in;\r\n background:#F2F2F2;border-collapse:\r\n collapse;border:none;''>\r\n <tr>\r\n  <td wid',6);
GO

INSERT INTO article_contents(art_content_id,art_id,art_content_name,art_content,art_content_ord) 
 VALUES (128,21,'APPENDIX A - Web Development Resources','\n\r\n<h2 style=''margin-left:0in;text-indent:0in''><a name=\"_Toc515701509\"></a><a\r\nname=\"_Toc516936383\">1.<span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Articles and Tutorials</a></h2>\r\n\r\n<p class=MsoBodyText><a name=\"_Toc515701510\">PHP and MySQL</a></p>\r\n\r\n<p class=MsoBodyText><a name=\"_Toc515701511\">PHP/MySQL Tutorial</a></p>\r\n\r\n<p class=MsoBodyText><a\r\nhref=\"http://hotwired.lycos.com/webmonkey/99/21/index2a.html\"><span\r\nstyle=''font-size:10.0pt;font-family:Arial;''>http://hotwired.lycos.com/webmonkey/99/21/index2a.html</span></a></p>\r\n\r\n<p class=MsoBodyText><a name=\"_Toc515701512\">DBI</a></p>\r\n\r\n<p class=MsoBodyText><a name=\"_Toc515701513\">Short guide to DBI</a></p>\r\n\r\n<p class=MsoBodyText><a href=\"http://www.perl.com/pub/1999/10/DBI.html\"><span\r\nstyle=''font-size:10.0pt;font-family:Arial;''>http://www.perl.com/pub/1999/10/DBI.html</span></a></p>\r\n\r\n<p class=MsoBodyText><a name=\"_Toc515701514\">JSP and JDBC</a></p>\r\n\r\n<p class=MsoBodyText><a name=\"_Toc515701515\">JDBC Basics Tutorial</a></p>\r\n\r\n<p class=MsoBodyText><a\r\nhref=\"http://java.sun.com/docs/books/tutorial/jdbc/basics/index.html\"><span\r\nstyle=''font-size:10.0pt;font-family:Arial;''>http://java.sun.com/docs/books/tutorial/jdbc/basics/index.html</span></a></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=MsoBodyText><a name=\"_Toc515701516\">HTML and CSS</a></p>\r\n\r\n<p class=MsoBodyText><a name=\"_Toc515701517\">A User&#8217;s Guide to Style Sheets</a></p>\r\n\r\n<p class=MsoBodyText><a\r\nhref=\"http://msdn.microsoft.com/workshop/author/css/css.asp\"><span\r\nstyle=''font-size:10.0pt;font-family:Arial;''>http://msdn.microsoft.com/workshop/author/css/css.asp</span></a></p>\r\n\r\n<p class=MsoBodyText><a name=\"_Toc515701518\">CSS Attributes Reference</a></p>\r\n\r\n<p class=MsoBodyText><a\r\nhref=\"http://msdn.microsoft.com/workshop/author/css/reference/attributes.asp\"><span\r\nstyle=''font-size:10.0pt;font-family:Arial;''>http://msdn.microsoft.com/workshop/author/css/reference/attributes.asp</span></a></p>\r\n\r\n<p class=MsoBodyText><a name=\"_Toc515701519\">HTML for Beginners</a></p>\r\n\r\n<p class=MsoBodyText><a\r\nhref=\"http://msdn.microsoft.com/workshop/author/html/beghtml.asp\"><span\r\nstyle=''font-size:10.0pt;font-family:Arial;''>http://msdn.microsoft.com/workshop/author/html/beghtml.asp</span></a></p>\r\n\r\n<p class=MsoBodyText><a name=\"_Toc515701520\">HTML Elements Reference</a></p>\r\n\r\n<p class=MsoBodyText><a\r\nhref=\"http://msdn.microsoft.com/workshop/author/html/reference/elements.asp\"><span\r\nstyle=''font-size:10.0pt;font-family:Arial;''>http://msdn.microsoft.com/workshop/author/html/reference/elements.asp</span></a></p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<h2 style=''margin-left:0in;text-indent:0in''><a name=\"_Toc515701521\"></a><a\r\nname=\"_Toc516936384\">2.<span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Tools and Utilities</a></h2>\r\n\r\n<p class=MsoBodyText><a name=\"_Toc515701522\">PHP and MySQL</a></p>\r\n\r\n<p class=MsoBodyText><a name=\"_Toc515701523\">PhpMyAdmin</a></p>\r\n\r\n<p class=MsoBodyText>Web based MySQL administration tool</p>\r\n\r\n<p class=MsoBodyText><a href=\"http://www.phpwizard.net/projects/phpMyAdmin/\"><span\r\nstyle=''font-size:10.0pt;font-family:Arial;''>http://www.phpwizard.net/projects/phpMyAdmin/</span></a></p>\r\n\r\n<p class=MsoBodyText><a name=\"_Toc515701524\">PHP Triad for Windows</a></p>\r\n\r\n<p class=MsoBodyText>Complete PHP server environment including Apache and MySQL</p>\r\n\r\n<p class=MsoBodyText><a href=\"http://sourceforge.net/projects/phptriad/\"><span\r\nstyle=''font-size:10.0pt;font-family:Arial;''>http://sourceforge.net/projects/phptriad/</span></a></p>\r\n\r\n\r\n<\r\n<',7);
GO

INSERT INTO article_contents(art_content_id,art_id,art_content_name,art_content,art_content_ord) 
 VALUES (129,21,'APPENDIX B - Troubleshooting','\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<table border=1 cellspacing=0 cellpadding=0 style=''border-collapse:collapse;\r\n border:none;''>\r\n <tr>\r\n  <td width=72 valign=top style=''width:54.05pt;border:solid windowtext .5pt;\r\n  background:#CCCCCC;\r\n  padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText>Symptoms:</p>\r\n  </td>\r\n  <td width=598 valign=top style=''width:448.75pt;border:solid windowtext .5pt;\r\n  border-left:none;background:#CCCCCC;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><a name=\"_Toc515701526\"><b>Database tables or fields\r\n  don&#8217;t show up in CodeCharge</b></a></p>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td width=72 valign=top style=''width:54.05pt;border:solid windowtext .5pt;\r\n  border-top:none;background:#E5E5E5;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText>Solution:</p>\r\n  </td>\r\n  <td width=598 valign=top style=''width:448.75pt;border-top:none;border-left:\r\n  none;border-bottom:solid windowtext .5pt;border-right:solid windowtext .5pt;\r\n  background:#F2F2F2;padding:\r\n  0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText align=left style=''text-align:left''>If you are able to\r\n  connect to the database from within CodeCharge but do not see the database\r\n  tables or fields, you may need to install the latest connectivity drivers\r\n  from Microsoft, called MDAC. The latest MDAC 2.6 drivers are available at <a\r\n  href=\"http://www.microsoft.com/data/download_260rtm.htm\"><span\r\n  style=''font-size:10.0pt;font-family:Arial;''>http://www.microsoft.com/data/download_260rtm.htm</span></a></p>\r\n  </td>\r\n </tr>\r\n</table>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<table border=1 cellspacing=0 cellpadding=0 style=''border-collapse:collapse;\r\n border:none;''>\r\n <tr>\r\n  <td width=72 valign=top style=''width:54.05pt;border:solid windowtext .5pt;\r\n  background:#CCCCCC;\r\n  padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText>Symptoms:</p>\r\n  </td>\r\n  <td width=598 valign=top style=''width:448.75pt;border:solid windowtext .5pt;\r\n  border-left:none;background:#CCCCCC;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><b>Error: Invalid use of Null Code: 94</b></p>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td width=72 valign=top style=''width:54.05pt;border:solid windowtext .5pt;\r\n  border-top:none;background:#E5E5E5;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText>Solution:</p>\r\n  </td>\r\n  <td width=598 valign=top style=''width:448.75pt;border-top:none;border-left:\r\n  none;border-bottom:solid windowtext .5pt;border-right:solid windowtext .5pt;\r\n  background:#F2F2F2;padding:\r\n  0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText>1. Upgrade Microsoft Internet Explorer to version 5.5+</p>\r\n  <p class=MsoBodyText align=left style=''text-align:left''>2. Install the latest\r\n  version of the Microsoft Data Access Components (MDAC 2.6) from\r\n  http://www.microsoft.com/data/download_260rtm.htm</p>\r\n  </td>\r\n </tr>\r\n</table>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<table border=1 cellspacing=0 cellpadding=0 style=''border-collapse:collapse;\r\n border:none;''>\r\n <tr>\r\n  <td width=72 valign=top style=''width:54.05pt;border:solid windowtext .5pt;\r\n  background:#CCCCCC;\r\n  padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText>Symptoms:</p>\r\n  </td>\r\n  <td width=598 valign=top style=''width:448.75pt;border:solid windowtext .5pt;\r\n  border-left:none;background:#CCCCCC;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText><b>Error: Operation Must Use an Updateable Query when\r\n  you try to add or update a record</b></p>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td width=72 valign=top style=''width:54.05pt;border:solid windowtext .5pt;\r\n  border-top:none;background:#E5E5E5;padding:0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText>Solution:</p>\r\n  </td>\r\n  <td width=598 valign=top style=''width:448.75pt;border-top:none;border-left:\r\n  none;border-bottom:solid windowtext .5pt;border-right:solid windowtext .5pt;\r\n  background:#F2F2F2;padding:\r\n  0in 5.4pt 0in 5.4pt''>\r\n  <p class=MsoBodyText>Database access permissions are not set correctly. If\r\n  you are using Windows NT or 2000, set the security on the .mdb file and its\r\n  parent directory to &quot;full-access&quot;. If you use Windows 95/98/Me,\r\n  right-click on the .mdb file and make sure that &quot;read-only&quot; is\r\n  unchecked, then do the same on the directory where your .mdb file is located.\r\n  Also, note the following:</p>\r\n  <p class=MsoBodyText>1) This error may occur if the account being used by\r\n  Internet Information Server (IIS), (usually IUSR), does not have the correct\r\n  Windows NT permissions for a file-based database or for the folder containing\r\n  the file.</p>\r\n  <p class=MsoBodyText>&nbsp;</p>\r\n  <p class=MsoBodyText>2) Use the Windows NT File Monitor to check for file\r\n  access failures. Windows NT File Monitor is available from the following Web\r\n  site: &lt;http://www.sysinternals.com&gt;. </p>\r\n  <p class=MsoBodyText>&nbsp;</p>\r\n  <p class=MsoBodyText>3) If you use a network path to the database (UNC or\r\n  mapped drive), check the permissions on the share, the file, and the folder. </p>\r\n  <p class=MsoBodyText>&nbsp;</p>\r\n  <p class=MsoBodyText>4) Check to make sure that the file and the data source\r\n  name (DSN) are not marked as Exclusive.</p>\r\n  <p class=MsoBodyText>&nbsp;</p>\r\n  <p class=MsoBodyText>5) Make sure no other process uses this mdb file.</p>\r\n  <p class=MsoBodyText>&nbsp;</p>\r\n  <p class=MsoBodyText>6) This error may also occur when accessing a local\r\n  Microsoft Access database linked to a table where the table is in an Access\r\n  database on a network server. In this situation, please refer to the\r\n  following article in the Microsoft Knowledge Base for a workaround.</p>\r\n  <p class=MsoBodyText>&nbsp;</p>\r\n  <p class=MsoBodyText>This error is attributed to the design of Microsoft\r\n  products and you can read more about it at:</p>\r\n  <p class=MsoBodyText>PRB: ASP Returns ''Operation Must Use an Updateable\r\n  Query'' Error</p>\r\n  <p class=MsoBodyText align=left style=''text-align:left''>http://support.microsoft.com/support/kb/articles/Q175/1/68.ASP&quot;</p>\r\n  </td>\r\n </tr>\r\n</table>\r\n\r\n\r\n<\r\n<',8);
GO

INSERT INTO article_contents(art_content_id,art_id,art_content_name,art_content,art_content_ord) 
 VALUES (130,21,'APPENDIX C - Additional Code and SQL Scripts','\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<h2 style=''margin-left:0in;text-indent:0in''><a name=\"_Toc516936387\">1.<span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>MySQL script</a></h2>\r\n\r\n<p class=MsoBodyText>Use the following SQL script to create the database tables\r\nfor this tutorial in a MySQL database. Note that this script only creates the\r\ntable structure and does not add any data into the tables. A separate script\r\nwith the table structure as well as sample data is included with the completed\r\nproject file.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<p class=Code># --------------------------------------------------------</p>\r\n\r\n<p class=Code>#</p>\r\n\r\n<p class=Code># Table structure for table ''email_register''</p>\r\n\r\n<p class=Code>#</p>\r\n\r\n<p class=Code>&nbsp;</p>\r\n\r\n<p class=Code>DROP TABLE IF EXISTS email_register;</p>\r\n\r\n<p class=Code>CREATE TABLE email_register (</p>\r\n\r\n<p class=Code>   email_id int(11) NOT\r\nNULL auto_increment,</p>\r\n\r\n<p class=Code>   email_date datetime,</p>\r\n\r\n<p class=Code>   member_id int(11),</p>\r\n\r\n<p class=Code>   PRIMARY KEY (email_id)</p>\r\n\r\n<p class=Code>);</p>\r\n\r\n<p class=Code>&nbsp;</p>\r\n\r\n<p class=Code>&nbsp;</p>\r\n\r\n<p class=Code># --------------------------------------------------------</p>\r\n\r\n<p class=Code>#</p>\r\n\r\n<p class=Code># Table structure for table ''events''</p>\r\n\r\n<p class=Code>#</p>\r\n\r\n<p class=Code>&nbsp;</p>\r\n\r\n<p class=Code>DROP TABLE IF EXISTS events;</p>\r\n\r\n<p class=Code>CREATE TABLE events (</p>\r\n\r\n<p class=Code>   event_id int(11) NOT\r\nNULL auto_increment,</p>\r\n\r\n<p class=Code>   event_name\r\nvarchar(100),</p>\r\n\r\n<p class=Code>   event_description text,</p>\r\n\r\n<p class=Code>   event_date datetime,</p>\r\n\r\n<p class=Code>   location_id int(11),</p>\r\n\r\n<p class=Code>   member_id int(11),</p>\r\n\r\n<p class=Code>   date_update datetime,</p>\r\n\r\n<p class=Code>   is_active int(11),</p>\r\n\r\n<p class=Code>   PRIMARY KEY (event_id)</p>\r\n\r\n<p class=Code>);</p>\r\n\r\n<p class=Code>&nbsp;</p>\r\n\r\n<p class=Code>&nbsp;</p>\r\n\r\n<p class=Code># --------------------------------------------------------</p>\r\n\r\n<p class=Code>#</p>\r\n\r\n<p class=Code># Table structure for table ''locations''</p>\r\n\r\n<p class=Code>#</p>\r\n\r\n<p class=Code>&nbsp;</p>\r\n\r\n<p class=Code>DROP TABLE IF EXISTS locations;</p>\r\n\r\n<p class=Code>CREATE TABLE locations (</p>\r\n\r\n<p class=Code>   location_id int(11) NOT\r\nNULL auto_increment,</p>\r\n\r\n<p class=Code>   location char(50),</p>\r\n\r\n<p class=Code>   PRIMARY KEY\r\n(location_id)</p>\r\n\r\n<p class=Code>);</p>\r\n\r\n<p class=Code>&nbsp;</p>\r\n\r\n<p class=Code>&nbsp;</p>\r\n\r\n<p class=Code># --------------------------------------------------------</p>\r\n\r\n<p class=Code>#</p>\r\n\r\n<p class=Code># Table structure for table ''members''</p>\r\n\r\n<p class=Code>#</p>\r\n\r\n<p class=Code>&nbsp;</p>\r\n\r\n<p class=Code>DROP TABLE IF EXISTS members;</p>\r\n\r\n<p class=Code>CREATE TABLE members (</p>\r\n\r\n<p class=Code>   member_id int(11) NOT\r\nNULL auto_increment,</p>\r\n\r\n<p class=Code>   member_name char(50),</p>\r\n\r\n<p class=Code>   real_name char(50),</p>\r\n\r\n<p class=Code>   member_email char(50),</p>\r\n\r\n<p class=Code>   location_id int(11),</p>\r\n\r\n<p class=Code>   password char(50),</p>\r\n\r\n<p class=Code>   security_level int(11),</p>\r\n\r\n<p class=Code>   date_registered\r\ndatetime,</p>\r\n\r\n<p class=Code>   is_notified int(11),</p>\r\n\r\n<p class=Code>   PRIMARY KEY (member_id)</p>\r\n\r\n<p class=Code>);</p>\r\n\r\n<p class=Code>&nbsp;</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n<h2 style=''margin-left:0in;text-indent:0in''><a name=\"_Toc516936388\">2.<span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Microsoft SQL Server script</a></h2>\r\n\r\n<p class=MsoBodyText>Use the following SQL script to create the database tables\r\nfor this tutorial in a Microsoft SQL Server database. Note that this script\r\nonly creates the table structure and does not add any data into the tables. A\r\nseparate script with the table structure as well as sample data is included\r\nwith the completed project file.</p>\r\n\r\n<p class=MsoNormal style=''text-autospace:none''><span\r\nstyle=''font-size:10.0pt;font-family:\"Courier New\"''>&nbsp;</span></p>\r\n\r\n<p class=MsoNormal style=''text-autospace:none''><span\r\nstyle=''font-size:10.0pt;font-family:\"Courier New\"''>&nbsp;</span></p>\r\n\r\n<p class=Code>if exists (select * from dbo.sysobjects where id =\r\nobject_id(N''[email_register]'') and OBJECTPROPERTY(id, N''IsUserTable'') = 1)</p>\r\n\r\n<p class=Code>drop table [email_register]</p>\r\n\r\n<p class=Code>GO</p>\r\n\r\n<p class=Code>&nbsp;</p>\r\n\r\n<p class=Code>if exists (select * from dbo.sysobjects where id =\r\nobject_id(N''[events]'') and OBJECTPROPERTY(id, N''IsUserTable'') = 1)</p>\r\n\r\n<p class=Code>drop table [events]</p>\r\n\r\n<p class=Code>GO</p>\r\n\r\n<p class=Code>&nbsp;</p>\r\n\r\n<p class=Code>if exists (select * from dbo.sysobjects where id =\r\nobject_id(N''[locations]'') and OBJECTPROPERTY(id, N''IsUserTable'') = 1)</p>\r\n\r\n<p class=Code>drop table [locations]</p>\r\n\r\n<p class=Code>GO</p>\r\n\r\n<p class=Code>&nbsp;</p>\r\n\r\n<p class=Code>if exists (select * from dbo.sysobjects where id =\r\nobject_id(N''[members]'') and OBJECTPROPERTY(id, N''IsUserTable'') = 1)</p>\r\n\r\n<p class=Code>drop table [members]</p>\r\n\r\n<p class=Code>GO</p>\r\n\r\n<p class=Code>&nbsp;</p>\r\n\r\n<p class=Code>&nbsp;</p>\r\n\r\n<p class=Code>CREATE TABLE [email_register] (</p>\r\n\r\n<p class=Code>     [email_id] [int] NOT\r\nNULL ,</p>\r\n\r\n<p class=Code>     [email_date]\r\n[smalldatetime] NULL ,</p>\r\n\r\n<p class=Code>     [member_id] [int] NULL </p>\r\n\r\n<p class=Code>) ON [PRIMARY]</p>\r\n\r\n<p class=Code>GO</p>\r\n\r\n<p class=Code>&nbsp;</p>\r\n\r\n<p class=Code>CREATE TABLE [events] (</p>\r\n\r\n<p class=Code>     [event_id] [int] NOT\r\nNULL ,</p>\r\n\r\n<p class=Code>     [event_name] [nvarchar]\r\n(100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,</p>\r\n\r\n<p class=Code>     [event_description]\r\n[ntext] COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,</p>\r\n\r\n<p class=Code>     [event_date]\r\n[smalldatetime] NULL ,</p>\r\n\r\n<p class=Code>     [location_id] [int]\r\nNULL ,</p>\r\n\r\n<p class=Code>     [member_id] [int] NULL\r\n,</p>\r\n\r\n<p class=Code>     [date_update]\r\n[smalldatetime] NULL ,</p>\r\n\r\n<p class=Code>     [is_active] [int] NULL </p>\r\n\r\n<p class=Code>) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]</p>\r\n\r\n<p class=Code>GO</p>\r\n\r\n<p class=Code>&nbsp;</p>\r\n\r\n<p class=Code>CREATE TABLE [locations] (</p>\r\n\r\n<p class=Code>     [location_id] [int] NOT\r\nNULL ,</p>\r\n\r\n<p class=Code>     [location] [nvarchar]\r\n(50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL </p>\r\n\r\n<p class=Code>) ON [PRIMARY]</p>\r\n\r\n<p class=Code>GO</p>\r\n\r\n<p class=Code>&nbsp;</p>\r\n\r\n<p class=Code>CREATE TABLE [members] (</p>\r\n\r\n<p class=Code>     [member_id] [int] NOT\r\nNULL ,</p>\r\n\r\n<p class=Code>     [member_name]\r\n[nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,</p>\r\n\r\n<p class=Code>     [real_name] [nvarchar]\r\n(50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,</p>\r\n\r\n<p class=Code>     [member_email]\r\n[nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,</p>\r\n\r\n<p class=Code>     [location_id] [int]\r\nNULL ,</p>\r\n\r\n<p class=Code>     [password] [nvarchar]\r\n(50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,</p>\r\n\r\n<p class=Code>     [security_level] [int]\r\nNULL ,</p>\r\n\r\n<p class=Code>     [date_registered]\r\n[smalldatetime] NULL ,</p>\r\n\r\n<p class=Code>     [is_notified] [int]\r\nNULL </p>\r\n\r\n<p class=Code>) ON [PRIMARY]</p>\r\n\r\n<p class=Code>GO</p>\r\n\r\n<h2 style=''margin-left:0in;text-indent:0in''><a name=\"_Toc516936389\"></a>3.<span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>&nbsp;</h2>\r\n\r\n<\r\n<',9);
GO

INSERT INTO article_contents(art_content_id,art_id,art_content_name,art_content,art_content_ord) 
 VALUES (131,21,'Legal Notices','\n<h2 style=''margin-left:0in;text-indent:0in''><a name=\"_Toc516936391\"><span\r\nstyle=''font:7.0pt \"Times New Roman\"''>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span>Copyright</a></h2>\r\n\r\n<p class=CopyrightText>  YesSoftware\r\nIncorporated. All rights reserved.</p>\r\n\r\n<p class=CopyrightText>&nbsp;</p>\r\n\r\n<p class=CopyrightText>This manual, as well as the software described in it, is\r\nfurnished under license and may be used or copied only in accordance with the\r\nterms of such license. The content of this manual is furnished for\r\ninformational use only, is subject to change without notice, and should not be\r\nconstrued as a commitment by YesSoftware Incorporated. YesSoftware Incorporated\r\nassumes no responsibility or liability for any errors or inaccuracies that may\r\nappear in this documentation. Except as permitted by such license, no part of\r\nthis publication may be reproduced, stored in a retrieval system, or\r\ntransmitted, in any form or by any means, electronic, mechanical, recording, or\r\notherwise, without the prior written permission of YesSoftware Incorporated.</p>\r\n\r\n<p class=CopyrightText>&nbsp;</p>\r\n\r\n<p class=CopyrightText>YesSoftware, the YesSoftware logo, CodeCharge and the\r\nCodeCharge Logo are either registered trademarks or trademarks of YesSoftware\r\nIncorporated in the United States and/or other countries. ASP, IIS, Microsoft,\r\nWindows and Windows NT are either registered trademarks or trademarks of\r\nMicrosoft Corporation in the United States and/or other countries. JavaScript\r\nand JSP are trademarks or registered trademarks of Sun Microsystems, Inc. in\r\nthe United States and other countries. All other trademarks are the property of\r\ntheir respective owners.</p>\r\n\r\n<p class=MsoBodyText>&nbsp;</p>\r\n\r\n</div>',10);
GO
 set IDENTITY_INSERT article_contents OFF;


if exists (select * from sysobjects where id = object_id(N'article_ratings') and OBJECTPROPERTY(id, N'IsUserTable') = 1) drop table article_ratings
GO
 
CREATE TABLE article_ratings (

  art_id int NOT NULL,
  user_id int NOT  NULL,
  art_rate int default NULL,
  ip varchar(50) NOT  NULL,
  primary key(art_id,user_id,ip)
);
GO



INSERT INTO article_ratings(art_id,user_id,art_rate,ip) 
 VALUES (21,0,5,'200.56.198.213');
GO

INSERT INTO article_ratings(art_id,user_id,art_rate,ip) 
 VALUES (21,0,4,'212.10.94.162');
GO



if exists (select * from sysobjects where id = object_id(N'article_types') and OBJECTPROPERTY(id, N'IsUserTable') = 1) drop table article_types
GO
 
CREATE TABLE article_types (

  art_type_id int IDENTITY,
  primary key(art_type_id),
  art_type_name varchar(50) default NULL,
  art_type_ord int default NULL
);
GO

 set IDENTITY_INSERT article_types ON;

INSERT INTO article_types(art_type_id,art_type_name,art_type_ord) VALUES (3,'Example',20);
GO

INSERT INTO article_types(art_type_id,art_type_name,art_type_ord) VALUES (4,'Article',10);
GO

INSERT INTO article_types(art_type_id,art_type_name,art_type_ord) VALUES (5,'Tip',30);
GO
 set IDENTITY_INSERT article_types OFF;


if exists (select * from sysobjects where id = object_id(N'articles') and OBJECTPROPERTY(id, N'IsUserTable') = 1) drop table articles
GO
 
CREATE TABLE articles (

  art_id int IDENTITY,
  primary key(art_id),
  art_name varchar(100) default NULL,
  art_submit_by int default NULL,
  art_submit_date datetime NOT NULL,
  art_type_id int default NULL,
  art_cat_id int default NULL,
  art_approved int default NULL,
  art_approved_by int default NULL,
  art_active int default NULL,
  art_rating float default NULL,
  art_rating_count int default NULL
);
GO
 set IDENTITY_INSERT articles ON;


INSERT INTO articles(art_id,art_name,art_submit_by,art_submit_date,art_type_id,art_cat_id,art_approved,art_approved_by,art_active,art_rating,art_rating_count)
 VALUES (21,'Building a Database-Driven Event Management Website Using CodeCharge',1,'2001-06-19 00:00:00',4,3,1,0,0,8,2);
GO

INSERT INTO articles(art_id,art_name,art_submit_by,art_submit_date,art_type_id,art_cat_id,art_approved,art_approved_by,art_active,art_rating,art_rating_count)
 VALUES (22,'CodeCharge Frequently Asked Questions',1,'2001-06-19 00:00:00',4,3,1,0,0,0,0);
GO

 set IDENTITY_INSERT articles OFF;

if exists (select * from sysobjects where id = object_id(N'demos') and OBJECTPROPERTY(id, N'IsUserTable') = 1) drop table demos
GO
 
CREATE TABLE demos (

  demo_id int IDENTITY,
  primary key(demo_id),
  app_id int default NULL,
  language_id int default NULL,
  lang_type_id int default NULL,
  demo_url varchar(100) default NULL,
  download_url varchar(100) default NULL
);
GO
 set IDENTITY_INSERT demos ON;


INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (111,4,1,1,'/apps/yellowpages/asp','/apps/dloads/yellowpages_asp.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (112,4,1,2,'/apps/yellowpages/aspt','/apps/dloads/yellowpages_aspt.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (113,4,6,1,'/apps/yellowpages/net','/apps/dloads/yellowpages_aspnet.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (114,4,4,1,'/apps/yellowpages/cfml','/apps/dloads/yellowpages_cfml.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (115,4,5,1,'/apps/yellowpages/JSP','/apps/dloads/yellowpages_jsp.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (116,4,5,2,'/apps/yellowpages/JSPt','/apps/dloads/yellowpages_jspt.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (117,4,3,1,'/apps/yellowpages/perl5','/apps/dloads/yellowpages_perl5.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (118,4,3,2,'/apps/yellowpages/perl5t','/apps/dloads/yellowpages_perl5t.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (119,4,2,1,NULL,'/apps/dloads/yellowpages_php3.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (120,4,2,2,NULL,'/apps/dloads/yellowpages_php3t.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (121,4,8,1,'/apps/yellowpages/php4','/apps/dloads/yellowpages_php4.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (122,4,8,2,'/apps/yellowpages/php4t','/apps/dloads/yellowpages_php4t.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (123,14,1,1,'/apps/tellafriend/asp','/apps/dloads/tellafriend_asp.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (124,14,1,2,'/apps/tellafriend/aspt','/apps/dloads/tellafriend_aspt.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (125,14,6,1,'/apps/tellafriend/net','/apps/dloads/tellafriend_aspnet.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (126,14,4,1,'/apps/tellafriend/cfml','/apps/dloads/tellafriend_cfml.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (127,14,5,1,'/apps/tellafriend/JSP','/apps/dloads/tellafriend_jsp.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (128,14,5,2,'/apps/tellafriend/JSPt','/apps/dloads/tellafriend_jspt.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (129,14,3,1,'/apps/tellafriend/perl5','/apps/dloads/tellafriend_perl5.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (130,14,3,2,'/apps/tellafriend/perl5t','/apps/dloads/tellafriend_perl5t.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (131,14,2,1,NULL,'/apps/dloads/tellafriend_php3.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (132,14,2,2,NULL,'/apps/dloads/tellafriend_php3t.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (133,14,8,1,'/apps/tellafriend/php4','/apps/dloads/tellafriend_php4.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (134,14,8,2,'/apps/tellafriend/php4t','/apps/dloads/tellafriend_php4t.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (135,13,1,1,'/apps/taskman/asp','/apps/dloads/taskman_asp.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (136,13,1,2,'/apps/taskman/aspt','/apps/dloads/taskman_aspt.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (137,13,6,1,'/apps/taskman/net','/apps/dloads/taskman_aspnet.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (138,13,4,1,'/apps/taskman/cfml','/apps/dloads/taskman_cfml.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (139,13,5,1,'/apps/taskman/JSP','/apps/dloads/taskman_jsp.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (140,13,5,2,'/apps/taskman/JSPt','/apps/dloads/taskman_jspt.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (141,13,3,1,'/apps/taskman/perl5','/apps/dloads/taskman_perl5.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (142,13,3,2,'/apps/taskman/perl5t','/apps/dloads/taskman_perl5t.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (143,13,2,1,NULL,'/apps/dloads/taskman_php3.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (144,13,2,2,NULL,'/apps/dloads/taskman_php3t.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (145,13,8,1,'/apps/taskman/php4','/apps/dloads/taskman_php4.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (146,13,8,2,'/apps/taskman/php4t','/apps/dloads/taskman_php4t.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (147,12,1,1,'/apps/regform/asp','/apps/dloads/regform_asp.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (148,12,1,2,'/apps/regform/aspt','/apps/dloads/regform_aspt.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (149,12,6,1,'/apps/regform/net','/apps/dloads/regform_aspnet.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (150,12,4,1,'/apps/regform/cfml','/apps/dloads/regform_cfml.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (151,12,5,1,'/apps/regform/JSP','/apps/dloads/regform_jsp.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (152,12,5,2,'/apps/regform/JSPt','/apps/dloads/regform_jspt.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (153,12,3,1,'/apps/regform/perl5','/apps/dloads/regform_perl5.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (154,12,3,2,'/apps/regform/perl5t','/apps/dloads/regform_perl5t.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (155,12,2,1,NULL,'/apps/dloads/regform_php3.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (156,12,2,2,NULL,'/apps/dloads/regform_php3t.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (157,12,8,1,'/apps/regform/php4','/apps/dloads/regform_php4.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (158,12,8,2,'/apps/regform/php4t','/apps/dloads/regform_php4t.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (159,11,1,1,'/apps/portal/asp','/apps/dloads/portal_asp.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (160,11,1,2,'/apps/portal/aspt','/apps/dloads/portal_aspt.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (161,11,6,1,'/apps/portal/net','/apps/dloads/portal_aspnet.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (162,11,4,1,'/apps/portal/cfml','/apps/dloads/portal_cfml.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (163,11,5,1,'/apps/portal/JSP','/apps/dloads/portal_jsp.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (164,11,5,2,'/apps/portal/JSPt','/apps/dloads/portal_jspt.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (165,11,3,1,'/apps/portal/perl5','/apps/dloads/portal_perl5.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (166,11,3,2,'/apps/portal/perl5t','/apps/dloads/portal_perl5t.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (167,11,2,1,NULL,'/apps/dloads/portal_php3.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (168,11,2,2,NULL,'/apps/dloads/portal_php3t.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (169,11,8,1,'/apps/portal/php4','/apps/dloads/portal_php4.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (170,11,8,2,'/apps/portal/php4t','/apps/dloads/portal_php4t.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (171,3,1,1,'/apps/bookstore/asp','/apps/dloads/bookstore_asp.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (172,3,1,2,'/apps/bookstore/aspt','/apps/dloads/bookstore_aspt.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (173,3,6,1,'/apps/bookstore/net','/apps/dloads/bookstore_aspnet.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (174,3,4,1,'/apps/bookstore/cfml','/apps/dloads/bookstore_cfml.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (175,3,5,1,'/apps/bookstore/JSP','/apps/dloads/bookstore_jsp.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (176,3,5,2,'/apps/bookstore/JSPt','/apps/dloads/bookstore_jspt.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (177,3,3,1,'/apps/bookstore/perl5','/apps/dloads/bookstore_perl5.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (178,3,3,2,'/apps/bookstore/perl5t','/apps/dloads/bookstore_perl5t.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (179,3,2,1,NULL,'/apps/dloads/bookstore_php3.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (180,3,2,2,NULL,'/apps/dloads/bookstore_php3t.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (181,3,8,1,'/apps/bookstore/php4','/apps/dloads/bookstore_php4.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (182,3,8,2,'/apps/bookstore/php4t','/apps/dloads/bookstore_php4t.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (185,10,4,1,'/apps/metasearch/cfml','/apps/dloads/metasearch_cfml.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (186,10,5,1,'/apps/metasearch/JSP','/apps/dloads/metasearch_jsp.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (187,10,5,2,'/apps/metasearch/JSPt','/apps/dloads/metasearch_jspt.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (188,10,3,1,'/apps/metasearch/perl5','/apps/dloads/metasearch_perl5.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (189,10,3,2,'/apps/metasearch/perl5t','/apps/dloads/metasearch_perl5t.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (190,10,2,1,NULL,'/apps/dloads/metasearch_php3.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (191,10,2,2,NULL,'/apps/dloads/metasearch_php3t.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (192,10,8,1,'/apps/metasearch/php4','/apps/dloads/metasearch_php4.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (193,10,8,2,'/apps/metasearch/php4t','/apps/dloads/metasearch_php4t.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (194,2,1,1,'/apps/links/asp','/apps/dloads/links_asp.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (195,2,1,2,'/apps/links/aspt','/apps/dloads/links_aspt.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (196,2,6,1,'/apps/links/net','/apps/dloads/links_aspnet.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (197,2,4,1,'/apps/links/cfml','/apps/dloads/links_cfml.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (198,2,5,1,'/apps/links/JSP','/apps/dloads/links_jsp.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (199,2,5,2,'/apps/links/JSPt','/apps/dloads/links_jspt.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (200,2,3,1,'/apps/links/perl5','/apps/dloads/links_perl5.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (201,2,3,2,'/apps/links/perl5t','/apps/dloads/links_perl5t.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (202,2,2,1,NULL,'/apps/dloads/links_php3.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (203,2,2,2,NULL,'/apps/dloads/links_php3t.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (204,2,8,1,'/apps/links/php4','/apps/dloads/links_php4.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (205,2,8,2,'/apps/links/php4t','/apps/dloads/links_php4t.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (206,9,1,1,'/apps/ledger/asp','/apps/dloads/ledger_asp.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (207,9,1,2,'/apps/ledger/aspt','/apps/dloads/ledger_aspt.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (208,9,6,1,'/apps/ledger/net','/apps/dloads/ledger_aspnet.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (209,9,4,1,'/apps/ledger/cfml','/apps/dloads/ledger_cfml.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (210,9,5,1,'/apps/ledger/JSP','/apps/dloads/ledger_jsp.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (211,9,5,2,'/apps/ledger/JSPt','/apps/dloads/ledger_jspt.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (212,9,3,1,'/apps/ledger/perl5','/apps/dloads/ledger_perl5.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (213,9,3,2,'/apps/ledger/perl5t','/apps/dloads/ledger_perl5t.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (214,9,2,1,NULL,'/apps/dloads/ledger_php3.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (215,9,2,2,NULL,'/apps/dloads/ledger_php3t.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (216,9,8,1,'/apps/ledger/php4','/apps/dloads/ledger_php4.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (217,9,8,2,'/apps/ledger/php4t','/apps/dloads/ledger_php4t.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (218,8,1,1,'/apps/forum/asp','/apps/dloads/forum_asp.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (219,8,1,2,'/apps/forum/aspt','/apps/dloads/forum_aspt.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (220,8,6,1,'/apps/forum/net','/apps/dloads/forum_aspnet.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (221,8,4,1,'/apps/forum/cfml','/apps/dloads/forum_cfml.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (222,8,5,1,'/apps/forum/JSP','/apps/dloads/forum_jsp.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (223,8,5,2,'/apps/forum/JSPt','/apps/dloads/forum_jspt.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (224,8,3,1,'/apps/forum/perl5','/apps/dloads/forum_perl5.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (225,8,3,2,'/apps/forum/perl5t','/apps/dloads/forum_perl5t.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (226,8,2,1,NULL,'/apps/dloads/forum_php3.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (227,8,2,2,NULL,'/apps/dloads/forum_php3t.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (228,8,8,1,'/apps/forum/php4','/apps/dloads/forum_php4.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (229,8,8,2,'/apps/forum/php4t','/apps/dloads/forum_php4t.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (230,7,1,1,'/apps/events/asp','/apps/dloads/events_asp.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (231,7,1,2,'/apps/events/aspt','/apps/dloads/events_aspt.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (232,7,6,1,'/apps/events/net','/apps/dloads/events_aspnet.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (233,7,4,1,'/apps/events/cfml','/apps/dloads/events_cfml.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (234,7,5,1,'/apps/events/JSP','/apps/dloads/events_jsp.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (235,7,5,2,'/apps/events/JSPt','/apps/dloads/events_jspt.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (236,7,3,1,'/apps/events/perl5','/apps/dloads/events_perl5.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (237,7,3,2,'/apps/events/perl5t','/apps/dloads/events_perl5t.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (238,7,2,1,NULL,'/apps/dloads/events_php3.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (239,7,2,2,NULL,'/apps/dloads/events_php3t.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (240,7,8,1,'/apps/events/php4','/apps/dloads/events_php4.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (241,7,8,2,'/apps/events/php4t','/apps/dloads/events_php4t.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (242,6,1,1,'/apps/empldir/asp','/apps/dloads/empldir_asp.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (243,6,1,2,'/apps/empldir/aspt','/apps/dloads/empldir_aspt.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (244,6,6,1,'/apps/empldir/net','/apps/dloads/empldir_aspnet.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (245,6,4,1,'/apps/empldir/cfml','/apps/dloads/empldir_cfml.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (246,6,5,1,'/apps/empldir/JSP','/apps/dloads/empldir_jsp.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (247,6,5,2,'/apps/empldir/JSPt','/apps/dloads/empldir_jspt.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (248,6,3,1,'/apps/empldir/perl5','/apps/dloads/empldir_perl5.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (249,6,3,2,'/apps/empldir/perl5t','/apps/dloads/empldir_perl5t.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (250,6,2,1,NULL,'/apps/dloads/empldir_php3.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (251,6,2,2,NULL,'/apps/dloads/empldir_php3t.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (252,6,8,1,'/apps/empldir/php4','/apps/dloads/empldir_php4.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (253,6,8,2,'/apps/empldir/php4t','/apps/dloads/empldir_php4t.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (254,5,1,1,'/apps/classifieds/asp','/apps/dloads/classifieds_asp.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (255,5,1,2,'/apps/classifieds/aspt','/apps/dloads/classifieds_aspt.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (256,5,6,1,'/apps/classifieds/net','/apps/dloads/classifieds_aspnet.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (257,5,4,1,'/apps/classifieds/cfml','/apps/dloads/classifieds_cfml.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (258,5,5,1,'/apps/classifieds/JSP','/apps/dloads/classifieds_jsp.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (259,5,5,2,'/apps/classifieds/JSPt','/apps/dloads/classifieds_jspt.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (260,5,3,1,'/apps/classifieds/perl5','/apps/dloads/classifieds_perl5.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (261,5,3,2,'/apps/classifieds/perl5t','/apps/dloads/classifieds_perl5t.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (262,5,2,1,NULL,'/apps/dloads/classifieds_php3.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (263,5,2,2,NULL,'/apps/dloads/classifieds_php3t.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (264,5,8,1,'/apps/classifieds/php4','/apps/dloads/classifieds_php4.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (265,5,8,2,'/apps/classifieds/php4t','/apps/dloads/classifieds_php4t.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (266,1,1,1,'/apps/BugTrack/asp','/apps/dloads/bugtrack_asp.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (267,1,1,2,'/apps/BugTrack/aspt','/apps/dloads/bugtrack_aspt.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (268,1,6,1,'/apps/BugTrack/net','/apps/dloads/bugtrack_aspnet.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (269,1,4,1,'/apps/BugTrack/cfml','/apps/dloads/bugtrack_cfml.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (270,1,5,1,'/apps/BugTrack/JSP','/apps/dloads/bugtrack_jsp.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (271,1,5,2,'/apps/BugTrack/JSPt','/apps/dloads/bugtrack_jspt.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (272,1,3,1,'/apps/BugTrack/perl5','/apps/dloads/bugtrack_perl5.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (273,1,3,2,'/apps/BugTrack/perl5t','/apps/dloads/bugtrack_perl5t.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (274,1,2,1,NULL,'/apps/dloads/bugtrack_php3.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (275,1,2,2,NULL,'/apps/dloads/bugtrack_php3t.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (276,1,8,1,'/apps/BugTrack/php4','/apps/dloads/bugtrack_php4.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (277,1,8,2,'/apps/BugTrack/php4t','/apps/dloads/bugtrack_php4t.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (278,15,5,1,'http://www.wapsilon.com/PDA/http://www.sourcenation.com/apps/newswap/jspwml/index.jsp','/apps/dloads/newswap_jsp.zip');
GO

INSERT INTO demos (demo_id,app_id,language_id,lang_type_id,demo_url,download_url) 
 VALUES (279,15,8,1,'http://www.wapsilon.com/PDA/http://www.sourcenation.com/apps/newswap/php4wml/','/apps/dloads/newswap_php.zip');
GO

  set IDENTITY_INSERT demos OFF;

if exists (select * from sysobjects where id = object_id(N'lang_types') and OBJECTPROPERTY(id, N'IsUserTable') = 1) drop table lang_types
GO
 
CREATE TABLE lang_types (

  lang_type_id int IDENTITY,
  primary key(lang_type_id),
  lang_type_name varchar(30) default NULL
);
GO

INSERT INTO lang_types(lang_type_name) VALUES ('Standard');
GO

INSERT INTO lang_types(lang_type_name) VALUES ('w/Templates');
GO

if exists (select * from sysobjects where id = object_id(N'languages') and OBJECTPROPERTY(id, N'IsUserTable') = 1) drop table languages
GO
 
CREATE TABLE languages (

  language_id int IDENTITY,
  primary key(language_id),
  language_name varchar(30) default NULL
);
GO


INSERT INTO languages(language_name) VALUES ('ASP');
GO

INSERT INTO languages(language_name) VALUES ('PHP3');
GO

INSERT INTO languages(language_name) VALUES ('Perl');
GO

INSERT INTO languages(language_name) VALUES ('ColdFusion');
GO

INSERT INTO languages(language_name) VALUES ('JSP');
GO

INSERT INTO languages(language_name) VALUES ('ASP.NET/C#');
GO

INSERT INTO languages(language_name) VALUES ('ALL');
GO

INSERT INTO languages(language_name) VALUES ('PHP4');
GO



if exists (select * from sysobjects where id = object_id(N'link_categories') and OBJECTPROPERTY(id, N'IsUserTable') = 1) drop table link_categories
GO
 
CREATE TABLE link_categories (

  link_cat_id int IDENTITY,
  primary key(link_cat_id),
  link_cat_desc varchar(50) default NULL
);
GO



INSERT INTO link_categories(link_cat_desc) VALUES ('Applications');
GO

INSERT INTO link_categories(link_cat_desc) VALUES ('Articles');
GO

INSERT INTO link_categories(link_cat_desc) VALUES ('Components');
GO

INSERT INTO link_categories(link_cat_desc) VALUES ('Examples');
GO

INSERT INTO link_categories(link_cat_desc) VALUES ('Sites');
GO

INSERT INTO link_categories(link_cat_desc) VALUES ('Tools');
GO

INSERT INTO link_categories(link_cat_desc) VALUES ('Tutorials');
GO



if exists (select * from sysobjects where id = object_id(N'links') and OBJECTPROPERTY(id, N'IsUserTable') = 1) drop table links
GO
 
CREATE TABLE links (

  link_id int IDENTITY,
  primary key(link_id),
  link_name varchar(50) default NULL,
  link_url varchar(50) default NULL,
  link_desc varchar(255) default NULL,
  link_cat_id int default NULL,
  link_approved int default NULL,
  link_added_by int default NULL,
  link_date_approved datetime NOT NULL,
  link_approved_by int default NULL,
  link_date_added datetime NOT NULL
);
GO
 set IDENTITY_INSERT links ON;


INSERT INTO links(link_id,link_name,link_url,link_desc,link_cat_id,link_approved,link_added_by,link_date_approved,link_approved_by,link_date_added)
 VALUES (7,'Norman Running Club, Norman, OK','http://www.kenhardwick.com/','Site developed entirely with Code Charge (except upload page) I plan to add additional features as time permits.',5,1,9,'2001-07-13 14:10:39',0,'2001-06-24 00:00:00');
GO

INSERT INTO links(link_id,link_name,link_url,link_desc,link_cat_id,link_approved,link_added_by,link_date_approved,link_approved_by,link_date_added)
 VALUES (9,'Test Link 1','http://www.link.com','Test Link Desc',6,1,1,'2001-06-24 20:00:29',1,'2001-06-24 00:00:00');
GO

 set IDENTITY_INSERT links OFF;

if exists (select * from sysobjects where id = object_id(N'messages') and OBJECTPROPERTY(id, N'IsUserTable') = 1) drop table messages
GO
 
CREATE TABLE messages (

  message_id int IDENTITY,
  primary key(message_id),
  message_parent_id int default NULL,
  Field3 int default NULL,
  topic varchar(255) default NULL,
  author varchar(255) default NULL,
  message text,
  date_entered datetime NOT NULL,
  last_reply_date datetime NOT NULL,
  child_count int default NULL
);
GO

set IDENTITY_INSERT messages ON;

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1,NULL,NULL,'Welcome to CodeCharge discussions!','Moderator','Welcome to CodeCharge discussions!  Please feel free to discuss any CodeCharge related questions here.','2001-01-22 07:57:09','2001-01-22 07:57:09',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (2,NULL,NULL,'Login Session Variables','JT','I am creating a Project Management website and would like to be able to use the UserID to filter records, what are the session variables created with the Login Form?  Thanks, JT','2001-01-30 06:26:23','2001-01-30 06:26:23',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (3,NULL,NULL,'CodeCharge generated PHP code on PHPTriad','Roger','Has anyone tried CC on PHPTriad sucessfully? I always get this error.  \"Fatal error: Cannot redeclare class db_sql in ./db_mysql.inc on line\"  Rgds','2001-01-30 09:48:00','2001-01-30 09:48:00',3);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (4,NULL,NULL,'bad code for dreamweaver','ubIKKls','Code which is generated by codecharge isn''t read properly in dreamweaver ultradev 4.0 ( for example i try it in namo webeditor 4.0 and everything was good). For example when i generate code for bookstore i see at dreamweaver just one columne not three as should be ( dreamweaver see some not properly tags too ( table and tr ).','2001-01-30 11:06:45','2001-01-30 11:06:45',4);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (5,NULL,NULL,'no fields and tables from database','Thorsten Schneider','Hi all  The problem is that i dont get any field from my database when i want to create a page nor can i choose the tables from the database. Properties tab tells me the connection to my DB is fine (no errors). Till now i tried to connect to the DB via Jet, MySQL. I even tried an Access database but got the same result...no fields or tables to choose from. When i tried the example databases (e.g. Ledger)i still got the same behaviour so it cant be a miscreated database. I changed between the different languages, PHP ASP JSP, i can use but to no avail. When i open the cc file from ledger for example i can see the fields and tables from the database but when i delete a field and then trie to reinsert it i cant choose the field again to add it (the field dropdown doesnt have any content). I am really at the end of my wisdom as it seems i am the only one with this problems (sifted through the newsgroups and egroups and the internet)....  My System: Client: Win2K Pro SP1 Server: win2K Server SP1, Apache, MySQL, PHP4, MyODBC  Any help would be greatly appreciated  Greetings  Thorsten Schneider','2001-01-30 12:16:26','2001-01-30 12:16:26',4);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (6,2,2,'Re: Login Session Variables','Ken Hardwick','JT,  The one session variable created on login is \"USERID\". This is from the table indicated on on the Property-Security page and from the field indicated as the \"Primary Key\". From the little testing I have done, I believe that this must be a numeric field.   Below is code I use in a ASP file to list current Session Variable and their values. Save the following as a ASP file and then run in a separate window. As you login using different userIDs, you can switch to this window and refresh to see the current values.  Hope this helps,  Ken Hardwick Norman,OK  <%@ Language=VBScript %> <%  on error resume next  for x = 0 to session.Contents.Count-1     Response.Write \"<nobr><pre><b>\"     Response.write session.Contents.key(x) & \" - </b>\"     Response.write session.Contents.item(x) &  \"</nobr><p><br>\"  next %> JT wrote:  >I am creating a Project Management website and would like to be able to use the UserID to filter records, what are the session variables created with >the Login Form? > >Thanks, >JT > >','2001-01-31 05:56:24','2001-01-31 05:56:24',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (7,NULL,NULL,'Installation Issues on Trial Edition','Mike Lee','Hi there,  I am very interested in trying out your program. It seems like it might be just the tool I need to do what I have to do to get my work done.  But, I can''t seem to get the installer to install it. When it gets to the point where the preinstall files have been installed, and it''s going to go into the InstallShield Wizard, it hangs and dies on me.  It mentions that it can''t start iKernal to get the install going. Is there a fix for this?  Thanks!  -Mike','2001-01-31 06:22:19','2001-01-31 06:22:19',3);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (8,3,3,'Re: CodeCharge generated PHP code on PHPTriad','Yehlu','CodeCharge use phplib for database function, the error message is you use phplib,s o you must remove the autoprepand file in you php.ini.Roger wrote:','2001-01-31 07:59:35','2001-01-31 07:59:35',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (9,7,7,'Re: Installation Issues on Trial Edition','Anonymous Coward','I had the same problem, but fixed it by doing the following (Windows 98 SE):  Delete the \"C:\\Program Files\\Common Files\\InstallShield\\Engine\" directory and exit every running program. Use CTRL+ALT+DEL to bring up the task manager and end every task except explorer and systray. Delete the \"C:\\Windows\\TEMP\\\" directory (or whatever %TEMP% is set to on your system).  Re-running the installer still failed _except_ when I ran it a third time it worked without a problem.  It''s actually a bug in installShield... ;P  -AC','2001-01-31 08:31:39','2001-01-31 08:31:39',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (10,3,3,'Re: Re: CodeCharge generated PHP code on PHPTriad','Roger','Hi Yehlu,  This line was found in the php.ini file. I tried removing \"prepend.php3\" and also puting ; to rem out the line but it still does not work.  auto_prepend_file = \"prepend.php3\"  Rgds','2001-01-31 08:33:25','2001-01-31 08:33:25',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (11,NULL,NULL,'how to add MySQL connection?','linker','how to add connection to exist. MySQL base?','2001-01-31 09:00:22','2001-01-31 09:00:22',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (12,11,11,'i''m sorry, problem is solved %) (-)','linker','subj','2001-01-31 09:04:50','2001-01-31 09:04:50',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (13,NULL,NULL,'Session Variables','Paul','How do I use the Session variable for a user that has logged in. For example, if I want a user to see only the data in a Grid that pertains to that usersID. I know this was covered before but I can''t seem to be able to get into the eGroups forum to look it up.  Thanks, -Paul','2001-01-31 13:22:31','2001-01-31 13:22:31',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (14,13,13,'Re: Session Variables','Paul','D''Oh! I see it in this forum. Nevermind!','2001-01-31 13:25:44','2001-01-31 13:25:44',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (15,7,7,'Re: Installation Issues on Trial Edition','Roger','I am on Win98SE & I had the same problem. What I did was delete all files in /temp & it re-install OK.  Rgds Roger','2001-01-31 19:03:14','2001-01-31 19:03:14',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (16,NULL,NULL,'Trial version problem: do all but generating html.','LamHoang','Hi there,  I just download CodeCharge Tril version. The interface looks great. But I have the following problem:  When I tried to generate web page from Generator menu, I see this error:   Site can''t be generated.  File:  Fiel pos:0  Line:   Line pos: 0  If I try to generate from Page menu (a grid file), I see this message:   Window title: IEBrowser1   Message: Runtime error ''403''. Class does not support Automation or does not suport expected interface. then CodeCharge crash!!!  Previously, I can connect to MySQL database properly, see all neccessary tables, fields etc through ODBC driver My system configuration:  - OS/Machine: Windows 98/96MBRAM/200MB free hdd.  - Databases/Web: MySQL for Win32, MyODBC for windows, Apache for Windows, PHP4 for Windows. All installed and tested propeerly with manual coded page.  CodeCharge trial in downloaded an installed properly under d:/program if it make sense.  Any body can help?  Thanks in advanced,  Lam Hoang (hoang-lam@fpt.vn)','2001-01-31 21:02:28','2001-01-31 21:02:28',5);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (17,NULL,NULL,'How to had MySQL connection ?','manu','What is the process to connect a mysql database on localhost ?','2001-02-01 00:28:45','2001-02-01 00:28:45',4);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (18,7,7,'Re: Installation Issues on Trial Edition','CodeCharge','There is a known issue with InstallShield, which causes problems if you have an older version of COM support programs (possibly installed by another program). The fix for Winndows 95/98 is available at http://www.microsoft.com/com/dcom/dcom98/dcom1_3.asp','2001-02-01 01:57:56','2001-02-01 01:57:56',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (19,16,16,'Re: Trial version problem: do all but generating h','CodeCharge','This issue is currently being resolved. Please wait for an update.','2001-02-01 02:12:54','2001-02-01 02:12:54',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (20,NULL,NULL,'429 ActiveX component can''t create object%','Maurizio','Staring the program (CodeCharge.exe) I get this error: 429 ActiveX component can''t create object%  Any idea. Thanks,Maurizio','2001-02-01 04:34:01','2001-02-01 04:34:01',3);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (21,16,16,'Re: Re: Trial version problem: do all but generati','oscar','I have the same problem, when will the update be available? Before the trial period ends?','2001-02-01 07:27:41','2001-02-01 07:27:41',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (22,20,20,'Re: 429 ActiveX component can''t create object%','Oleg Dudko','Download and install MDAC update from http://www.microsoft.com/data/download_260rtm.htm','2001-02-01 10:51:07','2001-02-01 10:51:07',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (23,16,16,'Re: Re: Trial version problem: do all but generati','update','plz inform about the update arrival. The programm really looks great so i want to use it, after seen it working..','2001-02-01 14:50:49','2001-02-01 14:50:49',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (24,NULL,NULL,'Quiz and Survey App','Dante S.','How do you go about designing such an app in cc?  A login/registration form first displays, if user has already taken the quiz then another form is displayed (read only) showing his/her score and answers?  What kind of cc page can achieve this?  Questions in the quiz/survey is of the multiple-choice, yes-no, fill-in-the-blanks type.  The survey form/page is separate (as in different files) from the quiz form/page.  I already setup the ms access db for this.  Thanks, Dante','2001-02-01 17:35:20','2001-02-01 17:35:20',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (25,24,24,'Re: Quiz and Survey App - addendum','Dante S.','A login/registration form first displays, if user has already taken the quiz then another form is displayed (read only) showing his/her score and answers, if not what he/she enters will trigger a new examinee and wil be presented with the questions.','2001-02-01 17:50:35','2001-02-01 17:50:35',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (26,20,20,'Re: Re: 429 ActiveX component can''t create object%','Rick Mombassa','.. or use a shorter directory names like CodeChrg instead of CodeCharge','2001-02-01 21:53:33','2001-02-01 21:53:33',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (27,20,20,'Re: Re: 429 ActiveX component can''t create object%','Maurizio','The problem persist.  Regards, Maurizio','2001-02-02 03:03:17','2001-02-02 03:03:17',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (28,NULL,NULL,'Microsoft Jet Database Engine error with example F','rmcbride@prodigy.net','Installed the trial version.  Cannot get the Forum example to run.  Get the following error.  Any ideas how to fix?   HTTP 500.100 - Internal Server Error - ASP error Internet Information Services  --------------------------------------------------------------------------------  Technical Information (for support personnel) Error Type: Microsoft JET Database Engine (0x80004005) Unspecified error /forum/Common.asp, line 30   Browser Type: Mozilla/4.0 (compatible; MSIE 5.5; Windows NT 5.0)   Page: GET /forum/index.asp','2001-02-02 03:53:28','2001-02-02 03:53:28',4);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (29,5,5,'Re: no fields and tables from database','amit','Could you pls tell me how did you connect to mysql database i have apache installed with mysql and php for windows just tried to download this software but cannot connect tothe database what drivers are to be specified in database tab pls help meThorsten Schneider wrote:  >Hi all > >The problem is that i dont get any field from my database when i want to create a page nor can i choose the tables from the database. Properties tab tells me the connection to my DB is fine (no errors). Till now i tried to connect to the DB via Jet, MySQL. I even tried an Access database but got the same result...no fields or tables to choose from. When i tried the example databases (e.g. Ledger)i still got the same behaviour so it cant be a miscreated database. I changed between the different languages, PHP ASP JSP, i can use but to no avail. >When i open the cc file from ledger for example i can see the fields and tables from the database but when i delete a field and then trie to reinsert it i cant choose the field again to add it (the field dropdown doesnt have any content). I am really at the end of my wisdom as it seems i am the only one with this problems (sifted through the newsgroups and egroups and the internet).... > >My System: >Client: Win2K Pro SP1 >Server: win2K Server SP1, Apache, MySQL, PHP4, MyODBC > >Any help would be greatly appreciated > >Greetings > >Thorsten Schneider > >','2001-02-02 04:36:08','2001-02-02 04:36:08',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (30,NULL,NULL,'connection','peter alex','codecharge doesnt show me all the databases running on mysql on my win2k-machine, but it shows me some i dont know also codecharge doesnt connect to mysql on a separate linux-machine...  please help','2001-02-02 04:38:42','2001-02-02 04:38:42',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (31,NULL,NULL,'Results from List Box to database','Ken H','On a form with a list box, when I update my record the database field is updated with the index number from list box instead of the actual \"text\" string as seen in the list box.  Any suggestions as to how to get the \"text\" from the list box instead of the index of the selected item ?  TIA,  Ken Hardwick Norman,Ok','2001-02-02 04:59:38','2001-02-02 04:59:38',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (32,5,5,'Re: Re: no fields and tables from database','Tony','I have the same problem i made a local installation with php and mysql and i can''t connect....','2001-02-02 06:49:34','2001-02-02 06:49:34',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (33,30,30,'Re: connection','CodeCharge Support','Have you installed myODBC driver on your win2k machine ? Please make sure you have correctly set up your mysql ODBC datasource , mysql machine  name ,login , password . Also you must point CodeCharge to this ODBC datasource (Site/Properties/DataBase).','2001-02-02 08:57:11','2001-02-02 08:57:11',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (34,17,17,'Re: How to had MySQL connection ?','CodeCharge Support','You will need to use MyODBC driver: http://www.mysql.com/downloads/api-myodbc.html You will need to create ODBC datasource for  your mysql database. In CodeCharge , Site/Properties/Database you will need to fill in correct database parameters : DB connection, login,password .','2001-02-02 09:40:41','2001-02-02 09:40:41',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (35,28,28,'Re: Microsoft Jet Database Engine error with examp','CodeCharge support','May be you haven''t specified Login and Password  (or specified incorrect ones) in tab  Site/Properties/Database ? Also please check if the connection string is correct.','2001-02-02 09:45:35','2001-02-02 09:45:35',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (36,5,5,'Re: no fields and tables from database','Andrew Streckfuss','I have almost the same problem. I am connecting to SQL Server and I can test the connection! When it comes to the page creation I do not see any fields!!  Please advise!  Andrew Streckfuss  P.S.  I think that this is a really cool product!!','2001-02-02 10:29:52','2001-02-02 10:29:52',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (37,NULL,NULL,'PHP 3 and ColdFusion 4.0 Announcement','Oleg Dudko','Dear CodeCharge users,   Thank you for recently downloading the Trial version of CodeCharge.  We are excited to announce the initial, Beta availability of PHP 3 support for PHP 3.0.9 and higher.  Download:  PHP 3.0 (162K) <a href=\"http://www.codecharge.com/download/files/patterns/PHP%203.0.ccp\"> http://www.codecharge.com/download/files/patterns/PHP%203.0.ccp</a>  PHP 3.0 with Templates (145K)  <a href=\"http://www.codecharge.com/download/files/patterns/PHP%203.0%20&%20Templates.ccp\">http://www.codecharge.com/download/files/patterns/PHP%203.0%20&%20Templates.ccp </a>  ColdFusion 4.0 (96K)  <a href=\"http://www.codecharge.com/download/files/patterns/ColdFusion%204.0.ccp\"> http://www.codecharge.com/download/files/patterns/ColdFusion%204.0.ccp</a>  These files need to be placed in \"CodeCharge\\Patterns\" directory on your system (for example C:\\Program Files\\CodeCharge\\Patterns)  Sincerely,  CodeCharge Team','2001-02-02 11:36:44','2001-02-02 11:36:44',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (38,NULL,NULL,'How can I include LH Margins in my header page?','Richard Madison','I am trying to create a header page which will actual be the header and the left hand margin (which is common on all of my pages).   I tried to create a table for the whole page on the header page and not close the table (moving the </TD></TR></TD> to the footer page...) CodeCharge is too smart and closed the missing table code on my header page which leaves my content pages below the header and left hand margin.  Can I do this?','2001-02-02 13:37:03','2001-02-02 13:37:03',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (39,5,5,'I finally found the solution :o) *read on*','Thorsten Schneider','The whole problem was that i dont have a c:\\ drive on my computer. I just installed an old harddisk specified it as c:\\ in win2k disk administrator.  Then i created a tmp folder on c:\\ and fired up  CodeCharge....Viola, the connection to the database was working like a dream :). Well I almost threw my PC out the window until i found the solution after 4 days of troubleshooting and searching. It would be great if CC could fix this problem or at least  place a remark in the readme or help files as i think i am not the only one without a c:\\ drive (on numerous times it saved me from some viruses or trojans that want to install automatically on c:\\ and i dont have a c:\\)  I hope for the others in this thread that this is the solution to their problems too :)   Greetings  Thorsten Schneider','2001-02-03 03:34:28','2001-02-03 03:34:28',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (40,31,31,'Re: Results from List Box to database','CC Support','To me this sounds reasonable. You have a  dictionary of name-id pairs , and your web application changes appropriate id''s -  and later you may be able to know what text is in some field by it''s ID. So it''s ok what you said.  It''s relational DB principle. If you mean  something else please give more detailed example. Or try to go to List Box properties and set \"Primary Key\" and \"Showing\" to the same text field  Regards, CC Support.','2001-02-03 04:21:30','2001-02-03 04:21:30',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (41,38,38,'Re: How can I include LH Margins in my header page','CodeCharge Support','You need to close your table on Footer page.','2001-02-03 05:49:33','2001-02-03 05:49:33',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (42,NULL,NULL,'Cancel,Update Redirect to main form','rmcbride@prodigy.net','HTTP Error 500-12 Application Restarting Internet Information Services  -------------------------------------------------------------------------------- Whenever I click on the Insert, Update, Cancel buttons on a record entry form I get the above error when the response.redirect sends me back to the grid form.  The update, delete, insert works before getting the error.  Need to be able to return to the main form without this error.  Any ideas?  Thanks,','2001-02-03 06:46:06','2001-02-03 06:46:06',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (43,42,42,'Re: Cancel,Update Redirect to main form','rmcbride','Never mind.  Turnd out that the error was caused by McAffe Netshield Anti-virus running. When I disabled the NetShield the problem cleared.','2001-02-03 10:12:56','2001-02-03 10:12:56',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (44,NULL,NULL,'Curious - Was cc used in www.codecharge.com','shawn','I am just curious to know if you folks used cc to create your own website? If yes, then sure it is a great product. If not, what were the reasons? Thanks','2001-02-03 15:18:39','2001-02-03 15:18:39',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (45,NULL,NULL,'display images with online catalog database...','ITJohn','Hi,   I''m trying to build an online catalog with php and mysql using codecharge,can anyone help me how to display images for each product with my products database?  any help greatly appreciated  ITJohn','2001-02-04 04:06:31','2001-02-04 04:06:31',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (46,45,45,'Re: display images with online catalog database...','CodeCharge support','Hi , first I must say that it''s considered a good web programming  practise to store images not in a database but in a file system. And you will  store only their location paths in this DB. Then you code will dolike this. 1) You run sql statement smth like  \"select image_location from products where id=\".id 2) If needed, you convert this absolute path into relative path, as it''s seen in outside world, for example /users/you/car.gif to \"/you/car.gif\"  (for html page) Now you will only need to insert code that replaces template variable in your html template with location of your picture. For instance , you have html  template  <html> Products: <!--Beginproducts--> Name: {name} <img src={imagelocation}> <!--Endproducts--> </html>  You code will looks like this  $tpl->set_var(\"imagelocation\", \"you/car.gif\");  $tpl->parse(\"products\", false);','2001-02-04 04:10:52','2001-02-04 04:10:52',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (47,44,44,'Re: Curious - Was cc used in www.codecharge.com','CodeCharge','Of course! This site was is done with CodeCharge! It''s a great product! Thanks','2001-02-04 04:26:40','2001-02-04 04:26:40',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (48,NULL,NULL,'PHP Code quality is xecellent','evan@isoftware.com','Excellent PHP code quality for a code generator....  What does everyone else think?  Love it!!!','2001-02-04 18:07:22','2001-02-04 18:07:22',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (49,NULL,NULL,'Tutorials, help update, when?','Dante S.','Just asking when will the step-by-step comprehensive tutorials (esp. ones that shows customization) be posted.  How about the update to the help file?','2001-02-05 08:37:05','2001-02-05 08:37:05',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (50,48,48,'Re: PHP Code quality is xecellent','Joachim Uersfeld','ASP-Code, Template-Code and Support also. A very good software. Gratulation!','2001-02-05 10:08:10','2001-02-05 10:08:10',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (51,3,3,'Re: CodeCharge generated PHP code on PHPTriad','Wandrer','In the include directory of phptriad, there already is a db_mysql.inc file that declares the db_sql function. Either remove the included db_sql file or edit it and change the function to something like default_db_sql and then the CC code will work.','2001-02-05 10:11:15','2001-02-05 10:11:15',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (52,NULL,NULL,'Menu''s External cc link without db','Bob Stageman','Very interesting product.  I don''t see how to generate a menu with links to external app pages unless I read them in from a database.  I have a page that is part of my site but was not done in cc how do I make that a menu link?','2001-02-05 12:25:55','2001-02-05 12:25:55',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (53,NULL,NULL,'JSP Troubles and Problems','Juanito Pepas','Please put your problems and troubles about jsp or jsp with wml on here!!','2001-02-05 14:10:12','2001-02-05 14:10:12',5);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (54,NULL,NULL,'sql names with spaces','js','how do i get around sql7 field names that have spaces.  for example:  ''selection key'' or ''selection value''.  the drop down list don''t allow me to add braces and i don''t control the field naming conventions.  when the asp is generated it gets confused so that:   sSQL = \"select EVENT.AGENT_NO as EVENT_AGENT_NO, \" & _     \"EVENT.EVENT_NO as EVENT_EVENT_NO, \" & _     \"tblAgent.agent_no as tblAgent_agent_no, \" & _     \"tblAgent.last_name as tblAgent_last_name, \" & _     \"ORD2KEYSTMPL.EVENT as ORD2KEYSTMPL_EVENT, \" & _     \"ORD2KEYSTMPL.[Selection Key] as ORD2KEYSTMPL_Selection_Key\" & _     \" from EVENT, tblAgent, ORD2KEYSTMPL\" & _     \" where tblAgent.agent_no=EVENT.AGENT_NO and   ORD2KEYSTMPL.EVENT=EVENT.EVENT_NO  \" & sWhere  & sOrder  generates as:   sSQL = \"select EVENT.AGENT_NO as EVENT_AGENT_NO, \" & _     \"EVENT.EVENT_NO as EVENT_EVENT_NO, \" & _     \"tblAgent.agent_no as tblAgent_agent_no, \" & _     \"tblAgent.last_name as tblAgent_last_name, \" & _     \"ORD2KEYSTMPL.EVENT as ORD2KEYSTMPL_EVENT, \" & _     \"ORD2KEYSTMPL.Selection Key as ORD2KEYSTMPL_Selection Key \" & _     \" from EVENT, tblAgent, ORD2KEYSTMPL\" & _     \" where tblAgent.agent_no=EVENT.AGENT_NO and ORD2KEYSTMPL.EVENT=EVENT.  \" & sWhere  & sOrder','2001-02-05 14:11:23','2001-02-05 14:11:23',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (55,52,52,'Re: Menu''s External cc link without db','Joachim Uersfeld','You can include a html-file in the header, just like <!--#INCLUDE FILE=\"myMenu.htm\"-->','2001-02-05 14:17:24','2001-02-05 14:17:24',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (56,53,53,'I have problems with jsp','David Cast','I+ve use Jrun 3.0 Enterprise Edition and The Examples when I try to view the default page  I get the next message:  javax.servlet.ServletException: Compilation error occured:   Found 11 errors in JSP file: C:\\\\Archivos de programa\\\\Allaire\\\\JRun\\\\servers\\\\default\\\\demo-app\\\\portal\\\\Default.jsp:74: Error: The method \"java.io.PrintWriter getWriter();\" can throw the checked exception \"java/io/IOException\", but its invocation is neither enclosed in a try statement that can catch that exception nor in the body of a method or constructor that \"throws\" that exception. C:\\\\Archivos de programa\\\\Allaire\\\\JRun\\\\servers\\\\default\\\\demo-app\\\\portal\\\\Default.jsp:75: Error: This catch block may be unreachable because there is no exception whose type is assignable to \"IOException\" that can be thrown during execution of the body of the try block. C:\\\\Archivos de programa\\\\Allaire\\\\JRun\\\\servers\\\\default\\\\demo-app\\\\portal\\\\Default.jsp:75: Error: Type IOException was not found. C:\\\\Archivos de programa\\\\Allaire\\\\JRun\\\\servers\\\\default\\\\demo-app\\\\portal\\\\Default.jsp:218: Error: The method \"java.io.PrintWriter getWriter();\" can throw the checked exception \"java/io/IOException\", but its invocation is neither enclosed in a try statement that can catch that exception nor in the body of a method or constructor that \"throws\" that exception. C:\\\\Archivos de programa\\\\Allaire\\\\JRun\\\\servers\\\\default\\\\demo-app\\\\portal\\\\Default.jsp:219: Error: This catch block may be unreachable because there is no exception whose type is assignable to \"IOException\" that can be thrown during execution of the body of the try block. C:\\\\Archivos de programa\\\\Allaire\\\\JRun\\\\servers\\\\default\\\\demo-app\\\\portal\\\\Default.jsp:267: Error: The method \"java.io.PrintWriter getWriter();\" can throw the checked exception \"java/io/IOException\", but its invocation is neither enclosed in a try statement that can catch that exception nor in the body of a method or constructor that \"throws\" that exception. C:\\\\Archivos de programa\\\\Allaire\\\\JRun\\\\servers\\\\default\\\\demo-app\\\\portal\\\\Default.jsp:268: Error: This catch block may be unreachable because there is no exception whose type is assignable to \"IOException\" that can be thrown during execution of the body of the try block. C:\\\\Archivos de programa\\\\Allaire\\\\JRun\\\\servers\\\\default\\\\demo-app\\\\portal\\\\Default.jsp:402: Error: The method \"java.io.PrintWriter getWriter();\" can throw the checked exception \"java/io/IOException\", but its invocation is neither enclosed in a try statement that can catch that exception nor in the body of a method or constructor that \"throws\" that exception. C:\\\\Archivos de programa\\\\Allaire\\\\JRun\\\\servers\\\\default\\\\demo-app\\\\portal\\\\Default.jsp:403: Error: This catch block may be unreachable because there is no exception whose type is assignable to \"IOException\" that can be thrown during execution of the body of the try block. C:\\\\Archivos de programa\\\\Allaire\\\\JRun\\\\servers\\\\default\\\\demo-app\\\\portal\\\\Default.jsp:509: Error: The method \"java.io.PrintWriter getWriter();\" can throw the checked exception \"java/io/IOException\", but its invocation is neither enclosed in a try statement that can catch that exception nor in the body of a method or constructor that \"throws\" that exception. C:\\\\Archivos de programa\\\\Allaire\\\\JRun\\\\servers\\\\default\\\\demo-app\\\\portal\\\\Default.jsp:510: Error: This catch block may be unreachable because there is no exception whose type is assignable to \"IOException\" that can be thrown during execution of the body of the try block.  what ist thats?!!  please help','2001-02-05 14:17:20','2001-02-05 14:17:20',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (57,54,54,'Re: sql names with spaces','Joachim Uersfeld','The best solution from a database-developer: Build your fieldname without spaces.','2001-02-05 14:23:49','2001-02-05 14:23:49',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (58,NULL,NULL,'PDF Documentation --- No Page Numbers :-(','Paul','I downloaded the PDF documentation and printed it out (I hate trying to read and learn something off the computer screen).  After I printed it out I found there are no page numbers on these pages!   If you don''t have the time to do it I''ll be happy to do it for you and then re-create your PDF and return it to you. Page numbers are essential for any document of any length.   Thank you;  Paul','2001-02-05 15:07:47','2001-02-05 15:07:47',3);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (59,52,52,'Re: Menu''s External cc link without db','CodeCharge Support','Or you can even take CodeChrage generated html and insert you menu html-javscript code right  inside it !','2001-02-06 02:21:32','2001-02-06 02:21:32',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (60,53,53,'Re: I have problems with jsp','CC support','Please tell me what JSp version in CodeCharge you are using ? JSP 1.1 or JSP 1.1 with templates ?','2001-02-06 02:27:12','2001-02-06 02:27:12',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (61,53,53,'Re: I have problems with jsp','CodeCharge Support','Let''s make sure it''s not a problem of JRun ,  please access this portal from another JSP enabled web server - for instance - jswdk , and  by all means tell me the results.  Do you use html templates with this JSP ?','2001-02-06 03:02:11','2001-02-06 03:02:11',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (62,NULL,NULL,'Missing ASP 3.0 from demo','mark.homoky@boulevard-consultancy.com','Hi,  Am I the only person that when trying the tutorials finds that ASP 3.0 is not supported in the demo?  In addition to the other problems that have been reported here, and the confusion over the time length of the demo (in the program it says 20 days, on the website it says 30 days) has anyone actually purchased the full version yet?','2001-02-06 06:32:19','2001-02-06 06:32:19',3);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (63,NULL,NULL,'NT Install botched?','BradleyMiller','I''m still struggling to get CodeCharge to run at all on a variety of machines, from Win NT 4.0 to Win200 to Win98 even.   So far I''ve got the big goose egg on generated code.  I''m up to package 5 I think on patches????   If anyone can lend assistance, I''d greatly appreciate it.    -- Bradley Miller (bradmiller@dslonramp.com)','2001-02-06 07:10:43','2001-02-06 07:10:43',5);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (64,54,54,'Re: Re: sql names with spaces','js','like i said i don''t control the naming conventions.  sql works with spaces in names and therefore codecharge should also support it tob compatible.  don''t you think?','2001-02-06 07:11:53','2001-02-06 07:11:53',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (65,62,62,'Re: Missing ASP 3.0 from demo','Joachim Uersfeld','I am shure, more than one. I have purchased a licence und build within 12 hours a complete database with 21 tables for a heldesk and with cc the html-templates and asp-codes.  Normally this a work for a week. CC works very well!','2001-02-06 09:00:28','2001-02-06 09:00:28',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (66,63,63,'Re: NT Install botched?','Joachim Uersfeld','I have install it on a Win2000 Workstation without problems. Check the system requirements.','2001-02-06 09:05:41','2001-02-06 09:05:41',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (67,63,63,'Re: NT Install botched?','Paul','Sorry to hear of your problems Bradley.   I''ve currently got it installed on Win98 and 2000 professional and haven''t found any problems with  creating the demo apps.  I''ve not tried any of my own creation yet.  Paul','2001-02-06 09:19:06','2001-02-06 09:19:06',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (68,NULL,NULL,'Data Types','Paul','I''ve noticed that the only data types that CodeCharge uses are ''date'', ''text'', and ''numeric''.  So how do I do logical fields?   Paul','2001-02-06 09:32:54','2001-02-06 09:32:54',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (69,63,63,'Re: NT Install botched?','Joachim Uersfeld','There are different Internetexplorer 5.0 Versions, try a update to 5.5.','2001-02-06 14:06:22','2001-02-06 14:06:22',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (70,63,63,'Re: NT Install botched?','BradleyMiller','Hmm -- I installed IE 5.5 and it works now.   I think the system requirements only mention 5.0!     -- Bradley Miller','2001-02-06 15:53:01','2001-02-06 15:53:01',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (71,63,63,'Re: Re: NT Install botched?','Paul','If memory servers installing IE 5.5 updates the MDAC.  I wonder if that could have something to do with it.  Paul','2001-02-06 16:01:43','2001-02-06 16:01:43',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (72,NULL,NULL,'how can i modify html code ?','Fabricio (fabricio@owb.com.br)','I need to modify de html code. But if i need change something in the codecharge, i generate de code and i lost my modification on html code. How can i modify without lost my changes ???','2001-02-06 17:52:50','2001-02-06 17:52:50',3);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (73,NULL,NULL,'PHP Code -- problem?','BradleyMiller','WOW!  This stuff is cool when it works!   I did get this however when running it in PHP 3.0 --  \"Fatal error: Call to unsupported or undefined function preg_match() in ./common.php3 on line 53\"  Any suggestions?  -- Bradley Miller','2001-02-06 20:28:25','2001-02-06 20:28:25',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (74,73,73,'Re: PHP Code -- problem?','BradleyMiller','Ok -- narrowed it down . . PHP4 has an \"is_numeric\" function.   This is what''s being defined in the common.php3 file:  function is_numeric($variable) {   if(preg_match(\"/(-?\\d\\d*\\.\\d*$)|(-?\\d\\d*$)|(-?\\.\\d\\d*$)/\", $variable))     return true;   else     return false; }   So, the preg_match is throwing the problem . . . so I looked up preg_match and it shows it''s from here: (PHP 3>= 3.0.9, PHP 4 )  My server is on 3.07 . . . . stupid RAQ2 . . .','2001-02-06 20:40:02','2001-02-06 20:40:02',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (75,58,58,'Re: PDF Documentation --- No Page Numbers :-(','CodeCharge support','We''ve added page numbers to the documentation.','2001-02-07 01:09:39','2001-02-07 01:09:39',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (76,72,72,'Re: how can i modify html code ?','CodeChrge Support','You will need to go to Tools/Options menu and check \"Lock edited files\" checkbox. This solves the whole issue.','2001-02-07 01:21:44','2001-02-07 01:21:44',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (77,72,72,'Re: how can i modify html code ?','Joachim Uersfeld','I use more styles than CC supports. I do this  with the style-tag in the Header of a Form. Here  and in Footer you can add html-code to change  the design of the cc-generated forms and you don''t lost your changes when you modified your  code.','2001-02-07 01:18:55','2001-02-07 01:18:55',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (78,16,16,'Re: Re: Trial version problem: do all but generati','Sylvain','CodeCharge wrote:  >This issue is currently being resolved. >Please wait for an update.  I downloaded the trial yesterday (02-06-2001) and experience the same problem. Is there a update already or am I doing something wrong?  Thanks in advance for your reply.','2001-02-07 02:50:07','2001-02-07 02:50:07',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (79,58,58,'Re: Re: PDF Documentation --- No Page Numbers :-(','Paul','Thank you :-)','2001-02-07 03:11:47','2001-02-07 03:11:47',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (80,NULL,NULL,'Flexibility on forms ?','BradleyMiller','How can you specify the length of a form field?  I want to be able to accept xx characters but when it displays I only want xx characters to display.  For instance, one particular form I just pulled up uses varchar fields of 255 characters in length.  It also uses a text field of 65K characters in length.  When it builds the form it makes this form go WAY across the screen.   This input box on this message area is a good example -- it could use a  wrap=\"hard\" to make the things appear on the next line instead of trailing on and on (using Netscape).   I can modify the code, but it would be handy to have a little control over the fields right from the pages window.  Bradley Miller  bradmiller@accesszone.com AccessZone Design -- http://www.accesszonedesign.com','2001-02-07 05:53:37','2001-02-07 05:53:37',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (81,28,28,'Re: Re: Microsoft Jet Database Engine error with e','Diestelhorst','Microsoft JET Database Engine error ''80004005''   Could not find installable ISAM.   /forum/Common.asp, line 30  I get this error. How can I resolve this?','2001-02-07 07:25:17','2001-02-07 07:25:17',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (82,72,72,'Re: Re: how can i modify html code ?','Fabricio','Thank you for your help !!!','2001-02-07 08:01:00','2001-02-07 08:01:00',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (83,16,16,'Re: Re: Trial version problem: do all but generati','Martin','Same problem. Is the upgrade available now?','2001-02-07 08:07:15','2001-02-07 08:07:15',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (84,58,58,'Re: PDF Documentation --- No Page Numbers :-(','Stephen','Where did you get the pdf files? I can''t find a link to them','2001-02-07 08:10:36','2001-02-07 08:10:36',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (85,80,80,'Re: Flexibility on forms ?','CodeCharge Support','Form fields have \"Size\" properties. You only need to specify yours.','2001-02-07 09:02:01','2001-02-07 09:02:01',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (86,NULL,NULL,'Error on Field Attribute ????','albert@netk.co.za','What does this mean ?  I get this when I generate my pages . . .           Field: A/C Type             Attribute:  - Name can contain only A..Z, a..z, 0..9 and _.','2001-02-07 09:36:52','2001-02-07 09:36:52',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (87,62,62,'Re: Missing ASP 3.0 from demo','Ruslee','I had a problem when trying out the trial version.  It crashes and has the message run time error 94  when trying to generate codes.','2001-02-07 09:50:51','2001-02-07 09:50:51',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (88,NULL,NULL,'Trial version crashes','Ruslee','I have dloaded the trial version on win 98SE. Installation was OK but when trying the examples to generate code it read a message : Null Void Run Time Error 94 and crashed. Can anyone advise on this. I wish to purchase the license but I have got to confirm that it has no bugs in the license one.','2001-02-07 09:53:40','2001-02-07 09:53:40',5);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (89,88,88,'Re: Trial version crashes','Joachim Uersfeld','CC workes on my system very well. I recommend to install Internetexplorer 5.5.','2001-02-07 11:14:46','2001-02-07 11:14:46',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (90,86,86,'Re: Error on Field Attribute ????','Joachim Uersfeld','Delete the wrong characters (like ''-'', ''-'' ...)  from the fieldname.','2001-02-07 11:18:36','2001-02-07 11:18:36',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (91,NULL,NULL,'VBScript Error on Chili!Soft ASP','markus','Does anyone know why?  Microsoft VBScript runtime error ''800a01c1''  Argument not optional: ''rs.open'' Common.asp  Love the product, would buy it if ASP code worked on Chili!Soft  thanks','2001-02-07 11:26:55','2001-02-07 11:26:55',8);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (92,NULL,NULL,'How can i Downloads Executables using CodeCharge ?','Fabricio (fabricio@owb.com.br)','I need to show some executables im my browser to download and a don+t know how I do that ?   Have anybody to help me ?  Thanks !  Fabricio','2001-02-07 11:24:00','2001-02-07 11:24:00',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (93,NULL,NULL,'file upload','Sebastian','How can i upload files with the help of codecharge ?   I want to generate a PHP/MySQL Katalog System, the Administrator of this Katalog should be able to upload the images for this katalog from a normal html formular (i know its php :-) )  I know there are such things on PHP.Net, but it would be great when anyone can explain or can give me tips how i can make this with CodeCharge.  The Image File shoul be uploaded to the server and the Filename should be parsed to the MySQL Database for ...','2001-02-07 11:30:58','2001-02-07 11:30:58',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (94,91,91,'Re: VBScript Error on Chili!Soft ASP','Joachim Uersfeld','Check the connection-settings to the database.','2001-02-07 11:39:48','2001-02-07 11:39:48',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (95,92,92,'Re: How can i Downloads Executables using CodeChar','Sebastian','you can go to the Event Tab and put some formulas under Show in, like this:  $fldlink=\"<a href=''$fldfilename''>$fldname</a>\"  this is meant for PHP, in your DB Table should be fields for:  \"filename\" (the filename of your exe or whatever) \"name\"      (the linkname or description)  \"link must not be in your table, but there should be a row with this as the name (not connected with a field and/or tabel)  i hope i can help you, my english is not so good :-)','2001-02-07 11:36:10','2001-02-07 11:36:10',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (96,92,92,'Re: Re: How can i Downloads Executables using Code','Sebastian Pfohl','sorry for the above, here is the formula again ...  <pre> $fldlink=\"<a href=''$fldfilename''>$fldname</a> </pre>','2001-02-07 11:44:23','2001-02-07 11:44:23',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (97,91,91,'Re: Re: VBScript Error on Chili!Soft ASP','markus','Connection looks okay to me','2001-02-07 21:26:41','2001-02-07 21:26:41',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (98,NULL,NULL,'Site can''t be generate','Basing','I try every example to generate to ASP but can''t. What''s wrong ?','2001-02-07 23:03:00','2001-02-07 23:03:00',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (99,NULL,NULL,'Access Connection','Phantom','Firstly, I must congratulate on a fine product. It is simple to use and powerful, but it can also get difficult on the connection side.  I am getting now where in connecting either a Access or SQL database... I consistanly get errors and yet have any luck in getting the connection. I have tried everything.. on the program. But nothing works!!!  The Test sees the connection with no problems. I am sure everthing is setup fine, as I am running another base okay.  Using Windows 2000. With Access 2000 and SQL 7.0  Your help is much appreicated.','2001-02-08 01:37:25','2001-02-08 01:37:25',5);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (100,99,99,'Re: Access Connection','Phantom','Also in regards to the above. I am using ASP.  I have tried with and without templates, they both result with different errors.','2001-02-08 01:47:04','2001-02-08 01:47:04',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (101,NULL,NULL,'Multiple Tables','Martin','Is it possible to include more than one table on a single form.','2001-02-08 03:59:47','2001-02-08 03:59:47',4);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (102,101,101,'Re: Multiple Tables','bat','is it Martin from Sweden ??? by the way yes you can','2001-02-08 04:19:36','2001-02-08 04:19:36',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (103,101,101,'Re: Multiple Tables','CodeCharge Support','Yes , you can do it a few ways.  1) - Specify an SQL statement into SQL section of Form Properties 2) - Use a View or Query instead of the Table (for example CC allows you to use MS Access query) 3) - Specify 2nd table in \"Join\" section of Field Properties','2001-02-08 05:36:12','2001-02-08 05:36:12',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (104,NULL,NULL,'Cold Fusion problems','BradleyMiller','Two things so far:  1) On the RegForm example, it complains about a User_ID when you go to the registration form.  In the common.cfm file it has this:  <CFPARAM NAME=\"Session.UserID\" DEFAULT=\"\">  So I added this, and it works now.  <CFPARAM NAME=\"Session.User_ID\" DEFAULT=\"\">  2)  None of the forms I''ve played with so far insert data in for Cold Fusion sites.   I have my debug info turned on and I can''t see any insert statements being executed.   Is this an error ?  Thanks!','2001-02-08 05:47:38','2001-02-08 05:47:38',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (105,98,98,'Re: Site can''t be generate','CodeCharge Support','Please run CodeCharge pack available at http://www.codecharge.com/download/files/CodeChargePack7.exe','2001-02-08 05:38:46','2001-02-08 05:38:46',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (106,91,91,'Re: VBScript Error on Chili!Soft ASP','Code','Does Chili!Soft ASP interpretator accept standard ASP code ? Because code generated by CC is  error-proof. IS there different ASP model for Chili-asp  ?','2001-02-08 07:33:59','2001-02-08 07:33:59',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (107,NULL,NULL,'PHP 4 and Apach module problem','christophe','Hi,  Each time I try to load a page I get an error from apache which is not logged. I am running windows 2000 and SQL server 7.0. I have loaded the PHP modules for Apache. Any idea ? Thanks  Christophe','2001-02-08 11:07:02','2001-02-08 11:07:02',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (108,NULL,NULL,'Not seeing expected results in table','relgeits','I can not access my oracle tables using CC, but I was able to link them through Microsoft Access and then access them in CC.  My problem is that once I access my pages I do not see any results.  I turn debug on and I get a list of variable names and values.  The table does generate, but when I look at the HTMl source code it shows <td > <font >&nbsp;</font></td>. Any Idea why the variable value does not show up here?  I am generating PHP code on Unix with an Apache web server.','2001-02-08 12:37:37','2001-02-08 12:37:37',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (109,91,91,'Re: Re: VBScript Error on Chili!Soft ASP','markus','Macromedia Ultradev generated ASP code runs on Chili!Soft without any problems.   I assume that is using standard ASP 2.0 code.','2001-02-08 23:33:16','2001-02-08 23:33:16',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (110,107,107,'Re: PHP 4 and Apach module problem','CodeCharge Support','Is this only with CC files ?  Please try run some test php script  <? echo \"hello world\"; ?> what are the results ?','2001-02-09 02:40:42','2001-02-09 02:40:42',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (111,108,108,'Re: Not seeing expected results in table','CodeCharge Support','Have you specified server side connection string in Site/Properties/Database tab? And Login/Password ?','2001-02-09 02:42:53','2001-02-09 02:42:53',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (112,101,101,'Re: Re: Multiple Tables','Martin','Sorry I maybe did not express myself correctly  I want to view data from a single table. Using drop down list I wnat to see data from another table.   I also want to edit the data using the list box to provide the Foreign Key field for the Insert statement  And I am not from Sweden.','2001-02-09 04:39:02','2001-02-09 04:39:02',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (113,99,99,'Re: Re: Access Connection','Joachim Uersfeld','CC works very well with Access, MS SQL 7/2000 and ASP (with templates) for me. Maybe there is a problem with the Ado-Connection. I recommend to install Internet Explorer 5.5 (ADO is included).','2001-02-09 05:56:20','2001-02-09 05:56:20',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (114,108,108,'Re: Re: Not seeing expected results in table','relgeits','Yes, I have.  I can turn debug on and get the  results, but when the table is generated the  results do not show up in the table.','2001-02-09 08:46:04','2001-02-09 08:46:04',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (115,99,99,'Re: Re: Access Connection','CodeCharge Support','Please specify what errors you have. Also check if you have set up correct database  connection in Site/Properties/Database tab.','2001-02-09 08:46:38','2001-02-09 08:46:38',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (116,68,68,'Re: Data Types','CodeChrge','CC works with all data types. Simply boolean type is not appropriate for some tasks.','2001-02-09 09:11:47','2001-02-09 09:11:47',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (117,NULL,NULL,'vpf','Bob Lee','Does CC handle data in .dbf  or Visual Fox Pro Data. ?','2001-02-09 12:32:29','2001-02-09 12:32:29',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (118,NULL,NULL,'error','Christian SKARNIAK','Hello,  I''ve got a problem when i trie to generate a form with a trial version. Message (in french) : Erreur d''execution 430                                 La classe ne g?re pas automation ou l''interface attendu ...  What can I do. I''m sorry but, If i can''t resolve my problem, i won''t buy this sofware','2001-02-09 14:05:54','2001-02-09 14:05:54',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (119,117,117,'Re: vpf','Joachim Uersfeld','Try to connect with the ODBC-driver. I think, It must be possible.','2001-02-09 20:11:29','2001-02-09 20:11:29',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (120,NULL,NULL,'Error in database field for Bookstore','Leo','I just installed the fields and the bookstore template.  Everything seems to be working fine except I get one error that I cannot figure out.  After I add an item to my shopping cart I get an error that the field member_id is ambigous, I am just learning mySQL and would appreciate any help. Here is the error:  1052 (Column: ''member_id'' in field list is ambiguous) Session halted.  If you want to check out this sample go to  http://www.elnuevosol.net/bookstore/index.php','2001-02-09 21:32:01','2001-02-09 21:32:01',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (121,118,118,'Re: error','CodeCharge support','Please uninstall your version of CodeCharge and download the updated version 1.0.103 from: http://www.codecharge.com/download/files/CodeCharge1_0_103.exe','2001-02-10 07:30:53','2001-02-10 07:30:53',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (122,120,120,'Re: Error in database field for Bookstore','CodeCharge support','I guess when you created DB in mysql , you''ve assigned member_id field integer type. You have to use auto_increment in field definition ,  because all member ids must be unique. Something like   CREATE TABLE persons (     member_id SMALLINT UNSIGNED NOT NULL AUTO_INCREMENT,      name CHAR(60) NOT NULL,     PRIMARY KEY (member_id) );','2001-02-10 07:32:58','2001-02-10 07:32:58',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (123,101,101,'Re: Re: Multiple Tables','Ciaran','I having difficulty with something similar.  I have two tables. \"Users\" is used for storing name, address etc. \"Logins\" is used for storing username, password, etc. Both tables share a primary key (userId).  I can show all the information from both tables in a single form. What I''m having problems with is inserting updates from that single from to each table.  Similarly if I click the \"Add\" link to add a new user, I would like entry fields for the columns from both tables to appear and when I click the \"Add\" button the each element in the form is inserted in the correct table.  Sorry, if I haven''t made this clear enough.  Thanks, Ciaran','2001-02-11 03:06:00','2001-02-11 03:06:00',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (124,88,88,'Re: Re: Trial version crashes','Ruslee','Thanks Joachim. Now it is working fine but before  I go ahead and purchase it just wanna find out  from you that have u ever tried out to modify the  html using Frontpage 98? What happened is that  the generated ASP code had some problem once  amended using Frontpage 98. Does oit mean I have  to use Frontpage 2000. Thanks again if u can help','2001-02-11 06:24:48','2001-02-11 06:24:48',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (125,88,88,'Re: Re: Re: Trial version crashes','Joachim Uersfeld','Don''t use Frontpage to edit ASP-Files. It formats the code and produced errors in the code. You can edit ASP-Code with Notepad. When you edit html-Files, change what ever you will, but not the cc-generated comments and variables.','2001-02-11 07:14:38','2001-02-11 07:14:38',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (126,88,88,'Re: Re: Re: Re: Trial version crashes','Ruslee','Joachim Thnks for your reply. I edited html files  using Frontpage 98 not the asp files. I edited  the non variable table title in the html files  but after running again the database kind of hay wire. Is it because of Frontpage 98 or do I need  to use frontpage 2000?','2001-02-11 08:20:49','2001-02-11 08:20:49',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (127,88,88,'Re: Re: Re: Re: Re: Trial version crashes','Joachim Uersfeld','No. I can take a look into the files. When you will, send the cc-generated and your modified htm-file to uersfeld@pc-team.de.','2001-02-11 11:26:54','2001-02-11 11:26:54',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (128,NULL,NULL,'ASP server-side includes','Ciaran','Hi, I have a file comms.inc that contains a number of functions for sending formatted emails etc.  I''d like to be able to specify that all CodeCharge generated ASP files #include comms.inc but I can''t see where to do this.  Any ideas? Ciaran','2001-02-12 05:00:09','2001-02-12 05:00:09',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (129,NULL,NULL,'Backward Compatablity','Nanda Kumar','Is these code supports backward compatablitty (meaning) whether it will work fine with Internet Explorer 4.0.','2001-02-12 06:32:00','2001-02-12 06:32:00',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (130,NULL,NULL,'Win 2K Pro','JT','Does Win 2K Pro include ASP support or do I have to install it?','2001-02-12 08:40:04','2001-02-12 08:40:04',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (131,128,128,'Re: ASP server-side includes','CodeCharge Support','If you use templates you can add  <!-- #INCLUDE FILE=\"comms.inc\" -->  to Common.asp file  Otherwise  You can do it via specifying header page in  Site/Properties/Pages tab  or Page Properties.  In header page you should insert   <!-- #INCLUDE FILE=\"comms.inc\" --> command.','2001-02-12 10:06:32','2001-02-12 10:06:32',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (132,129,129,'Re: Backward Compatablity','CodeCharge Support','Sure , generated code will work under IE 4.0 . Especially as long as one doesn''t  add incompatible code there. But CodeCharge itself requires IE 5.0 for development purposes.','2001-02-12 10:08:00','2001-02-12 10:08:00',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (133,130,130,'Re: Win 2K Pro','CodeCharge Support','Yes , it includes IIS , and thus ASP too.','2001-02-12 10:11:23','2001-02-12 10:11:23',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (134,53,53,'Re: Re: I have problems with jsp','safarnejad','i had that same problem when generating JSP and template.  When i switched to generating JSP alone, that problem went away. However, the java.io package is not loaded in the JSP, so you''ll have to either prepend \"java.io.\" to every instance of IOException or import the package in the JSP page.','2001-02-12 10:54:37','2001-02-12 10:54:37',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (135,130,130,'Re: Win 2K Pro','Shell','It includes ASP support if you install IIS (Internet Information Services).  This is  not a service that is installed by default.  If you do not have IIS installed, go to  control panel>windows options (whatever the third option down is and pick it from the list).  Shell','2001-02-12 10:59:18','2001-02-12 10:59:18',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (136,NULL,NULL,'Sybase ODBC','Tony Botello','When I try to use a existing data source that I can use fine in Access, it says the Test Connection failed because of an error in initializing provider.  Catastrophic failure  Any suggestions?','2001-02-12 12:03:08','2001-02-12 12:03:08',4);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (137,NULL,NULL,'How to add a number to a database??','markus','Probably a silly question, but how would I take a total from a database, and add a number to it and update the database with the new total?  I need to do this in php and asp.  thanks','2001-02-12 15:20:22','2001-02-12 15:20:22',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (138,NULL,NULL,'Images as buttons?','Popee','Is there a way to use images in place of those ugly gray buttons for actions like submit, cancel, add, delet and so forth?  Thank you;  Popee','2001-02-13 05:00:25','2001-02-13 05:00:25',3);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (139,136,136,'Re: Sybase ODBC','CodeCharge','First , you should check if your ODBC datasources for sybase work at all. Or even reinstall sybase ODBC drivers.','2001-02-13 06:13:59','2001-02-13 06:13:59',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (140,68,68,'Re: Re: Data Types','Paul','That being the case Could you please tell me why, when I use the checkbox, the data changes in the database but the changes do not show up  on the form?  For example if I check a box that was previously unchecked when I look at the data in the database the field is checked; however when I  bring the record backup in the form the checkbox appears unchecked.  Thank you for any assistance;  Paul','2001-02-13 06:47:07','2001-02-13 06:47:07',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (141,137,137,'Re: How to add a number to a database??','CodeCharge','CodeCharge Supports it currently on sql level only.  Create a new form , click \"Form properties\" select \"sql\" tab. Enter our own sql code for counting totals. Something like : select sum(item_id) as mysum from items Now that you have alias for this sum , you may add a new field to this form and choose this alias (mysum, in our case) . It will show your totals. No need to save them. Better sum up totals on the fly.','2001-02-13 07:13:52','2001-02-13 07:13:52',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (142,138,138,'Re: Images as buttons?','CodeCharge','Sure. It''s a cinch , just instead of html  code for those gray buttons insert another code :  <a href=\"javascript:form.submit()\"> <img src=\"your_picture.gif\"> </a>  Enjoy!','2001-02-13 08:06:22','2001-02-13 08:06:22',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (143,138,138,'Re: Images as buttons?','CodeCharge','Sure. It''s a cinch , just instead of html  code for those gray buttons insert another code :  <a href=\"javascript:form.submit()\"> <img src=\"your_picture.gif\"> </a>  For other action but submit you should specify appropriate javascript function.  Enjoy!','2001-02-13 08:06:22','2001-02-13 08:06:22',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (144,53,53,'Re: I have problems with jsp','CodeCharge','Please try run this example from another JSP enabled server , jswdk for instance. Do you still have same error messages in this case ?','2001-02-13 08:37:19','2001-02-13 08:37:19',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (145,138,138,'Re: Re: Images as buttons?','Popee','Appreciate the help.  Thank you;  Popee','2001-02-13 10:47:52','2001-02-13 10:47:52',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (146,NULL,NULL,'IIS5','Mehrdad','Hi is IIS5 support PHP?  i''m new at php and our server is IIS , please help me what can i do?   Regards, arshadrad@usa.net Mehrdad','2001-02-13 15:35:46','2001-02-13 15:35:46',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (147,NULL,NULL,'Closing of Database Objects','Ruslee','Dear Support, I noticed the CC generated ASP code did not generate closing statements at the end of Database open connection. This I think will exhaust the server resources. Pls comment.','2001-02-13 19:24:07','2001-02-13 19:24:07',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (148,NULL,NULL,'Date in PHP??','markus','With ASP i know to get a date in a field you can put:  =Date()  in the default field value. So how to do this with PHP??  thanks','2001-02-13 23:38:30','2001-02-13 23:38:30',3);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (149,137,137,'Re: Re: How to add a number to a database??','markus','Thanks, I''ll try this.','2001-02-13 23:40:23','2001-02-13 23:40:23',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (150,147,147,'Re: Closing of Database Objects','CodeCharge','All objects created in page''s scope , and when the script is over they  all are automatically closed and deleted. So, it''s all ok about server resources.','2001-02-14 01:08:45','2001-02-14 01:08:45',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (151,148,148,'Re: Date in PHP??','CodeCharge','Php has date() fucntion as well. Format : string date (string format [, int timestamp]) Example: date (\"l dS of F Y h:i:s A\")); Note : you must apply your date formatting parameters. See PHP menual.','2001-02-14 01:22:19','2001-02-14 01:22:19',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (152,146,146,'Re: IIS5','CodeCharge','Please visit http://php.net/downloads.php There you can find php installations that work with IIS. Good luck!','2001-02-14 01:45:23','2001-02-14 01:45:23',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (153,99,99,'Re: Access Connection','Mohsin S. Mirza','Hi,  Initially I too had a problem connecting to MS SQL, although connecting to an Acess (.mbd) database was outright easy.  I use the following strings when connecting to our SQL 7.0 database(s):  String for the Design Database Connection box is: Provider=SQLOLEDB.1;Persist Security Info=False;User ID=ENTER_HERE_YOUR_SQL_USER_ID;Initial Catalog=ENTER_HERE_YOUR_SQL_DATABASE_NAME;Data Source=ENTER_HERE_YOUR_SQL_SERVER_MACHINE_NAME Example: Provider=SQLOLEDB.1;Persist Security Info=False;User ID=fordconnects;Initial Catalog=database1;Data Source=fordmachine00816  String for the Server Side Connection String: driver={Sql Server};Server=ENTER_HERE_YOUR_SQL_SERVER_MACHINE_NAME;database=ENTER_HERE_YOUR_SQL_DATABASE_NAME;uid=ENTER_HERE_YOUR_SQL_USER_ID;pwd=ENTER_HERE_YOUR_SQL_USER_PASSWORD driver={Sql Server};Server=fordmachine00816;database=database1;uid=fordconnects;pwd=password1  The string for the Server Side Connection String  (right above) is the one that you would use in  your ASP file or in the include  (if you are using includes for storing database  connection strings as a security measure).  --- Mohsin S. Mirza mmirza5@visteon.comPhantom wrote:  >Firstly, I must congratulate on a fine product. It is simple to use and powerful, but it can also get difficult on the connection side. > >I am getting now where in connecting either a Access or SQL database... I consistanly get errors and yet have any luck in getting the connection. I have tried everything.. on the program. But nothing works!!! > >The Test sees the connection with no problems. >I am sure everthing is setup fine, as I am running another base okay. > >Using Windows 2000. With Access 2000 and SQL 7.0 > >Your help is much appreicated. >','2001-02-14 06:01:14','2001-02-14 06:01:14',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (154,99,99,'need details','CodeCharge','Please  tell what kind of errors you have. This is required for further investigation of your problem.','2001-02-14 07:55:52','2001-02-14 07:55:52',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (155,148,148,'Re: Re: Date in PHP??','markus','I have tried this, I always get a parse error.','2001-02-14 15:11:46','2001-02-14 15:11:46',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (156,148,148,'Re: Re: Date in PHP??','markus','Apologies, I got it to work, there was an extra \")\" in your example. I should look harder.  thanks','2001-02-14 15:13:42','2001-02-14 15:13:42',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (157,104,104,'Re: Cold Fusion problems','Sonny Salazar','Check the advanced ODBC properties in CFAdministrator and ensure Insert is checked. Also, verify that the database you are pointed to is not read only. Next, go into the form properties and verify that you have insert selected.','2001-02-14 18:54:32','2001-02-14 18:54:32',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (158,NULL,NULL,'Windows 2000 Connection Error','Sonny Salazar','I''ve done a fresh Windows 2000 install on 3 seperate machines and install all the latest greatest patches to include CFServer 4.5 Netscape/IPlanet Enterprise Server 4.1. The problem is with CodeCharge when I create a new site and select Properties>Database>Design Database Connection> I get the Error:  Microsoft Datalink Error provider is no longer available  Or...  Test connection failed because of an error initializing provider - unspecified error  I''ve succesfully installed Codecharge on a machine that had NT4SP6 with 2000 installed over it with no problems. Please advise.','2001-02-14 19:52:37','2001-02-14 19:52:37',5);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (159,NULL,NULL,'editor','rturner','I just downloaded the trial.  I do not see an editor within codecharge and when I use notepad the source is compressed.','2001-02-14 20:12:38','2001-02-14 20:12:38',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (160,158,158,'Re: Windows 2000 Connection Error','Adam Stock','I suspect that is a connectivity issue (rather then CodeCharge itself). Maybe you could try downloading and installing MDAC 2.6 from http://www.microsoft.com/data/download_260rtm.htm','2001-02-14 21:09:40','2001-02-14 21:09:40',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (161,159,159,'Re: editor','Adam Stock','CodeCharge doesn''t have editor, although you may add/edit snippets of code called Events. The generated source isn''t compressed. Which file(s) are you looking at ?','2001-02-14 21:12:27','2001-02-14 21:12:27',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (162,NULL,NULL,'CCP Templates','Bruno','Is there any way for me to create a Template Pattern for a site?!??!','2001-02-15 09:43:23','2001-02-15 09:43:23',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (163,4,4,'Re: bad code for dreamweaver','mmirza5@visteon.com','Dreamweaver seems to do that with any code. You just can''t preserve the code with Dreamweaver.  It changes the code (tag placement, spaces, tabs,  tag order, etc.)  I have tried both: Dreamweaver and Dreamweaver UltraDevubIKKls wrote:  >Code which is generated by codecharge isn''t read properly in dreamweaver ultradev 4.0 ( for example i try it in namo webeditor 4.0 and everything was good). For example when i generate code for bookstore i see at dreamweaver just one columne not three as should be ( dreamweaver see some not properly tags too ( table and tr ). >','2001-02-15 10:52:45','2001-02-15 10:52:45',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (164,NULL,NULL,'Spelling','Moleman','While I haven''t gotten it to work yet I''m having fun learning this program. I''ve found one bug so far: in the generated HTML, the MAXLENGTH command is spelled MAXLENGHT. Just thought you''d like to know in case it causes problems down the road.','2001-02-15 11:33:06','2001-02-15 11:33:06',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (165,NULL,NULL,'Logout function','German','Hi everybody!  I created a form where my user can to logout of the web-system, but I need to know how works the logout because if I put a link to the login form this form puts a logout button, well this is the button that I need. But how do I put on my user-form?  thanks','2001-02-15 19:43:25','2001-02-15 19:43:25',3);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (166,NULL,NULL,'PWS on Win ME','JT','Does Windows ME include PWS or do I have to install it?','2001-02-15 19:47:54','2001-02-15 19:47:54',4);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (167,136,136,'Re: Sybase ODBC','Bruce Kerr','Yeah i get the same on SQL 7 connections ado and odbc Tony Botello wrote:  >When I try to use a existing data source that I can use fine in Access, it says the Test Connection failed because of an error in initializing provider.  Catastrophic failure > >Any suggestions?','2001-02-15 23:00:36','2001-02-15 23:00:36',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (168,162,162,'Re: CCP Templates','CodeCharge','This can be done different ways. 1) Use cascading stylesheets(if you mean onyl style). 2) Use codecharge File/Import ability to import Pages from other sites created by CodeCharge into your current project. Use server side includes (if you''re not working with html templates).','2001-02-16 02:02:35','2001-02-16 02:02:35',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (169,165,165,'Re: Logout function','CodeCharge','You just need to put login form on user-form. Sice this form is displayed only when the user is logged in , you will see \"Logout\" button.','2001-02-16 02:36:36','2001-02-16 02:36:36',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (170,165,165,'Re: Logout function','CodeCharge','You just need to put login form on user-form. Since this form is displayed only when the user is logged in , you will see \"Logout\" button.','2001-02-16 02:36:36','2001-02-16 02:36:36',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (171,164,164,'Re: Spelling','CodeCharge','Thanks for the observation. We appreciate your help.','2001-02-16 04:35:12','2001-02-16 04:35:12',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (172,166,166,'Re: PWS on Win ME','CodeCharge','Microsoft has not provided PWS in Windows Me. For more details see http://support.microsoft.com/support/kb/articles/Q266/4/56.ASP?LN=EN-US&SD=SO&FR=0','2001-02-16 04:38:53','2001-02-16 04:38:53',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (173,NULL,NULL,'What''s this for','Popee','On the CodeCharge Menu when one clicks on \"Tools\" then selects \"Options\" there is selection options for a HTML editor and a code editor.  I use HomeSite so I referenced it for both.  Then on the Tool bar is a button with a Tool Tip that says \"Edit Files\" and has a little arrow on it.  I assumed that this would pull the active page into HomeSite.  Obviously I was wrong.  So what are the options for and what is the \"Edit File\" button for?  Thank you;  Popee','2001-02-16 04:53:19','2001-02-16 04:53:19',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (174,NULL,NULL,'Anyone using this with SQLserver 7 ??','Chris','Anyone using codecharge w/ SQLserver 7?  Comments please.  How does it work (gotchas, look out fors, ...) with an ISP hosted SQL database (not hosting myself)...  TIA','2001-02-16 05:23:13','2001-02-16 05:23:13',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (175,173,173,'Re: What''s this for','CodeCharge','This is for editing your html code with your favourite HTML editor. Please press \"Generate\" button on a toolbar - and codecharge will generate your html code(previously you simply had nothing to edit), that you can edit via clicking \"Edit files\" button on a toolbar. Do not forget to click the \"down arraw\" on the left , to be able to choose between script and html editing.','2001-02-16 06:09:23','2001-02-16 06:09:23',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (176,173,173,'Re: Re: What''s this for','Popee','OK; now I see thanks.  This is going to really come in handy.','2001-02-16 06:27:38','2001-02-16 06:27:38',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (177,158,158,'Re: Windows 2000 Connection Error','Keith','  I allready installed mdac2.6.....I have the same problem.!!!','2001-02-16 07:57:15','2001-02-16 07:57:15',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (178,174,174,'Re: Anyone using this with SQLserver 7 ??','js','works fine.  we do not use a hosting service so i can''t comment on that.  the only problem that i saw was the use of field names with spaces. codecharge does not handle these and their advice is to not use them. doesn''t help much when you do not create the tables and have no control on these conventions.  doesn''t seem like a major task to look at the names and enclose them in braces.','2001-02-16 08:41:55','2001-02-16 08:41:55',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (179,165,165,'Re: Re: Logout function','German','Thanks I''ll try it!','2001-02-16 10:39:13','2001-02-16 10:39:13',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (180,NULL,NULL,'PHP-Lib error','Sebastian Pfohl','I have problem with the generated PHP4 Code. On my Testserver all works fine but when i upload the files to my provider i become a error like this:  Fatal error: Class db_example: Cannot inherit from undefined class db_sql in /home/******/phplib-7.2c/php/local.inc on line 12  PS:***** is edited by me :-)  whats wrong ?','2001-02-16 13:29:39','2001-02-16 13:29:39',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (181,158,158,'Re: Re: Windows 2000 Connection Error','Keith','works on my other win2000 box....so, <sigh> guess I''ll rebuild my box if need be...NOT a CodeCharge problem.....!!!','2001-02-16 16:04:32','2001-02-16 16:04:32',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (182,NULL,NULL,'Win ME / PWS / ASP','JT','Can I install PWS 4 on Windows ME?  If I can, do I then need to install ASP on top of that to get Active Server Pages working?','2001-02-16 16:40:00','2001-02-16 16:40:00',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (183,4,4,'Re: Re: bad code for dreamweaver','Lonnie','Strange.  I have used dreamweaver for the last three years because it doesn''t change my code. I got tired of frontpage messing with the code and switched.  I am evaluating codecharge now. If it doesn''t work with dreamweaver, oh well...','2001-02-16 20:30:57','2001-02-16 20:30:57',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (184,NULL,NULL,'Links Template','Jim Nicolis','Hi all, I recently purchased codecharge and am trying to play with the links demo.  whenever I try to access it i get :  Microsoft JET Database Engine error ''80040e10''   No value given for one or more required parameters.   /opsweb/links/Common.asp, line 37    I have tried different things but nothing works    Regards  Jim','2001-02-16 21:10:23','2001-02-16 21:10:23',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (185,NULL,NULL,'how do i preserve  carriage returns','markus','In a text area, how do i preserve the line feeds/carriage rreturns, without all line being joined one after the other?  thanks','2001-02-17 02:39:26','2001-02-17 02:39:26',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (186,166,166,'Re: PWS on Win ME','JW','I tried it! It loaded up the files but it did activate.','2001-02-17 04:54:18','2001-02-17 04:54:18',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (187,166,166,'Re: PWS on Win ME','JT','What about Active Server Pages?  I could not get it to install properly.','2001-02-17 06:56:45','2001-02-17 06:56:45',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (188,166,166,'Re: Re: PWS on Win ME','CodeCharge','You mean it downloaded scripts instead of running them ? Then you need to set \"Execute\" permissions on the directory where your scripts lie. Go to Pws/Advanced properties/ ... Choose directory ... \"Edit properties\" set \"script\" and possibly \"execute\" permissions on. Good luck!','2001-02-18 02:45:12','2001-02-18 02:45:12',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (189,185,185,'Re: how do i preserve  carriage returns','CodeCharge.','Please see example provided with CodeCharge . It''s forum example. In any case , click \"Form properties\" icon , select \"Events\" tab. Select \"Show event\" . Enter your code smth like (depend on your lang.): For ASP: fldmessage=replace(fldmessage,vbCRLF,\"<br>\") For PHP:$fldmessage = str_replace(\"\\n\", \"<br>\", $fldmessage); For Perl :$fldmessage =~ s/\\n/<br>/gm; See , it''s just a simple substitution code. replaces \\n\\r with <br> tags.','2001-02-18 02:47:54','2001-02-18 02:47:54',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (190,184,184,'Re: Links Template','CodeCharge','Please tell what is your codecharge version ? If it''s lower than 1.03 I recommend you downloading newer version. So you can try download version 1.0.103 http://www.codecharge.com/download/files/CodeCharge1_0_103.exe What about other examples ? They work OK?','2001-02-18 02:56:29','2001-02-18 02:56:29',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (191,NULL,NULL,'Using a CodeCharge variable in SQL stmt.','Stefan Penter',' Is it possible to use a CodeCharge variable - which was transfered from another FORM- in a SQL  statement e.g. for a ListBox/List-Tab  E.g. Something like:  SELECT someId,someDescription FROM myTable  WHERE someId = <VariablePassedToCurrentFORM>   TIA and Kind Regards  Stefan','2001-02-18 07:57:20','2001-02-18 07:57:20',3);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (192,191,191,'Re: Using a CodeCharge variable in SQL stmt.','Ken Hardwick','To use variable that has been passed use ...for variable \"someId\"  use GetParam(\"SomeID\")... keep in mind though that if your field (SomeId) is a text field, you will need to add \"''\"''s around it...ie Where someID = '' & getParam(\"Someid\") & \"'' (not that I left the \" off the end as CodeChare will add it if it is startand end of sql line.  Also, one function available as part of CodeCharge is ToSql(????,\"Text\")(which will add the '' around it  or ToSQL(????,\"number\")  So, you could use  Where someid = \" & tosql(getparam(\"someid\"),\"text\")  You may have to experiment some and also look at the resulting generated code.','2001-02-18 08:38:03','2001-02-18 08:38:03',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (193,191,191,'Re: Re: Using a CodeCharge variable in SQL stmt.','Ken Hardwick','Where someID = '' & getParam(\"Someid\") & \"''  I should have indicated  Where someID = ''\" & getParam(\"Someid\") & \"''','2001-02-18 08:49:55','2001-02-18 08:49:55',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (194,NULL,NULL,'Upgrades','JT','How do you inform CodeCharge owners of upgrades?','2001-02-18 09:17:37','2001-02-18 09:17:37',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (195,191,191,'Re: Re: Re: Using a CodeCharge variable in SQL stm','Stefan Penter',' Ken Hardwick wrote:  >Where someID = '' & getParam(\"Someid\") & \"''  >I should have indicated > >Where someID = ''\" & getParam(\"Someid\") & \"''  > >  Thanks Ken,  Your hack seems to work OK, when generating for  ASP....Great! Thanks!.. but will the method not  fail when generating for other target languages,  since the string concatenation is probably  different from ''&'' ??  Maybe there is no target-code independent way ?','2001-02-18 10:01:11','2001-02-18 10:01:11',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (196,184,184,'Re: Re: Links Template','Jim Nicolis','Thanks for replying, I will download the latest release and try that.  By the way as a registered user ( I bought codecharge about 2 weeks ago), do you notify users of upgrades ?   Regards   Jim Nicolis','2001-02-18 14:20:06','2001-02-18 14:20:06',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (197,185,185,'Re: Re: how do i preserve  carriage returns','markus','Thanks, works great.','2001-02-18 15:28:20','2001-02-18 15:28:20',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (198,NULL,NULL,'tmp\\sess_XXXX','Marc','I am using MySQL with PHP and your very promising program. The data is read out but I am getting the following error messages:  Warning: open(/tmp\\sess_52170a9e570753cc1933052dd6d33d37, O_RDWR) failed: m (2) in c:\\phpdev2\\www\\mysite\\web.php on line 11  and Warning: open(/tmp\\sess_52170a9e570753cc1933052dd6d33d37, O_RDWR) failed: m (2) in Unknown on line 0  Warning: Failed to write session data (files). Please verify that the current setting of session.save_path is correct (/tmp) in Unknown on line 0  What do I need to correct? Marc.','2001-02-19 08:09:30','2001-02-19 08:09:30',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (199,198,198,'Re: tmp\\sess_XXXX','CodeCharge','Check in php.ini file session.save_path variable , it must point to existing directory , where session info will be stored.','2001-02-19 08:30:55','2001-02-19 08:30:55',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (200,NULL,NULL,'PRoblem with Apache.mySQL.PHP site development','darth','On Windows 98SE, I have the NUSPHERE server package with Apache, mySQL, and PHP4 installed.  I run into difficulty & errors when trying to put together a PHP/mySQL Codecharge site.   Here''s what I am doing:  In Properties General: 	 		Language: PHP4 	Output code path: G:\\nusphere\\apache\\htdocs\\forum 	Out files format: Windows 	       Live site: localhost/forum  In Properties Database:  	Design Database Connection: ????? 	(What should I do here? The Access.mdb is default.) 	Database Name: forum_db (Is the name Critical?) 	Database Type: mySQL 	Host: (my IP address? As server is running on my system) 	 If I chose JSP instead of PHP4, there would be a box for ''Database Driver: It mentions this in the help files, but it doesn''t exist in codecharge when I select PHP4.  --------------------------------------------- Warning: open(/tmp\\sess_c557a3481dcdc8856a31d81b6b821b8d, O_RDWR) failed: m (2) in g:\\nusphere\\apache\\htdocs\\forum\\index.php on line 12 Database error: cannot use database forum_db MySQL Error: 1044 (Access denied for user: ''...'' to database ''forum_db'') Session halted. Warning: open(/tmp\\sess_c557a3481dcdc8856a31d81b6b821b8d, O_RDWR) failed: m (2) in ./db_mysql.inc on line 0  Warning: Failed to write session data (files). Please verify that the current setting of session.save_path is correct (/tmp) in ./db_mysql.inc on line 0  ---------------------------------------------   What''s the solution?','2001-02-19 09:19:52','2001-02-19 09:19:52',6);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (201,200,200,'Re: PRoblem with Apache.mySQL.PHP site development','Peter Roth','Hi I try to help you:  1) Design Database Connection: ?????  Create a ODBC Datasource to the mySQL Database forum_db  2) Database Name: forum_db  This is the name of the mySQL Database. It must be the same as you created within the mySQL environment  3) Host: (my IP address? As server is running on my system)  I set this to localhost. Because my mySQL Server is defined to run on localhost  4) Please make sure you have the rights set within mySQL (user, password)  5) session.save_path In the php.ini file (located in your php directory or within the windows directory) there is a variable called session.save_path. So you can set this to e.g. c:\\temp  Info: If you try to generate a JSP Site you have to have a JSP enabled WebServer (Apache with JServ or Tomcat/Jakarta)  I hope this helps  Regards   Peter Roth software solutions, switzerland e-mail: proth@softsol.ch web: http://www.softsol.ch','2001-02-19 14:27:20','2001-02-19 14:27:20',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (202,200,200,'Re: Re: PRoblem with Apache.mySQL.PHP site develop','darth','Peter Roth wrote:  > 1) Design Database Connection: ?????  > Create a ODBC Datasource to the mySQL Database forum_db  OK, I created a database ''forum_db'' in mySQLadmin.  How do I create an ODBC datasource to the mySQL database? Everything I try fails.  > 4) Please make sure you have the rights set within mySQL (user, password)   OK, this is something I never figured out.','2001-02-19 21:41:02','2001-02-19 21:41:02',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (203,198,198,'Re: Re: tmp\\sess_XXXX','Marc','Easy enough. Thank you.','2001-02-20 00:26:14','2001-02-20 00:26:14',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (204,NULL,NULL,'One Key Two Fields','Popee','I''m trying to bring two fields from another table into a form.  The only unique number I have is the Customer''s ID.  When I use it to get the customer''s name I can''t use it to get the customer''s address because I get an error message telling me that that key has already been used.  How can I pull more than one field over from a second table?  I''m using Access 97 and ASP.  Thanks in advance.  Popee','2001-02-20 07:46:45','2001-02-20 07:46:45',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (205,204,204,'Re: One Key Two Fields','Popee','Never mind I got it.  Oh do I love this program!','2001-02-20 08:07:53','2001-02-20 08:07:53',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (206,NULL,NULL,'Like ''...&'' is not working','BHB','When I choose the Like ''...%'' the generated code show an ''='' for ASP.  Like ''%...%'' works fine.','2001-02-20 15:28:23','2001-02-20 15:28:23',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (207,206,206,'Re: Like ''...&'' is not working','Joachim Uersfeld','This was a problem with one of the first versions. Try do download version 1.0.103  http://www.codecharge.com/download/files/CodeCharge1_0_103.exe.','2001-02-20 23:41:09','2001-02-20 23:41:09',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (208,1,1,'Re: Welcome to CodeCharge discussions!','Yogita','Hi All,        I am trying to make my own Bug Tracking  system.For this, I would want that my system  prepares a log file of all the stages a bug goes  through so that I can view the intermediate stages (from Development team to the testing team and  back) .       Also, I would want a data field value to be appended to its earlier contents rather than being  overwritten.  Can anybody suggest as to how do I go about it?Moderator wrote:  >Welcome to CodeCharge discussions! > >Please feel free to discuss any CodeCharge related questions here.','2001-02-21 01:12:10','2001-02-21 01:12:10',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (209,NULL,NULL,'Log file generation?','Yogita','Hi All,        I am trying to make my own Bug Tracking  system.For this, I would want that my system  prepares a log file of all the stages a bug goes  through so that I can view the intermediate stages (from Development team to the testing team and  back) .       Also, I would want a data field value to be appended to its earlier contents rather than being  overwritten.  Can anybody suggest as to how do I go about it?','2001-02-21 01:17:25','2001-02-21 01:17:25',4);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (210,NULL,NULL,'Updates to Codecharge','Jim Nicolis','As a registered user, how are you informed of any recent updates ?  I recently had a experience whereby I only new of the update after posting a question in this forum, I was answered by the CodeCharge support people and told to download the update.   This is not a gripe, but just want to know if there are any new updates, I love this tool.  Regards  Jim Nicolis','2001-02-21 02:50:47','2001-02-21 02:50:47',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (211,209,209,'Re: Log file generation?','CodeCharge','Well , you can use BugTrack example provided with CodeCharge. You will only need to add some filter , that will filter out info submitted by testers , developers  and others.','2001-02-21 02:56:32','2001-02-21 02:56:32',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (212,209,209,'Re: Log file generation?','CodeCharge','Well , you can use BugTrack example provided with CodeCharge. You will only need to add some filter , that will filter out info submitted by testers , developers  and others.','2001-02-21 02:56:32','2001-02-21 02:56:32',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (213,4,4,'Re: bad code for dreamweaver','Michael Hiles','UltraDev accomplished the \"dragging & dropping\" of database functions by establishing a ''standard'' instruction library to do things like opening connections, creating recordsets, etc...  While it is extensible and created a path to true script coding for design oriented people, it creates limitations. When you look at an ASP page that has been written in an environment outside of UD, the code may not be recognized and interpreted as a UD Server Behavior... even though the code may do the exact same thing.  If you get more familiar with the functions and subs in the Common.asp file generated by CodeCharge, you will find much of what you are looking for.','2001-02-21 03:51:17','2001-02-21 03:51:17',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (214,210,210,'Re: Updates to Codecharge','CodeCharge','Jim , not that it was an update ,  it was just a patch for solving some problems that sometimes appear in our customer''s environment.','2001-02-21 04:48:33','2001-02-21 04:48:33',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (215,NULL,NULL,'Block with name FormForm1 does''t exist','Marc','When inserting a new form (Menu, record etc.)on a page I am getting the message:  Block with name FormForm1 does''t exist  What do I do wrong?  Thank you. Marc.','2001-02-21 08:03:42','2001-02-21 08:03:42',4);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (216,215,215,'Re: Block with name FormForm1 does''t exist','Joachim Uersfeld','Rename this Form.','2001-02-21 09:07:58','2001-02-21 09:07:58',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (217,215,215,'Re: Block with name FormForm1 does''t exist','CodeCharge','When exactly and how do you get this type of message ? Right in CodeCharge or when running generated scripts ? Please check if in generated html file for this page there is a line <!--BeginFormForm1-->  ? and check if Form Name is Form1. HTML comment and Form name must be  equal except prefix.   As a temporary solution you can go to Site/Properties and select language  pattern without templates.','2001-02-21 09:05:16','2001-02-21 09:05:16',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (218,NULL,NULL,'Passing parameters','German','Hi everybody!! I want to create a form where I can choose fomr many options such like \"Create\", \"Delete\",  \"Insert\" well, for each option I need to pass a reference number for the operation so with this reference number i need to show to my user the correct form, but how can I pass variables or parameters without a table? because if a need to pass a variable i need to have a table. thanks for your help. German','2001-02-21 18:03:09','2001-02-21 18:03:09',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (219,209,209,'Re: Re: Log file generation?','Yogita','It was after I explored the BugTrack example that I asked this question. I walked thru that  example again but could not find answer to any of the two ques I had asked.    Can you suggest something else?','2001-02-21 20:09:06','2001-02-21 20:09:06',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (220,NULL,NULL,'Can anybody help create a logfile?','Yogita','It was after I explored the BugTrack example  that I asked this question. I walked thru that  example again but could not find answer to any  of the two ques I had asked.  Can you suggest something else?','2001-02-21 20:12:34','2001-02-21 20:12:34',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (221,NULL,NULL,'Can anybody help create a logfile?','Yogita','I would want to create a logfile of everything that is done using my application. I am trying to make my own Bug tracking system from a scratch. Even after exploring the example (Bugtrack), I could not find the place where I can do this.    Also, I would want to append the updations in a data field rather than overwriting it. Have tried changing \"Common.asp\" in \"case insert:\" , but it was of no use.    Can anybody suggest something?','2001-02-21 20:13:37','2001-02-21 20:13:37',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (222,215,215,'Re: Re: Block with name FormForm1 does''t exist','Marc','Page Preview in CC doesn''t show any mistake. You are right, when checking the HTML there is NO <!--BeginFormForm1-->, plain missing. I then generated the site without templates, PHP only and I got the following error message:  Parse error: parse error in c:\\phpdev2\\www\\mysite\\web_company.php on line 260  Line 260 says: echo  $scroller_prev.\"<font \"..\">Prev</font>\";  Hopefully you can help! Marc.','2001-02-21 23:57:18','2001-02-21 23:57:18',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (223,218,218,'Re: Passing parameters','CodeCharge','Actually it''s not quite clear what you want. But I''ll try to exmplain approximately. 1) If you don''t to use table tags , you can manually strip them from html code  generated by codecharge. 2) If you want to pass some parameters other way but through form , you can do it useing \"URL\" field type , it passes parameters too. See it''s \"Output\" tab.','2001-02-22 01:46:15','2001-02-22 01:46:15',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (224,215,215,'Re: Re: Re: Block with name FormForm1 does''t exist','CodeCharge','Please send you .ccs file to  support@codecharge.com.','2001-02-22 01:58:18','2001-02-22 01:58:18',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (225,209,209,'Re: Log file generation?','CodeCharge','1) You will need to create a table that stores bug history, You will need to modify BugRecord page. Add there a form \"AddBugInfo\" info. This form will contain listbox with values \"developer,tester\", and it will sumbit a record to table bughistory with values like  (project_id,bug_id,sumbitter_id,sumitter_type) Now you have extended bug history in the db. You can display history data on a form using simple grid. One grid for testers and one grid for developers. You will probably need to fill in SQL tab of Form properties dialog. You could enter in \"Where\" text box your condition code , like :  sumbitter_type=0','2001-02-22 02:04:15','2001-02-22 02:04:15',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (226,NULL,NULL,'multi language',NULL,'How about multilingual site''s? In the captions of my form I can put things like <? echo $username; ?> but the checks, etc remain in English. Also forms like the standard login, search, etc. are allways in Enlish. Will there be a solution for this in the near future?','2001-02-22 05:32:38','2001-02-22 05:32:38',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (227,4,4,'Re: bad code for dreamweaver','Edu Yama from Brazil','Hi Tyr this: Edit -> Preferences -> Code Rewriting -> Uncheck everything  Bye','2001-02-22 06:27:51','2001-02-22 06:27:51',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (228,NULL,NULL,'Description for code separation ASP template?',NULL,'Nice peace of software we have here. Is there a description for the TemplateObj.asp file which is supose to separate the HTML from the ASP code? I can''t understand a thing here... VBScript is not really my language of choice. :))  BTW... in the pdf description for CodeCharge one of the picture shows that asp 3.0 templates can be produced... why is it that in the trial version only asp 2.0 templates are being developed?','2001-02-22 08:12:07','2001-02-22 08:12:07',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (229,NULL,NULL,'Alternate Table row colors odd and even',NULL,'Anyone know how to alternate table row colors odd and even?  ie. even rows have a gray background, odd rows have a white background....just makes things easier to read.  Please advise.','2001-02-22 08:14:10','2001-02-22 08:14:10',4);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (230,200,200,'Re: Re: PRoblem with Apache.mySQL.PHP site develop','Jeff Held','I have done this.  I use MS Access in design mode...and mySQL for runtime.  Jeff Held','2001-02-22 08:17:43','2001-02-22 08:17:43',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (231,228,228,'Re: Description for code separation ASP template?','CodeCharge support','ASP 3.0 has been removed from CodeCharge, and trial version is complete CodeCharge version. The only difference is trial period. Use asp 2.0 templates. See beginning of template.obj(template usage) :  LoadTemplate server.mappath(\"/templates/new.html\"), \"main\"  SetVar \"ID\", 2  SetVar \"Value\", \"Name\"  Parse \"DynBlock\", False ''or True if you want to create a list  Parse \"main\", False  PrintVar \"main\"','2001-02-22 09:33:59','2001-02-22 09:33:59',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (232,NULL,NULL,'ASP - Populating a Listbox with two items',NULL,'I''ve created a listbox that is populated with the following SQL:  SELECT JobID,ClientName,JobDescription FROM Jobs INNER JOIN Clients ON Jobs.Clientnumber = Clients.Clientnumber WHERE JobDescription <> '''' ORDER BY Clients.ClientName ASC  I successfully get a list that has a ClientName for each JobID. But I want to put in JobDescription as well as the ClientName. If I was coding by hand, I would tell it to Response.write something like:  <%=obj(\"ClientName\") - <%=obj(\"JobDescription\")  for the value, that way I would have a list that would give me all the necessary information.  But with CodeCharge, I can only seem to populate the list box with one thing at a time. What do I need to do to be able to change this?  Thanks!','2001-02-22 10:19:11','2001-02-22 10:19:11',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (233,232,232,'Re: ASP - Populating a Listbox with two items','Joachim Uersfeld','Let''s the database do the work:  SELECT JobID,ClientName,JobDescription  /* new start */   ,ClientName + '' '' + JobDescription AS myNewField /* new end */  FROM Jobs ...  And take myNewField in the listbox.','2001-02-22 10:51:39','2001-02-22 10:51:39',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (234,NULL,NULL,'ASP 3.0 ? But ASP 2.0 in trial version',NULL,'I am testing out the trial version, and reading the documentation. In the manual, it has the option of \"ASP 3.0 and template\", but I do not see this option in the trial version. It has only ASP 2.0.    Secondly, I can only buy an electronic download version of the product?  I see a product box photo in your site, can I buy the product somewhere with the box?  Thanks!  Richard','2001-02-22 11:08:04','2001-02-22 11:08:04',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (235,229,229,'Re: Alternate Table row colors odd and even','Jeff Held','If anyone else is interested, I figured a quick way to do it...just added a html parameter inplace of the color...and doubled the ASP \"generation\" code to add an alternating color parameter. FUN STUFF!!!!  Jeff Held wrote:  >Anyone know how to alternate table row colors odd and even? > >ie. even rows have a gray background, odd rows have a white background....just makes things easier to read. > >Please advise. >','2001-02-22 13:50:45','2001-02-22 13:50:45',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (236,200,200,'Re: Re: Re: PRoblem with Apache.mySQL.PHP site dev','Peter Roth','Hi - sorry for the delay  1) ODBC Datasource: >> Did you install the ODBC-Drive for mySQL. You can  found it on the mySQL Webpage','2001-02-22 14:34:21','2001-02-22 14:34:21',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (237,200,200,'Re: Re: Re: Re: PRoblem with Apache.mySQL.PHP site','darth','Peter Roth wrote:  >Hi - sorry for the delay > >1) ODBC Datasource: >>> Did you install the ODBC-Drive for mySQL. You can  >found it on the mySQL Webpage  Yes, the mySQL ODBC driver is installed.  I have NuSphere Apache/PHP/mySQL installed at the moment,','2001-02-22 21:55:54','2001-02-22 21:55:54',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (238,229,229,'Re: Re: Alternate Table row colors odd and even','Ken Hardwick','Jeff,   Could you provide an example of the \"html parameter\" that you used to do this..  And, what do you mean by \"doubled the ASP ''generation'' code\" ?  thanks, Ken Hardwick Norman,Ok','2001-02-23 03:31:42','2001-02-23 03:31:42',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (239,200,200,'Re: Re: Re: Re: Re: PRoblem with Apache.mySQL.PHP','Peter Roh','Hi  Ok - I asume the myODBC Driver is installed properly and works! ;-))  Go to the Control Panel->ODBC Data Sources->System DSN->click the Add-Button  select MySQL from the list then you have to  define your mysql-database:  Windows DSN name: whateveryouwant MySQL host (name or IP): yourmysqlserver (normaly localhost) MySQL database name: forum_db User: theUser Password: thePassword  Thats all!  Right now if you are in CodeCharge you have the possibility to select the right Datasource: Properties->Database->Design Database Connection: select the OLE DB Provider for ODBC Drivers->click next and select your Datasource the name is that you typed in at \"Windows DSN name:\"  So I hope this helps  Regards Peter Roth software solutions, switzerland','2001-02-23 04:42:33','2001-02-23 04:42:33',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (240,NULL,NULL,'Logged in user',NULL,'What''s the variable for a user that logged in via the standard login form in PHP4?','2001-02-23 09:17:56','2001-02-23 09:17:56',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (241,NULL,NULL,'Tip on Format and Question on Alignment of Fields',NULL,'(Note:I am using ASP as the generated code) I found a way to format a number from within CodeCharge so am just passing this on.. In the \"show\" event option of a form...indicate fldFIELDNAME = formatcurrency(fldFIELDNAME,2) or fldFIELDNAME = formatnumber(fldFIELDNAME,2) (I believe formatnumber is the correct function name) For example, for field Annual_Salary...the generated ASP code creates a varible... fldAnnual_Salary so to format that to display in your form with currency format , two places.. then in the Event-Show put fldAnnual_Salary = formatcurrency(fldAnnual_Salary,2)   Now...I know I can go into the generated html code and right/left/center align the resulting form fields...but has any have any suggestions as to how to put that into CodeCharge and have it generate the appropriate code ?   Thanks,  Ken Hardwick Norman,OK','2001-02-23 13:23:59','2001-02-23 13:23:59',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (242,228,228,'Re: Re: Description for code separation ASP templa','Tony','That description is the same on top of the page. It is very cryptic. Is there any documentation describing the method calls?  Tony','2001-02-23 14:24:07','2001-02-23 14:24:07',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (243,NULL,NULL,'PHP/mySQL ?',NULL,'I am trying to use CodeCharge to develop web applications in PHP4 to run on an Apache server with mySQL. Will CodeCharge actually create the mySQL database on my server or do I have to do that myself. I generated one of the samples (YellowPages) and then FTP''d the generated code to my server. I get an error that the database doesn''t exist. I set up the database as mySQL on my server and tested the connection. I selected the myODBC driver but I am still confused. It looks like the application would work on my server if the database was created with the proper structure, but I can''t find how to create the database. What am I doing wrong?','2001-02-23 17:24:53','2001-02-23 17:24:53',6);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (244,NULL,NULL,'removing generated my codecharge',NULL,'Is it possible to remove the generated by codecharge tag that appears at the bottom of all the portal pages...did mine in asp....  someone let me know! thanks!','2001-02-23 18:57:04','2001-02-23 18:57:04',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (245,244,244,'Re: removing generated my codecharge','Joachim Uersfeld','This happens only with the trial-version. Purchase CC ...','2001-02-23 23:14:35','2001-02-23 23:14:35',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (246,243,243,'Re: PHP/mySQL ?','Joachim Uersfeld','CC generates no database. That''s your part.','2001-02-23 23:18:54','2001-02-23 23:18:54',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (247,243,243,'Re: Re: PHP/mySQL ?','darth','Joachim Uersfeld wrote:  >CC generates no database. That''s your part. >  I think I almost figured that part out. Too bad my trial is nearly over, I really wanted to try that feature (PHP/mySQL) out.   btw: In the bookstore example, what is that bookstore_mysql_.sql file for, and how do you use it?','2001-02-24 01:58:45','2001-02-24 01:58:45',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (248,243,243,'Re: Re: PHP/mySQL ?','gord','Where do I find the database structures required for the examples provided with CC? If I need to set up the mySQL database structure on my server first - how do I find out what needs to be set up?  Or do I just have to create the database in my SQL and CC will handle the definition of the table(s)?','2001-02-24 05:23:16','2001-02-24 05:23:16',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (249,243,243,'Re: Re: Re: PHP/mySQL ?','gord','Okay, I found the files with .sql extensions that look like scripts for mySQL etc. to create the databases. Are these supposed to be invoked  by the Generate process? Or do I have to pipe these to mySQL manually?','2001-02-24 12:44:55','2001-02-24 12:44:55',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (250,229,229,'Re: Re: Alternate Table row colors odd and even','JW','Ok, care to share the secret?','2001-02-25 06:07:14','2001-02-25 06:07:14',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (251,NULL,NULL,'Great product -- satisfied registered user',NULL,'I just wanted to let everyone know -- this is a GREAT product.  The tech support people have been extremely helpful in working through all the configuration problems I was having, and in offering help on why certain things were wrong with code and that.   Even though this product is a Version 1.0, it''s still usefull beyond my wildest dreams.  I''ve built similar things by hand and this blows those things away because of the functionality built in.  Even if the code generated doesn''t have all the features you would like, it helps shave countless hours off the production time to have code that you can then modify outside the program.   I''m very pleased with the product.   I''d recommend anyone and everyone contemplating this product to register it now.   It''s still not going to be like a \"Frontpage designer in a box\" product, but for coders who are swamped already, this is a welcome additon to our tool arsenal.    -- Bradley \"frazzeled coder\" Miller','2001-02-25 10:56:22','2001-02-25 10:56:22',5);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (252,251,251,'Re: Great product -- satisfied registered user','Ken Hardwick','I would like to \"dito\" Bradley''s comments.  Great product..great support..and I am sure even more great options as time permits.. Anyone trying to develop web pages using forms/ read/write to databases can not go wrong in using this product.  ...Ken Hardwick ...Norman,Ok','2001-02-25 11:11:00','2001-02-25 11:11:00',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (253,158,158,'Re: Windows 2000 Connection Error','Sonny Salazar','This is still a problem!!','2001-02-25 18:18:12','2001-02-25 18:18:12',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (254,NULL,NULL,'tutorials status.... when?',NULL,'Need the promised tutorials to be able to sell this product.  When will it be posted?','2001-02-25 22:43:17','2001-02-25 22:43:17',3);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (255,NULL,NULL,'What are the Layout Design abilities like?',NULL,'Hey,  I just downloaded this yesterday after stubling across it looking for PHP4 source for my server.  Reading the ''blurb'' on the site it seemed a good thing, and reading that review of it it seemed like a good thing, but at initial impressions (about 45 seconds glimpse at the samples) it does sem very bland and limited in the Design and Layout features.  How good are these features compared to Dreameaver Ultradev 4? How well do the two work together?  I''m designing for IIS4/ASP 2 right now but bulidng my linux server I''m looking at PHP too, thus I''d like a good Layout/Design front end or pretty damn good interoperability with Dreamweaver.  Cheers  Mark Napper','2001-02-26 02:12:54','2001-02-26 02:12:54',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (256,240,240,'Re: Logged in user','CodeCharge','Use Session(\"UserID\") to get it.','2001-02-26 02:55:56','2001-02-26 02:55:56',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (257,255,255,'Re: What are the Layout Design abilities like?','CodeCharge','First I must say that CodeCharge is more code generator than design tool. But we''ve provided it with good ways of communications between  web designers and web developer.  1) Scripting code and html code can be separated one from another via template mechanism. This let designers do their job while developers make some modifications to code. 2) If you want to edit some code you can tie it up to your favourite design tool right in CodeCharge. A lot of CodeCharge users edit their files in DreamWeaver. 3) Sometimes outer editing of UltraDev code may bring disasters , while CodeCharge generated code is clean and easily understood. Besides, We support flexible and convinient way of adding new code through our \"Events\" mechanism. This way you will be more concentrated on your tasks, than on searching where on earth to insert your code.  We''re planning to add more support in CC for such things.','2001-02-26 04:42:46','2001-02-26 04:42:46',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (258,NULL,NULL,'PHP 4.0 with HTML Templates',NULL,'I have downloaded the product yesterday only and was able to generate useful files with 24 hours. Its a great tool  I am able to work with PHP 4.0 type of files but when I generate the same with template option it gets generated but I am not able to see HTML Files connecting to php files when running the site in browser  My configuration is as under  Win 2000 IE 5.5 IIS 5  How to connect the template files with php files?  Even the downloaded source code gives same result on my machine  Could you add more documentation on templating  Regards  Ajit','2001-02-26 05:10:17','2001-02-26 05:10:17',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (259,229,229,'Re: Re: Re: Alternate Table row colors odd and eve','Jeff Held','Look in the ASP code for the page with your table.  Find the area that replaced the html parameter in the HTML file for that page.   You will see a while loop.  What I did was double the code in the while loop.    Then add a row in each that repaces another parameter that I inserted in the html page:  SetVar \"color\", ToHTML(\"#whatcoloryou want\")  So when it spits out each row of data, it also sets the color for the row.  Jeff Held','2001-02-26 05:34:10','2001-02-26 05:34:10',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (260,251,251,'Re: Great product -- satisfied registered user','Jeff Held','I purchased as well.  I think that this company has the best shot at making a great application tool.  It is the best I have seen since Drumbeat-2000.    Jeff Held JRH Productions, Inc.','2001-02-26 05:53:14','2001-02-26 05:53:14',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (261,NULL,NULL,'Naming a form to react on',NULL,'Hi I need to name a form. In the the onchange() event of a Listbox I call a function called changeMake(). Within this function I coded document.<formname>.submit();  But CC do not named its controls! Wy? I need this stuff to create a advanced search-form with listboxes depending on values on other listboxes.  How can a do it? Any ideas are welcome..  Regards Peter Roth','2001-02-26 06:17:38','2001-02-26 06:17:38',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (262,261,261,'Re: Naming a form to react on','CodeCharge','CC does name it''s controls. You can set their \"Name\" attribute (both for fields and forms),  and it''ll be control''s name. If there are still no named controls, that''s weird . Anyways try regenerate site, if no dice , then send email your .ccs file to our support.','2001-02-26 07:01:27','2001-02-26 07:01:27',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (263,261,261,'Re: Re: Naming a form to react on','Peter Roth','Hi In CC I typed in a name \"SEARCH\" for the form name. Then I asume that in the generated HTML-Site the form becoms the name \"SEARCH\" as a name= attribute in the <FORM ....>-Tag. But it isn''t still there.  The code below shows a part of the generated site. I get it by show-source!  <table>   <tr>    <td valign=\"top\">    <form method=\"POST\" action=\"SellerLoB.php?\">     <table>      <tr>       <td colspan=\"2\"><a name=\"Search\"><font >Suchen</font></a></td>  As I analyse the code I saw, that one cell is named Search. But this is not what I expect.  Regards Peter','2001-02-26 13:21:02','2001-02-26 13:21:02',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (264,251,251,'Re: Re: Great product -- satisfied registered user','Jesus Torres','There is no doubt that CodeCharge has found a unique place in my arsenal of tools to develop data driven Websites.  Thanks for a great product and great support.  I look forward to new releases with added functionality.  Jesus Torres El Paso, TXKen Hardwick wrote:  >I would like to \"dito\" Bradley''s comments.  >Great product..great support..and I am sure >even more great options as time permits.. >Anyone trying to develop web pages using forms/ >read/write to databases can not go wrong in using >this product. > >...Ken Hardwick >...Norman,Ok >','2001-02-26 13:24:56','2001-02-26 13:24:56',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (265,NULL,NULL,'JOINING IN CODECHARGE',NULL,'This is a great product but will be more useful if it allows join for list on the basis of multiple fields. At present it allows join only on primary key having one field and this puts lot of restrictions in complex design  Can I expect that this facility would be extended in future versions?','2001-02-27 06:35:48','2001-02-27 06:35:48',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (266,NULL,NULL,'ASP - Marking records with a date',NULL,'I have a situation where when I save a record using a form, the ASP fills a hidden input with the ''=Date()'' function, and sends it to the SQL Server database. This obviously allows me to know when the item was added.  Now what I would like to do is when you''re editing the record, if you apply a status of ''Closed'' from the Status listbox and save the record, I want the system to mark the time it was marked closed in a similar fashion. But I can''t figure out how to do it with CodeCharge.  Any ideas?','2001-02-27 08:36:06','2001-02-27 08:36:06',4);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (267,NULL,NULL,'ASP - Email Notification',NULL,'Does CodeCharge have any email notification capabilities built in, or is this something you have to drop in post-CodeCharge?','2001-02-27 08:46:16','2001-02-27 08:46:16',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (268,265,265,'Re: JOINING IN CODECHARGE','CodeCharge','Yes , we are adding this feature in the next version.','2001-02-27 07:56:02','2001-02-27 07:56:02',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (269,265,265,'Re: JOINING IN CODECHARGE','CodeCharge','Yes , we are adding this feature in the next version.','2001-02-27 07:56:02','2001-02-27 07:56:02',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (270,267,267,'Re: ASP - Email Notification','CodeCharge','Basically CodeCharge doen''t have built-in email capabilities, but that''s not the point. Please take a look at Tell-A-Friend example and see how easy it is to send email from CodeCharge. Just cut-and-paste code from there.','2001-02-27 09:26:38','2001-02-27 09:26:38',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (271,251,251,'Re: Great product -- satisfied registered user','Volker Wawer','I agree to Bradley''s comments. A great product! Since months I am looking for a product \"between\" Frontpage and Visual-Interdev. CC matches this requirements. I am sure there are more features \"behind\" the scene. Therefor it is necessary to have a better documentation about this covered things (events, parameters etc.)','2001-02-27 09:45:53','2001-02-27 09:45:53',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (272,NULL,NULL,'Newsgroup or Discussion?',NULL,'Today the newsserver is down?  I see there are much more threads in the newsgroup then here in the discussion. But many threads are in both directories.  CC what do you think what we should use? I am not happy to drilldown both to look for information  Volker','2001-02-27 11:31:30','2001-02-27 11:31:30',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (273,251,251,'Re: Great product -- satisfied registered user','Paul','I''m not big on RA-RA posts; but then I haven''t  come across a product I felt deserved it in a long time.  Not until now that is.  CodeCharge is doing  for me what others just promised.  The product is  very nice thats true but beyond that the guys that  stand behind it are what really makes a complete  package for me.     The people that are behind this package seem to have their heads in the right place.  I''m sure they won''t  object to getting rich, but they seem determined to  give their customers the very best product and service for a very resonable price.  Now don''t just blow  past that word \"SERVICE\".  In this day and time it''s really raer to get both a good product and good  service.    CodeCharge Guys your tops in my book! Keep up the  good work  Paul','2001-02-27 11:35:02','2001-02-27 11:35:02',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (274,272,272,'Re: Newsgroup or Discussion?','CodeCharge','Please use forum for the time being.','2001-02-28 00:51:17','2001-02-28 00:51:17',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (275,266,266,'Re: ASP - Marking records with a date','CodeCharge','You can open Form properties , Event tab ,select insert event , and enter similar code (suppose your  listbox name is \"mystatus\"): if fldmystatus=0 then fldtimeclosed=''now()'' Note : 0 - is value of closed , or use your value. It all will be done right before insertion. In the next upgrade of CodeCharge we''re planning to add \"BeforeInsert\" and \"AfterInsert\" events. If you''re using some powerful sql server, you could do this using triggers.','2001-02-28 00:53:53','2001-02-28 00:53:53',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (276,NULL,NULL,'Error in Join Tab of Fieldprop.Window',NULL,'Hi all... I get an error when I define a Join within the Join-Tab in Field Properties window.  table: categories 	categorie_id 	parent_catid 	categorie_desc  grid-form: field 1:	categorie_id	 		url with link to the edit form field 2:	categorie_desc 		label field 3:	parent_catid 		label with the join to the categories table primKey=categorie_id showing=category_desc  I get an error like this:  ----begin----- Database error: Invalid SQL: select c.category_desc as c_category_desc, c.category_id as c_category_id, c.parent_catid as c_parent_catid, c1.category_id as c1_category_id, c1.category_desc as c1_category_desc from categories as c, categories as c where c.category_id=c.parent_catid order by c.category_id Asc MySQL Error: 1066 (Keine eindeutige(n) Tabelle/Alias: ''c'') Session halted. ----end  What happens now is: as I select again the categories table as a lookup CC generates an alias for both tables. And in this case the alias was create as a \"c\". This creates the error because the alias isnt unique.   The solution can be: CC has to create aliases with a number as suffix e. g. .... from categories as c1, categories as c2. With this the alias will be unique and no error occurse.  As an enhancement to the join tab. It should be very helpful to define additional where clause. Or to provide a textbox to define the sql - statement itself. This field can be placed in addition to the \"List Of Valus\"-Textfield   Kind Regards and I looking forward for any feedback  Peter Roth software solutions, switzerland','2001-02-28 04:12:07','2001-02-28 04:12:07',3);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (277,NULL,NULL,'ASP.NET',NULL,'When ASP.NET Codecharge inclusion is scheduled ? Can I get beta version with documentation for testing ?','2001-02-28 04:43:12','2001-02-28 04:43:12',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (278,204,204,'Re: One Key Two Fields','Volker Wawer','Use a view instead of the original table where you merge the Fields. I am not sure that it works with access (View = Query) In SQLserver it works.  Volker','2001-02-28 05:57:22','2001-02-28 05:57:22',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (279,NULL,NULL,'Width of Grids in Columnbar Layout','AJIT DIXIT','Is there any way to control width of grids in different forms placed under one column in columner Layout ? I want that all grids in one column of columner layout to look of same width How can I achieve this?','2001-02-28 05:58:01','2001-02-28 05:58:01',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (280,243,243,'Re: Re: Re: Re: PHP/mySQL ?','Kevin Donnelly','I posted this note earlier to one of the 3 systems CC has been using for community input (!), but to save you looking for it I attach it again below.  Basically, you need to set up the databases separately - CC generates only references to them.  In most of the project folders under codecharge/examples, you will find short text files (viewable with Notepad) ending in _MySQL.sql.  First, you need to create the database.  At an MS_DOS prompt (Windows) or in a terminal (Linux) enter:     mysqladmin [-u username -p password] create \"project\"  You may need to be in mysql\\bin in Windows, depending on how your path is set up. The username and password in square brackets will be required if you have set up users - on a default installation they will not be necessary (though should you be using a default installation ...?). The name \"project\" should be whatever is relevant to the project (eg bugtrack).  You should get a message like \"Database \"project\" created\".  The next step is to use the .sql scripts mentioned above to create the table structure in the database, and populate it with some test data.  The .sql scripts are set up so that they will drop any tables already in the database (the series of DROP TABLE statements can be seen at the beginning of the .sql text file), and recreate them from scratch.  If you do not have such tables, the population process will stop with an error message: \"Unknown table ''whatever'' \".  So for first-time use you need to comment out the DROP TABLE lines in the .sql script by typing a # at the beginning of the line.  Save the amended file.  Then, at the same MS_DOS prompt (Windows) or in a terminal (Linux) enter:     mysql [-u username -p password] project < project.sql  The name \"project\" should be the name of the database you set up earlier, and \"project.sql\" should be the name of the .sql script you are using. You will have to precede \"project.sql\" with the full path (eg C:\\codecharge\\examples\\project) in Windows.  In Linux, it''s easiest to be in the directory where the .sql file is.  You can check the creation of the database by entering:     mysql [-u username -p password] and then     use project You can then use     show tables; and     explain [tablename] to look at the database structure.  You can then use MyODBC to connect to the database you have created, and use that as the source for the pages you build in the app.  Hope this helps.  Kevin','2001-02-28 07:46:57','2001-02-28 07:46:57',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (281,NULL,NULL,'Error 405 Method not allowed','Steve','While trying to search a simple Access database, I get the following error after executing the search command.  Any guidance?  405 Method Not Allowed  The method specified in the Request Line is not allowed for the resource identified by the request. Please ensure that you have the proper MIME type set up for the resource you are requesting.','2001-02-28 08:47:58','2001-02-28 08:47:58',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (282,NULL,NULL,'Lookup SQL on list box field','Tony Gambee','how do I use this?  I want to only show records with a foreign key that matches a field passed to the form.  for example, a field passed to the form is OrganizationID  I want my list box to show all companies with organizationID=<value passed to form>  what is the syntax for this?','2001-02-28 11:41:50','2001-02-28 11:41:50',3);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (283,266,266,'Re: Re: ASP - Marking records with a date','Imranz','Tried this solution on both the Insert and the Update event, but it doesn''t seem to work. Am I missing something?','2001-02-28 13:57:08','2001-02-28 13:57:08',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (284,266,266,'Re: Re: Re: ASP - Marking records with a date','Peter Roth','Hi  Did you tryed to define the hidden field as a label? I''m not sure but I think hidden field would not be updated!  Regards Peter Roth software solutions, switzerland','2001-02-28 23:27:30','2001-02-28 23:27:30',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (285,276,276,'Re: Error in Join Tab of Fieldprop.Window','CodeCharge','Please tell us what pattern you''re using and your CodeCharge version. Thanks!','2001-03-01 00:21:19','2001-03-01 00:21:19',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (286,276,276,'Re: Re: Error in Join Tab of Fieldprop.Window','Peter Roth','Hi  I''m using CC 1.0.103 with pattern php4 & templates  Regards  Peter','2001-03-01 01:31:27','2001-03-01 01:31:27',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (287,276,276,'Re: Re: Re: Error in Join Tab of Fieldprop.Window','Peter Roth','Oh -  The field is defined as a label-field!','2001-03-01 01:34:28','2001-03-01 01:34:28',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (288,282,282,'Re: Lookup SQL on list box field','CodeCharge','Use form''s \"Input\" tab in CodeCharge. There you can specify input parameters and how they affect form''s resultset','2001-03-01 02:55:41','2001-03-01 02:55:41',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (289,NULL,NULL,'Stored procedure with CC','Volker Wawer','I have a form with a field I_CPU_ID In the events under \"Delete\" I want call a stored procedure named sp_CPU_DEL which has an input parameter CPU_ID and an output parameter ROWS.  To call the procedure is no problem sSql \"exec sp_CPU_DEL\"  How can I pass the parameter from the form to the procedure?  How can I return the parameter back to the form?   Thanks for any help  Volker','2001-03-01 02:57:53','2001-03-01 02:57:53',3);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (290,NULL,NULL,'Uploading files?',NULL,'with CC is possible uploading files, whit COM component, SA-FileUP or ASpupload... (Platform: IIS + ASP + MSSQL)  Luca from Italy','2001-03-01 05:42:03','2001-03-01 05:42:03',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (291,282,282,'Re: Re: Lookup SQL on list box field','Tony Gambee','Let me clarify.  I''m fine with what you suggested already.  here  is the setup  1st form: a list of organizations. 2nd form: organization details. one field is a  list box, I only want to show records from the  address table: in the address table there is a primary key,  addressid, and a foreign key organizationid,  I want to only show addresses where  organizationid equals the organizationid that  I already use to only show that one organization  record.','2001-03-01 07:26:55','2001-03-01 07:26:55',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (292,289,289,'Re: Stored procedure with CC','German','Hi, try this:  sSql = \"exec sp_CPU_del(\" &_ \"''\" &getParam(\"field1\")& \"''\" &_ \"''\" &getParam(\"field2\")& \"''\" &_ \"''\" &getParam(\"field3\")& \"'')\"   cn.Exec(sSQL)  cn is the name of the object that opens the connection  German','2001-03-01 09:46:31','2001-03-01 09:46:31',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (293,NULL,NULL,'Default Value from input variable',NULL,'I would like to make the default value of a field on a record to be equal to that of a input variable.  is that possible?  is so, how?','2001-03-01 11:48:53','2001-03-01 11:48:53',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (294,289,289,'Re: Re: Stored procedure with CC','Volker Wawer','Thank you very much! I have tried - this works:  sSQL = \"exec konfig_KUCPU_DEL \"& GetParam(\"PK_I_KUCPU_REFID\")  Perhaps you know how to use a output parameter from a SP (e.g. I get the @@IDENTITY back) How can I put it on a formfield?  Best regards  Volker','2001-03-01 12:03:04','2001-03-01 12:03:04',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (295,289,289,'Re: Re: Re: Stored procedure with CC','German','ok! if you use the cn connection object if you getback the identity... in your sp you must have insert ....... id = @@INDETITY select id  in your connectio it will be... cn(\"id\")  try...!  German','2001-03-01 12:51:00','2001-03-01 12:51:00',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (296,158,158,'Re: Windows 2000 Connection Error','hari','I believe you have a missing or an an incorrect ODBC data source on your machine. Please install Microsoft / Oracle ODBC drivers, configure correctly and connect using ODBC connect tool before trying CodeCharge.','2001-03-01 17:09:44','2001-03-01 17:09:44',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (297,290,290,'Re: Uploading files?','JY','Simply purchase ASPUpload to enable file upload in your website.  JY from HongKong','2001-03-01 20:46:33','2001-03-01 20:46:33',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (298,73,73,'Re: Re: PHP Code -- problem?','Mariano Debiazzi','Is there a way to fix this? pls reply to mariano@faronet.com','2001-03-01 23:27:01','2001-03-01 23:27:01',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (299,NULL,NULL,'Blob Upload and entry to database',NULL,'Is this possible, to upload an image and store it in a database via codecharge generated code?  thanks','2001-03-02 01:16:38','2001-03-02 01:16:38',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (300,299,299,'Re: Blob Upload and entry to database','CodeCharge','Currently CodeCharge itsef doesn''t generate such code , but you can easily add a few your own lines of code handling upload inside codecharge (Page/Events,Form properties/Events). Personally I''d recommend you to store images filesystem.','2001-03-02 02:26:44','2001-03-02 02:26:44',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (301,293,293,'Re: Default Value from input variable','CodeCharge','You don''t need to do anything , it''s deafault behavour of CodeCharge , when newly inserted field is assigned input variable value. Don''t forget to specify in \"Input\" tab DB field that is connected with input variable.','2001-03-02 03:08:11','2001-03-02 03:08:11',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (302,282,282,'Re: Re: Lookup SQL on list box field','Tony Gambee','nobody understands...  I want the values in a listbox to be limited based on a variable.  ie  pk  type    fk 1   hot     999 2   cold    999 3   medium  777 4   boiling 777  only show records with 999 in fk in the list box.','2001-03-02 05:51:20','2001-03-02 05:51:20',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (303,254,254,'Re: tutorials status.... when?','CodeCharge','try  http://www.codecharge.com/download/files/Tutorial.zip','2001-03-02 09:58:22','2001-03-02 09:58:22',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (304,49,49,'Re: Tutorials, help update, when?','CodeCharge','here it is http://www.codecharge.com/download/files/Tutorial.zip','2001-03-02 10:00:37','2001-03-02 10:00:37',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (305,266,266,'Re: Re: ASP - Marking records with a date','Imranz','No matter what I do, I can''t seem to get the form to dump in the value of the date.  Just to be clear, I am on a page that handles updates to a record. I change the status from one value to ''Closed''. When I submit, I want it to see that my status field has a value of Closed, and thus write =Date() to the DateClosed field. The suggestions thus far don''t seem to work at all. Am I being clear with my description?  Thanks.','2001-03-02 13:00:22','2001-03-02 13:00:22',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (306,254,254,'Tutorial - corrected web address','Ken Hardwick','I keep try the web page indicated but finally noticed that the \"r\" was left out of codecharge so to save others same frustration..the address is: http://www.codecharge.com/download/files/Tutorial.zip not http://www.codechage.com/download/files/Tutorial.zip','2001-03-02 13:21:46','2001-03-02 13:21:46',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (307,NULL,NULL,'Demo Version will not work...why?',NULL,'I downloaded a copy this evening and keep getting an error:  429 ActiveX component can''t create object%  I am using Win98 with a 600 MHz P3 chip and 256 MB RAM  What gives? I have tried reinstalling and get same result','2001-03-02 16:51:26','2001-03-02 16:51:26',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (308,NULL,NULL,'Wish List..Respectfully..',NULL,'Hi all,  This product is the absolute most wonderful dev tool I have in my arsenal. It is cought between a WYSWYG and a raw db Editor.  The team did an excellent job on this and is sure to have gotten the attention of some bug players-whos company names begin with an \"M\".....  A satisfied Trial User with his Credit Card ready to \"Swipe\"  Peace All...stay good to the CC team who makes your DevLife easier  !!','2001-03-03 00:09:41','2001-03-03 00:09:41',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (309,308,308,'[Erase Me !! CC] TeamRe: Wish List..Respectfully..','JGutierrez','this can be erased as I made an error in submitting the message I would like to see posted has another timestamp later than this on  Thank You JGutierrez','2001-03-03 00:16:59','2001-03-03 00:16:59',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (310,NULL,NULL,'Just a thought..',NULL,'Hi all,  This product is the absolute most wonderful dev tool I have in my arsenal. It is cought between a WYSWYG and a raw db Editor.  The team did an excellent job on this and is sure to have gotten the attention of some bug players-whos company names begin with an \"M\".....  A satisfied Trial User with his Credit Card ready to \"Swipe\"  Peace All...stay good to the CC team who makes your DevLife easier  !!','2001-03-03 00:09:41','2001-03-03 00:09:41',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (311,NULL,NULL,'Wish List..Wants Your Entry !!!',NULL,'Hey All ,  I do have a few wishes for this list -   1) a built in FTP client, (next to the blue globe ) preview in browser button.  2) a way to manage each field in the properties dialogue an a global scale..ie; the local publish folder/dir and remote host address..currently set to default.  3)Have the text editor built in rather than open up a new window..have the option to open in new window or do the editing in the palette window on the right. (Similar to the Cold Fusion Studio) where the tabs are at the top..  4) Have as many users contribute template, examples and complimentary components. like the Macromedia Exchange...:)  5) a built in dbase creator,  create table, edit table grid etc....I know that may be asking a whole lot but hey what can I say..:)  6) a built in bug tracker/submission under the help drop down menu.  7) a server to client file manager \"window\" to the left bottom of the CC work area. similar to CF Studio.  This is sure to go mainstream if we can collaborate among eachother,,,  Peace All and again keep this running it will shed some light on the awesome CC team !!!  Thank You  Joe Gutierrez Rosemead, CA.','2001-03-03 00:20:10','2001-03-03 00:20:10',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (312,NULL,NULL,'Data Validation in text boxes',NULL,'is there a way to make codecharge detect or force capital letters in text boxes ?    Thanks in advance','2001-03-03 01:24:59','2001-03-03 01:24:59',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (313,NULL,NULL,'MSAccess',NULL,'Hi There I cannot open the MSAccess files with Outlook97 Access version. Do I need 2000?  Then I keep getting an error when I try to run the website Forum Sample. I get an error: ADODB.Connection error ''800a0e7a''   ADO could not find the specified provider.   /cc_forum/Common.asp, line 30  WHile the *.mdb file is in the path (stated in common.asp)  any advise?  thanks Paul','2001-03-03 05:44:15','2001-03-03 05:44:15',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (314,NULL,NULL,'USE OF SESSION VARIABLES',NULL,'How can I use Session Variables as part of SQL Query in Codecharge in PHP Can I Register my own session variables?','2001-03-03 12:05:26','2001-03-03 12:05:26',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (315,307,307,'Re: Demo Version will not work...why?','Jeff Held','I have been thinking this when I started inspecting the code the program generates...  I see the filesystemobject being use and I don''t think PWS supports that.  I develop on a Win2000 box so I have not got a chance to try it....but that may be your problem.  Jeff Held','2001-03-03 13:59:49','2001-03-03 13:59:49',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (316,290,290,'Re: Uploading files?','Popee','Here''s a very nice ASP upload page.  Oh and it''s free!  http://www.planetsourcecode.com/xq/ASP/txtCodeId.6224/lngWId.4/qx/vb/scripts/ShowCode.htm  HTH;  Popee','2001-03-03 16:44:05','2001-03-03 16:44:05',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (317,NULL,NULL,'MS SQL 7 connection',NULL,'How can I connect to a remote SQL Server 7?  I try to enter the IP address in the Database Tab Properties but it doesn''t seem to find it.  I don''t have a SQL Server running on the machine that I have codecharge installed on so how does one get the Database stuff from a remote machine?','2001-03-04 00:19:11','2001-03-04 00:19:11',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (318,317,317,'Re: MS SQL 7 connection','JGutierrez','Good Day,  You must first setup a DSN on your workstation to connect to a remote MSSQL server,  Control Panel> ODBC Editor. After you setup and configure your ODBC connection,.  In Code Charge you must select Microsoft OLE DB Provider for ODBC > Next> 1. Specify the data source name 2. Enter the database login UN and PW  or  sa and no password.  3. Select your default catalog/db to use exapmle \"Bookstore\"  Hope this helps. Peace JoeyG','2001-03-04 01:33:33','2001-03-04 01:33:33',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (319,NULL,NULL,'Some Major Bugs',NULL,'As I am working on this tool , more and more I fell in love but let me report some major bugs and some of the suggessions   My working environment: Development Windows 2000 Mysql PHP Latest Deployment  Linux Redhat Mysql PHP Latest  1.In menu form try to add the input parameters and then delete the same, the tool crashes.  It doesnot even ask for saving the existing work and all work from last save is lost  2.The mailing lists it is claimed as under   when you are passing parameters to a record form for inserting a record and map the fields to parameters in the input form then it takes care of default values while inserting a record  It happens only for Session variables and not for the parameters  There is no wat you can register session variables while sending parameters  Hence lot of programming restrictions when making header / detail forms.  Also while sending parameters the variables are prefixed with pre in the generated code and while reading value in the record form it assumes that the variables are transferred by the forms post action (trn prifix)  Can we have values defaulted at the time of insert based on mapped parameters?  Can we register our own session variables for better control ?  how can we use the parameters and session variables in SQL for form and for populating list boxes?  Can Codecharge place some serious example of using events in PHP?  Thanks  Ajit Dixit','2001-03-04 06:39:06','2001-03-04 06:39:06',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (320,NULL,NULL,'Acknolegment form',NULL,'I have a Record Form. After a insert, i would have a form with a text like \"you have created the X code\".  X is an autoincremental key.  Is there a mean for that ??  Thanks  I apologize for my english ... it''s easier to re','2001-03-04 09:14:31','2001-03-04 09:14:31',3);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (321,NULL,NULL,'Acknolegment form',NULL,'I have a Record Form. After a insert, i would have a form with a text like \"you have created the X code\".  X is an autoincremental key.  Is there a mean for that ??  Thanks  I apologize for my english ... it''s easier to re','2001-03-04 09:14:31','2001-03-04 09:14:31',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (322,NULL,NULL,'Evaluation Period had expired',NULL,'I downloaded evaluation copy from ZDNet and I installed it but when I try to run it. it was give me window with this text: Evaluation Perioed had expired','2001-03-05 00:05:55','2001-03-05 00:05:55',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (323,NULL,NULL,'Some More Bugs',NULL,'I have noticed some more bugs. Let me report the same for correction in future versions  1.Tree form wizard if used to create data entry form , while inserting a record it does not update parent_id field. This is because this field is passed as parameter to record form and parameters are not updating the defaullt value even if they are properly mapped in the input forms. Only session variables are considered  2.if you have table with parent id field(which is required for tree forms) and you want to display the label text of parent field in grid form giving join parameters , the mysql query fails as lable join parameters do not use different query  e.g If you have a table as under  Employee_Id Employee_Name Reporting_To  The reporting to is parent field Id you construct a grid as under  Employee Name Reporting To (Lable with join lookup in same database)  This creates errorprone sql statement   Thanks  Ajit Dixit','2001-03-05 01:23:36','2001-03-05 01:23:36',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (324,NULL,NULL,'Connection problems',NULL,'I am very enthusiastic about this product, but there are some issues that concern me.  Mainly, we are having serious problems connecting to both MS Access 97/2000 and MySQL. All drivers are in place, the connection is fine when tested, but when browsing generated pages we ALWAYS get an error, like:   Fatal error: Cannot redeclare class db_sql in ./db_mssql.inc on line 13  Asd stated in this forum, we should edit the file to avoid redeclaration of the class. Doing so, it results in the following run-time errors:  Category  Warning: Can''t connect to MySQL server on ''localhost'' (10061) in db_mysql.inc on line 73  Database error: pconnect(, , $Password) failed. MySQL Error: () Session halted. Warning: open(/tmp\\sess_754a6bc806901d042090dfc56cad2648, O_RDWR) failed: m (2) in db_mysql.inc on line 0  Warning: Failed to write session data (files). Please verify that the current setting of session.save_path is correct (/tmp) in db_mysql.inc on line 0  Please note that this code was generated for PHP and MS Access, and we get a MySQL error.   Please make the database connection setup easier, or remove the bugs, we have now spent 3 whole days trying to get this package to work properly, on Win95, win98 and Win2000, with both Access 97, Access 2000 and two versions of MySQL.   I am sure that this tool is excellent for RAD, but the reason I want to use it is that I am completely blank on MySql and PHP. Therefore I have absolutely no chance of correcting these errors myself.  A tip might be to make a step-by-step tutorial, more detailed than the user manual, to help new users connect properly to Access and test the examples.  Please advice.','2001-03-05 01:54:13','2001-03-05 01:54:13',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (325,NULL,NULL,'TREEVIEW PROBLEM',NULL,'When you create treeview forms , it allows you to create record only at last node and to if it is empty  The insert of middle level grids is suppressed even if the insert tag for gris form properties is checked  Can this be rectified in future versions?  Regards  Ajit Dixit','2001-03-05 02:10:23','2001-03-05 02:10:23',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (326,313,313,'Re: MSAccess','CodeCharge','Download and install on your server MDAC update from  http://www.microsoft.com/data/download_260rtm.htm','2001-03-05 02:45:50','2001-03-05 02:45:50',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (327,322,322,'Re: Evaluation Period had expired','Javier','I downloaded directly from codecharge.com and tried it in 2 PC (one with win2k and the other with WinMe).  I got the ''Evaluation Period had expired'' in both machines.  Please try to solve this.','2001-03-05 05:33:47','2001-03-05 05:33:47',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (328,254,254,'Re: Re: tutorials status.... when?','jims','not available as of 3/5/01.','2001-03-05 06:39:37','2001-03-05 06:39:37',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (329,324,324,'Re: Connection problems','CodeCharge','1) in php_ini file find line session_save_path set it''s value to some existing directory , eg  c:\\windows\\temp 2) in php.ini either disable option auto_perpend_file','2001-03-05 07:36:30','2001-03-05 07:36:30',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (330,323,323,'Re: Some More Bugs','CodeCharge','Please tell me your full version of CC. E.g 1.0.103. Tell me also what language pattern you''re using to generate your files.','2001-03-05 08:47:35','2001-03-05 08:47:35',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (331,320,320,'Re: Acknolegment form','CodeCharge','it depends on your database. for istance you could use \"After insert\" event and enter some code for calculation of list insert key (it''s database dependent) :  set rs = cn.execute (\"select max(key) from table\") if not rs.eof fldmessage= rs(0) end if  if it was mysql you could write like this : set rs = cn.execute (\"select last_insert_id()\") if not rs.eof fldmessage= rs(0) end if','2001-03-05 08:53:40','2001-03-05 08:53:40',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (332,NULL,NULL,'preg_match error',NULL,'using apache, php3 version 3.0.16, mysql on my local machine.  This error occurs in Links and Portal.  Fatal error: Call to unsupported or undefined function preg_match() in ./common.php3 on line 54  Also when I try to sign in I get this error. Warning: fopen(\"/tmp/6e52c9f0c49cee6b42e2086bd16ce8cfSession\",\"w+\") - No such process in ./ct_file.inc on line 38   This program has a LOT to offer! Thanks for all the hard work you guys have put into this.','2001-03-05 19:36:44','2001-03-05 19:36:44',5);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (333,49,49,'Re: Tutorials, help update, when?',NULL,NULL,'2001-03-06 00:05:03','2001-03-06 00:05:03',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (334,332,332,'Re: preg_match error','CodeCharge','1) The problem with pregmatch shouldn''t appear in version of php 3.0.9 or higher (since it''s present in these versions). Please recheck your php version. To temporarily work around this , you can select PHP (without templates) as language pattern in Site/Properties. And CodeCharge won''t use pregmatch in this case. 2) Also when I try to sign in I get this error.  Warning: fopen(\"/tmp/6e52c9f0c49cee6b42e2086bd16ce8cfSession\",\"w+\") - No such process in ./ct_file.inc on line 38  you possibly don''t have enough rights to /tmp directory (session info is stored there) in any case , either change rights or change directory in php.ini file in section session_save_path to another dir with more rights','2001-03-06 01:38:31','2001-03-06 01:38:31',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (335,NULL,NULL,'Error: Type Mismatch',NULL,'Presently evaluating Codecharge - ''excellent piece of kit''  Everthing worked fine until i recently tried to open an example file, when all i receive is \"error: Type Mismatch\", after i click \"OK\" to clear the message box system opens up to a new blank file. Same message on files i have saved (not generated). Have tried unistalling / reinstalling - nothing works - Help!','2001-03-06 07:25:35','2001-03-06 07:25:35',6);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (336,325,325,'Re: TREEVIEW PROBLEM','CodeCharge','Please send your .ccs and .mdb file to support codecharge.com','2001-03-06 07:29:15','2001-03-06 07:29:15',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (337,NULL,NULL,'ASP - Marking a date on Update',NULL,'I''ve asked this before but to no avail...  I''ve got an Update page that has a field StatusID, which is joined to a Description field (New, Closed, etc.).  What I want to do is... When a user arrives at the update page, and changes the Status from some value to Closed, I want to automatically update another field (DateClosed) with the current date (=Date()).   Of course, it should only mark the date when it is set to closed. If another part of the record is updated later, it shouldn''t re-mark the current date because the value will remain as Closed.  I can''t figure out how to get CodeCharge to do this--it really shouldn''t be a big thing.','2001-03-06 07:45:16','2001-03-06 07:45:16',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (338,335,335,'Re: Error: Type Mismatch','CodeCharge','Please try download latest version of CC. And if you get the same error , download and  install  pathc http://www.codecharge.com/download/files/CodeChargePatch14.exe','2001-03-06 08:36:43','2001-03-06 08:36:43',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (339,335,335,'Re: Re: Error: Type Mismatch','Leslie','Thanks for the speedy reply, downloading and trying the file shortly. P.S. - Apart from registering the product via the net, is it available for purchase in the UK? Regards.','2001-03-06 09:23:52','2001-03-06 09:23:52',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (340,335,335,'Re: Re: Error: Type Mismatch','Leslie','Original version downloaded was http://www.codecharge.com/download/files/CodeCharge1_0_103.exe  Have applied the patch as advised  - still same problem. Have uninstalled / reinstalled to a different drive (c) - still same problem. Also noticed that it will alow me to import example pages in, add database .... but when generated has numerous links / actions missing.  At present i am on day 12 of my evaluation, I AM DEFINETLY interested in registering this product, but obviously not if this problem is to persist. Regards.','2001-03-06 09:38:15','2001-03-06 09:38:15',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (341,NULL,NULL,'Listing combo box items based on selected item in',NULL,'I have 2 combo boxes:    System   Subsystem  I am trying to display the list of Subsystems when I selected a System. The DB relationship is :   1 system may contain many subsystems.  I partially implemented this by clicking on the search button and passing the SYSTEMID to the search form.  Is there a better way to do this. I also need this on the Add/Edit form.  Thanks.','2001-03-06 11:16:03','2001-03-06 11:16:03',3);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (342,337,337,'Re: ASP - Marking a date on Update','CodeCharge','You should open Form properties dialog , select \"Events\" tab , open \"BeforeUpdate\" event. You can access form fields using their names prefixed with fld. You might enter code like : if flddescription=\"closed\" then flddateclosed=now()','2001-03-06 12:11:13','2001-03-06 12:11:13',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (343,332,332,'Re: Re: preg_match error','BlueEagle','I re-ran codecharge again using the php3 without templates in a different directory. I get the same  preg_match error. Re-checked php version using phpinfo() and it says it is version 3.0.16. Looking at the code I see \"function is_numeric($variable)\". I looked up is_numeric in the php manual and it say that is not supported until php4... I wish I new more about this  stuff. Can you tell me anything else to try?','2001-03-06 14:16:21','2001-03-06 14:16:21',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (344,332,332,'Re: Re: Re: preg_match error','BlueEagle','UPDATE: If I run this example from the manual on my website  under php 3.0.15: <? // the \"i\" after the pattern delimiter indicates a case-insensitive search if (preg_match (\"/php/i\", \"PHP is the web scripting language of choice.\")) {     print \"A match was found.\"; } else {     print \"A match was not found.\"; }  ?>  It prints out -  A match was found.  On my localhost using 3.0.16 I get the following  error:  Fatal error: Call to unsupported or undefined function preg_match() in  d:\\program files\\abriasoft\\abria sql\\apache\\htdocs\\portal2\\phpinfo.php3 on line 3   Does the running this on a windows sys have anything to do with this problem?','2001-03-06 16:32:30','2001-03-06 16:32:30',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (345,NULL,NULL,'Default field value to be from session variable?',NULL,'What to enter in \"default value\" of field properties in a record form to have a session variable as the default, say for example the value of Session(\"UserID\") from the login form?','2001-03-06 17:07:42','2001-03-06 17:07:42',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (346,332,332,'Re: Re: Re: Re: preg_match error','BlueEagle','UPDATE II: I have uploaded Portal, Links and Bookstore to my website using php3 and templates and they are all working perfect!!!!  I do hope you can help me get this working on my desktop set up as editing would be so much easier.  If you can do that you have a new customer!!  It took me two day to figure out how to upload the tables from the examples and to get going with this program but after I see what it can do I just love it. I have not seen anything that even  comes close. All this stuff is a hobby for me so I  am very slow at some things but this program is going to make me look like an expert. Thanks again for all the hard work you guys have put into this.','2001-03-06 18:58:55','2001-03-06 18:58:55',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (347,323,323,'Re: Re: Some More Bugs','AJIT DIXIT','Language : PHP4 with templates Codecharge Version : 1.0.103 Thanks   Ajit DixitCodeCharge wrote:  >Please tell me your full version of CC. >E.g 1.0.103. >Tell me also what language pattern >you''re using to generate your files.','2001-03-06 20:58:37','2001-03-06 20:58:37',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (348,NULL,NULL,'How to set attritute enctype in form tag?',NULL,'For uploading files is necessary set attribute enctype=\"multipart/form-data\" into tag form, is possible?','2001-03-07 01:34:23','2001-03-07 01:34:23',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (349,335,335,'Re: Re: Re: Error: Type Mismatch','CodeCharge','Leslie , please  send your email address to support@ codecharge.com , and we''ll contact you personally on your problem.','2001-03-07 03:31:14','2001-03-07 03:31:14',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (350,341,341,'Re: Listing combo box items based on selected item','CodeCharge','How did you make comboboxes ? May be you mean Listboxes ? If you have listbox with systems , you may hookup OnChange() javascript event on it , that will submit current form. For instace you can enter in Form''s Header/Footer tab : <script> document.all[\"lb1\"].onchange = formSubmit; document.all[\"category_id\"].onchange = formSubmit; document.forms[\"ads\"].elements.tags(\"INPUT\")[0].style.visibility = ''hidden''; function formSubmit() {   document.forms[\"ads\"].submit(); } </script>  In \"Before show\" events of this form enter code: if not(fldlb1 = \"\") then fldlb1where = \" where par_category_id=\" & toSQL(fldlb1, \"Number\")  And in \"List\" tab of second listobx enter  lookup sql like : select category_id, name from categories \" & fldlb1where & \"','2001-03-07 06:24:52','2001-03-07 06:24:52',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (351,320,320,'Re: Re: Acknolegment form','Bruno Folly','Thanks for your response, but i have no  After insert event. I must modify the code manually and it''s ok.  My version is 1.03, coding PHP4+Template with MySQL','2001-03-07 11:19:48','2001-03-07 11:19:48',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (352,335,335,'Re: Re: Re: Re: Error: Type Mismatch','Leslie','Email address posted as requested - reply seems a long time coming ?','2001-03-07 12:53:31','2001-03-07 12:53:31',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (353,341,341,'Re: Re: Listing combo box items based on selected','Peter Roth','Hi I''m also interested about this solution. I''m trying  to reconstruct a likely form. I named my listbox as \"lb1\" and also I inserted the script as suggested. When I go live with the page  I get the error that lb1 isnt an object. What goes  wrong?  Any Ideas are welcome  Regards Peter Roth','2001-03-07 13:21:05','2001-03-07 13:21:05',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (354,NULL,NULL,'Used Vehicle Catalog sit',NULL,'I am planing to develop a e commerce site for displaying and inquiring used cars in the net, please let me know whether this tool will help me','2001-03-07 14:36:57','2001-03-07 14:36:57',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (355,332,332,'Re: preg_match error','BlueEagle','In response to preg_match() error, I received the following email form Adam:  I search the net and found some info that this issue is specific to Windows machines. One comment was that you may fix it by loading the php3_pcre.dll in your php3.ini file.  Adam  Thanks Adam, that did the trick!  /tmp problem, codcharge replied:  \"you possibly don''t have enough rights to /tmp  directory (session info is stored there)  in any case , either change rights or  change directory in php.ini file in  section session_save_path to another dir with more  rights\"  My install of codecharge is on D:  It took me a little while to figure out that /tmp folder should be in the D:/tmp path.   I think this program will be useful to a lot of folks like me that are not programmers but just like learning all this stuff. So thats why I have posted this info, in hopes that it might save someone else a lot of time.  Looks like I am going to have to buy this now! As someone else said \"CodeCharge ROCKS!\"','2001-03-07 14:58:52','2001-03-07 14:58:52',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (356,335,335,'Re: Error: Type Mismatch','CodeCharge Support','This issue was resolved in the latest CodeCharge release at http://www.codecharge.com/download/files/CodeCharge1_0_112.exe','2001-03-07 19:55:53','2001-03-07 19:55:53',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (357,NULL,NULL,'Announcement: New version of CodeCharge',NULL,'New version of CodeCharge is now available at http://www.codecharge.com/download/files/CodeCharge1_0_112.exe Within couple days this version will be officially announced through mailings to subscribed users.  New features in version 1.0.112: Internationalization - customizable and translatable generation of standard messages (\"No records found\", \"Previous\", \"Next\", etc.\") - translation XML files are stored in directory \"...\\CodeCharge\\Translations\". Added new Page and Form Events. Added \"Modules\" section containing Global Site Events/Functions. Site Publishing - added FTP functionality for the generated code to be published directly to the external web server. Added List Of Values (LOV) for Label and URL type Fields in Record form Added documentation/help for the Events Added Event Import/Export functionality Added \"Apply to all files\" option when showing Message Box about modified files during code generation.  Changes and fixes: Optimized the generated code in Grid and Record type forms. Fixed the issue with joining the same table several times on one form. Fixed the issue of generating nulls in SQL statements for empty fields in JSP & ColdFusion (instead of \"\")','2001-03-07 19:59:36','2001-03-07 19:59:36',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (358,354,354,'Re: Used Vehicle Catalog site','CodeCharge Support','Of course. One of examples included with CodeCharge is an Online Classifieds site. CodeCharge is meant to speed up the development of websites, so it should help you. Please try it and let us know if it did :-)','2001-03-07 20:20:46','2001-03-07 20:20:46',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (359,341,341,'Re: Re: Re: Listing combo box items based on selec','CodeCharge','Please try the same method again with the latest CodeCharge version at http://www.codecharge.com/download/files/CodeCharge1_0_112.exe','2001-03-07 21:26:48','2001-03-07 21:26:48',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (360,NULL,NULL,'why always display script error??',NULL,'Would you mind to tell me why when i run the examples (for example:bookstore) when i run pages normaly i can see the fields in the from but i can see only the \"scritp error !!\" and i can not see the detail (descripts about the propertiesof  each field ) from  (for instance:admindbooks-page) why?? thanks','2001-03-07 23:12:03','2001-03-07 23:12:03',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (361,320,320,'Re: Re: Re: Acknolegment form','Bruno Folly','It''s Ok, i downloaded the new version, and it''s all good.  Thanks','2001-03-08 02:46:19','2001-03-08 02:46:19',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (362,NULL,NULL,'CC - Thanks',NULL,'Having tried virtually everything u have been dredging the net for 10yrs, it is very rare that I actually ?like? a product. Usually it?s mm,  well, ok. After downloading the trial version CC, I had a few hiccups, which in fairness to support (thanks for tolerating me) they resolved quickly and most importantly to my satisfaction.  Before I completely sound like a ?plant? for CC  - I?ve thrown the headache tablets away and am definitely going to purchase it.  Well done CC u For once someone actually DELIVERS!','2001-03-08 04:21:12','2001-03-08 04:21:12',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (363,NULL,NULL,'Code Editor',NULL,'If anybody needs a good code editor, SciTE is an excellant opensource editor based on Scintilla.  Scintilla is an open source code coloring component for C++.  http://www.scintilla.org/SciTE.html  SciTE can be intergrated with pretty much anything, and has an external API for calling SciTE functions from other applications.   It has bracket matching, syntax coloring, code folding, multiple buffers, and much more.  It supports the following languages:    Python     C/C++     IDL - both MSIDL and XPIDL     Java     JavaScript     HTML     HTML with embedded JavaScript, VBScript,     PHP and ASP     XML     INI, properties and similar     VB and VBScript     A subset of Perl     SQL     Lua     Pascal     Avenue   Wouldn''t it be great to have an editor built in directly in CC.','2001-03-08 07:02:02','2001-03-08 07:02:02',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (364,NULL,NULL,'Wish for Next Release',NULL,'If I may I would like to suggest that in a future version the ability to choose the type of sort (Ascending/Decending) would be really nice.  Just a suggestion;  Popee','2001-03-08 08:55:34','2001-03-08 08:55:34',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (365,NULL,NULL,'ASP - Querystring not carrying',NULL,'I''ve got a grid page that has a URL field that outputs an ID to the query string to an Update page. The querystring carries over perfectly, and the record appears as it should on the update page.  But then, when I update the record by clicking the update button, it''s supposed to go back to that first page, and the ID should carry in the querystring but it doesn''t. It does appear in the query string, but it doesn''t retain the value. Any ideas?  I just downloaded the new version thinking that was the issue but no dice.','2001-03-08 10:37:56','2001-03-08 10:37:56',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (366,17,17,'Re: Re: How to had MySQL connection ?','fabienne','But why can I connect to my mysql_db without MyODBC driver through localhost and it is not possible  with CodeCharge? Sorry if this is a stupid question. Fabienne','2001-03-09 00:55:01','2001-03-09 00:55:01',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (367,NULL,NULL,'Operation requires updateable query','Christian Hjortmar','After uploading my access db to my isp I could not update the database. Got the error message \"Operation must have an updateable query\". The solution in my case was to edit common.asp and change driver as seen in code below. from this code strConn = \"Provider=Microsoft.Jet.OLEDB.4.0;Data Source=d:\\inetpub\\wwwroot\\kansli\\tryckeri\\OrtSok\\postorter.mdb;Persist Security Info=False\" to this code strConn = \"Driver={Microsoft Access Driver (*.mdb)};DBQ=c:\\inetpub\\wwwroot\\katalog\\another catalog\\mycatlog\\xxxxxxx.mdb\".','2001-03-09 01:52:15','2001-03-09 01:52:15',3);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (368,367,367,'Re: Operation requires updateable query','CodeCharge','You must set read-write attributes on your .mdb file and possibly on directory containing this file.','2001-03-09 02:47:47','2001-03-09 02:47:47',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (369,367,367,'Re: Re: Operation requires updateable query','hjortmar','That is very, very correct. I did a lot of surfing to find out. Microsoft, of course has a document that explains the issue of this particular error message. But the thing is that when creating the application with codecharge, I used the JET 4 provider. I found a solution to the error message, the microsoft document did not mention ie use access driver instead.','2001-03-09 04:08:55','2001-03-09 04:08:55',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (370,360,360,'Re: why always display script error??','CodeCharge','What is your CC version , windows version, MDAC version ? What''s our IE version ? There may be some problems running CC with IE version lower than 5.00.26.','2001-03-09 08:18:05','2001-03-09 08:18:05',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (371,365,365,'Re: ASP - Querystring not carrying','CodeCharge','You should specify variable \"ID\" in  Form Properties /Input tab of your grid page. Or if you want to get this value yourself use getparam(\"your_param_name\") function.','2001-03-09 08:24:25','2001-03-09 08:24:25',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (372,NULL,NULL,'Run-Time error 429','Brandon','Run-Time error 429 \"ActiveX component can''t create object\"  I get this error when trying to generate pages via ftp  Any help would be appreciated','2001-03-09 20:11:12','2001-03-09 20:11:12',3);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (373,NULL,NULL,'CodeCharge1_0_112','Ayman','Hi I''m trying to install the latest downloadable trial version over an expired previous version, but it gives me the same \"expired\" screen.  Is there a remedy to this situation especially that I have not had the chance to test it -fully- during the trial period.  Thanks','2001-03-10 01:54:34','2001-03-10 01:54:34',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (374,NULL,NULL,'problems with php-oracle','Francis','I have a problem with php and Oracle. No data is displayed when I create a page with codecharge. But there are as many lines displayed as there are records in the Oracle database. The only problem is that codecharge seems to be unable to extract the data from the database.  I work on a server with IIS, PHP and Oracle 8.0 on it.  Thanks for your help!','2001-03-10 05:25:28','2001-03-10 05:25:28',3);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (375,360,360,'Re: Re: why always display script error??','hpguo','My ieversion is v5.5&5.5sp1 mdac=2.6(in tradition_chinese) but i don''t know what is cc?? Thank you!!CodeCharge wrote:  >What is your CC version , windows version, >MDAC version ? >What''s our IE version ? There may be some >problems running CC with IE version lower than >5.00.26.','2001-03-10 18:55:09','2001-03-10 18:55:09',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (376,372,372,'Re: Run-Time error 429','CodeCharge','Brandon, please download and install MDAC update from  http://www.microsoft.com/data/download_260rtm.htm','2001-03-11 03:43:20','2001-03-11 03:43:20',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (377,NULL,NULL,'The Examples do not open nor generate anything','Peter','Please help. Examples worked initially, they will open and generate demo sites. Now when I open any of the examples, in the CodeCharge interface nothing happens.  Your help will be highly appreciated','2001-03-11 04:34:08','2001-03-11 04:34:08',3);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (378,373,373,'Re: CodeCharge1_0_112','CodeCharge','Currently you can only either install CodeCharge on another computer or purchase it.','2001-03-11 03:46:56','2001-03-11 03:46:56',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (379,377,377,'Re: The Examples do not open nor generate anything','CodeCharge','What is your CC version ? I also suggest you to upgrade your IE, especially if it''s version is lower than 5.00.26.','2001-03-11 04:50:25','2001-03-11 04:50:25',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (380,372,372,'Re: Re: Run-Time error 429','BlueEagle','I have been getting this message when I try using  the \"FTP\" during \"Generator\". I have downloaded the MDAC as suggested and have IE 5.50.4522.1800. Everything works on PHP3  as long as I save the files to my hard drive and then upload them to my website via regular ftp. I am unable to get the cgi file to work with even MetaSearch. I have installed lots of other cgi programs that work fine. So I think I have the permissions, etc set right.Any help  with these problems would be appreciated.','2001-03-11 10:49:42','2001-03-11 10:49:42',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (381,372,372,'Re: Re: Run-Time error 429','Brandon','I downloaded the MDAC update, and still no luck. But after installing the MDAC update and it not working, I reinstalled CodeCharge and it seems to be working now.  Quick question? I can''t seem to get CodeCharge to generate & upload via ftp. Is it supposed to connect via ftp & upload, because it doesn''t even seem to be attempting to do so.  Thanks, Brandon  By the way, this program is great! I think you are on to something.','2001-03-11 12:28:59','2001-03-11 12:28:59',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (382,NULL,NULL,'Whats the best  database type to use?','Brandon','I have worked with PHP, Perl, JavaScript, etc. but not a whole lot with creating databases.  What is the easiest type to use, cheapest, most stable, etc.  Any good sites with info or tutorials out there?  Any help would be appreciated.  Thanks, Brandon','2001-03-11 12:41:52','2001-03-11 12:41:52',3);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (383,382,382,'Re: Whats the best  database type to use?','CodeCharge','I think that in your case it''s mysql  http://www.mysql.com. But if you want to use such features as embedded selects , views and transactions you can use PostgreSQL , personally I think it''s not as  reliable as mysql, when it comes to backups.','2001-03-12 01:05:11','2001-03-12 01:05:11',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (384,NULL,NULL,'Run-Time error 429','shin','Run-Time error 429  \"ActiveX component can''t create object\"   I get this error when trying to generate pages via FTPUpload.  Where is the documents using FTPUpload ? I can''t find it in Manual.pdf.  Please, let me know the method fix it.','2001-03-12 01:01:44','2001-03-12 01:01:44',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (385,NULL,NULL,'Question before purchase','J.Roels','Besides a few minor things i like the product.  I am thinking about purchasing it, but have a question. Since the current version is not completely bugfree I wonder if the comming approvements will be free. Or do you have to buy the $99 update thing.  What is and what is not covered with a normal purchase ?  Jurjen','2001-03-12 01:46:44','2001-03-12 01:46:44',4);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (386,NULL,NULL,'How to maintain TreeView Table ?','Yusuf W','Is there a sample on how to maintain (Insert, edit, delete) a Tree Table which containing : - ID - ParentID - Description Thanks in advance.','2001-03-12 02:38:18','2001-03-12 02:38:18',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (387,374,374,'Re: problems with php-oracle','marc',':)','2001-03-12 02:48:53','2001-03-12 02:48:53',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (388,385,385,'Re: Question before purchase','CodeCharge','If you buy a regular version of CodeCharge you will receive free updates to CodeCharge 1.0','2001-03-12 06:30:32','2001-03-12 06:30:32',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (389,385,385,'Re: Question before purchase','CodeCharge','All minor upgrades in versions 1.0 - 1.9 will be provided at no charge to all registered owners. However the Upgrade Subscription/Price Protection allows you not to worry about future upgrades for the next 2 years. For example we''re planning to release a more graphical version of CodeCharge within 4 months. The cost may be $199, although we''re not sure yet. In such case, the upgrade price would be $50. We do not have future upgrade policies yet, but it is very likely that you will spend more then $99 in less then 2 years if you like to use the latest version of CodeCharge and do not purchase the Upgrade Protection.','2001-03-12 06:30:32','2001-03-12 06:30:32',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (390,386,386,'Re: How to maintain TreeView Table ?','CodeCharge','Please see \"Classifieds\" example provided with CodeCharge installation. See \"Default\" page, \"Tree\" form , click form properties icon and  select \"Common\" tab to see how this tree is set up.','2001-03-12 06:40:06','2001-03-12 06:40:06',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (391,377,377,'Re: The Examples do not open nor generate anything','Anon helper','As a suggestion since I encountered the same thing, check your error message.  If it says something about the JET engine already being used, that''s your problem.  You can''t have the Codecharge project open and see the demo at the same time. When I close the project, the site becomes available.','2001-03-12 06:55:51','2001-03-12 06:55:51',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (392,385,385,'Re: Re: Question before purchase','Joe','The cost may be 9, although we''re not sure yet. In such case, the upgrade  price would be .   Could you clarify the above?  Thanks,  Joe','2001-03-12 08:54:56','2001-03-12 08:54:56',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (393,NULL,NULL,'Inventory Control','david','Do you have an example of inventory control.  I need an inventory control of software, with pictures and smart serch.   Thank you,','2001-03-12 09:34:57','2001-03-12 09:34:57',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (394,NULL,NULL,'103 to 112','Sam Chaim','Do i have to un-install version 103 to upgrade to version 112.  I am a registered user.','2001-03-12 09:51:30','2001-03-12 09:51:30',4);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (395,NULL,NULL,'ASP - Email with ID field','Needer of Help','OK, I''m sending an autogenerated CDO email when a record is entered into a database with a form. I have the CDO script working perfectly as a ''Before Insert'' event. But in the email itself, I want to put the ID of the record that was just generated. I''m trying to do this with the following code, but without luck. Any suggestions?  set RSmaxIssueID = cn.execute(\"SELECT MAX(IssueID) FROM Issues\") if not RSmaxIssueID.eof then fldIssueID = RSmaxIssueID(0)','2001-03-12 10:47:47','2001-03-12 10:47:47',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (396,377,377,'Re: Re: The Examples do not open nor generate anyt','Peter','The version of Internet Explorer is 5.00.2920  The version of CC is 1.0.103  Everything worked before.... why not now? The examples do not load on the CC interface as it did before... Even the Bugs Tutorial doesn''t work following the steps... when I want to add the fields... it is impossible.  BTW, no messages appear in any of the cases... simply it doesn do anything  Looking for help. Best regards','2001-03-12 11:51:51','2001-03-12 11:51:51',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (397,385,385,'Re: Re: Question before purchase','Pet','The cost may be 9, although we''re not sure yet. In such case, the upgrade  price would be .   Could you clarify the above?   Also is that version going to be BugFree?, will it be version number 2?  Thanks','2001-03-12 13:13:22','2001-03-12 13:13:22',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (398,NULL,NULL,'This Forum - count of replies','Svein Are Gronsund','Great product, this discussion forum is included in the examples as \"forum\".  But with less functionality.  How do you for instance add the number of replies in the default-listing?  - CC-fan Svein Are (sg@portalen.no)','2001-03-12 13:38:34','2001-03-12 13:38:34',8);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (399,398,398,'Re: This Forum - count of replies','Svein Are','Correction of email address: sag@portalen.no','2001-03-12 13:41:29','2001-03-12 13:41:29',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (400,NULL,NULL,'Some more questions before purchase!','Darryl','Hi all,  Nice product! I am a web developer with a tellecommunications company in Canada and we develop many many sites over the course of a year.  Two questions:  (i) What sort of licensing restrictions apply to CodeCharge in using it to develop third-party sites?  (ii) Assuming there is a difference, what are the costs of the various licenses?  Darryl','2001-03-12 14:39:11','2001-03-12 14:39:11',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (401,NULL,NULL,'SQL Server 2000 Connection Problem','Andy Hanas','We''re evaluating your product on a windows 2000 server running SQL Server 2000.  I''ve set the database connection using OLE ODBC with a database type of ODBC.    Initially everything works fine, but after a period of time I begin to get errors such as:  Database error: Invalid SQL: select e.employee_num as e_employee_num, e.name as e_name, e.status as e_status from employee_mst e WHERE () order by e.employee_num Asc ODBC Error: 1 (General Error (The ODBC interface cannot return detailed error messages).) Session halted.  When I re-boot, everything functions again for a period of time.  Any ideas?    This is a great product, it we can get past this problem, we''re going to purchase it.  Thanks for your help.','2001-03-12 19:42:08','2001-03-12 19:42:08',3);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (402,401,401,'Re: SQL Server 2000 Connection Problem','Volker Wawer','Why not using the original core OLEDB-Provider? The OLE-ODBC is only for backward compatibility.  best regards Volker','2001-03-13 02:45:17','2001-03-13 02:45:17',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (403,400,400,'Re: Some more questions before purchase!','CodeCharge','Darryl , there are no restrictions for  development of third-party sites with CodeCharge. Main restriction is the CoedCharge lisence lets you install it only on three computers.  If you need more, you need to buy additional licence. See http://codecharge.com/purchase/','2001-03-13 04:10:10','2001-03-13 04:10:10',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (404,398,398,'Re: This Forum - count of replies','CodeCharge','Open index page , select \"Messages\" form. Add a dummy field (don''t select database field) set field''s name to nreplies. Then click \"Form properties\" icon and select \"Event\" tab. There you must select \"Before show\" event. Type in the following code :  fldnreplies = cn.execute(\"select count(*) from messages where message_parent_id=\"&fldmessage_id).fields.item(0)  Through events you can access form fields using their names with \"fld\" prefix. cn is already open connection object.','2001-03-13 04:16:10','2001-03-13 04:16:10',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (405,401,401,'Re: SQL Server 2000 Connection Problem','CodeCharge','I''d recommend you to use Microsoft OLEDB provider for sql server. You also need to check your MDAC version , may be you need to upgrade it http://www.microsoft.com/data/download_260rtm.htm','2001-03-13 05:00:48','2001-03-13 05:00:48',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (406,395,395,'Re: ASP - Email with ID field','CodeCharge','Looks like you assign the same value to fldIssueID and CC simply ignores your insertion. think you should change the last line to : fldIssueID = RSmaxIssueID(0)  +  1','2001-03-13 05:13:43','2001-03-13 05:13:43',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (407,393,393,'Re: Inventory Control','CodeCharge','For now you only can take a look at examples provided with CodeCharge installation. Nevertheless it''s quite easy to make an application you''re talking about in CodeCharge.','2001-03-13 05:18:56','2001-03-13 05:18:56',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (408,394,394,'Re: 103 to 112','CodeCharge','Sure. You must uninstall older version in this case. Remember to backup your .ccs files.','2001-03-13 05:26:26','2001-03-13 05:26:26',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (409,401,401,'Re: Re: SQL Server 2000 Connection Problem','Andy Hanas','I loaded the lates MDAC and in the database properties tab specified a type of MSSQL.  I then get the following message when I run my generated forms  Warning: MS SQL error: Invalid parameter in DB-LIBRARY function reference. (severity 11) in ./db_mssql.inc on line 36  Warning: MS SQL: Unable to select database: locator in ./db_mssql.inc on line 36  Warning: MS SQL error: Invalid parameter in DB-LIBRARY function reference. (severity 11) in ./db_mssql.inc on line 53  Warning: MS SQL: Unable to set query in ./db_mssql.inc on line 53 Database error: Invalid SQL: SELECT employee_num FROM employee_mst WHERE employee_num =''locator'' AND password=''locator'' MSSQL Error: 1 (General Error (The MSSQL interface cannot return detailed error messages).) Session halted.  If I change the type to ODBC is seems to work ok.  Should I use ODBC or MSSQL in the database type field','2001-03-13 05:47:09','2001-03-13 05:47:09',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (410,NULL,NULL,'generator','Gad','I''ve installed the trial version. I try to generate a project but i have an error message code: 94 What is the problem ?','2001-03-13 09:08:46','2001-03-13 09:08:46',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (411,374,374,'Re: Re: problems with php-oracle','Fred','??','2001-03-13 16:41:15','2001-03-13 16:41:15',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (412,NULL,NULL,'Passing Custom Variables','Yusuf Wiryonoputro','Is it possible to pass custom variables in every pages ? Custom variable, I mean , is a variable which doesn''t have relation to any tables. For example, I need to pass \"myCustVar=3\" through some of pages using QueryString (Not using Session).','2001-03-13 16:57:12','2001-03-13 16:57:12',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (413,NULL,NULL,'ODBC or MSSQL Database Type?','Andy Hanas','On the database tab on the properties page, there is a field for database type.  There are ODBC and MSSQL types.    I''m using Sql Sever, should I be using ODBC (which works) or MSSQL (which sometimes does not - I sporadically get \"PHP has encountered an Access Violation at 73342C83\")?  Thanks','2001-03-13 18:53:32','2001-03-13 18:53:32',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (414,NULL,NULL,'how to generate *.ccs??','hpguo','Dear Sir: when i follow the sample(zb:bookstore &the new database is called test.mdb as you provide in examples) the system let me to open *.ccs but i don''t know how to it!! would you mind give me an answer?? thans a lots','2001-03-13 19:08:16','2001-03-13 19:08:16',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (415,394,394,'Re: Re: 103 to 112','Sam','Uninstalled registered version and loaded upgrade!!! Now I''m back to trial version with no time left!!!  Please help!!!','2001-03-13 19:32:30','2001-03-13 19:32:30',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (416,394,394,'Re: Re: Re: 103 to 112','CodeCharge','Usually when you install new version , it stays registered. Did you see any splash screen with  \"try\",\"activate\" buttons? Did you enter any serial numbers in new installation or CodeCharge simply installed with no questions ?','2001-03-14 03:01:55','2001-03-14 03:01:55',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (417,414,414,'Re: how to generate *.ccs??','CodeCharge','Run CodeCharge , it''ll display a dialog with files, select any file (e.g. bookstore.ccs) .Click \"OK\" button. To generate side you need either click generate button or press F9.','2001-03-14 03:18:54','2001-03-14 03:18:54',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (418,398,398,'Re: Re: This Forum - count of replies','pr','Hi How an query can be executed with PHP?','2001-03-14 03:44:16','2001-03-14 03:44:16',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (419,NULL,NULL,'Records Missing problem','Martin Orton','Hi,  I''ve got to two tables (TableOne and TableTwo)   I''ve got a Grid with Labels that is joined in TableOne from TalbeTwo. Now, If I delete a specific record in TableTwo that might be joined to TableOne to populate a Label, the entire record in TableOne does not show, not just the specific Label data. Is there a way to still show that specific record in TableOne, even though the label joined form TableTwo might be deleted (perhaps showing just a blank space for that Label data)  I also tried to add the same record to TableTwo, but TableOne still doesn''t show the required joined data in the label. So, this tells me it relies on the Primary Key (which is unique)  Any suggestions?  Kind Regards, Martin Orton martin@ebuilders.co.za http://www.ebuilders.co.za eBuilders -  Web Design, Web Hosting & Stationery Design Tel:  +27-57-217-4262 Fax:  +27-57-217-4262 Cell:  +27-83-430-0358','2001-03-14 05:01:05','2001-03-14 05:01:05',3);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (420,398,398,'Re: Re: This Forum - count of replies','CodeCharge','Use this code : $db->query(\"select count(*) as cnt from messages where  message_parent_id=\".$fldmessage_id); $fldnreplies = get_value($db,\"cnt\");','2001-03-14 04:59:44','2001-03-14 04:59:44',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (421,413,413,'Re: ODBC or MSSQL Database Type?','CodeCharge','The the one that fits your needs. Both  are suitable in your case if you have ODBC installed on the same computer as php.','2001-03-14 05:10:47','2001-03-14 05:10:47',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (422,374,374,'Re: problems with php-oracle','CodeCharge','Please download latest PHP patter files with fixes to php lib.  http://www.codecharge.com/download/files/patterns/PHP%204.0.ccp  http://www.codecharge.com/download/files/patterns/PHP%204.0%20%26%20Templates.ccp Copy them over old pattern files in CodeCharge/Patterns directory','2001-03-14 05:19:41','2001-03-14 05:19:41',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (423,410,410,'Re: generator','CodeCharge','What is your CodeCharge version number ?  (E.g. 1.0.103)','2001-03-14 05:19:25','2001-03-14 05:19:25',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (424,410,410,'Re: generator','CodeCharge','Is the project you''re trying to generate from  CodeCharge example or your own project ?','2001-03-14 05:27:23','2001-03-14 05:27:23',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (425,419,419,'Re: Records Missing problem','CodeCharge','Martin,  For this task you may write your own custom sql form this grid in \"Form properties\"/\"SQL\" tab.','2001-03-14 05:29:31','2001-03-14 05:29:31',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (426,419,419,'Re: Records Missing problem','CodeCharge','Martin,  For this task you may write your own custom sql for this grid in \"Form properties\"/\"SQL\" tab.','2001-03-14 05:29:31','2001-03-14 05:29:31',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (427,412,412,'Re: Passing Custom Variables','CodeCharge','We plan to add this feature to CodeCharge. Now you may create dummy databaseless field to \"record\" forms , and set their values through \"Events\" mechanism. You can access fields by their names prefixed with \"fld\" prefix. Like fldname , fldprice etc.','2001-03-14 05:32:22','2001-03-14 05:32:22',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (428,384,384,'Re: Run-Time error 429','CodeCharge','Please download new executable http://www.codecharge.com/download/files/FTPUpload.exe','2001-03-14 05:45:19','2001-03-14 05:45:19',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (429,394,394,'Re: Re: Re: Re: 103 to 112','Sam','>Usually when you install new version , it stays  registered.  I guess not this time!  >Did you see any splash screen with  \"try\",\"activate\" buttons?  Yes!  >Did you enter any serial  numbers in new installation or CodeCharge simply  installed with no questions ?  No serial number was entered  on the new installation, I assumed the registry was maintained.','2001-03-14 06:44:50','2001-03-14 06:44:50',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (430,398,398,'Re: Re: Re: This Forum - count of replies','pr','Sorry but I do not have a get_value(...) function.','2001-03-14 07:11:39','2001-03-14 07:11:39',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (431,419,419,'Re: Re: Records Missing problem','Martin Orton','This is a possible solution, however if I do use SQL which is the following in the Grid Form:  select * from TableOne Order By TableOneId  All data is listed, except for the data which is joined on the Grid Form from TableTwo (and more tables)  to be displayed as labels. In the labelled areas it is only blank spaces, where in the previous case at least some data were displayed without SQL.  On Record Form I don''t have these problems, but keep in mind I don''t use SQL in it and I use a Listbox to join the table data.  Another thing I should point out is that the clickable Captions doesn''t sort the data anymore if I do use SQL in the Grid Form.  So, what do you suggest now?','2001-03-14 08:16:20','2001-03-14 08:16:20',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (432,398,398,'Re: Re: Re: Re: This Forum - count of replies','CodeCharge','This function is defined in common.php file which is included to all codecharge php scripts.','2001-03-14 08:24:47','2001-03-14 08:24:47',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (433,398,398,'Re: Re: Re: Re: Re: This Forum - count of replies','pr','Hi  Yes you are right. In Version 1...103 there is a function within the common.php file called get_value(..) .  But the generated file (common.php) from  Version 1...112 do not have any function  called get_value(...)  The function is missing!!!! ;-((   Regards peter','2001-03-14 09:23:23','2001-03-14 09:23:23',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (434,17,17,'Re: Re: How to had MySQL connection ?','Stas Newdel','So it is not possible to connect directly to MySQL, you must do it through MyODBC?  Thanks','2001-03-14 09:28:53','2001-03-14 09:28:53',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (435,NULL,NULL,'how do i add users to my system?','shivkumar','hi, i want to add new users to my system ( Linux rh 6.1) based on a form that they fill. how do i do this in PHP?','2001-03-14 09:21:47','2001-03-14 09:21:47',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (436,NULL,NULL,'Error Gen. PHP 4','Peter Roth','Hi,  There is a Bug in Version CC 1.0.112  The new possibility to place a global  function within the module/global section  is great - but.  As I saw within the help the defined function will be placed within the common.xyz file  (xyz Ext. depends on the target language!)  Let me explain what I do: 1) placed a function within the modules/Event/global functions lang->PHP  2) within properties General->Language I''ve selected PHP 4.0  3) save the project  4) generate all pages  5) check the result in common.php -->>>> my own function is there and can be used   go back to step 2) now with selecting PHP 4.0 & Templates  6) save the project  7) delete all file within the target directory (to make sure all pages will be generated!)  8) generate all pages  9) check the result in common.php -->>>>> my own function isn''t in place!!! Where is it going?    Feel free to contact me for additional infos   Kind Regards  Peter Roth software solutions, switzerland  PS:  1) I''m an absolutely Fan of CC and if I can I provide you with some test-results. 2) Please provide all global defined function you have developt as a reusebal file! All developers like me will be happy about!!!!','2001-03-14 11:03:08','2001-03-14 11:03:08',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (437,17,17,'Re: Re: Re: How to had MySQL connection ?','test','test','2001-03-14 16:05:41','2001-03-14 16:05:41',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (438,NULL,NULL,'Sites built with CodeCharge','Rudy Genasky','Are there any sites online that is built with CodeCharge?','2001-03-14 17:47:20','2001-03-14 17:47:20',4);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (439,382,382,'Re: Whats the best  database type to use?','Popee','As the CodeCharge Support advises, MySQL is a fantastic free database.  For tutorials and instructive articles go to http://www.devshed.com you''ll find a wealth of help in MySQL and PHP.  Enjoy;  Popee','2001-03-14 19:10:11','2001-03-14 19:10:11',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (440,438,438,'Re: Sites built with CodeCharge','mhiles','i did the admin side to http://www.cruise800.com with it','2001-03-14 19:25:04','2001-03-14 19:25:04',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (441,382,382,'Re: Re: Whats the best  database type to use?','Brandon','Thanks for your responses!','2001-03-14 21:36:33','2001-03-14 21:36:33',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (442,398,398,'Re: Re: Re: This Forum - count of replies','Peter Roth','Hi This part of code can be used for an other case then this. Because within the loop to read all Threads it is not a good solution to redefine the  actual used query!  So - how can I execute the query for retrieve the  counts (in this case) without loosing the main  query info? Is there a way to access predefined/ preinitialized php vars  Regards Peter Roth','2001-03-14 21:54:11','2001-03-14 21:54:11',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (443,NULL,NULL,'Sort on Header','Peter Roth','Hi  I created a form with 5 columns as a grid. All of this columns are defined to have the sort possibility. So - if I decide to remove the sort from one ore more columns - how can I do that. I the other way - how can I define a colomn to have this feature without create the form again?  Any ideas??  Regards Peter Roth','2001-03-14 22:06:20','2001-03-14 22:06:20',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (444,438,438,'Re: Sites built with CodeCharge','Joachim Uersfeld','You can take a look at www.pc-team.de ... codecharge .. forum.','2001-03-14 23:11:29','2001-03-14 23:11:29',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (445,NULL,NULL,'Total field not viewed','cparadis','when i try to include a sql qwery with sum fonction like in your example ledger, i can''t see and recall the total in the fields.  How can i do that ?  Thank''s in advance','2001-03-15 02:59:44','2001-03-15 02:59:44',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (446,445,445,'Re: Total field not viewed','CodeCharge','Please  see http://codecharge.com/forum/viewthread.php?mid=398&','2001-03-15 08:16:07','2001-03-15 08:16:07',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (447,435,435,'Re: how do i add users to my system?','CodeCharge','Please see Classfieds example provided with CodeCharge. Registration page. Example can be found at <path-to-CC>/CodeCharge/ Examples/Classifieds.','2001-03-15 08:23:29','2001-03-15 08:23:29',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (448,NULL,NULL,'wich is the best way to learn codecharge??','hpguo','I have purched  the codecharge via my friend but untils this time i can''t generate any program of asp from codecharge while it has always error occures(in the properties&pages) i don''t know why?? I can''t also learn anything from the examples that provided from your Company''s due to the examples haven''t a good sample(or tutorial) from begin to finish!! Would You mind to tell me how &what i should to do?? thanks','2001-03-15 20:29:13','2001-03-15 20:29:13',3);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (449,438,438,'Re: Sites built with CodeCharge','Jeff Held','Working on a few.    I put the bookstore demo at: http://www.drumbeat-2000.com/codecharge/demosites/bookstore/  :)','2001-03-15 21:00:23','2001-03-15 21:00:23',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (450,NULL,NULL,'Formating Numbers','Ken Hardwick-Norman,Oklahoma','Since cc doesn''t offer a option to format numbers yet, I have writen a function to make it easier do so in the meantime. (ie if you have a salary field of $32,000.23 you would see in your form ...32000.23 but would rather see,,,$32,000.23)  Place the following function in your Global function module...  function KenFormat(iNum,iType,iRnd) ''Use to format numbers to various formats ''valid iType''s = \"c\" for currency,\"n\" for numeric,\"p\" for percent ''iRnd = places to round to ''Example fldAmt = KenFormat(fldAmt,\"c\",2) ''if fldAmt = 12000 then returns $12,000.00    iNum = cstr(iNum)   iRnd = cstr(iRnd)  ''Check to see value passed is a number, if not just return value if isnumeric(iNum) = false then  KenFormat = iNum  exit function end if  ''Check to see value passed is a number, if not just return value if isnumeric(iRnd) = false then  KenFormat= iNum  exit function end if   Select Case iType      case \"n\",\"N\"       KenFormat = formatNumber(inum,iRnd)     case \"c\",\"C\"       KenFormat = formatcurrency(inum,iRnd)     case \"p\",\"P\"       KenFormat = formatPercent(inum,iRnd)     case else       ''if iType passed not valid , just return value       KenFormat = iNum end select  end function   Then in form \"Before Show\" events...use this function for each field you want to format.  For example, if your field name is \"Salary\", then enter...  fldSalary = KenFormat(fldSalary,\"c\",2) then 123456.78  will be displayed as $123,456.78  Please post any suggestions, improvements,or comments on this.   Hopefully CC will add a feature like this, plus a allignment feature to their software soon...but this should help in the meantime...  (note on alignment,,all fields originally come out left aligned, so for number fields, I have to go to the html to do right align for each field as needed. Anyone have a better,easier way?)  By the way, CC is a great product and provides great,quick support.  Ken Hardwick KenHardwick@visto.com Norman,Oklahoma','2001-03-16 04:03:37','2001-03-16 04:03:37',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (451,450,450,'Re: Formating Numbers-Currency Symbol','Ken Hardwick-Norman','Well my post looks a little weird in the fact that in places where I  had entered a UScurrency symbol, it  suppressed the symbol and the numbers imediately following the symbol... and before the first comma.. the function should be ok as it appears.. but you will just have to read between the lines...well actually the currency symbol and the comma  Ken Hardwick','2001-03-16 04:19:45','2001-03-16 04:19:45',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (452,448,448,'Re: wich is the best way to learn codecharge??','CodeCharge','Please describe your error and tell us what version of CodeCharge you''re using. See tutorial at  http://www.codecharge.com/download/files/Tutorial.zip','2001-03-16 05:04:19','2001-03-16 05:04:19',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (453,450,450,'Re: Re: Formating Numbers-Currency Symbol','CodeCharge Support',' Thank you Ken :-)  Alex.','2001-03-16 05:44:06','2001-03-16 05:44:06',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (454,438,438,'Re: Sites built with CodeCharge','CodeCharge','http://codecharge.com/forum/','2001-03-16 06:12:49','2001-03-16 06:12:49',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (455,NULL,NULL,'Left JOIN (or join tab)','Anton','Hi! How I can join two field from other table to only field from first table?  For example: I am using UserData table and want join userFamily and userFirst from table Users.  SQL -  SELECT * FROM UserData Left Join Users on UserData.Id = Users.Id.  But CodeCharge generate error when I place 2 field Id on \"Page\".....  I try replace in template html and in real code (ASP) two values and it was working.','2001-03-16 07:37:01','2001-03-16 07:37:01',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (456,NULL,NULL,'Cold Fusion application variables','scott','Anyone using Codecharge with coldfusion? if so are you using an application.cfm? I am having an ordeal with passing variables to the codecharge pages via an existing application.cfm','2001-03-16 15:30:30','2001-03-16 15:30:30',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (457,NULL,NULL,'Prompt for new login','Jim Nicolis','How could I get a user to try to log into a  page and if not found codecharge prompt him  to provide a userid & password.  Any ideas appreciated.','2001-03-16 23:21:28','2001-03-16 23:21:28',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (458,243,243,'Re: Re: Re: Re: Re: PHP/mySQL ?','JQ','Agreed. In addition, I recommand installing a  phpMyAdmin on your MySQL server, which will  enable you to manage your MySQL database via web page interface. I personally think that it''s very convenient and have been enjoying it so far. Check the following for details on phpMyAdmin  http://www.htmlwizard.net/phpMyAdmin/ or: http://www.mysql.com/downloads/contrib.html for \"phpMyAdmin_2.0.1.tar.gz\"  cheer! JQ','2001-03-17 17:09:56','2001-03-17 17:09:56',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (459,448,448,'Re: which is the best way to learn codecharge??','Robert Smiley','Is this link accurate? I tried to get that file and  it appears that the file is not there.  Thanks','2001-03-17 17:50:50','2001-03-17 17:50:50',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (460,NULL,NULL,'CF Generate Issue -','JGutierrez','I have created an ODBC connection, run the SQL script (Bookstore) provided by CodeCharge, set all permissions on my WIN2K server, CF Server.  I can see the tables and data thru each forn field on the default page of the Bookstore, but when I get ready and Generate an error is produced in a pop-up box:  ------------------------------------------------- Site     Attribute: DSN - Attribute is required. -------------------------------------------------  any suggestions, please help, i only have a few days left.  Thank You JGutierrez','2001-03-17 23:40:12','2001-03-17 23:40:12',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (461,NULL,NULL,'Encoding support?','Majkl','I want to use international encoding utf-8 on my pages. How can i specify it in CC? Or do i have to add it to every generated page?','2001-03-18 03:13:19','2001-03-18 03:13:19',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (462,448,448,'Re: wich is the best way to learn codecharge??','Majkl','Have you tried to read Codecharge Manual?','2001-03-18 03:28:17','2001-03-18 03:28:17',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (463,NULL,NULL,'Custom patterns?','Majkl','Is it possible to create pattern files? According to documentation, pattern files should be XML documents. But .ccp files are binary. Are there any tools for creating these files?','2001-03-18 03:55:39','2001-03-18 03:55:39',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (464,364,364,'Re: Wish for Next Release','Paul Thomas','I also think that generating the MySQL table code would be an excellent idea, this seems to be the only drawback with the program.  Keep up the good work, Paul','2001-03-18 15:56:50','2001-03-18 15:56:50',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (465,NULL,NULL,'Metasearch demo problem','Andy Farrell','Error Type: Server object, ASP 0177 (0x80040112) Class is not licensed for use  /metasearch/MetaSearch.asp, line 84  Any ideas?  - A.','2001-03-18 20:17:56','2001-03-18 20:17:56',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (466,364,364,'Re: Re: Wish for Next Release','Peter Roth','Hi  On my point of view, it can be the functionality for  a development tool to generate, manipulate or maintain a DB-Model. In my opinion CC is a great tool to  develop Webapplication very fast and with a high  quality goal. CC does not only act on MySql so it  should be a negative point when CC is focusing to create the DB too.  My wishes for further version of CC to be the best  tool for createing Webapplications. So CC has to focus on the frontent. Perhaps with including of MVC-Model.  But this is only my point of view!  Kind Regards  Peter Roth software solutions, switzerland','2001-03-18 21:37:44','2001-03-18 21:37:44',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (467,NULL,NULL,'Poor performacnce with Mysql','Majkl','I''ve big table - about 100000 records. It takes several minutes to load page with grid form, that uses data from this table.   Codecharge doesn''t use \"limit\" in sql queries. Instead it selects every possible record and then scrolls through result set to get required data. It works fine on Microsoft SQL server and others. They start returning data as soon as possible. But mysql first prepares whole result and then sends it to client. With small tables, delay is not noticable, but when tables get larger performance suffers.  Is there any other solution to this problem then to edit generated code?  Is it possible to access database other way then using OLE DB,ADO,ODBC? (for example Or is codecharge doomed to Windows platform?','2001-03-18 23:04:28','2001-03-18 23:04:28',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (468,NULL,NULL,'Virus alert?','Majkl','When i''m starting CodeCharge, my antivirus shows warning that CodeCharge.exe is modifying file msgwc32.dll in Windows system directory.   Why the hell this happens?   I tried to delete this file and everything worked fine. (but after restarting codecharge the file was again there.)','2001-03-18 23:22:31','2001-03-18 23:22:31',4);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (469,NULL,NULL,'id key needed of Code Charge','Tania','I worked on trial version of Code Charge. It is really interesting tool. Could anyone provide me the id key of this tool. I will use it only for educational purposes.  -Tani','2001-03-19 00:14:51','2001-03-19 00:14:51',4);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (470,467,467,'Re: Poor performacnce with Mysql','CodeCharge Support','Re: SQL You may use your own SQL query in CodeCharge - just enter it in Form Properties.  Re: database connection. You may connect to your database any way you like. For example when using PHP, CodeCharge uses the standard PHPLib library functions to connect to the database.  > is codecharge doomed to Windows platform? CodeCharge generates the code - it doesn''t care where and how you run it. Most CodeCharge users use the generated code on UNIX/Linux platforms.','2001-03-19 00:32:58','2001-03-19 00:32:58',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (471,468,468,'Re: Virus alert?','CodeCharge Support','This file is a CodeCharge file. I don''t know why your antivirus shows warnings. Possibly its a configuration issue. Please check with your antivirus software vendor.','2001-03-19 00:40:55','2001-03-19 00:40:55',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (472,463,463,'Re: Custom patterns?','CodeCharge Support','At this time .ccp files cannot be modified.','2001-03-19 00:50:16','2001-03-19 00:50:16',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (473,457,457,'Re: Prompt for new login','CodeCharge Support','>How could I get a user to try to log into a  >page and if not found codecharge prompt him  >to provide a userid & password.  I''m not sure if I understand the problem. For the user to be able to login - you have to ask for the userid and password already. So, if you are asking the user to login, you are already doing what you asked for :-)','2001-03-19 00:52:09','2001-03-19 00:52:09',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (474,461,461,'Re: Encoding support?','CodeCharge Support','You may change the encoding in the language translation files stored in \"Translations\" subdirectory.','2001-03-19 00:54:21','2001-03-19 00:54:21',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (475,NULL,NULL,'Blob fields in DB','THW','I''m testing cc, until now it works fine. What i like to do is storing files like  pdf''s directly in mysql db. So any Webuser can contribute files directly  and not via ftp.','2001-03-19 01:54:28','2001-03-19 01:54:28',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (476,468,468,'Re: Re: Virus alert?','Majkl','Antivirus works just fine. It correctly detects that some program (possibly virus) is changing executable file.  In fact this is not executable file, it only has .dll extension.  It is quite strange that Codecharge stores some information to such file.','2001-03-19 04:09:28','2001-03-19 04:09:28',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (477,NULL,NULL,'PHP, warning message','Bart','Warning: <?php_track_vars?> is no longer supported - please use the track_vars INI directive instead   What do I need to change in script?','2001-03-19 08:14:53','2001-03-19 08:14:53',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (478,NULL,NULL,'login/logout problem','Walt','On my test application, a user is able to login.  I cannot get the logout function working.  From previous messages on this board, I believe that you just add your login form to an existing form and you''ll be able to logout.  Whenever I do this, I get the follwing message:  Warning: SQL error: [Microsoft][ODBC SQL Server Driver][SQL Server]Invalid column name ''locator''., SQL state S0022 in SQLExecDirect in ./db_odbc.inc on line 47  Database error: Invalid SQL: SELECT employee_num FROM employee_mst WHERE employee_num=locator ODBC Error: 1 (General Error (The ODBC interface cannot return detailed error messages).) Session halted.  Any ideas/suggestions?','2001-03-19 08:32:21','2001-03-19 08:32:21',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (479,281,281,'Re: Error 405 Method not allowed','Jim','I''m having the same problem on my 2000 server, any luck getting an answer from these guys','2001-03-19 09:36:24','2001-03-19 09:36:24',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (480,468,468,'Re: Re: Re: Virus alert?','Popee','If I may make two points:  1.) If you changed the tone of your messages you might find that you would get more offers of help.  2.) Everyone here is a CodeCharge user.  Yet you are the only one (to my knowledge) to have this problem.  Doesn''t that tell you something?  Popee','2001-03-19 10:44:44','2001-03-19 10:44:44',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (481,468,468,'Re: Re: Re: Virus alert?','CodeCharge Support','I don''t understand what''s strange about CodeCharge using .dll files ? Any program can create, use and modify .dll files and so does CodeCharge. msgwc.dll is a CodeCharge file.','2001-03-19 22:04:19','2001-03-19 22:04:19',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (482,NULL,NULL,'Can we download & use CodeCharge on different PCs','Farooq Ahmed','I am going to purchase CodeCharge. Can we download & use the same software from different computers? Actually I want to use it from home and office. Can we download it again and again or only one time?','2001-03-20 04:26:02','2001-03-20 04:26:02',3);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (483,455,455,'Re: Left JOIN (or join tab)','Henrik Lorange','I don''t know if I understand you right, but have you tried changing the field name on the Common Tab of Field Properties?','2001-03-20 06:15:44','2001-03-20 06:15:44',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (484,469,469,'Re: id key needed of Code Charge','Code Dude','1234567Tania wrote:  >I worked on trial version of Code Charge. It is really interesting tool. Could anyone provide me the id key of this tool. I will use it only for educational purposes. > >-Tani > >','2001-03-20 07:06:26','2001-03-20 07:06:26',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (485,477,477,'Re: PHP, warning message','Popee','Hey Bart;  A PHP wizard I am not; but I believe that you might be getting this message because php_Track_vars is turned on in the config file when your compiling your code.  I believe that this is always turned on in the later versions of PHP and doesn''t need to activated at the config any longer.  I hope I''m telling you right; if not I hope someone else will be kind enough to set us both straight.  Popee','2001-03-20 11:15:48','2001-03-20 11:15:48',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (486,482,482,'Re: Can we download & use CodeCharge on different','CodeCharge Support','Single user license lets you intall CodeCharge on up to three computers with unlimited number of installations. Otherwise you need to buy another license.','2001-03-20 13:56:33','2001-03-20 13:56:33',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (487,NULL,NULL,'Win2k issues?','Steve','Are there any known win2k issues with Code Charge. I downloaded the trial version, but upon clicking \"Try\" I receive the following errors, in different popup windows, in the foloowing order:  Title: Microsoft Windows Common Controls-3.6.0 Message: Automation Error (Clicked OK)  Title: Diagram Message: Runtime Error ''50003'' Unexpected Error (Clicked OK)  Title: CodeCharge Message: 372 Failed to load control ''Site Diagram'' from Diagram.ocx. Your version of Diagram.ocx may be outdated. Make sure you are using the version of the control that was provided with your application.% (Clicked Ok)  After this, I have to open my task manager in order to kill the Code Charge process.   Any ideas? Thanks in advance.','2001-03-20 14:39:48','2001-03-20 14:39:48',4);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (488,487,487,'Re: Win2k issues?','Steve','FYI, the version I am trying to run is 1.0.112','2001-03-20 15:08:37','2001-03-20 15:08:37',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (489,NULL,NULL,'how to build multi_pages use codecharge??','hpguo','Dear Sir: I will try to write a career_database & in this database contains four_tables every table will conatins in a page&every page uses a primakey( userid) to link. (these tables For instance:personal,education,training,idealworks...) (1). It will can page_up,pagedown for every pages howcan i do use codecharge?? (2).how can i use radio_box(replace radio_box use check_box??) (3).is listbox''s function likes combo_box?? would someone pls tell me ??thank you very much sincerly yours hpguo','2001-03-21 01:47:22','2001-03-21 01:47:22',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (490,489,489,'Re: how to build multi_pages use codecharge??','CodeCharge Support','1) Do you mean page up/page down buttons, scroler or somthig else , please specify 2) radio box is not currently supported in CC but you can add it in \"header/footer\" section of form or add a Label field that will be replace in \"Before show\" event in form properites: fldmyradio = \"<input type=radio name=answer value=56>Text<br> \" where html checkbox in field properties must be on. You can also add any html code right into  codecharge generated code. 3) The difference between listobox and combobox that in listobx you can not add custom value. this can be worked around by placeing textbox near listbox and in Form properties/\"Before show\" event you enter code like : if fldlmytext=empty then combovalue=fldmylistbox','2001-03-21 05:42:44','2001-03-21 05:42:44',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (491,487,487,'Re: Win2k issues?','CodeCharge Support','A few solutions : 1) Please try to uninstall/install CodeCharge. 2) Try download newer CC from http://www.codecharge.com/download/files/CodeCharge1_0_114.exe 3) Manually install  Microsoft Windows Common Controls','2001-03-21 06:06:15','2001-03-21 06:06:15',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (492,487,487,'Re: Win2k issues?','Popee','Good morning Steve;  I''m using CodeCharge .112 on an IBM ThinkPad with Windows2000 and have not encountered any porblems whatsoever.  Have you tried doing a complete de-install, rebooting and then re-installing from scratch? Also have you installed the latest service pack for Win2K?  If not you might want to try doing that before re-installing Codecharge.  Hope This Helps;  Popee','2001-03-21 06:14:25','2001-03-21 06:14:25',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (493,469,469,'Re: Re: id key needed of Code Charge','CodeCharge Support','You may use CodeCharge without Activation key for 30 days. Just clikc \"Try\" button on splash screen when running it first time.','2001-03-21 06:36:56','2001-03-21 06:36:56',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (494,455,455,'Re: Left JOIN (or join tab)','CodeCharge','You should''ve used this sql with aliases for field and table names. This way fields with same names could be destinguished. You need only one field from another table you may use \"Firld properties\"/\"Join\" tab where you specify joined table and join field.','2001-03-21 07:00:32','2001-03-21 07:00:32',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (495,478,478,'Re: login/logout problem','CodeCharge Support','Please send your ccs file and database(or sql script to create it) to support@codecharge.com','2001-03-21 07:26:44','2001-03-21 07:26:44',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (496,NULL,NULL,'wapnews','Allen Patrick','I have been able to get 5 of the examples to work with mysql and apache.  However the wapnews example does not seem to work for me.  When I go to the index.php page all I get is a blank screen. Do I need something special to make this work or am I missing something?','2001-03-21 07:27:18','2001-03-21 07:27:18',5);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (497,NULL,NULL,'Directories','Quim','Hi,  I''m now just testing CodeCharge for first time. There''s any way to group pages into directories? Is the tree-style page an indented list?  Thanks,  Quim','2001-03-21 07:47:48','2001-03-21 07:47:48',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (498,496,496,'Re: wapnews','CodeCharge Support','You don''t need nothing special , it''s just a usual http output , only for WAP. What is your CC verion ? What language (Site/Properties) do you use for WAP ?','2001-03-21 08:04:07','2001-03-21 08:04:07',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (499,497,497,'Re: Directories','CodeCharge Support','There is way to group pages into directories for now. We''ll take your question into consideration. >Is the tree-style page an indented list?  Something like this. There are 2 id''s used in \"Tree\" for , one for usual id and another is  parent_id (since it is a tree and we need to link branches and subbranches)','2001-03-21 08:05:52','2001-03-21 08:05:52',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (500,NULL,NULL,'ASP - Dropping Zeroes','imranz','I have a column in an SQL Server db that holds 9-digit numbers. Sometimes the number begins with a 0, and sometimes not (social security numbers).  Trouble is, the forms that codecharge creates to search those forms drops the zeros off the start of the number, even if I set the column to ''varchar'' and the form data type in Codecharge to ''text''. Why does it drop the zeros at the start of a number?','2001-03-21 13:01:22','2001-03-21 13:01:22',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (501,469,469,'Re: Re: id key needed of Code Charge','Happy bunny','Yeh Sure! Buy it like the rest of us.  P.S. Money is also for educational purposes.','2001-03-21 18:15:58','2001-03-21 18:15:58',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (502,NULL,NULL,'Locked CCS file','Peter Bourke','Hi Guys,  I just started CC and it said something about the file being locked, and sure enough I can''t save now. How do I unlock this file?  Thanks, Peter  Great product...great value for money!','2001-03-21 18:43:59','2001-03-21 18:43:59',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (503,489,489,'Re: Re: how to build multi_pages use codecharge??','hpguo','Thank you for friendly answer!! my problem is as follow: (1).page1_fields: Userid name ...        next_page [icon for user               to go nextpage] (2).page2_fields: userid(hidden) graduated school degree ...         [next_page][up_page][icon for user               to go nextpage] (3)..... ... ... (4)..... ... ...        [next_page][sumit] I am sorry because my poor english that perhaps i can''t descript so clear. PS: other  problem: when i follow the example[regtration]      tryto learn codecharge i got the error message :Attribute:Login page Attribute is required when Authentication is  select in sitesecurity properties. but i follow all same as the example step i don''t know why?? Would mind tellme Why??thank you !! your hpguo','2001-03-21 19:26:33','2001-03-21 19:26:33',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (504,478,478,'Re: login/logout problem','Henrik Lorange','I have the same problem with PHP, I cannot log out, although this seems to be a MySQL problem:     Login / Logout  Database error: Invalid SQL: SELECT usr_alias FROM users WHERE usr_alias=admin MySQL Error: 1054 (Unknown column ''admin'' in ''where clause'') Session halted.','2001-03-22 03:40:58','2001-03-22 03:40:58',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (505,467,467,'Re: Re: Poor performacnce with Mysql','Majkl','How can i specify that i want PHP to connect directly  to MySQL database without using ODBC? Is it possible  to set it in Project properties/Database tab? Or do i have to edit generated code?','2001-03-22 03:51:25','2001-03-22 03:51:25',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (506,500,500,'Re: ASP - Dropping Zeroes','CodeCharge Support','Please check your type information(column type), field type more thoroughly. I made a small experiment. Added a new user in Bookstore example with a name 007 . And when I entered members grid all zeroes in the name remained. If you still encounter this kind of problem submit your case to support.comdecharge.com','2001-03-22 04:12:52','2001-03-22 04:12:52',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (507,502,502,'Re: Locked CCS file','CodeCharge Support','Make you sure this file is not use by other programs.','2001-03-22 04:22:20','2001-03-22 04:22:20',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (508,460,460,'Re: CF Generate Issue -','bananachunks','CodeCharge uses the ODBC connection to build - when you actually go to run the app, ColdFusion runs by the datasource that is set up thru the ColdFusion Administration and the ''datasource=\"\"'' of the <cfquery>, which in this case, sounds like it was not set, because it was left out in the CC site properties.  This can usually be set thru ODBC as well, so if you already have an ODBC set up for ''staging'', you should notice a datasource in the CFAdmin for ''staging'' too.  Just make sure that in the CodeCharge site properties you put the name of this datasource in the DSN textfield, as well as telling CC how to connect to the database...  HTH geo','2001-03-22 04:23:59','2001-03-22 04:23:59',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (509,456,456,'Re: Cold Fusion application variables','bananachunks','Exactly what kind of ordeal are you having, and I''ll give helping out a go?  I''ve not had this prob using CC to develop for both win/lin CF (I prefer the lin).  Is this for Linux CF?  If so, it needs to be Application.cfm, not application.cfm (good practice anyway - you don''t know how irritating it''s been porting apps over to lunix with all these windows faux paus... *smile*).  If that''s not the prob, can you give me a little more detail as to what''s going on?  geo','2001-03-22 04:30:44','2001-03-22 04:30:44',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (510,496,496,'Re: Re: wapnews','Allen Patrick','Code Charge Version 1.0 which is a trial version. Language is PHP 4.0 & WML 1.1','2001-03-22 06:39:32','2001-03-22 06:39:32',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (511,465,465,'Re: Metasearch demo problem','CodeCharge Support','Make sure that InetCtls.Inet.1 ActiveX  component is installed on your computer. As far as I know it''s distributed with IE 5.0','2001-03-22 06:50:23','2001-03-22 06:50:23',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (512,496,496,'Re: Re: wapnews','CodeCharge Support','Most of codecharge examples generate pages with images and other things unsuitable in wml case. The only example that should work with WML is NewsWAP example. Use it and tell us if you have any problems.','2001-03-22 07:33:36','2001-03-22 07:33:36',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (513,482,482,'Re: Re: Can we download & use CodeCharge on differ','Ayman','What if my HDD crashes and I need to re-install CC on  a new HDD?  Do I need to contact support by email, or will the  activation-key system recognize this issue? Buying additional license is not a problem (I already have one license), but will it be required if I decide to move CC to another PC, or the first case I have mentioned?  Thanks  Ayman','2001-03-22 07:32:48','2001-03-22 07:32:48',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (514,475,475,'Re: Blob fields in DB','CodeCharge Support','unfortunately, yo can`t use blob  fields in musql db','2001-03-22 08:48:21','2001-03-22 08:48:21',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (515,348,348,'Re: How to set attritute enctype in form tag?',NULL,'No, it`s not necessary','2001-03-22 09:54:26','2001-03-22 09:54:26',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (516,348,348,'Re: How to set attritute enctype in form tag?',NULL,'No, it`s not necessary','2001-03-22 09:54:26','2001-03-22 09:54:26',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (517,NULL,NULL,'Custom Tags','Atomicdragon','Just wondering if it''s possible to put custom tags around data returned in grid format. For example, if my database table has a field called ImgSrc... can I make it so that the <img src= VALUE > is inserted around the VALUE.  Thanks in advance for any help.','2001-03-22 14:07:55','2001-03-22 14:07:55',7);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (518,487,487,'Re: Re: Win2k issues?','Steve','No luck. Thanks anyway.','2001-03-22 14:15:17','2001-03-22 14:15:17',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (519,NULL,NULL,'Login page problem','Peter Bourke','Hi Guys,  I have tried to add a login page to my app. I get two lognin forms (identical) on the one page, and neither one appears to work.  Have you heard of this? I have tried deleting the page and starting the page again but to no avail. I am using ASP, W2K IIS5, and MS SQL Server 7.  Thanks, Peter','2001-03-22 17:05:57','2001-03-22 17:05:57',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (520,517,517,'Re: Custom Tags','bananachunks','This is something that I''ve found, that unfortunately has to be done when you are done with CC.  CC does a whole lot (WOW!  Does it!)  But it doesn''t do it all (yet?).  Once you make these changes, however, remember that if you make anymore changes in CC and export the page, any and all custom changes you''ve made to the code are lost.  =(  HTH geo','2001-03-22 17:21:47','2001-03-22 17:21:47',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (521,517,517,'Re: Custom Tags','Peter Roth','Hi,   this is my suggestion:  1) place your imageholder field into the form (take care that you call the field unlike image (don''t ask me wy!?!?)) 2) go to the form property page (click on property picture next right to the form name) 3) select the Events and select the \"Before Show\" Event within the list (make sur your target language is set!) 4) place the following code:   PHP: $fldpicture = \"<img src=''\" . toURL($fldpicture) . \"'' width=''100'' height=''43'' alt=''Home''>\"; ASP: fldpicture = \"<img src=''\" & toURL(fldpicture) & \"'' width=''100'' height=''43'' alt=''Home''>\"  Description: fldpicture : field on form width/height/alt : can be set for your situation   Kind regards  Peter Roth software solutions, switzerland e-mail: proth@softsol.ch','2001-03-23 00:54:24','2001-03-23 00:54:24',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (522,519,519,'Re: Login page problem','Peter Roth','hi,  did you have a field within your database to get the  security level information? If not define it and make sure your user (you try to login) have a level value to sucessfully log in. Within the page you can select the security level value. If the user do not have a levelvalue => the page levelvalue -  the login form will be fired again!  Hope this help!   Kind Regard   Peter Roth software solutions, switzerland e-mail: proth@softsol.ch','2001-03-23 00:56:07','2001-03-23 00:56:07',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (523,482,482,'Re: Re: Can we download & use CodeCharge on differ','Ayman','Thanks for clearing up this issue.','2001-03-23 02:56:44','2001-03-23 02:56:44',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (524,517,517,'Re: Re: Custom Tags','bananachunks','Ah...  so that''s where ''Events'' comes into play...  Very Cool.  Thank You!  geo','2001-03-23 05:02:10','2001-03-23 05:02:10',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (525,517,517,'Re: Re: Re: Custom Tags','Peter Roth','your welcome! It easy - isn''t it??  And a very cool tool!!  regards  peter','2001-03-23 09:29:30','2001-03-23 09:29:30',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (526,NULL,NULL,'Session Variable SQL Filter','berklee','I''m just trying to figure something out....  In my User Table, I have a field for ''CompanyID''. When I log in, I''m taking that value into a session variable.  I know the variable''s being stored, but I''m trying to filter a recordset on a page using the session variable in the where statement. I can''t seem to get it to work.  Added note : why is it that when I do a Response.Write with ''sSQL'', it shows up twice?','2001-03-23 11:44:59','2001-03-23 11:44:59',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (527,526,526,'Re: Session Variable SQL Filter','berklee','Never mind. Figured it out.','2001-03-23 12:09:52','2001-03-23 12:09:52',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (528,NULL,NULL,'Feature Request','berklee','When generating a ''stock'' login, it would  really be nice to set the maximum field lengths.   I''m using the standard login right now, and it works, but I have to go in and manually change it on every generation because I''m getting people to log in with their e-mail address.','2001-03-23 12:10:54','2001-03-23 12:10:54',3);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (529,517,517,'Re: Re: Custom Tags','Atomicdragon','Thanks Peter, I''m beginning to understand the events area a bit better.  However, the < > brackets are getting replaced by & l t ; (no spaces). Anyone know how to get avoid this problem?  (I''m so close to getting this to work).  Right now I have.  Grid:Events:Show:ASP  fldPIC = \"<img src=''\" & fldPIC & \"''>\"  Thanks everyone. (thx bananachunks for the suggestion)  AD','2001-03-23 12:09:57','2001-03-23 12:09:57',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (530,526,526,'Re: Re: Session Variable SQL Filter','Hiran','I need to figure out the same thing. Could you post how you grap the UserID value in the sql query. I am using JSP and I can seem to get the variable to pass into the other pages.','2001-03-23 12:55:50','2001-03-23 12:55:50',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (531,517,517,'Re: Re: Re: Custom Tags','Peter Roth','Hi  the <> brackets must be <> not &lt / &gt. because they are in content of a right html tag. Please also make sure that on the field property page the html checkbox is checked. Only with this the contend within this field is interpreted as a html tag.  Questions? I hope not ;-))  Regards Peter software solutions, switzerland e-mail:proth@softsol.ch','2001-03-23 15:18:08','2001-03-23 15:18:08',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (532,496,496,'Re: Re: Re: wapnews','Allen Patrick','The wap news example is what I am trying to get working.  I got the bookstore and a couple of other ones to work but not the wap news.  I am useing php4 with wml, mysql and the downloaded free timed version of code charge.  Please Help  My evaluation period is running out.','2001-03-23 18:47:26','2001-03-23 18:47:26',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (533,517,517,'Re: Re: Re: Re: Custom Tags','Atomicdragon','ahhh... checking the html box fixed everything!  (That''s what it''s for!) :)  Thanks for your help!  I really appreciate it!  AD','2001-03-23 19:03:54','2001-03-23 19:03:54',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (534,NULL,NULL,'Best development system advice.','Kevin','I would like to start using CodeCharge productively as soon as possible and would like some advice.    My production Web server is a Cobalt RaQ 3 -- it has MySQL version 3.22 and PHP 3.  I know that I can use something such as AbriaSoft Lite in order to have an Apache WebServer, PHP 3 and MySQL loaded on my Windows workstation, but would you have a recommendation for something better.  Would your suggestion be to upload the pages immediately to the server via FTP and may be used phpmyadmin for modifying the tables more easily. Perhaps I should use ASP and Microsoft WebServer for simplicity of development.  I also have JSP installed on our Cobalt RaQ.  I really prefer the non Microsoft platform for the final publishing on the Web that I would like to know your suggestions for a perfect development environment.  The two gray areas that were not very clear in the documentation were where to go to next to build the SQL databases and tables related (and does CodeCharge have anything to do with generating this usual .SQL file)  I also noticed that there are some filename.sql in an SQL directory in the examples.  Are these intended to help quickly build the tables by funneling these into the SQL Server.  Do I have to have Access 2000 to read the file that is filenamems.mdb that is also located in the examples folder?  I tried to read this MDB file with Microsoft Access 97 and was told was not the correct structure or some such error that indicated that it was not a Microsoft Access 97 file.  Thanks in advance -- I''m really looking forward to making more productive progress building Web apps with your tool.  Kevin Schaefer','2001-03-24 00:04:20','2001-03-24 00:04:20',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (535,NULL,NULL,'MySQL and ASP code problems...','Srinivas B.','Hi  I am trying to evaluate CodeCharge. I have created a test database (MySQL) and am able to set up the pages and DB properties in CodeCharge. The test connection is successfull which I assume there are no problems with MySQL connectivity as such.  Then, I generated ASP code and when I try to  access the page from browser, this is what I get: ++++++++++++++From Here++++++++++++++++++++++ Technical Information (for support personnel)  Error Type: Microsoft VBScript compilation (0x800A0401) Expected end of statement /hwebmail/Common.asp, line 21, column 95 strConn = \"Provider=MSDASQL.1;Persist Security Info=False;User ID=hwebusr;Extended Properties=\"DSN=hwebmail;DB=hwebmail;SERVER=localhost;UID=hwebusr;PORT=;OPTION=0;STMT=;\"\" ----------------------------------------------------------------------------------------------  ++++++++++++++Till Here++++++++++++++++++++++   The section of the common.asp that is created is given below:  ++++++++++++++From Here++++++++++++++++++++++ ''Database connection string strConn = \"Provider=MSDASQL.1;Persist Security Info=False;User ID=hwebusr;Extended Properties=\"DSN=hwebmail;DB=hwebmail;SERVER=localhost;UID=hwebusr;PORT=;OPTION=0;STMT=;\"\" Set cn = Server.CreateObject(\"ADODB.Connection\") ++++++++++++++Till Here++++++++++++++++++++++  It looks like the quotes ''\"'' are not escaped for  the Extended Properties. I dont see any problems at the design time, but at run time it just wont work.  Is any one faced with this situation before? Thanks in advance.  -Srinivas','2001-03-24 12:21:44','2001-03-24 12:21:44',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (536,367,367,'Re: Re: Operation requires updateable query','davidsmith','I had the same problem, which I resolved by changing the permissions on my database on the webserver.   I''ll point out to the original poster that while your solution may work, even Microsoft recommends a DSN-less connection to online databases for a whole host of reasons.','2001-03-24 22:36:55','2001-03-24 22:36:55',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (537,28,28,'Re: Re: Re: Microsoft Jet Database Engine error wi','davidsmith','I also have this problem on the version of CodeCharge that''s installed on my work computer, but not my home system.  Obviously, something is not installed that should be installed.....but what should I be looking for?','2001-03-24 22:42:16','2001-03-24 22:42:16',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (538,28,28,'Re: Re: Re: Re: Microsoft Jet Database Engine erro','davidsmith','I replied to the wrong message. My error is the \"ISAM\" one.','2001-03-24 23:29:32','2001-03-24 23:29:32',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (539,496,496,'Re: wapnews','Marc','View your wap site with Opera browser, it works,  only browser that has wml support, wapnews worked.','2001-03-25 02:27:00','2001-03-25 02:27:00',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (540,NULL,NULL,'exsisting code','jay','First I''d like to say that this is an outstanding program.  I was wondering is there a way to import my own exsisting site into the program?  I see it has import features but only for code generated with CC ex. sitename.ccs.  Thanks for any info on this.','2001-03-25 11:24:00','2001-03-25 11:24:00',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (541,NULL,NULL,'Problem with the \"@\" char','Eros Ciaiolo','Hi, greetings from Italy. Your program is great (I''m just downloaded the trial version two days ago).  Let me explain my problem: I''m working with a Access97 database that contains a field where is stored an E-Mail address. Why the program don''t let me insert this field and tell me that the \"@\" is not a valid character ?','2001-03-26 02:04:25','2001-03-26 02:04:25',6);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (542,540,540,'Re: exsisting code',NULL,'unfortunaly, you can`t import existing site into CC, if it not generated by CC.  Regards, CodeCharge Support','2001-03-26 03:34:44','2001-03-26 03:34:44',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (543,535,535,'Re: MySQL and ASP code problems...',NULL,'You should have next Design Connection String Provider=MSDASQL.1;Persist Security Info=False; User ID=hwebusr;Extended Properties=\"\"DSN=hwebmail; DB=hwebmail;SERVER=localhost;UID=hwebusr;PORT=; OPTION=0;STMT=;\"\"  Regards, CodeCharge Support','2001-03-26 05:37:38','2001-03-26 05:37:38',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (544,534,534,'Re: Best development system advice.',NULL,' - .sql files have included into Examples to easy  create the same databases as examples .mdb DB.   - MS Access97 can`t open .mdb files created by MS Access2000','2001-03-26 05:58:51','2001-03-26 05:58:51',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (545,528,528,'Re: Feature Request',NULL,NULL,'2001-03-26 06:04:52','2001-03-26 06:04:52',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (546,541,541,'Re: Problem with the \"@\" char',NULL,'Try to use Access2000. There`s no such a problem. But unfortunately MS Access2000 can`t work with MS Access97 .mdb files.','2001-03-26 06:30:51','2001-03-26 06:30:51',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (547,528,528,'Re: Feature Request',NULL,'Now you can enter Login not much than 20 symbols.  Regards, CodeCharge Support','2001-03-26 07:36:22','2001-03-26 07:36:22',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (548,541,541,'Re: Re: Problem with the \"@\" char','Eros Ciaiolo','Thanks for your answer, but Access97 works fine and I don''t plan to buy Office 2000 only for this bug. So folks... other tips ? :-)','2001-03-26 08:47:33','2001-03-26 08:47:33',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (549,541,541,'Re: Re: Re: Problem with the \"@\" char','Eros Ciaiolo','I''m readed the post again and maybe there are a misunderstanding... The program that not accept the \"@\" char in not Acces97, but CodeCharge.','2001-03-26 08:52:23','2001-03-26 08:52:23',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (550,541,541,'Re: Problem with the \"@\" char','CodeCharge Support','Run bookstore example and go to Registration page , register , enter email with @ character. Tell me if it works ok.','2001-03-26 09:47:10','2001-03-26 09:47:10',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (551,NULL,NULL,'Method ''~'' of object ''~'' failed.','berklee','Just a note for everyone....  I''m getting this error when I try and fill a page with custom SQL. It''s OK, I can still get the page to work, but the reason it''s happening is because CodeCharge doesn''t do a full MDAC install when you initially set up the program on your machine.  It''s got to do with version conflicts coming from the ADO files on your machine. They''re different from the ones that CodeCharge is looking for.  You can still get your page to work by doing the following (assuming your data is coming from one table):  Point the form to the database table, then configure your fields. Once you''ve done it, go in and set your custom SQL. You won''t be able to modify the fields in the form after, but you can at least get a working form.  Ciao for now! Your internet neighbor, berklee.','2001-03-26 10:53:07','2001-03-26 10:53:07',3);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (552,469,469,'Re: id key needed of Code Charge','berklee','Um, yeah. Me too.  I''d like some free licenses, please!  Could someone buy me 9 or 10? I promise I won''t do anything with them.  *sigh*  Don''t try to snow the developers.   We programmers are probably the only ones who appreciate the importance of paying for software! :)','2001-03-26 10:58:36','2001-03-26 10:58:36',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (553,541,541,'Re: Re: Problem with the \"@\" char','berklee','Actually, I have the same problem with SQL Server 2000.  I try and pass an e-mail address, and all i get is everything prior to the domain.  I just threw my hands up and built a workaround for my project.  P.S. I won''t be moving my app to Access 2000 ;)','2001-03-26 11:02:06','2001-03-26 11:02:06',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (554,528,528,'Re: Re: Feature Request','berklee','um...... ok..........  That''s what I''m saying... you can only enter 20 characters. But if I want someone to log in with an e-mail address, for example, I''d like to be able to just say ''I need 50 characters for the login field''.','2001-03-26 11:15:51','2001-03-26 11:15:51',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (555,NULL,NULL,'Grabbing the file name','hcsmith','How do I grab a file name?  Is there a specific variable for this?','2001-03-26 13:28:23','2001-03-26 13:28:23',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (556,NULL,NULL,'ASP - Include Files','imranz','I have an include file that I want to place into one of my pages. If it was a header or footer, I could just use the header/footer functionality built into CodeCharge. But this include will be filling a particular space in the template of my site, not just at the top or bottom.  Problem is, if you drop an include statement into the HTML template page, it doesn''t get included, since the HTML page is just a template.  So what I''m asking is, how can I include a file into a page and have it appear exactly where I want it to in the HTML page?  Is there some special code for this where I could push the contents of an include file into one a new variable on the template page?  Thanks.','2001-03-26 13:47:02','2001-03-26 13:47:02',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (557,NULL,NULL,'MS FrontPage 2000','ADW','What is the best way to integrate a web built using CodeCharge into an existing FrontPage 2000 web?','2001-03-26 15:46:17','2001-03-26 15:46:17',3);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (558,NULL,NULL,'Boolean Keyword Search','Carl C','I couldn''t find this one answered anywhere, so here goes:  Is there a way to do a boolean keyword search using CC.  In other words, if I have the words \"SQL Server\" in a field, I want to be able to do a search on my database with ''SQL and server'' or ''server and SQL'' and get the same result set.    The reason I ask is that we are considering using CC for a small, internal Knowledge Base.  Boolean search is pretty important in this situation.  Thanks,  Carl','2001-03-26 18:24:00','2001-03-26 18:24:00',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (559,NULL,NULL,'CodeCharge','Clinton Moore','Ok, could  you sell any script that you make?','2001-03-26 20:46:36','2001-03-26 20:46:36',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (560,NULL,NULL,'properities of form&field seetings are not clearly','hpguo','I try follow the examples of codecharge to setting all from&field''s  properties but i found they are''nt clearly description ans so i ca''nt understand all fuctions would some descritpins more clearly?? my e-mal:hoguo@m2.dj.net.tw thank you !!','2001-03-26 22:06:40','2001-03-26 22:06:40',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (561,541,541,'Re: Re: Problem with the \"@\" char','Eros Ciaiolo','Sorry Sorry Sorry Sorry Sorry Sorry... :-)  Please be mercy...  The Bookstore application works great, so I have thought that the error must be in any other place. Finally, I found it.  The error wasn''t in the field value but in the name field. The error message told me that it was an error in the field \"E-Mail\" and the only permitted characters are \"a..z\", numbers and \"_\". So I think that the error was in the \"@\" character. But the real error was the \"-\" character of the name field \"E-Mail\". I renamed \"E-Mail\" in \"Email\" and no more error message boring me... :-)  Again, sorry for the mistake and excuse me for the false alarm.','2001-03-27 00:59:25','2001-03-27 00:59:25',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (562,557,557,'Re: MS FrontPage 2000',NULL,'You can integrate separate pages generated  by CodeCharge into you site if you can. Also you can edit generated .html pages in FP. Use language+Template, get separately .html and  code file. Don`t edit text in curl braces {name} and comments.','2001-03-27 02:18:33','2001-03-27 02:18:33',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (563,NULL,NULL,'Idiot question','Henrik Lorange','In the Before Show event in a form, I have put some PHP code to alter default values etc. This works fine.  For some strange reason, the folloeing piece of code does not work, I guess it has to do with the NULL statement.  if ($fldtra_validto=NULL) {     $fldtra_validto=\"Forever\"; }  The field is a date field, which controls how long a training is valid. 0 means it is valid forever, and I want the user to see \"Forever\" instead of 0.  I have tried =0, =''0'', =\"0\", without result. The solution is probably dead easy, but I guess I need someone else''s eyes to look at it.  BTW, CC is a good tool once you get used to it! Henrik','2001-03-27 02:18:08','2001-03-27 02:18:08',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (564,560,560,'Re: properities of form&field seetings are not cle',NULL,'Page, Form, Field Properties Settings much depend  on the case. Header&Footer Tab is for your defined header or footer of page, form. Event Tab is for your defined events (parts of  your code will be included in generated code). SQL Tab using for SQL queries. Input Tab -  for choosing input parameters of form etc. For more information see CC Help/UserGuide. Also contact http://support.codecharge.com with specific questions','2001-03-27 00:25:59','2001-03-27 00:25:59',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (565,556,556,'Re: ASP - Include Files',NULL,'you can include necessary parts of your file into  Page, Form Events (Page, Form Properties/Events  Tab). Entered code will be included in generated CodeCharge code. Also use Global functions to include your own functions (Site/Modules). If it won`t help describe your problem in details and contact  http://support.codecharge.com  Regards, CodeCharge Support','2001-03-27 00:44:54','2001-03-27 00:44:54',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (566,563,563,'Re: Idiot question','CodeCharge Support','Use if ($fldtra_validto == \"\") {  $fldtra_validto=\"Forever\";  }','2001-03-27 01:17:11','2001-03-27 01:17:11',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (567,558,558,'Re: Boolean Keyword Search','CodeCharge Support','You should write approximately the next in FormProperties/Events Tab. sWhere = replace(sWhere, \" &and \", \"%'' and Field_Name like''%\") sWhere = replace(sWhere, \" |or \", \"%'' or Field_Name like''%\") And do search ''server &and SQL''.  Regards','2001-03-27 01:24:11','2001-03-27 01:24:11',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (568,551,551,'Re: Method ''~'' of object ''~'' failed.','CodeCharge Support','To avoid suck a problem install MDAC2.6 http://www.microsoft.com/data/download_260rtm.htm  Regards','2001-03-27 04:22:33','2001-03-27 04:22:33',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (569,551,551,'Re: Method ''~'' of object ''~'' failed.','CodeCharge Support','To avoid such a problem install MDAC2.6 http://www.microsoft.com/data/download_260rtm.htm  Regards','2001-03-27 04:22:33','2001-03-27 04:22:33',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (570,555,555,'Re: Grabbing the file name','CodeCharge Support','This depends on your scripting language in asp it''s request.servervariables(\"SCRIPT_NAME\") simply use environment variables','2001-03-27 05:43:59','2001-03-27 05:43:59',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (571,551,551,'Re: Re: Method ''~'' of object ''~'' failed.','berklee','I have SQL Server 2000, so ADO 2.6 is already on my machine. The binaries are a different version.  The actual ''problem'' is that you didn''t include the MDAC installer with CodeCharge, to make sure that the end users are using the same version of ADO.  (I''ve done this before, and that''s the problem I had.)','2001-03-27 06:42:08','2001-03-27 06:42:08',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (572,NULL,NULL,'multiple cells in to 1 cell','jdieppa','I''ve been trying to get information from multiple places in my db to be listed in just 1 cell in a table on the web page.  Could someone please tell me how to do this with codecharge.  If you need more info, I''d be glad to provide it.  Thanks','2001-03-27 07:13:59','2001-03-27 07:13:59',3);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (573,572,572,'Re: multiple cells in to 1 cell','Joachim Uersfeld','With a query like this:  SELECT myTable1.Field1 + myTable2.Field1  FROM myTable1, myTable2 WHERE ...','2001-03-27 10:24:38','2001-03-27 10:24:38',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (574,572,572,'Re: Re: multiple cells in to 1 cell','jdieppa','Thank you for your response. I apologize,  my question was not clear enough. The solution  you gave me would be good for putting together  information from different columns. What I need to do , is put information in different rows together.  The HTML table that I''m working with, displays 2 columns,  a project name and the names of the people working  on the project. Each name is listed on a different row  and the project name is repeated for each person.  Is there a way to have the project name listed only once  and have the names listed all in one cell of the table?   I''m not sure if I explained this very well... Any help would be appreciated.  Thanks','2001-03-27 11:15:37','2001-03-27 11:15:37',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (575,572,572,'Re: Re: Re: multiple cells in to 1 cell','Joachim Uersfeld','You can built a form only with the project name (just as a header) and built then a second form with the persons.','2001-03-27 14:15:31','2001-03-27 14:15:31',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (576,557,557,'Re: Re: MS FrontPage 2000','davidsmith','Ditto.  Also, a if-you-are-careful method is to set the output code path directly into the folder of your local web. That way, when you generate the code it goes straight into your web.  I found it easier to incorporate and reference other parts of the web that way.  The danger, of course, is if you re-generate your CodeCharge code.  Any changes that you have made in Front Page may be over-written if you don''t pay close attention to the prompts.','2001-03-27 14:36:15','2001-03-27 14:36:15',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (577,NULL,NULL,'WOW','Vampire','The most exiting product I''ve seen in a long time. What I''m not sure about, and I suspect I will find out when I play around a bit, is how to define my own templates. Overall a good piece of software.','2001-03-27 15:47:10','2001-03-27 15:47:10',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (578,519,519,'Re: Re: Login page problem','Peter Bourke','Still not working.  This is the schema of the user table -  CREATE TABLE [dbo].[users] ( 	[user_id] [smallint] IDENTITY (1, 1) NOT NULL , 	[login] [char] (31) NOT NULL , 	[password] [char] (31) NOT NULL , 	[role] [char] (31) NOT NULL , 	[security_level] [int] NOT NULL  ) ON [PRIMARY] GO  \"security_level\"  has values from 0 to 3 in it.  I get 2 identical login forms on the one page... so this must be a bug straight up, as the deisgn form in CC shows only one form.  I''ll email the CCS file to codecharge support.  Any other ideas appreciated.  Thanks, Peter','2001-03-27 20:15:04','2001-03-27 20:15:04',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (579,NULL,NULL,'Support Site Code','markus','Can i get the example code for your support site?  this is a great system, i would like to see how it works, and automatically sends out emails etc.  thanks  markus','2001-03-27 22:19:49','2001-03-27 22:19:49',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (580,NULL,NULL,'Date problems','J. Roels','Hi, i have international date problems, with the generated code.  When i try to insert a date as a dutch date, i get an odbc error. When I enter it in yyyy-mm-dd everthing is inserted.  When i open an existing record the date values are presented the dutch way so... dd-mm-yyyy. If i press update, without changing anything, i get the same odbc error.   I can write my own date functions, but it would be nice if codecharge could generated it working at once.   As a feature it might be handy to seperated the date field into three textfields, one for mm, one for dd and one for yyyy.   In the properties you could be able then, to add the field seperator which is placed between the fields. e.g / or -  and als your default orde dd-mm-yyyy or mm-dd-yyyy or what ever you prefer. That way it is completly felxible.','2001-03-28 06:08:09','2001-03-28 06:08:09',5);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (581,NULL,NULL,'Browser Compatibility','Steve','Just an FYI,  Some of the code produced by CodeCharge is not compatible with Netscape 6.x. For example, the login pages in the sample sites do not work with Netscape 6. Is this something that will be fixed in the future?','2001-03-28 06:56:27','2001-03-28 06:56:27',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (582,NULL,NULL,'Looking for a tool is code-charge it','kbenning@scitexdpi.com','I need a tool that will look into a data base, and then if it sees a down trend (in cash flow for example) will put up a red \"flag\". Will CC do this?','2001-03-28 06:56:02','2001-03-28 06:56:02',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (583,581,581,'Re: Browser Compatibility','Steve','Or maybe not. I re-generated the page and the problem went away. Disregard.','2001-03-28 07:51:14','2001-03-28 07:51:14',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (584,NULL,NULL,'listbox','cskarniak@ntic-conseil.fr','In a listbox, we can use a field and we can show an another field. For example, i''ve got a table (keywords) with two fields : ID and name.  In a form, i''ve got a listbox called \"motcle\" to show this table. The show field is \"name\". The show ID is record in the database.  I''d like to affect a new field (in a form - called newmotcle) with the name field and another field ....in a event like beforeupdate ... I can do that with ID field : fldnewmotcle=fdllistbox but i don''t know how to affect the name field in newfield.  can you help me. sorry for my English !!!! We think to buy CC soon. Is it possible to use the show field to an another field than','2001-03-28 08:23:37','2001-03-28 08:23:37',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (585,580,580,'Re: Date problems','Popee','I ran into a similar problem with both date and time.  I ended up doing individual textboxs for Day,Month,Year,Hour, and Minutes and putting them together the way I wanted manually.','2001-03-28 08:49:35','2001-03-28 08:49:35',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (586,577,577,'Re: WOW','Popee','If I might make a suggestion.  Let CC have it''s way with the templates.  Then when you''ve got the program working the way you want copy the HTML files to another folder and keep them as masters incase you screwup.  Now have your way with the generated HTML files.  Just don''t mess with the embedded CC code.','2001-03-28 08:54:26','2001-03-28 08:54:26',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (587,580,580,'Re: Re: Date problems','CodeCharge Support','We plan to add this kind of functionality. For now you can write Javascripts that will control input text in date fields.','2001-03-28 09:39:55','2001-03-28 09:39:55',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (588,NULL,NULL,'Listing combo box items based on selected item in','Mauricio Rapari','Listing combo box items based on selected item in another combo box in asp page. How can I do it?','2001-03-28 09:38:04','2001-03-28 09:38:04',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (589,NULL,NULL,'search and update','DavidBeccue',' I want a single web page to search for a record and then allow me to edit (update) that record on that page.  Is this possible?  I can''t seem to get an Update button unless I use a record type form, but then the search doesn''t work for me.  And if I use a grid-type form, then no update button appears.  Any ideas?','2001-03-28 12:05:03','2001-03-28 12:05:03',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (590,NULL,NULL,NULL,NULL,NULL,'2001-03-28 20:22:22','2001-03-28 20:22:22',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (591,NULL,NULL,'Upgrading to MSIE 5.x from 3.02','not a fan of M$','Problems with MSIE 5.x not working properly after upgrading from 3.02?  	\"When you use Internet Explorer, you may experience either of the following symptoms:  You disabled the use of style sheets in Internet Explorer 3.x, but after you upgrade to Internet Explorer 4.0 or 4.01 or Windows 98, you may be unable to re-enable them.\"  	... and ...  	\"This issue can occur because the ability to disable style sheets was removed from Internet properties.\"  	... and ...  	\"To work around this issue, use Registry Editor to open the following registry key and then perform the appropriate steps:  	HKEY_CURRENT_USER\\Software\\Microsoft\\Internet Explorer\\Main  To re-enable the use of style sheets, edit the string value \"Use StyleSheets\" in the above key and set it to yes.\"  ---- Hope this helps some save the two days of M$ hassle it cost me to find it.  Cheers,  - Don','2001-03-28 20:23:15','2001-03-28 20:23:15',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (592,NULL,NULL,'Insert forms','Louie','Hi How do I insert a form in between 2 other existing forms?  When I add a new form, it is only added at the end of the list, but I need it to go in between other forms.  Thanks','2001-03-28 22:14:45','2001-03-28 22:14:45',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (593,NULL,NULL,'How to add parameter to menu','J. Roels','Hi,  how to do the following.  I have a page, with information about a project.  With some detail information.  underneath i want to make a menu. containing  * milestones * activitiets * reports  the milestones link, goes to page where you can see the milestones and edit them.  I must pass the page_paramter project_id to milestones....  but if you choose menu as form type, you can''t seem to pass variables. how do i do this? completely within codecharge  Jurjen','2001-03-29 01:42:10','2001-03-29 01:42:10',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (594,580,580,'Re: Re: Re: Date problems','J. Roels','I think it is a good thing to add to the software soon.  For me it is verry annoying. I have to use dates a lot.  Regards Jurjen','2001-03-29 01:58:04','2001-03-29 01:58:04',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (595,592,592,'Re: Insert forms','CodeCharge Support','Insert new form e.g. Form3. Click on Form3 Tab.  You`ll see small arrow near it`s name. Click on it to move your form.  Regards','2001-03-29 04:49:52','2001-03-29 04:49:52',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (596,589,589,'Re: search and update','Ken Hardwick','I would suggest using the \"New Page Wizard\" and selecting the \"Grid and Edit (one page)\". As part of this wizard, you will be prompted if you want setup a search form also.  Ken Hardwick Norman,Oklahoma   DavidBeccue wrote:  > >I want a single web page to search for a record and then allow me to edit (update) that record on that page. > >Is this possible? > >I can''t seem to get an Update button unless I use a record type form, but then the search doesn''t work for me. > >And if I use a grid-type form, then no update button appears. > >Any ideas?','2001-03-29 06:55:02','2001-03-29 06:55:02',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (597,593,593,'Re: How to add parameter to menu','David Beccue','I wanted to do something that I think is similar.  I don''t know a \"good\" way to do it; but here is a way.  I wanted all the parameters passed to my phonelistGrid page to be passed to a more detailed page called phonelistGridDetails.  So I just created a some some HTML and Javascript in the footer of a form (instead of using CodeCharge''s Menu-type).  Here''s the footer code I used, YMMV.  Good Luck, David    <SCRIPT LANGUAGE=\"JavaScript\"><!-- function getmoredetails() {   var newloc = new String(self.location);   self.location = newloc.replace(/phonelistGrid/,\"phonelistGridDetails\");   return 0; } //--></SCRIPT>  <form action=\"x\"> <input type=\"button\" value=\"More Details on this Info\" onClick=\"getmoredetails();\"> </form>','2001-03-29 10:49:19','2001-03-29 10:49:19',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (598,NULL,NULL,'Need help with events','Walter','Hi all, I hope someone can help me. I have the following problem with events. In the form properties I have the following sql statement under sql: select orders.orderid, quantity, customerid, unitprice from orders, orderdetails where orders.orderid=orderdetails.orderid; and under events/before show I have the following event code: fldtotal = fldunitprice * fldquantity but when I build the page and try to run it I get an internal surver error. When I remove the event code the surver error goes away but I need it to give me the total column. The total column is named total in its properties and the data type is number. Please help. Thanks again  Walter','2001-03-29 18:29:33','2001-03-29 18:29:33',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (599,NULL,NULL,'PHP SERVER Win2000','Bernd Farka bfarka@hakamstetten.ac.at','I have a Win2000 Server and i need a plug in that i can use PHP with it. Can somebody help me? Please write to bfarka@hakamstetten.ac.at','2001-03-29 23:08:11','2001-03-29 23:08:11',6);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (600,598,598,'Re: Need help with events','Peter Roth','Why you don''t write the sql like:  select orders.orderid, quantity,         customerid, unitprice       , unitprice * quantity as total  from orders, orderdetails  where orders.orderid=orderdetails.orderid;   I do not try to run this query in CC. But as a normal SQL it work. In CC you can get the total as a normal column.  I hope this help  Peter','2001-03-30 02:29:31','2001-03-30 02:29:31',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (601,NULL,NULL,'browser status and compressed html','Thomas Wien','Hi,   I want to transfer compressed html-files from the server to the browser. I''m using gzip, therefore the extension is *.gz. After ensuring http_accept_encoding is gzip the file example.html.gz is displayed in the browser window properly as a html-file. In the status window is displayed the real size of the compressed file. But actually I want that in the status window is displayed the decompressed size while decompressing.  Once I figured out to write a little php-script like the following:   *******************  EXAMPLE.PHTML   <?php  $filename=\"example.html.gz\";   $filehandle=fopen($filename, \"r\");   $content=fread($filehandle, filesize($filename));   fclose($filehandle);   header (\"Content-Type: text/html\\n\\n\");   echo $content;  ?>   ***************   Consider, this script above doesn''t work. But the script I once created worked quite properly, but unfortunately I deleted it and now I cannot remember what I did to make it possible. I tried many possibilities to figure it out, but no way. The solution is not \"header (''Content-Encoding: gzip'')\", that would be the same as a direct request to the example.html.gz.  I think the solution is to find in the kind of content-type. When does the browser show the uncompressed size of file while decompressing used a special content-type?   Please, I need quick help.   Thomas Wien.','2001-03-30 06:44:49','2001-03-30 06:44:49',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (602,599,599,'Re: PHP SERVER Win2000',NULL,'Install Apache for Windows','2001-03-30 07:03:37','2001-03-30 07:03:37',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (603,599,599,'Re: PHP SERVER Win2000','Ultra Chronic-Monsta','Here''s a good link on how to run PHP on Win2000 thru IIS and not Apache. http://php.weblogs.com/php_cgi_iis','2001-03-30 08:06:00','2001-03-30 08:06:00',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (604,599,599,'Re: PHP SERVER Win2000','Mike Haisley','http://php.net (the offical php site) It has a windows binary posted.','2001-03-31 12:03:07','2001-03-31 12:03:07',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (605,563,563,'Re: Idiot question','Mitch Ward','In Php = is always an assignment operator, in you example you assigned NULL to your variable. What you need is == which is the logical equals operator.','2001-03-31 13:06:46','2001-03-31 13:06:46',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (606,NULL,NULL,'Master/Detail: more than one Primary-key ?','Jens O.','Hi, I have a relation with to keys. How can i link this two tables.','2001-03-31 14:42:43','2001-03-31 14:42:43',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (607,NULL,NULL,'PHP - MYSQL','Aidin','I''ve generated some php & template pages. I used ODBC to connect, connection established, when i upload files, the PHP files show up as php code...and template pages show up  with {header}, {name} etc...any suggestions as to why it doesnt pull data from the database?','2001-03-31 15:55:34','2001-03-31 15:55:34',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (608,NULL,NULL,'FTP/ActiveX can''t create object','Quim','Hi all,  I''m trying the 112 version and I have a problem when generating pages. If I generate in localhost/LAN no problem. If I generate using FTP I get the message \"ActiveX can''t create object\" (Error 429)  Any idea how to solve this?  Thanks.  Quim','2001-04-01 08:54:11','2001-04-01 08:54:11',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (609,598,598,'Re: Re: Need help with events','Walter','Thanks Peter!','2001-04-01 09:57:49','2001-04-01 09:57:49',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (610,NULL,NULL,'Calendar Popup','Robert J Bullock','Not sure who else agrees with me, but I think a neat new feature would be a dynamic HTML pop up calendar control for date fields. Maybe with an option to turn it on or off based on needs?  Who likes this idea?  Robert','2001-04-01 10:22:30','2001-04-01 10:22:30',3);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (611,NULL,NULL,'More than field in the tree list','ammer@flashmail.com','I need to display more than the name of the category in the tree form, please any suggestions Thank you in advance','2001-04-01 21:50:11','2001-04-01 21:50:11',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (612,NULL,NULL,'Validation before deleting a record','fredelnet@wanadoo.fr','How can we make a user validate before deleting a record?  Exemple: Delete y/n?  Using PHP/Mysql/Apache','2001-04-02 02:43:10','2001-04-02 02:43:10',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (613,NULL,NULL,'FP2000 Integration','ADW','Does anyone know how to integrate web pages generated by Code Charge into a FP2000 web that uses Shared Borders?.  I''ve tried adding the code that generates the borders to the Code Charge .asp & .html pages, but this does not work very well.  It appears to work ok with the .asp pages (the pages look complete with the correct borders, etc), but when I publish the web & then try to go from say the Login page I get the following error:  Response object error ''ASP 0156 : 80004005''  Header Error  login.asp, line 117  The HTTP headers are already written to the client browser. Any HTTP header modifications must be made before writing page content.  Line 117 is:   Parse \"Formlogin_form\", False  Any help much appreciated. ADW','2001-04-02 04:43:58','2001-04-02 04:43:58',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (614,557,557,'Re: Re: Re: MS FrontPage 2000','ADW','Thanks for the info. Have you tried to integrate any CC web pages into a PF web that uses shared borders.  I''ve managed to get the web working ok from within FP, but I can''t seem to get it working with shared borders. (see separate posting)  Any ideas? ADW','2001-04-02 04:46:53','2001-04-02 04:46:53',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (615,607,607,'Re: PHP - MYSQL','Joaquim Garcia','Review your http server configuration, it seems not to be properly configured You must configure it to server php files, read the documetntation about PHP, it''s explained on it.  hope it helps ...','2001-04-02 08:22:43','2001-04-02 08:22:43',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (616,608,608,'Re: FTP/ActiveX can''t create object','CodeXharge Support','Download newer version http://www.codecharge.com/download/files/CodeCharge1_1_16.exe  Regards','2001-04-02 09:11:16','2001-04-02 09:11:16',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (617,612,612,'Re: Validation before deleting a record','Peter Roth','Hi,  First make sure you have checked the \"Create Validation Rules\"-Checkbox within the form  properties screen.  Within the validation event, of the same form,  you can place some validations before doing some actions. In the Header/Footer tab place the script as follows within the Footer section:  <script Language=\"JavaScript\"> document.\"NameOfYourForm\".onsubmit=delconf; function delconf(){ if document.\"NameOfYourForm\".FormAction.value ==''delete'')   return confirm(''Delete record?''); } </script>  Please take a look in CC Examples Portal Page=EditMembers. I just get the script above from there.  I hope this helps  Regards Peter Roth software solutions, switzerland','2001-04-02 23:14:33','2001-04-02 23:14:33',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (618,NULL,NULL,'joining two pages','Farooq Ahmed','I am new user of CC. I made two pages -- first as search page. When I type any search field, it should display results in the next page but in my case, it shows records in the same page. How could I make two pages and join the two. From where can I get detailed tutorials of CC from the web; as I have already downloaded its tutorial from site which is not enough for me.','2001-04-03 01:15:05','2001-04-03 01:15:05',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (619,NULL,NULL,'Could work directly on Linux server?','3s@seric.es','Sorry for my stupid question. But is not clear for me. Codecharge permits me works directly in my Linux Red Hat internal server? Could save script and pages in this server and use MySql or other Databases without ODBC connections?  Thanks Jose Valle','2001-04-03 02:10:24','2001-04-03 02:10:24',3);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (620,NULL,NULL,'Templates','Jose','Hi,  I''m playing with Codecharge to see if I can join with our actual framework. We programming in PHP4 with MySql or PostgreSql.  I have a few questions: -where are the basic templates? I need to change totally the way that are showed actually. And works over the final produced template means a lot of work. -is it possible make modular pages with different zones and nested templates? or is it limited to header and footer zones only? If its possible what is the basic procedure?  Thanks a lot Jose Valle  Thanks','2001-04-03 05:49:45','2001-04-03 05:49:45',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (621,NULL,NULL,'Problem Memo fields - Text areas','Tony','I am very new to this, but inserting large amounts of text from a memo field into a text area was very easy in version 1.1. Now I''ve purchased 1.1.16 it doesn''t work....Is it me?  can anyone help?  Thanx in advance','2001-04-03 07:46:19','2001-04-03 07:46:19',8);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (622,NULL,NULL,'User Table Requirements','Andy','When creating a table to store user login information for code charge on sql server, what are the minimum column requirements of this table?','2001-04-03 08:50:19','2001-04-03 08:50:19',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (623,NULL,NULL,'Select Multiple in Form','wandrer@glcomputers.com','Here''s my problem.  I have three tables:  Students: (Student_ID) (Student_Name) ... ...  Class: (Class_ID) (Class_Name) ... ...  Class_Data (Student_ID) (Class_ID)  I''ve created a page that allows me to select a Student (Search Form with Student_ID being a listbox - table: students / Primary Key: Student_ID / Showing: Student_Name).  The form action goes to ''class_assign'' page. This page i would like to show all the class_names (using class_id from class tables) with the selected values being the class_id''s that match with the student_id from the class_data table.  Then, when the form is submitted, it should update the class_data table to add records where the classes are selected and delete records that are not selected where student_id equals the student_id on the field.  Is this able to be done ? Or is there a better way of doing something like this ?  I can do this in straight PHP/mySQL, but I would like to do this in CodeCharge so that it can be ported to any platform.  Paul','2001-04-03 09:09:34','2001-04-03 09:09:34',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (624,610,610,'Re: Calendar Popup','Popee','Yea I''ve added my own because I felt it important enough to go through the hassel.  It would be one less thing I need to modify on the templates.','2001-04-03 09:19:04','2001-04-03 09:19:04',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (625,580,580,'Re: Date problems','Volker Wawer','If you are using SQLserver enter on your default page in the open event the following   cn.execute (\"set language deutsch\")  that means dd-mm-yyy  Best regards   Volker','2001-04-03 11:46:31','2001-04-03 11:46:31',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (626,580,580,'Re: Re: Re: Re: Date problems','Srinivas B','What is the expected release date with this fix. I am using MySQL on Linux. Thanks.  -Srinivas srinivas@Hinduweb.org','2001-04-03 14:06:02','2001-04-03 14:06:02',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (627,621,621,'Re: Problem Memo fields - Text areas','ADW','I''ve found this as well.  I was about to post it but you just beat me to it.','2001-04-03 14:15:16','2001-04-03 14:15:16',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (628,NULL,NULL,'Creating a domain registration service','Jon Stanton','I want to sell sub-domains on some of my domain names and am trying to code a registration system with CodeCharge.  Basically it should work like any other domain registration system, ie. a user enters their required domain (theirname.mydomain.com) and it returns whether or not the domain is available. I have a number of domains they can use so they may be able to search ''theirname.alldomains'' and get a list of which ones are available and which ones aren''t. They then click on a ''available'' tag and enter their details.  I''ve got the basics done but can only work out how to show a results list whereby only records that are found are shown. I need to show those which are NOT found so they can proceed to a registration screen.  Can this be done easily in CodeCharge or will it require additional hand-coding?  If anyone can assist at all I would very much appreciate it. This is my first project. I''m used to UltraDev (ASP) but want to migrate to PHP instead so hope CC is the solution.  Many thanks in anticipation.','2001-04-03 15:26:47','2001-04-03 15:26:47',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (629,NULL,NULL,'Showcase Section','albert@netk.co.za','Hi there,  I was wondering if would be possible to start a showcase section where people could upload there ccs files for all to see . . . and we could learn from each other.  Thanks','2001-04-03 23:43:14','2001-04-03 23:43:14',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (630,NULL,NULL,'Custom Insert?','berklee','I''ve noticed in the help file that there is supposed to be a custom insert in the record form, but I can''t find the event.  Why can I not see it?','2001-04-04 04:16:02','2001-04-04 04:16:02',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (631,NULL,NULL,'Linked Tables','Ayman','Hi Why doesn''t CC recognize linked tables in MS Access2000? Thanks','2001-04-04 04:53:26','2001-04-04 04:53:26',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (632,618,618,'Re: joining two pages','CodeCharge Support','It displays record on the same page because of you a form of Grid type on the first page. Make this form on the second page. And at 1st page choose \"Form action\" as Second page. See CodeCharge examples , these are good for learning.','2001-04-04 08:39:11','2001-04-04 08:39:11',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (633,631,631,'Re: Linked Tables','CodeCharge Support','Because it is a database related feature. In access I of course can but if you''re using  ODBC data source for csv files it  can be not too easy.','2001-04-04 09:02:24','2001-04-04 09:02:24',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (634,619,619,'Re: Could work directly on Linux server?','CodeCharge Support','Sure . You can. ODBC connections will be used only in design time. On server you''ll only have mysql connections.','2001-04-04 09:06:34','2001-04-04 09:06:34',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (635,630,630,'Re: Custom Insert?','CodeCharge Support','There is no such event. There are only \"Before Insert\" or \"After Insert\".','2001-04-04 09:09:13','2001-04-04 09:09:13',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (636,622,622,'Re: User Table Requirements','CodeCharge Support','4 fields 1) Primary key  2) Login  3) Password 4) Security level (optional)','2001-04-04 09:13:45','2001-04-04 09:13:45',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (637,620,620,'Re: Templates','CodeCharge Support','1) Templates are in the same directory as your scripts. If script name is somename.php then template lies in the same dir as somename.html. 2) It is sure possible to have nested templates. (to be put in template of Header&Footer sections right in CC)  <!--BeginOuter> <p>some text {var_text} <!--BeginInner> Name: {name} Price : {price} <!--EndInner> <p> end of inner template <!--EndOuter>  $tpl->set_var(\"var_text\",get_name_fromdb()); //some loop $tpl->set_var(\"name\",get_name_fromdb()); $tpl->parse(\"Inner\", true); //end loop $tpl->parse(\"Outer\", false); //true-false means if you will parse this template multiple times appending or not.','2001-04-04 09:16:06','2001-04-04 09:16:06',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (638,623,623,'Re: Select Multiple in Form','CodeCharge Support','Using CodeCharge basics you can create a page which allows you to assign classes to the selected user. As an example you can use the following schema:  First Page   Search Form     student_id listbox based on the \"Students\" table.   Grid Form based on the \"Class_Data\" table.    The grid is insertable and the action is on the second page.     This form has input transit requred parameter student_id.     The grid contains one column with URL type joined with \"Class\" table.  Second Page   Record form based on the \"Class_Data\" table.   This form has \"Transit Required Parameter\" student_id and one field.   The action is on the the first page fo the current form.     The page has one listbox field based on the database Class_ID field .  This method does not required any specific features of the language and  these pages can be generated in any of the supplied languages.  If you want to create one form allowing updating of the all student records you may use the events and custom columns in grid.  Please let us know whether our solution is sufficient for you. Otherwise we can provide a sample grid, which will be the language dependent.  Thanks, CodeCharge Support','2001-04-04 09:44:13','2001-04-04 09:44:13',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (639,599,599,'Re: Re: PHP SERVER Win2000','Nihil','I would stay away from the win32 implementation of apache, very buggy.  Stick with the PHP win32 binary.','2001-04-04 10:39:21','2001-04-04 10:39:21',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (640,619,619,'Re: Re: Could work directly on Linux server?','Chris','At design time however, how can it grab the tables etc from the remote server for page design?','2001-04-04 11:26:09','2001-04-04 11:26:09',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (641,NULL,NULL,'CONFIGDRIVER error message installing CODECHARGE','Peter','Hi everybody...  Although the application seems to work, I do get the following message when installing it: \"CONFIGDRIVER: Unable to configure ODBC driver Microsoft Access Driver (*.mdb): Could not load the setup or translator library\".  Does anybody know why and how to solve it? Regards','2001-04-04 11:51:58','2001-04-04 11:51:58',3);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (642,NULL,NULL,'PERL and CGIs... how and where should...? Basics','Peter','Hi everybody,  Anybody has tried with success the PERL and CGIs language for the BOOKSTORE example????  If yes,... How did you do it???? what variables did you put??? Hod did you modify the CGI files and where did you put them? where did you leave the template (html) files???  Regards and thank you','2001-04-04 11:54:43','2001-04-04 11:54:43',3);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (643,NULL,NULL,'AND and OR Operators in Grid & Search','schoenf@chello.at','Hi there,  How do I change the behaviour of SEARCH from AND to an OR operator AFTER the page has been created with the wizard?  I didn''t find any option  br -schoenf','2001-04-04 15:25:52','2001-04-04 15:25:52',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (644,463,463,'Re: Re: Custom patterns?','Jeff Stuart','How soon do you plan on allowing us to create our own patterns or modify existing ones?','2001-04-04 17:54:33','2001-04-04 17:54:33',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (645,NULL,NULL,'Event queries','Chris','This may be a lack of understanding about the product, but I''m trying to figure out how to best add a column to a grid that makes a mysql call with a row value as a portion of it...i.e.  value for domain is mydomain.com, I want to also have a column of Number of Domains that is: select count(*) as counter from DomainInfo where domain=''$domainName'' help????','2001-04-04 20:16:08','2001-04-04 20:16:08',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (646,645,645,'Re: Event queries','Chris','Never mind, figured it out - if anyone else is interested, I added a new field on the form, edited the field properties (without selecting a name), and put: =dlookup(\"DomainInfo\", \"count(*)\", \"clientID=$fldclientID\") where DomainInfo is my table, count(*) is my select param and clientID=$fld.. is selecting it based on the clientID for that particular row I''m doing this for PHP BTW','2001-04-04 20:54:51','2001-04-04 20:54:51',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (647,641,641,'Re: CONFIGDRIVER error message installing CODECHAR','CodeCharge Support','Peter don`t worry about this errormessage. It`s not CodeCharge`s error, it`s not an error at all.  It won`t affect on the CodeCharge`s work','2001-04-05 00:33:02','2001-04-05 00:33:02',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (648,613,613,'Re: FP2000 Integration',NULL,'Right now the only way to insert some code into  <header>...</header> this is to manually modify  the generated header file. From that point CodeCharge will ask you if you  want to overwrite modified file when generating  new code.','2001-04-05 00:40:35','2001-04-05 00:40:35',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (649,593,593,'Re: How to add parameter to menu','Henrik Lorange','Making a \"jump\"-page solves the problem for my case. I have to pass the $PHP_AUTH_USER variable to a page, and the menu sends the user to a jump page, which has the following Before Show event:  global $PHP_AUTH_USER; print \"<SCRIPT>location.replace(\\\"ReservationHistory.php?res_alias=$PHP_AUTH_USER\\\")</SCRIPT>\";  The \"jump\" page is a record page with no fields on it. This does the trick for me! Hope this is helpful to someone.  Regards, Henrik','2001-04-05 01:37:40','2001-04-05 01:37:40',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (650,630,630,'Re: Re: Custom Insert?','berklee','You''re gonna want to update your help file, then, dude...  Straight from the documentation, under ''Record Form Events'':  Custom Insert  Allows overriding of the standard record insert processing.   Custom Update  Allows overriding of the standard record update processing.   Custom Delete  Allows overriding of the standard record deletion processing.','2001-04-05 09:44:18','2001-04-05 09:44:18',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (651,NULL,NULL,'CF Error in CC','spectrum@post.com','When CodeCharge generate my test site (EmplDir example) occur this error   Error Occurred While Processing Request Error Diagnostic Information Just in time compilation error  An unknown attribute ''SCOPE'' has been encountered at document position (19:9) to (19:13) while processing tag CFLOCK. This tag can only take the following attributes:   NAME THROWONTIMEOUT TIMEOUT TYPE The last successfully parsed CFML construct was a CFLOCK tag occupying document position (19:1) to (19:7).  The specific sequence of files included or processed is: C:\\INETPUB\\WWWROOT\\STDARH\\DEFAULT.CFM         C:\\INETPUB\\WWWROOT\\STDARH\\COMMON.CFM      CFInclude  The error occurred while processing an element with a general identifier of (CFINCLUDE), occupying document position (1:1) to (1:33).   Date/Time: 03/29/01 13:49:56 Browser: Mozilla/4.0 (compatible; MSIE 5.0; Windows 98; DigExt) Remote Address: 127.0.0.1 Template: C:\\Inetpub\\wwwroot\\stdarh\\Default.cfm   Thanx for help me.','2001-04-05 10:44:02','2001-04-05 10:44:02',3);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (652,NULL,NULL,'Coldfusion','Matt','I downloaded the demo taskman for coldfusion and the appropriate database. After unzipping and seting up the odbc-datasource nothing happened.  I got lots of errors (parameters not found).  Is codecharge a fake, are the examples bad or has someone taskman for coldfusion running?  Matt','2001-04-05 12:01:15','2001-04-05 12:01:15',5);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (653,599,599,'Re: Re: PHP SERVER Win2000','Andy','Try www.nusphere.com - easy install of  both Apache, Nusphere and MySql - works great','2001-04-05 18:35:04','2001-04-05 18:35:04',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (654,652,652,'Re: Coldfusion','CodeCharge Support','In \"DataLink\" properties dialog please click \"Test connection\" , will it work ok ? Please cut-and-paste your errors here.','2001-04-06 01:26:19','2001-04-06 01:26:19',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (655,651,651,'Re: CF Error in CC','trinity','I suggest you to upgrade to CF 4.01','2001-04-06 01:29:19','2001-04-06 01:29:19',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (656,642,642,'Re: PERL and CGIs... how and where should...? Basi','CodeCharge','Did you successfully generate BookStore example without any modifications. Please tell what exactly you want to do , and I will give you advice. Basically , code can be added through Page Properties/Events and Form Properties/Events sections.  Please give more details.','2001-04-06 01:32:55','2001-04-06 01:32:55',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (657,643,643,'Re: AND and OR Operators in Grid & Search','CodeCharge Support','during creation form with wizard if you chose ''AND'' one textbox per every search criteria  creating (e.g. 3 criteria - 3 textboxes),  if you chose ''OR'' only one textbox for all  criteria creating (e.g. 3 criteria - 1 textbox).  So you cant switch from ''OR'' to ''AND''and vice  versa in principle.  to generate search form with OR withou wizard you should on the search form add only one field  but not assign a real field from the table to it.  Just define ''Caption''for it. Choose so many input parameters for your search  form as you want search criterias and check one  of them as ''Transfer''. On related Grid form also choose the same input parameters as for Search  form, don`t forget make the proper parameter as  transfer Regards, CodeCharge Support','2001-04-06 01:46:58','2001-04-06 01:46:58',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (658,628,628,'Re: Creating a domain registration service','CodeCharge Support','Jon, Define for proper field (e.g. pr_id) Default  Value ''Available''. Then write in SQL Tab of this  form query like: SELECT pr.pr_id, pr.name FROM pr RIGHT JOIN Table1 ON pr.pr_id=Table1.pr_id  where pr - is your table with missing records  (1,3,4) and Table1 has all records (1,2,3,4).  Regards, CodeCharge Support','2001-04-06 01:53:29','2001-04-06 01:53:29',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (659,606,606,'Re: Master/Detail: more than one Primary-key ?','CodeCharge Support','to set relations of tables with keys set one  during creating the Master/Detail  by wizard and the other add as input parameters for Master form and Detail form  Regards, CodeCharge Support','2001-04-06 02:23:43','2001-04-06 02:23:43',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (660,642,642,'Re: Re: PERL and CGIs... how and where should...?','Peter','Thank you for your reply.  I did generate the Bookstore example in ASP without any modifications... in IIS Server... it works.  I wanted to try Perl and CGIs... but either I am  setting something wrong before generating  the bookstore code or the CGIs and templates should not be in the same folder.. but it doesn''t work in my Apache server.  Looking forward to hearing from you Regards Peter','2001-04-06 13:07:58','2001-04-06 13:07:58',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (661,641,641,'Re: Re: CONFIGDRIVER error message installing CODE','Peter','Thank you for your reply.  But why does this happen? Why nobody has mentioned  it before?  Another question... When and what functionalities is going to have the next Codecharge version  (I can''t wait to see it)?  Thanks again Peter','2001-04-06 13:21:17','2001-04-06 13:21:17',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (662,599,599,'Re: PHP SERVER Win2000','Marc','www.firepages.com.au, it''s free, for W2K you have  make a few small changes, easy enough. You can write to me if you have problems. Diamonds@SwissGems.com','2001-04-07 07:19:09','2001-04-07 07:19:09',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (663,NULL,NULL,'Center','Marc','How do I center a simple page consisting of only 1 form? Marc','2001-04-07 07:26:45','2001-04-07 07:26:45',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (664,NULL,NULL,'Search Form Results','Scott','I have created a search form and results grid form on the same page. When it is openned in the browser the entire database shows up in the results.  Any search results in the entire database showing in the results.  How can I fix this?','2001-04-07 07:37:30','2001-04-07 07:37:30',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (665,NULL,NULL,'Break','Marc','I am planning a portal page. I would like to have one or more break tag(s) between each form. Can I do this from CC? Best regards. Marc.','2001-04-08 02:25:33','2001-04-08 02:25:33',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (666,663,663,'Re: Center','Joachim Uersfeld','Insert into page header:  <div align=\"center\"><table border=\"0\"><tr><td>  Insert into page Footer:  </td></tr></table></div>','2001-04-08 05:29:13','2001-04-08 05:29:13',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (667,665,665,'Re: Break','Joachim Uersfeld','You can do this in the form properties / footer : Insert <br> or <p> or insert a blank image.','2001-04-08 05:40:48','2001-04-08 05:40:48',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (668,NULL,NULL,'Limit Number of Returns','Marty','How do you limit the number of returns per query to 25?','2001-04-08 06:54:01','2001-04-08 06:54:01',3);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (669,668,668,'Re: Limit Number of Returns','CodeCharge Support','Click \"Form properties\" icon , you can set it in common tab , enable page scroller , set  \"Records\" number.','2001-04-08 07:00:56','2001-04-08 07:00:56',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (670,664,664,'Re: Search Form Results','CodeCharge Support','Select your grid form in CC. Click Form Properties icon. Select \"Input\" tab. Add input variables (same variables that are ouput in Search form)','2001-04-08 07:04:27','2001-04-08 07:04:27',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (671,668,668,'Re: Re: Limit Number of Returns','Marty','That limits the number of records per page, I want to limit the Total records returned to 25.','2001-04-08 15:45:49','2001-04-08 15:45:49',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (672,664,664,'Re: Search Form Results','Henrik Lorange','If you check the box \"required\" on the key field(s), the results will not display until the user submits the search form.','2001-04-09 00:14:52','2001-04-09 00:14:52',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (673,642,642,'Re: Re: Re: PERL and CGIs... how and where should.','CodeCharge Support','Templates and cgis must be in the same folder. In the same folder create a folder \"session_files\" and give it all possible permissions. Give your cgis enough permissions(chmod 755 *, as I remember). Everything should be ok.','2001-04-09 02:35:13','2001-04-09 02:35:13',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (674,668,668,'Re: Re: Re: Limit Number of Returns','CodeCharge Support','You may either: a) Instead of the table, use SQL query in CodeCharge with word TOP, like: SELECT TOP 100 my_table.field1, my_table.field2 FROM my_table;  or  b) Instead of the table, use MS Access Query in CodeCharge. When creating your query in MS Access, right-click somewhere on the Query design panel, select \"Properties\" and then enter the number of records in \"Top Values\" property.','2001-04-09 02:55:21','2001-04-09 02:55:21',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (675,NULL,NULL,'Functions: stat.close() and comm.close()','Robi','Why functions:        </body>        </html>        -------------------------------------------        <%        if ( stat != null ) stat.close();        if ( conn != null ) conn.close();        %>        ------------------------------------------        <%!  closed page?  I''m used: win98 resin1.1.5 (jsp) CodeCharge 1.1.16 Trial Version Sybase Adaptive Server Anywhere Database Engine Version 6.0.3.2747  Configuration: GENERAL ^~~ Language: JSP 1.1 Server Side Application Path: /  Publishing ^~~ Location: Local/Network Output Code Path: c:\\resin1.1.5\\doc\\{my_Folder} Output File Format: Windows Live Site URL: http://localhost/{my_Folder}  Database ^~~ Connection String: jdbc:sybase:Tds:localhost:2638/{my database name} com.sybase.jdbc2.jdbc.SybDriver  Thanks, _______________________ robi','2001-04-09 03:16:31','2001-04-09 03:16:31',6);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (676,621,621,'Re: Re: Problem Memo fields - Text areas','CodeCharge Support','What is your production platform ? What is data size that you failed to post ? For more info http://www.adodb.com/errors_new_result.asp?errors_id=846','2001-04-09 03:38:37','2001-04-09 03:38:37',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (677,675,675,'Re: Functions: stat.close() and comm.close()','CodeCharge Support','Do you mean why  <%  if ( stat != null ) stat.close();  if ( conn != null ) conn.close();  %>  is at the very and of the page after </html? tag? Probably because they may have been opened previously. Please ask more detailed answer.','2001-04-09 03:51:57','2001-04-09 03:51:57',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (678,675,675,'Re: Functions: stat.close() and comm.close()','CodeCharge Support','these functions don`t close the page themselves,  they close connection to database. And they are  the last functions in the code file, also yhey  can be posted in other part of file.','2001-04-09 03:55:35','2001-04-09 03:55:35',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (679,621,621,'Re: Problem Memo fields - Text areas','CodeCharge Support','Tony and ADW, please give us next information: CodeCharge version (see Help/About), Windows or other OS version, language you use, IExplorer version. Contact us: support@codecharge.com','2001-04-09 04:00:31','2001-04-09 04:00:31',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (680,675,675,'Re: Re: Functions: stat.close() and comm.close()','CodeCharge Support','That is CodeCharge behavour. It''s abolutely ok since there is such thing as connection pooling. Connection pooling spreads the connection overhead across several user requests by  establishing a pool of connections which  your internet applications can use. Put another  way, each user request incurs the overhead of only a fraction of the cost of connecting and  disconnecting. After the initial resources are  spent to produce the connections in the pool,  additional connecting and disconnecting overhead is insignificant because the existing connections are reused repeatedly.','2001-04-09 04:12:08','2001-04-09 04:12:08',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (681,589,589,'Re: search and update','CodeCharge Support','Use wizard for Grid and Edit on one page, also add search form at this page. You can`t get search results in Record form  directly, only through Grid form.  Regards, CodeCharge Support','2001-04-09 05:09:44','2001-04-09 05:09:44',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (682,579,579,'Re: Support Site Code','CodeCharge Support','Download it: http://www.codecharge.com/download/files /examples/demo_support.zip','2001-04-09 05:23:19','2001-04-09 05:23:19',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (683,NULL,NULL,'MySQL access probs','tCBUK','OK I am running windows 2000 and I am also running mysql from my pc.  I have a few databases set up on my mysql server.  I have a working connection string of Provider=MSDASQL.1;Persist Security Info=False;User ID=tcbuk;Data Source=sample-MySQL; however codecharge is saying there are no databases on my server.  I was wondering what I should put for my database name cos currently I have named it the same as the database im trying to access on my mysql server but it does not deted it and says there are no tables etc - anyone have any ideas? id be very appreciative for any help.','2001-04-09 07:40:30','2001-04-09 07:40:30',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (684,683,683,'Re: MySQL access probs','CodeCharge Support','Have you isalled myODBC for mysql driver on your computer ? It''s here :http://www.mysql.com/downloads/api-myodbc.html After that you need to create ODBC datasource for your database. It''s name shoudb''t be same as db name. Alll this settings are set and configured at ODBC data source properties ,  in Control Panel/ODBC. There you must create your ODBC data source with mysql driver for a given datavase. You must specify host name(IP), database name , login/password.  When you click \"test connection\" button in \"Data Link properties\" dialog , does it tell everything''s ok ? >however codecharge is saying there are no >databases on my server When exactly does it say so ?','2001-04-09 08:10:29','2001-04-09 08:10:29',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (685,NULL,NULL,'Is it a good product ?','Vincent','What do you think of codecharge ?','2001-04-09 09:31:48','2001-04-09 09:31:48',5);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (686,NULL,NULL,'CF Error','David Walsh','Hello All,  I am giving CodeCharge a tryout and I am working with cold fusion. I have a created a little site based off 1 of the templates and have run into this error:  \"ODBC Error Code = S1090 (Invalid string or buffer length)  [Microsoft][ODBC Driver Manager] Invalid string or buffer length  The error occurred while processing an element with a general identifier of (CFQUERY), occupying document position (16:3) to (16:166).\"  Anyone have an idea why I would get this error and how to fix it?  Thanks, Dave Walsh steelrat@steelrat.com','2001-04-09 15:38:19','2001-04-09 15:38:19',3);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (687,686,686,'Re: CF Error','CodeCharge Support','What is your connections string ?','2001-04-10 02:26:10','2001-04-10 02:26:10',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (688,686,686,'Re: CF Error','CodeCharge Support','What is your connection string ?','2001-04-10 02:26:10','2001-04-10 02:26:10',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (689,NULL,NULL,'Update thru URL','A. Markovic','Please, can someone tell me how to do this. I want to update records and some filds thru URL. --------- exmp. \"FormAction=update\"  http://localhost/insert.asp?id=1&var1=qwerty&FormName=insertForm&FormAction=update  This don''t work! Why? --------- But, when \"FormAction=insert\" work  http://localhost/insert.asp?&var1=qwerty&FormName=insertForm&FormAction=insert --------- Please help.  Best regards.  A.M.','2001-04-10 05:20:19','2001-04-10 05:20:19',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (690,619,619,'Re: Re: Re: Could work directly on Linux server?','Ed Finkler','You''ll need to use an appropriate ODBC driver (if you''re using Mysql, grab the MyODBC driver) and use that to connect to your remote db server.','2001-04-10 06:58:00','2001-04-10 06:58:00',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (691,136,136,'Re: Sybase ODBC','Sam Moses','I''m having the same problem when trying to connect  with mysql','2001-04-10 12:26:02','2001-04-10 12:26:02',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (692,NULL,NULL,'shbang generation','eventi@yahoo.com','When I generate Perl for use with Unix servers, it generates a  #!\\Perl\\bin\\perl.exe at the top, which is obviously a Windows Path... Is it possible to configure your own perl path?','2001-04-10 12:33:35','2001-04-10 12:33:35',3);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (693,686,686,'Re: Re: CF Error','David Walsh','This is the current string:  Provider=Microsoft.Jet.OLEDB.4.0;User ID=Admin;Data Source=C:\\Program Files\\CodeCharge\\Examples\\Portal\\Portal_MSAccess.mdb;Persist Security Info=False  Dave','2001-04-10 13:38:29','2001-04-10 13:38:29',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (694,NULL,NULL,'Feature Request','Sam Moses','Guys, Codecharge is the greatest thing to happen to web programmers since since dreamweaver. I just discovered iHTML though, and Codecharge doesn''t seem to support it. Are there any plans to include it in a future version???','2001-04-10 14:36:58','2001-04-10 14:36:58',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (695,675,675,'Re: Re: Re: Functions: stat.close() and comm.close','Robi','Thanks,  What do I do with Life Data ?  500 Servlet Exception java.sql.SQLException: JZ0S2: Statement object has already been closed. 	at com.sybase.jdbc2.jdbc.ErrorMessage.raiseError(ErrorMessage.java:439) 	at com.sybase.jdbc2.jdbc.SybStatement.checkDead(SybStatement.java:1654) 	at com.sybase.jdbc2.jdbc.SybStatement.close(SybStatement.java:420) 	at _jsp._lex_0wla._hasla__jsp._jspService(/hasla.jsp:149) 	at com.caucho.jsp.JavaPage.service(JavaPage.java:89) 	at com.caucho.jsp.JavaPage.subservice(JavaPage.java:83) 	at com.caucho.jsp.Page.service(Page.java:280) 	at com.caucho.jsp.QServlet.service(QServlet.java:161) 	at com.caucho.server.http.AbstractRequest.service(AbstractRequest.java:452) 	at com.caucho.server.http.AbstractRequest.service(AbstractRequest.java:395) 	at com.caucho.server.http.PageCache$Entry.service(PageCache.java:256) 	at com.caucho.server.http.PageCache.service(PageCache.java:105) 	at com.caucho.server.http.VirtualHost.service(VirtualHost.java:424) 	at com.caucho.server.http.Request.dispatch(Request.java:212) 	at com.caucho.server.http.HttpRequest.handleRequest(HttpRequest.java:207) 	at com.caucho.server.http.HttpRequest.handleConnection(HttpRequest.java:142) 	at com.caucho.server.TcpConnection.run(TcpConnection.java:142) 	at java.lang.Thread.run(Thread.java:484)   -------------------------------------------------------------------------------- Resin 1.1.5 -- Mon Oct 2 17:34:31 PDT 2000   Robi','2001-04-11 04:17:56','2001-04-11 04:17:56',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (696,692,692,'Re: shbang generation','CodeCharge Support','Yes, it may occur if you FTPUpload your files. We`ll fix it in next version. Now to get Unix files via FTP follow next steps: 1.choose ''Local/Network''; 2.choose ''Output File Format'' Unix; 3. switch to ''FTP''; click generate.','2001-04-11 04:42:14','2001-04-11 04:42:14',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (697,675,675,'Re: Re: Re: Re: Functions: stat.close() and comm.c','CodeCharge Support','What is your CC version ? If it''s lower than 1.1.16 I recommend you to download latest version from our site. Otherwise please send your ccs file with database (or some script to create it) to support@ocdecharge.com','2001-04-11 05:39:12','2001-04-11 05:39:12',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (698,136,136,'Re: Re: Sybase ODBC','CodeCharge Support','Perhaps it''s MDAC related connectivity problem. Download and install latest MDAC from http://www.microsoft.com/data/download_260rtm.htm','2001-04-11 07:03:14','2001-04-11 07:03:14',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (699,675,675,'Re: Re: Re: Re: Re: Functions: stat.close() and co','Robi','CodeCharge 1.1.16 Trial Version.  Ok. Thanks,  Robi','2001-04-11 07:13:35','2001-04-11 07:13:35',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (700,NULL,NULL,'Email shopping cart contents ?!','Edwin','After experimenting with the online shop example, I was wondering if there isn''t a simple way to complete the order ? In other words: e-mail the cart-contents to the shop-owner, sending a confirmation to the customer and emptying the shoppingcart.  I can''t really find an easy way to achieve this. Someone ideas ???  Edwin','2001-04-11 12:26:39','2001-04-11 12:26:39',8);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (701,685,685,'Re: Is it a good product ?','berklee','It''s not bad, but it''s still a bit buggy. I like what it does, but I''m hoping that the documentation will be better matched with what''s actually in the software. (I think it was written while it was in development, because there are some features in the docs that never happened in the software.)','2001-04-11 16:52:47','2001-04-11 16:52:47',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (702,685,685,'Re: Is it a good product ?','Ken Hardwick','It is a very good product and well worth the \"low\" cost.  I''ve been using it to generate ASP code and have had very few \"bugs\" with this product. The support is very,very good.  If you plan to develop web pages that on which you retrieve/update data from databases...then you should definately use this product.','2001-04-11 17:11:42','2001-04-11 17:11:42',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (703,NULL,NULL,'How to use passed parameter in SQL lookup','Marko','Can I use a passed parameter to a form in order to do a SQL lookup in order to fill a listbox?  If yes, how can I mark the parameter, I have tried standard :<parameter> format but this soes not help :)','2001-04-11 22:20:51','2001-04-11 22:20:51',4);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (704,NULL,NULL,'Params problem','sinisa','I pass to a form three parameters, id, surname, and name. ID is used to fill one field in the new record while name and surname are passed only to be printed on the form as additional information. But I cannot define variables on the form that are not connected toa database field, or can I?','2001-04-12 00:56:32','2001-04-12 00:56:32',4);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (705,685,685,'Re: Is it a good product ?','Sam Moses','I look back to my days manually coding db connections and forms and kick myself. Codecharge is really the only product of it''s kind that I like. There are others but I can''t stand to work with them. I love my little copy of codecharge.','2001-04-12 01:40:43','2001-04-12 01:40:43',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (706,NULL,NULL,'The Demos','Sam Moses','Hey there. I was noticing that the demos on the site are not the same as the ones that come with the product. I like the simpler version of the online store, and was wondering if there is a place to download the codecharge project files for these demos. Thanks.','2001-04-12 01:49:20','2001-04-12 01:49:20',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (707,704,704,'Re: Params problem','CodeCharge Support','You can define your own variables on the form.  Just add new field but not select any table`s  field for it. Set up its Caption and Name  (Field Properties/Common Tab).','2001-04-12 01:55:02','2001-04-12 01:55:02',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (708,NULL,NULL,'Bug report','sinisa','if you use perl 5.0 template you cannot enter NOW() or SYSDATE() as a default value in the field of type date. I looked at thecommon.pm and you only make difference between Number and String (sub ToSQL)','2001-04-12 02:33:06','2001-04-12 02:33:06',6);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (709,703,703,'Re: How to use passed parameter in SQL lookup','mighty Alex :-))','depends on your scriping language ,  select id,name from table where id = \" &  GetParam(\"some_param\") & \"  select must have some id as 1st field , some text as 2nd field','2001-04-12 03:07:05','2001-04-12 03:07:05',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (710,706,706,'Re: The Demos','CodeCharge Support','See http://codecharge.com/download/?templ=examples&example_id=1','2001-04-12 03:19:19','2001-04-12 03:19:19',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (711,708,708,'Re: Bug report','CodeCharge Support','Please give more details , it''s not quite clear to me.','2001-04-12 04:45:15','2001-04-12 04:45:15',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (712,708,708,'Re: Re: Bug report','Sinisa','I a doing a submit form and I have several fields:  name - text lastname - text group - int entry_date - date  group is given to the form when form is called, first and last name appear as text fields while enry_date should be set automatically to current date/time when user submits the data. I set the entry_date as hidden field of type date and set the default value to \"=NOW()\" (tried also \"Now()\" notation). but this didn''t work, I went to Common.pm and edited ToSQL sub ,  I added aditional elsif for Date field  (if substr($Value,0,1) eq ''='' evaluate as funcion, else evaluate as string (put in '''')) but since every generation rewrites common.pm I have a bad time rewriting changes each time:  the changed sub  sub ToSQL {   my ( $Value, $sType ) = @_;   if ( $Value eq \"\" ) {     return \"Null\"   } else {     if ( $sType eq \"Number\" ) {       return $Value     }     elsif ( $sType eq \"Date\" ) {                if (subsr($Value,0,1) eq ''='')            {               return substr($Value,-(length($Value)-1));            }            else            {              $Value =~ s/''/''''/g;              $Value =~ s/\\\\/\\\\\\\\/g;              return \"''\" . $Value . \"''\"            }     }      else {       $Value =~ s/''/''''/g;       $Value =~ s/\\\\/\\\\\\\\/g;       return \"''\" . $Value . \"''\"     }   } }   this evaulates Date field type as string if first char is not = else it returns function name without leading = sign.','2001-04-12 04:48:36','2001-04-12 04:48:36',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (713,700,700,'Re: Email shopping cart contents ?!','CodeCharge Support','It may require some manual programming. Well , you may put an URL \"Complete\" on a shopping cart script ,  it will point to a new CC page. On this new page : select \"Page properties\"/\"Open\" event , enter pure code that will  iterate through orders in \"orders\" table , and after appaneding each record data to email body(just a string) , will delete this record. That use CDONTS or another component to email this string to customer and site owner. It''s takes some coding.','2001-04-12 06:16:43','2001-04-12 06:16:43',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (714,700,700,'Re: Re: Email shopping cart contents ?!','Edwin','Thank you for the reply, but then I think CC will not suit me in building a complete shopping site at this point then, while I''m not a coder (I''m just slowly getting to learn PHP a little).  At least I will try to make the custom code the way you explained but at this moment I''m not very confident in succeeding this.  Regards, Edwin','2001-04-12 08:24:31','2001-04-12 08:24:31',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (715,708,708,'Re: Re: Re: Bug report','CodeCharge Support','You can enter functions in default values , not like \"now()\"  , but like \"=now()\"','2001-04-12 10:40:40','2001-04-12 10:40:40',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (716,706,706,'Re: The Demos','Sam Moses','Thanks a lot. That was great.','2001-04-12 12:05:41','2001-04-12 12:05:41',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (717,NULL,NULL,'Multi-language web site','Daniel Raymond','Hi,  how can I support english and french in the same project ?  We have a table message with an ID, a french description and english descrition?  Thanks','2001-04-12 12:34:52','2001-04-12 12:34:52',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (718,NULL,NULL,'Help on event','Daniel Raymond','Hi,  I would like to have a tutorial for each event of Codecharge.  Ex: Before Show, After Insert, etc.  And what kind of code we can put in these events.  Also a Tutorial on the structure of the ASP code generated.  Thanks.','2001-04-12 13:22:48','2001-04-12 13:22:48',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (719,700,700,'Re: Re: Re: Email shopping cart contents ?!','Andrea','In effect I can not understand why CC do not insert some simple routine that can be used for This pourpose. I think many CC user are not familiar with programmig language, so they buy CC Why do not make easy way to use CC ?? Many user are interesting in use same C.A.S.E. so they do not have to programming all code Please consider insert something for compliting shop example  Andrea','2001-04-12 13:38:33','2001-04-12 13:38:33',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (720,NULL,NULL,'A new Login page and a Thank You page in .asp..How','Jose','How to I built a new User Name and Password page in CC then a Thank You page ,or  post to a thank you page?  please help, i love this but only have 1 year of mid level skills.  it so easy to follow example but need to setup new page to protect my images directory, how to do that would apprecated, bye.  thank you - from brazil jose','2001-04-12 23:43:08','2001-04-12 23:43:08',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (721,NULL,NULL,'Deleting directly from a grid','Sam Moses','Hey there, Me again. I''m working with the online store example. It seems to me that there are too many steps to removing an item from the cart. It would be a lot easier if there was a remove from cart button on the shopping cart page that would simply delete from within the grid. Is this possible?','2001-04-12 23:49:05','2001-04-12 23:49:05',4);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (722,717,717,'Re: Multi-language web site','Marc','Add another field \"languages_id\" into your table, create a second table \"language\" and then join  both tables. Either the visitor chooses his  language or you have a system detection (in my opinion less preferable).','2001-04-13 00:01:38','2001-04-13 00:01:38',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (723,700,700,'Re: Email shopping cart contents ?!','Sam Moses','I had the same problem. Here''s what I did. Mine was  written in asp. I guess it helps that I have some ASP background, but anyway, I created an extra field in  the database called status in the orders table. There are three default settings within status: 1. confirmed 2. aborted 3. shipped (for admin only)  I created a page off of the catalog page called checkout.asp Within checkout.asp there is the list of items, and the user uses a pull down menu to confirm or cancel items in the shopping cart. I used the sendmail object from the tell a friend example (with a few changes) to send an e-mail reciept to the customer of the orders he or she has set as confirmed.  This required two minor tweeks to the admin section When viewing orders you need to change the link so that it looks something like this: <a href=\"orders.asp?status=confimed\">Orders</a> additionally, I created two new links within orders.asp to view orders that have been aborted and orders that have been shipped. I have it ordered and seperated by date. It just makes more sense that way. From there admin can go in and change the status of any order, and juggle back and forth betwen users if he or she wants to.  I also created a new featured items section, but that''s a whole nother posting.','2001-04-12 23:56:56','2001-04-12 23:56:56',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (724,NULL,NULL,'Love the Forum','John Huff','Cool forum. You aren''t by any chance releasing the project file, are you?','2001-04-13 00:13:41','2001-04-13 00:13:41',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (725,700,700,'Re: Re: Email shopping cart contents ?!','Edwin','Something like that was also my idea for an \"easy alternative\". I also made an \"orderstatus\" field in the orders table. But in that case I want a simple order-send form.  Something like customer clicking \"Send order\" ->  All items in order table are updated to \"status=confirmed\" and the customer has an empty shoppingcart (status confirmed items are not showed in shoppingcart form)','2001-04-13 01:49:55','2001-04-13 01:49:55',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (726,721,721,'Re: Deleting directly from a grid','CodeCharge Support','Sure it''s possible. When you''re in CodeCharge environment it''s seems the word \"impossible\" is made up by some stry-teller. Kidding :-).  1) Create \"delete\" page ,  Just a dummy page with some code in page/open  event  , smth. like : cn.execute(\"delete * from orders where  member_id=\"&session(\"UserID\")&\" AND order_id=\" & get_param(\"\"order_id))  2)On grid page , add one more field of URL type, caption  - \"Delete\" field properties - link it to \"delete\" page , in \"Output\" tab add order_id fields or another field uniquely identifying shopping cart record.','2001-04-13 04:03:05','2001-04-13 04:03:05',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (727,720,720,'Re: A new Login page and a Thank You page in .asp.','CodeCharge Support','Please see BookStore example,  Registration page example. Let me know what is unclear about it. What about images directory ? How exactly you need to protect it  and from what ?','2001-04-13 04:32:22','2001-04-13 04:32:22',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (728,NULL,NULL,'How to join pages once logged in?','BradleyMiller','I''m building an area where once someone is logged in, they can edit/update various records about themselves.  (Car racing things -- vehicle info, driver bios, quarter mile times, timeslips, etc...)   I''m really stumped as to how to get a username or ID to be passed to the record form to retrieve the info and let it be edited.   Any suggestions?  Thanks!','2001-04-13 05:53:20','2001-04-13 05:53:20',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (729,NULL,NULL,'Queries','Matt S.','Can I create web pages that reference/display queries from my Access database?','2001-04-13 06:44:14','2001-04-13 06:44:14',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (730,729,729,'Re: Queries','Daniel Raymond','Hi,  yes of sure, but why you don''t try it.    Select * from [nameOfYourQuery]','2001-04-13 07:12:31','2001-04-13 07:12:31',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (731,728,728,'Re: How to join pages once logged in?','CodeCharge Support','You need to open \"Form properties\"/Input and add variable for UserID , set \"type\" to \"session\". For  a good example , see Bookstore example / MyInfo page. In this case records on this form will shown only if their \"Field\" equals current userid session variable.','2001-04-13 07:39:25','2001-04-13 07:39:25',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (732,721,721,'Re: Re: Deleting directly from a grid','Sam Moses','So I create this page called delete. And I use something like this  cn.execute(\"delete * from orders where  member_id=\"&session(\"UserID\")&\" AND order_id=\" &  get_param(\"\"order_id))   Do I put the code into the events section of the delete page, or does it go into modules?','2001-04-13 10:33:41','2001-04-13 10:33:41',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (733,NULL,NULL,'price for student','adam','there is any discounted price for students ?  Great product Thenks','2001-04-13 11:27:02','2001-04-13 11:27:02',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (734,721,721,'Re: Re: Deleting directly from a grid','Sam Moses','You''re right. Codecharge does make life a lot easier. I tried the code you mentioned but ran into trouble with it. Here is the error I recieved.  Microsoft VBScript compilation error ''800a0409''   Unterminated string constant   /bookstore/ShoppingCart_Remove.asp, line 2   cn.execute(\"delete * from orders where --------------------------------------','2001-04-13 11:49:54','2001-04-13 11:49:54',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (735,NULL,NULL,'Perl and flat text files','rogerod','Is it possible to connect to a flat text file as a database using CC? Thanks in advance.','2001-04-13 11:54:57','2001-04-13 11:54:57',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (736,721,721,'Re: Re: Re: Deleting directly from a grid','Sam Moses','Hey all, If anyone else is curious how to do this, use this code:  <!--#include file=\"Common.asp\" --><% cn.execute(\"delete * from orders where member_id=\"&session(\"UserID\")&\" AND order_id=\" & Request.QueryString(\"order_id\")) Response.Redirect \"ShoppingCart.asp?\" %>  Thanks again codecharge guys.','2001-04-13 12:29:11','2001-04-13 12:29:11',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (737,700,700,'Re: Re: Re: Email shopping cart contents ?!','Sam Moses','What if you used a mail object in the events section of your checkout page?','2001-04-13 21:17:43','2001-04-13 21:17:43',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (738,NULL,NULL,'Z Language','s1k','I have just discovered a new kinf of relational database called Z Language. It is a relational database format, and is written in Java ByteCode. Is there any support for it in Codecharge?','2001-04-13 21:40:05','2001-04-13 21:40:05',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (739,NULL,NULL,'Active and Inactive Categories','Sam Moses','Hi, Me again. I''ve figured out how to create a page based on the status of a field in the db, and how to view the page based on status when passing query strings from one page to another. Using the bookstore example, I''ve added a field to categories, Status. Status can be set by the administrator as either active or inactive. The problem I''m having is displaying only active categories on the main page. I know it has to be simple, but I feel like I''m over looking it. Is there anything I can do?','2001-04-13 23:36:13','2001-04-13 23:36:13',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (740,NULL,NULL,'Multiple totals','Levi@evilpuppy.com','Is there a way to produce multiple order totals by date in the bookstore?','2001-04-14 00:56:47','2001-04-14 00:56:47',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (741,738,738,'Re: Z Language','CodeCharge Support','CodeCharge support can work with all kinds of databases that expose their functionality through such common DB interfaces as ODBC, DBI,PHP,JDBC,OLE DB. See if Z Language is supported by one of the above interfaces , then it''s all OK.  Regards, Alex','2001-04-14 04:26:13','2001-04-14 04:26:13',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (742,738,738,'Re: Z Language','CodeCharge Support','CodeCharge  can work with all kinds of databases that expose their functionality through such common DB interfaces as ODBC, DBI,PHP,JDBC,OLE DB. See if Z Language is supported by one of the above interfaces , then it''s all OK.  Regards, Alex','2001-04-14 04:26:13','2001-04-14 04:26:13',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (743,733,733,'Re: price for student','CodeCharge Support','Please submit your request  to http://support.codecharge.com','2001-04-14 04:38:58','2001-04-14 04:38:58',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (744,739,739,'Re: Active and Inactive Categories','CodeCharge Support','You may use Form properties/SQL/\"Custom sql\" of this form , smth like : select * from categories where status=''active''','2001-04-14 04:41:29','2001-04-14 04:41:29',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (745,NULL,NULL,'Link to ''more info'' page','Poul Jensen','Hi, In a catalog on the grid that displays the items I would like to create a link to a ''more-info'' pop-up window that gets its contents from a field in the database.   The field could contain either the text to display OR HTML-text to display OR a HTML-filename to display (probably only one of these options though). Any idea how to do this. Regards Poul','2001-04-14 07:23:11','2001-04-14 07:23:11',3);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (746,NULL,NULL,'MIME Type?','M Scott','While trying to insert data into my simple Access database, I get the following error after executing the insert command.   405 Method Not Allowed   The method specified in the Request Line is not allowed for the resource identified by the request. Please ensure that you have the proper MIME type set up for the resource you are requesting.   The techs at my isp are asking what the MIME type is. Anyone know?  Thanks','2001-04-14 08:28:46','2001-04-14 08:28:46',3);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (747,641,641,'Re: Re: CONFIGDRIVER error message installing CODE','Peter','Waiting for response to my second email.  Thank you.','2001-04-14 08:30:56','2001-04-14 08:30:56',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (748,739,739,'Re: Re: Active and Inactive Categories','Sam Moses','Works like a charm. Thanks','2001-04-14 08:44:13','2001-04-14 08:44:13',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (749,534,534,'Re: Best development system advice.  Software List','Jay Mackey','If you have access to Access 2000, you can save as an Access 97 file.  I too would like to know what the favorite development setup is.  As a complete Server/DB/html-pre-processor newbie, I have been able to get up and going on Win98SE with CodeCharge on Apache/MySQL/PHP in a couple of days using mostly free software: PHPTriad - Installs Apache, MySQL, and PHP.  Instant personal server. MyOBDC - Allows CodeCharge to link to MySQL database. MySQLFront - GUI for creating/editing MySQL databases.  Search on www.download.com to find these programs.  I would love to have any other suggestions on software setups, or suggestions for adding to my setup as outlined above.  I am beginning to build an intranet for my company, an engineering firm.  Thanks  Jay','2001-04-14 13:38:43','2001-04-14 13:38:43',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (750,NULL,NULL,'Can this be done?','Sam','I was wondering something. I want to create a virtual restaurant menu with multiple pages and a single category. I was wondering if it would be possible to create a link at the bottom of each content page that automatically takes you to the next content page (doing this by item ID in the query string), but the last page would take you back to the first page. I don''t even know where to start on this one. Help would be appreciated. Thanks','2001-04-15 01:26:19','2001-04-15 01:26:19',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (751,NULL,NULL,'Wish List','berklee','Just thought I''d throw some of these ideas out there... if you agree with any of these, post a comment here. Let the CodeCharge team know what you want to see!  1) Capability to link to external pages whose URL''s are not stored in the database.  2) Ability to remove the META GENERATOR tags from generated HTML (I strip them out anyway)  3) Ability to map to XML data sources and/or schemas.  4) Better interoperability with SQL stored procedures.','2001-04-15 01:34:48','2001-04-15 01:34:48',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (752,652,652,'Re: Re: Coldfusion','Matt','Why letting potential customers test your demos? You should have done this work before.  MattCodeCharge Support wrote:  >In \"DataLink\" properties dialog please click >\"Test connection\" , will it work ok ? >Please cut-and-paste your errors here.','2001-04-15 02:06:51','2001-04-15 02:06:51',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (753,NULL,NULL,'Session cache, Failed opening ... for inclusion','Jay Mackey','Hi,  I don''t know what to change to get rid of the warnings below.  I have an Apache/PHP4/MySQL setup.  I started getting these when I renamed the php.ini_optimized to php.ini so that I could set some other settings that were generating warnings.  Those warnings went away and now I have these.  Warning: Failed opening ''0'' for inclusion (include_path='''') in Unknown on line 0  Warning: Cannot send session cache limiter - headers already sent in c:\\apache\\htdocs\\svec\\index.php on line 12  I have no idea what to set ''include_path'' to so that it can open ''0''.  I''m not even sure this is really what the problem is.  And I have no clue on the second one.  Thanks in advance,  Jay','2001-04-15 02:02:28','2001-04-15 02:02:28',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (754,652,652,'Re: Re: Re: Coldfusion','Joachim Uersfeld','All demos are working on my system.  Check your configuration -  and remain friendly.Matt wrote:','2001-04-15 11:11:39','2001-04-15 11:11:39',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (755,652,652,'Re: Re: Re: Coldfusion','Joachim Uersfeld','All demos are working on my system.  Check your configuration -  and remain friendly.','2001-04-15 11:11:39','2001-04-15 11:11:39',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (756,652,652,'Re: Coldfusion','Sam Moses','If codecharge was a fake program, there wouldn''t be as many people happy with it as there are. I swear by it. All the demos except for the ask a friend are working on mysystem. The ask a friend doesn''t work because I don''t have the mail software installed. No biggie. Codecharge is a god send.','2001-04-15 14:15:17','2001-04-15 14:15:17',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (757,751,751,'Re: Wish List','Sam Moses','Yeah, XML would be really nice. iHTML would be awesome too if we could download a scheme for it. I just remove the meta generator tags manually. But I do the same with dreamweaver and Golive. As far as I know, Codecharge does support external links not in the db, but sometimes it generates an error. I wish codecharge could be a little faster. But given what it does, I''m not going to push that one. It would also be nice if there was another option for ASP. Right now, all the asp generated is written in vbscript. It would be nice if we could also choose Jscript as an alternative. Well that''s my two cents.','2001-04-15 14:18:58','2001-04-15 14:18:58',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (758,NULL,NULL,'Upgrades?','www@s1k.net','When codecharge releases a new version of the program, do existing users get an upgrade? Or will it cost extra? If so, how much?','2001-04-15 14:37:17','2001-04-15 14:37:17',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (759,NULL,NULL,'Insert js or metatags','Sandra Campbell','hi  Is there a way to force CC to insert custom code such as javascript functions anywhere above the body tag of a generated html template?  thank you  sandra','2001-04-15 16:39:47','2001-04-15 16:39:47',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (760,NULL,NULL,'Sam Moses','Styles','You know, It would be great if users could contribute their own styles to the sytes section of the web site instead of just offering the ones that come with the program.','2001-04-15 22:54:57','2001-04-15 22:54:57',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (761,760,760,'Re: Sam Moses','CodeCharge Support','Sam, we can offer you different ways for it. You can  change existing styles direct in CodeCharge in Site/Styles, can create your own ones the same  way (in Site/Styles) and save them, you can create your .css outside CC (see the existing style files to find out syntax) and save it to  CodeCharge/Styles folder','2001-04-16 00:26:01','2001-04-16 00:26:01',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (762,759,759,'Re: Insert js or metatags','CodeCharge Support','you can write JavaScript in Page/Properties/ Header&Footer Tab.  It will be included right after <body class=\"PageBODY\"> {Header}  It`s before all other body tags. But if you want to include JS before body tag, you should generate .html template, open it in any editor and include your JS. During regeneration  when CC warning appear \"This file has been  modified outside CodeCharge. Overwrite?\" click ''No''','2001-04-16 01:00:49','2001-04-16 01:00:49',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (763,758,758,'Re: Upgrades?','CodeCharge Support','Watch over upgrades at http://support.codecharge.com/bulletins.asp If you purchased CC the upgrade is free','2001-04-16 01:28:19','2001-04-16 01:28:19',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (764,750,750,'Re: Can this be done?','CodeCharge Support','Sam, you can create url link from one page to other. In Page Properties/Header&Footer Tab specify for footer link like (e.g. PHP) <a href=\\\"NextPage.php?domainid=\" . $flddomain_id.\"&IName=\".$tmp.\"&FormAction=Insert&FormName=FirstForm \\\">InsertPage</a> transfer ''FormName'' parameter if you have more  than one form on the page.','2001-04-16 01:42:22','2001-04-16 01:42:22',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (765,735,735,'Re: Perl and flat text files','CodeCharge Support','to connect to flat text file using CC you should have ODBC drivers for flat files be installed on your machine. For connection select ''Microsoft OLE DB Provider for ODBC Drivers'' on Providers Tab during creation Connection String','2001-04-16 01:56:25','2001-04-16 01:56:25',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (766,NULL,NULL,'about the language setting','eric fu','the default language settings in option menu are only a few languages not including Chinese. I am wondering how can I add \"<META HTTP-EQUIV=\"Content-Type\" Content=\"text-html; charset=gb2312\">\" into the head of the html. If it works, then I will buy codecharge. Although there is some bugs in it, it is really a sharp tool to create a web site.   thank you p.s there is sth wrong at logout.','2001-04-16 01:59:28','2001-04-16 01:59:28',5);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (767,753,753,'Re: Session cache, Failed opening ... for inclusio','CodeCharge Support','1) Warning: Failed opening ''0'' for inclusion (include_path='''') in Unknown on line 0  Means you don''t have enough permissions , set more permissions to a folder with uploaded  codecharge php files and set proper permission to those files. Like : chmod -R 755 ./folder chmod -R 755 *  2) Warning: Cannot send session cache limiter - headers already sent in c:\\apache\\htdocs\\svec\\index.php on line 12  Do you use PHP or PHP&Templates ? Did you manually modify index.php ? General advice in this case is : Look for empty lines, html tags,\"echoes\" or \"prints\" before the cookie  session is tried, even in include files and clear them.','2001-04-16 02:29:10','2001-04-16 02:29:10',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (768,766,766,'Re: about the language setting','CodeCharge Support','CodeCharge has option for Chinese language. At least download newer version: http://www.codecharge.com/download/files/CodeCharge1_1_17.exe If you choose Chinese you`ll have <meta http-equiv=\"Content-Type\" content=\"text/html; charset=Big5\"> where Big5 is a chinese charset. To have <META HTTP-EQUIV=\"Content-Type\" Content=\"text-html; charset=gb2312\"> you should open proper language .xml file (they are in CodeCharge/Languages folder) and change the string <Messages Encoding=\"Big5\"> to  <Messages Encoding=\"gb23125\">','2001-04-16 02:38:26','2001-04-16 02:38:26',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (769,745,745,'Re: Link to ''more info'' page','CodeCharge Support','This will require some JavaScript skills Use the function below to popup a window , put this script in footer section  of you grid form (Properties/Header&Footer/Footer)  <script language=\"javascript\"> function ccpopup(some_url) { var w = open ('''', ''windowName'', ''width=300,height=300,titlebar=0''); w.document.open(); w.location.href=some_url;  w.document.write(''<HTML><BODY>Please wait while page is loading...<br><A HREF=\"javascript: window.close();\">close<\\/A>''); } </script>  The only thing that we should do is to set some_url variable and call this function, this must be an url to CodeCharge page that diplays from field from a database using input parameter.  At your grid create a field of Label type (call it label_name), with \"HTML\" checkbox checked in \"Field properties\"  Use Form properties/Events/\"Before Show\" event to fill this Label with call to our function :  fldlabel_name = \"<a href=javascript:ccpopup(\" & fldid & \")> More info </a> \"  This will display a hyper link with text \"More info\" that will call our fucntion withg a parameter id , (fldid is automaitcally created CC variable for this field)','2001-04-16 02:57:53','2001-04-16 02:57:53',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (770,700,700,'Re: Re: Re: Email shopping cart contents ?!','CodeCharge Support','If you have further problems coding contact support.codecharge.com','2001-04-16 04:29:20','2001-04-16 04:29:20',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (771,689,689,'Re: Update thru URL','CodeCharge Support','We`ve tested the issue. Everything works both for insert and update. Check up if \"id\" is selected as primary key on  the form. And check is your record form updateable: if ''Allow Update'' selected at Form  Properties/ Common tab. If it won`t help put your issue into our support system (support.codecharge.com)and send us   your .ccs file.','2001-04-16 05:10:34','2001-04-16 05:10:34',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (772,NULL,NULL,'Create a custom login page','Daniel Raymond','Hi,  I would like to modify the default login page to a custom login page.  I need 3 fields : company username, username and password.  Someone could give me 1 or 2 tip to acheeve this.  thank you.','2001-04-16 07:29:29','2001-04-16 07:29:29',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (773,NULL,NULL,'Passing variable from Login','Owen Lees','Assume that I want a user to login (taking db call to for example: user_id) and then I need to pass that users id to the resultant page so that I can display content aimed at that user.. whats the best way to do this. CC apparently does not allow the sending of variables from the login page scripts that it generates.  To sum up: I want to take the user info from a login page and send that to the next page.','2001-04-16 07:41:46','2001-04-16 07:41:46',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (774,62,62,'Re: Re: Missing ASP 3.0 from demo','Sam Moses','I downloaded ASP.NET from the web site. It''s not very useful. I have noticed though that the ASP 2.0 which is provided in the program works perfectly. It''s some great stuff. I know I keep raving about this progrm, but I have done six months worth of programming in a month since I got the program.','2001-04-16 09:01:45','2001-04-16 09:01:45',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (775,NULL,NULL,'Updating CodeCharge Version','Abu Abdullah','I downloaded CodeCharge v1.0.112 - Now I see that version 1.1 is available. Can I update the version I have to the latest one or do I have to do the full download. Also, I am just a few days into this so, I am still talking about the trial version, although it is increasingly becoming apparent that I might purchase this.  Regards.','2001-04-16 10:30:54','2001-04-16 10:30:54',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (776,NULL,NULL,'Portal: Show/hide Articles depending on Usergroup','CCTester','Hi there I am creating an intranet-portal app.(looks a little like yourPortal-Demo site) Depending to the users group membership (I created a table usergroup to get information in which group(s) a user is member) I want to hide/show articles. E.g. an technical worker should not see business admininstration articles, because this information is not interesting for his job.  How can I filter the appearance which articels will appear depending on the users membership ?  The usergroup-table cons?sts of two field: userid and groupname . for example tester1  technic tester2  business tester1  business tester3  technic tester3  admin tester1  admin  By the way, congratulations to CC.','2001-04-16 12:56:33','2001-04-16 12:56:33',5);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (777,750,750,'Re: Re: Can this be done?','Sam Moses','Will the same code work in ASP? It seems to be generating errors.','2001-04-16 13:14:28','2001-04-16 13:14:28',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (778,NULL,NULL,'totalling the bookstore','Sam','Is there a way to display differant totals in the bookstore example in asp by order date?','2001-04-16 14:07:07','2001-04-16 14:07:07',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (779,NULL,NULL,'about the html head','eric fu','Is there any convinient way to custom the content of the html head not editing by other tools? I am wondering how can I add sthing into the page befor the tag of the body such as files, js, and the meta. The response will be appriciated.','2001-04-16 18:16:24','2001-04-16 18:16:24',6);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (780,766,766,'Re: Re: about the language setting','eric fu','thanks you suggetion, now the version I used is CodeCharge1_1_17.exe but there is only Japenese, Korea and etc still not  including Chinese. But CC is still wonderful, I create a Chinese.xml under the folder named translation, now it works.hohoo, thank you.','2001-04-16 18:46:56','2001-04-16 18:46:56',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (781,759,759,'Re: Re: Insert js or metatags','Sandra Campbell','That''s pretty much what I''m doing now. Thank You.  kind regards','2001-04-16 19:05:19','2001-04-16 19:05:19',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (782,NULL,NULL,'How Can I Get Rid Of it?','target','at the footer of the page, there always display the information about CC, I am wondering how can I get rid of it.   P.S not means edit it in other editor.','2001-04-16 21:38:16','2001-04-16 21:38:16',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (783,776,776,'Re: Portal: Show/hide Articles depending on Usergr','CCTester','..some additional information to make the whole thing clear :   Depending to the users group membership (I created a table usergroup to get information in which group(s) a user is member, structure see below)  I want to hide/show articles.  E.g. an technical worker should not see business admininstration articles, because this information is not interesting for his job.   How can I filter the appearance which articels will appear depending on the users membership ?   The usergroup-table cons?sts of two field: userid and groupname . for example  tester1 technic  tester2 business  tester1 business  tester3 technic  tester3 admin  tester1 admin   I added a field GROUP to The article table to set the group relevance for each article.   Everything clear ? How do I have to work it out ?','2001-04-16 23:37:02','2001-04-16 23:37:02',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (784,NULL,NULL,'Portal: Show/hide forms depending on Usergroup','CCTester','Hi there  I am creating an intranet-portal app.(looks a little like yourPortal-Demo site)   Depending to the users group membership (I created a table usergroup to get information in which group(s) a user is member)  I want to hide/show a complete form e.g. the EVENT-form should only appear when a user is member of the group technic.  How can I filter the appearance which forms will appear depending on the users membership ?   The usergroup-table cons?sts of two field: userid and groupname . for example  tester1 technic  tester2 business  tester1 business  tester3 technic  tester3 admin  tester1 admin','2001-04-16 23:44:46','2001-04-16 23:44:46',3);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (785,782,782,'Re: How Can I Get Rid Of it?','Peter Roth','Hi  This section only shows within the eval.','2001-04-17 01:15:19','2001-04-17 01:15:19',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (786,708,708,'Re: Re: Re: Re: Bug report','sinisa','CodeCharge Support wrote:  >You can enter functions in default values , >not like \"now()\"  , bt like \"=now()\"  doesn''t work for me ...','2001-04-17 01:49:19','2001-04-17 01:49:19',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (787,776,776,'Re: Re: Portal: Show/hide Articles depending on Us','CodeCharge Support','I suggest you to set a session variable containing usergroup value. Use \"Page properties\"/Events/Open event , and fill it with code (example for ASP) :  session(\"group\") = dlookup(\"users\",\"group_id\",\"userid=\"&session(\"UserID\")) dlookup is a cc function for quick look into a database , 1st param is table , 2n is a field we fetch , 3rd is a condition  Then Open \"Form properties\" of your grid form that shows Articles , select \"Input\" tab, add variable group , set it to session type , and now it will be a filter for this form.','2001-04-17 02:19:25','2001-04-17 02:19:25',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (788,685,685,'Re: Is it a good product ?','Dean Murphy','Vincent,  In my opinion, CodeCharge represents a quantum leap forward in dynamic site creation. I have been developing dynamic sites for almost five years now (I started with early versions of Apache, Perl and PHP/FI).  Despite having written many of my own generic libraries to ease the process of developing dynamic web sites, I have to say that it is unlikely that I will ever use them again. CodeCharge is not a panecea (yet) but its certainely heading in the right direction.  Download the eval and have a play. Don''t be afraid to contact support. I''ve received superb support from the CC guys even though I''m still using the eval version.  P.S. I have no comercial or otherwise interest in the company. I''m just a happy customer-to-be.  --  Dean deanpm@ntlworld.com','2001-04-17 02:30:26','2001-04-17 02:30:26',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (789,776,776,'Re: Re: Re: Portal: Show/hide Articles depending o','CCTester','Thank you, sounds good.. But, a user might be member in different groups (see example)  Dlookup will only retreive a single line from the users table, but the user is in groupA AND groupB.  Of course, an article has only one groupmembership(only groupA  or only groupB)  Any idea ?','2001-04-17 02:56:54','2001-04-17 02:56:54',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (790,708,708,'Re: Re: Re: Re: Re: Bug report','CodeCharge Support','I don''t know if function now() is present in any standard Perl disrtibution , same as sysdate. Please use some functions from standard modules , like localtime() function etc.','2001-04-17 04:36:12','2001-04-17 04:36:12',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (791,784,784,'Re: Portal: Show/hide forms - solution','CodeCharge Support','I will explain it to you on example of one form. Let''s suppose that you have a boolean condition that will be used to determine if form shouldn''t be shown. Open your project , select form that you want to show/hide.  Open \"Form Properties\"/Events/Open event. Say , if you form name is \"Search\" enter this code   (for PHP)  if (condition_to_hide) { $tpl->set_var(\"FormSearch\",\"\"); return; }  (for ASP)  if condition_to_hide then    SetVar \"FormSearch\",\"\"   exit sub end if  The code above will hide the form if condition_to_hide is true.','2001-04-17 05:59:47','2001-04-17 05:59:47',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (792,784,784,'Re: Portal: Show/hide forms - solution','CodeCharge Support','I will explain it to you on example of one form. Explanation below assumes that you use html templates. Let''s suppose that you have a boolean condition that will be used to determine if form shouldn''t be shown. Open your project , select form that you want to show/hide.  Open \"Form Properties\"/Events/Open event. Say , if you form name is \"Search\" enter this code   (for PHP)  if (condition_to_hide) { $tpl->set_var(\"FormSearch\",\"\"); return; }  (for ASP)  if condition_to_hide then    SetVar \"FormSearch\",\"\"   exit sub end if  The code above will hide the form if condition_to_hide is true.','2001-04-17 05:59:47','2001-04-17 05:59:47',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (793,779,779,'Re: about the html head','CodeCharge Support','You can put e.g. javascript in Header page, ''Open'' event of the page or in page`s Header. It will be inserted right between <body> and <table> of the page.','2001-04-17 06:27:17','2001-04-17 06:27:17',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (794,91,91,'Re: Re: Re: VBScript Error on Chili!Soft ASP','Steve','Somewhat on this topic... Does anybody know of a ''good'' unix host which offers Chillisoft ASP, along with other common unix features such as perl, php, ssh etc.?','2001-04-17 06:36:48','2001-04-17 06:36:48',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (795,775,775,'Re: Updating CodeCharge Version','CodeCharge Support','Download newer version http://www.codecharge.com/download/files/CodeCharge1_1_16.exe and install it over old one. See its new features at http://support.codecharge.com/bulletins.asp','2001-04-17 06:47:29','2001-04-17 06:47:29',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (796,746,746,'Re: MIME Type?','M Scott','I''m getting close. My ISP is telling me that they do not have MIME type extensions set on there server until a customer request a specific extension. If I can get YesSoftware to tell me what extension or extensions to use I just might buy this app.','2001-04-17 07:08:40','2001-04-17 07:08:40',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (797,773,773,'Re: Passing variable from Login','CodeCharge Support','You can get user_id from session.Its name is  \"UserID\". For result form add input parameter  like this: member_id | UserID | Session | Number | = select it as ''Required'' and ''Transfer'' (if you  want to pass it to the next form)','2001-04-17 07:14:41','2001-04-17 07:14:41',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (798,91,91,'Re: VBScript Error on Chili!Soft ASP','CodeCharge Support','Try to download new patterns http://www.codecharge.com/download/files/patterns/ASP.NET%20C%23.ccp http://www.codecharge.com/download/files/patterns/ASP.NET%20Templates.ccp and copy them over old ones to CodeCharge/Patters folder','2001-04-17 07:44:20','2001-04-17 07:44:20',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (799,746,746,'Re: MIME Type?','CodeCarge Support','Try to reinstall MDAC2.6: http://www.microsoft.com/data/download_260rtm.htm and JET4: http://www.microsoft.com/data/download.htm','2001-04-17 07:50:21','2001-04-17 07:50:21',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (800,91,91,'Re: VBScript Error on Chili!Soft ASP','CodeCharge Support','Try download these patterns and copy then into  Patterns folder (back up old patterns).  http://www.codecharge.com/download/files/patterns/ASP%202.0.ccp http://www.codecharge.com/download/files/patterns/ASP%202.0%20&%20Templates.ccp','2001-04-17 08:23:40','2001-04-17 08:23:40',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (801,746,746,'Re: Re: MIME Type?','M Scott','I have tried that on three different systems. Two Win98 and one WinNT 4.0 SP6. I still get the same Error.  I hate to be redundant but is there a MIME extension that I can pass onto my ISP. I seem to be dead in the water until they have that info.  Thanks','2001-04-17 09:33:15','2001-04-17 09:33:15',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (802,NULL,NULL,'Large number of fields','ADW','Has anyone else come across this problem.  If I put a large number of fields (say > 50) on a Record type form, the CodeCharge IDE is very slow when moving to & from that form, & the display becomes corrupted when scrolling up or down the fields.  Having said that, the generated forms appear to be ok.  Is this a bug?  ADW','2001-04-17 17:52:17','2001-04-17 17:52:17',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (803,NULL,NULL,'Discussion Group','ADW','This discussion group is great & I''m finding it very useful, however sometimes it is very slow.  How about making the database available to download as a zip file that can be browsed offline.','2001-04-17 18:06:58','2001-04-17 18:06:58',4);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (804,779,779,'Re: Re: about the html head','eric fu','not between the body and the table, just above the tag of the body, or maybe  between <head>and</head> thank you','2001-04-17 19:09:11','2001-04-17 19:09:11',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (805,NULL,NULL,'can I change the session','eric fu','can I change the session''s parameter user_id to clerk_id, or passwd to password,..., etc?  can I create other model like login, search, etc?','2001-04-17 19:58:32','2001-04-17 19:58:32',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (806,91,91,'Re: VBScript Error on Chili!Soft ASP','Sam Moses','Did you change your platform in properties from windows to Unix?','2001-04-17 22:32:32','2001-04-17 22:32:32',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (807,NULL,NULL,'Todays News?','Sam Moses','Here''s an idea. I have a news section on a project I''m working on. It will be updated daily by admin. I want to create a \"todays news page\" which will only read items added the day the viewer is looking at it. Is this possible?','2001-04-17 22:35:33','2001-04-17 22:35:33',4);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (808,807,807,'Re: Todays News?','Sam Moses','PS: I need to do it with a whole table rather than just a couple of fields','2001-04-17 22:41:26','2001-04-17 22:41:26',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (809,805,805,'Re: can I change the session','CodeCharge Support','1) As to userID and passwd , you can define your own OnLogin event in form properties/Events/OnLogin of your Login form , where you can set your own session variables. 2) > can I create other model like login, search, etc?  In most cases you can make it work differently , but it depends on a particular case , there are different approaches. What exactly and how you want to change ?','2001-04-18 01:54:22','2001-04-18 01:54:22',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (810,802,802,'Re: Large number of fields','CodeCharge Support','It''s IE component bug. So event if you come out of CC and make your own form with lot''s of fields , they may get corrupted too and it''s considered a good practise to scatter them across a few pages. I think there will not be such a thing in CC2.','2001-04-18 02:00:13','2001-04-18 02:00:13',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (811,784,784,'Re: Re: Portal: Show/hide forms - solution','CCTester','Thank you, it works great as you described. Another step to create an intranet portal with  personalisation features (not everyone should/want  see all information)  By the way, the forum is very slow and there is no way,  to see the whole thread in a explorer-like treestructure . This would make using and viewing the board more  easy.','2001-04-18 02:14:46','2001-04-18 02:14:46',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (812,776,776,'Re: Re: Re: Re: Portal: Show/hide Articles dependi','CCTester','Any idea about the multi-group membership ? Maybe it can be done by using instr (I dont know whether instr is working in ASP, in Visual Basic is does )  Any idea ?','2001-04-18 02:32:34','2001-04-18 02:32:34',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (813,805,805,'Re: Re: can I change the session','eric fu','thank you very much. I just want to creat some other models. ie,change the login to the other style including much more things. I want to create navigator bar, then how can I do it?  p.s I am sorry my English is not very good. I really thing CC is a very good tool, after I using a while I will consider to buy one.thank you.','2001-04-18 02:43:17','2001-04-18 02:43:17',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (814,807,807,'Re: Todays News?','Ken Hardwick','I am using the following in my ASP project to get list of Officer for current year. It is in my SQL where statement ..useing ASP  OfficerHistory.OfficeYear = \" & year(now()) & \"  You should be able to use something like it. Maybe... UpdateDate = \" & date() & \"\"  Also, you may want to use the database row with the highest updatedate instead of looking at todays date but less than or equal to current date.  something like..  by highest 1 UpdateDate ... where Updatedate <= currentdate  Doing this would allow user to veiw most current news (in case current days news has not been added yet) and also allow administrator to add news for future days that would not viewed until it''s updateDate is current.  Hope this helps ,  Ken Hardwick Norman,Ok','2001-04-18 02:54:09','2001-04-18 02:54:09',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (815,776,776,'Re: Re: Re: Re: Re: Portal: Show/hide Articles dep','CodeCharge Support','Sure you can use Instr(). You can simply parse your session variable containing list of groups and using it you can form a custom sql , which you can use instead of dlookup , cn is standard cc connection object , use  some_sql = \"select * from table\" cn.execute(some_sql)','2001-04-18 03:20:27','2001-04-18 03:20:27',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (816,778,778,'Re: totalling the bookstore','CodeCharge Support','You must add date field to  orders table. You must set date when new order is made.  Then just add a search form to shopping cart page , and in \"form properties\"/sql/where add mydatefield = #\"&  GetParam(\"mydatefield\") & \"#\" & \"','2001-04-18 03:39:49','2001-04-18 03:39:49',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (817,NULL,NULL,'Support System demo','Jon Stanton','Do you have (or any intention to have) a PHP / MySQL version of the Support System demo?','2001-04-18 08:19:42','2001-04-18 08:19:42',3);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (818,778,778,'Re: Re: totalling the bookstore','Sam Moses','This would work for both applications wouldn''t it?','2001-04-18 09:24:04','2001-04-18 09:24:04',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (819,807,807,'Re: Re: Todays News?','Sam Moses','Groovy. Thanks for the input.','2001-04-18 09:26:22','2001-04-18 09:26:22',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (820,807,807,'Re: Re: Todays News?','Sam Moses','Interesting. It seems to be displaying yesterdays news until I ad things from today.  This is very handy. I appriciate the help. Thanks.','2001-04-18 09:35:00','2001-04-18 09:35:00',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (821,817,817,'Re: Support System demo','Sam Moses','It comes built into codecharge. It''s a variation on taskman.','2001-04-18 09:37:25','2001-04-18 09:37:25',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (822,745,745,'Re: Re: Link to ''more info'' page','Poul Jensen','Hi,  I am having problem with this and maybe I haven''t explained clearly what I want to achieve. In the example store application I would like the contents of the items.notes field to generate this ''more info'' field if there is some text in the notes field.  Please see: http://www.marisoft.dk/store/AdminMenu.php Username: admin  PW: admin Select: ''Varer''  What I don''t understand (amongst other things <g>) is your comment about the input parameter.  Could you clarify this please.','2001-04-18 11:49:45','2001-04-18 11:49:45',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (823,817,817,'Re: Re: Support System demo','Jon Stanton','I know I already have Taskman but it''s not really a patch on Support System.  Having Support System for PHP is just what I''m looking for.','2001-04-18 14:26:08','2001-04-18 14:26:08',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (824,817,817,'Re: Support System demo','CodeCharge Support','You can download Support System demo http://www.codecharge.com/download/files/examples/demo_support.zip and generate output code on any language.','2001-04-19 01:54:31','2001-04-19 01:54:31',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (825,779,779,'Re: Re: Re: about the html head','CodeCharge Support','unfortunaly, CodeCharge doesn`t let you input code between <head></head>. If you need to do it generate output files and edit them. Note,  don`t edit comments and text in {};during regeneration click ''No'' when warning about  overwriting will appear','2001-04-19 02:31:55','2001-04-19 02:31:55',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (826,766,766,'Re: Re: Re: about the language setting','CodeCharge Support','CodeCharge1_1_17 supports Chinese language. Go to Tools/Options, Site Translation and in  dropdown you`ll see the list of languages: Chinese English French German Italian etc You don`t need to create Chinese.xml, it already exists.','2001-04-19 05:17:59','2001-04-19 05:17:59',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (827,766,766,'Re: Re: Re: about the language setting','CodeCharge Support','CodeCharge1_1_17 supports Chinese language. Go to Tools/Options, Site Translation and in  dropdown you`ll see the list of languages: Chinese English French German Italian etc You don`t need to create Chinese.xml, it already exists, you can see in in CodeCharge/Translations folder.','2001-04-19 05:17:59','2001-04-19 05:17:59',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (828,NULL,NULL,'Link colour','Henrik Lorange','Hi,  Any easy way to change the default link color? CC changes link colour to black, and I need to make them blue (without making all text blue).  Any suggestions out there?','2001-04-19 06:40:05','2001-04-19 06:40:05',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (829,NULL,NULL,'Access Queries','SF','I was told in the Newsgroup that Microsoft Access Queries within the DB will be recognized as Tables by CodeCharge. Is this true? My queries are not recognized as tables by CodeCharge and was wondering if there was anything I need to configure for this to happen. FYI: I am using IIS on Win2k with Access 2000.  Thanks','2001-04-19 07:01:02','2001-04-19 07:01:02',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (830,829,829,'Re: Access Queries','Warp9','I''m working with an Acces 97 database and the queries works great. But with Access 2000 I don''t have idea...','2001-04-19 07:21:04','2001-04-19 07:21:04',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (831,NULL,NULL,'More Examples?','xPhoton','I would like to see some real working sites using CC.  Can you please post your URL.  Thanks','2001-04-19 07:42:03','2001-04-19 07:42:03',5);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (832,745,745,'Re: Re: Re: Link to ''more info'' page','CodeCharge Support','>In the example store application I would like >the contents of the items.notes field to generate >this ''more info'' field if there is some text in  >the notes field.  Does \"generate\" mean you will show contents of items.notes on the same page , or in a new window ? ---------- Another solution could be just to add a field of URL type into grid , this field must contain item_id in \"Field properties\"/Output tab \"Page link\" attribute must point to page that will show  notes of that item. Don''t forget to add item_id in \"target page/record form for item/input tab\"','2001-04-19 09:24:22','2001-04-19 09:24:22',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (833,828,828,'Re: Link colour','CodeCharge Support','Put your Javascript code changing that color into some Footer section of form or a page.','2001-04-19 09:33:19','2001-04-19 09:33:19',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (834,829,829,'Re: Re: Access Queries','SF','I actually got it to recoginze some queries, depending on how they were designed.  Thanks','2001-04-19 09:44:32','2001-04-19 09:44:32',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (835,NULL,NULL,'Admin Module for the Forum Example','Dereck Moath','Hi, i''m using codecharge for making a little custom forum, i''ve been using the example but it has no admin page, thus i''m doing one myself, and here''s the problem : I want to put a checkbox on the rightside of all the messages, so when they are marked and i press a ''delete'' button, the selected messages are deleted from the db . How can i do this ? i''ve tried a lot of ways but i still haven''t found a quick & easy way, btw i''m using coldfusion code.  Thank you .   Note : i can do this straight using coldfusion and jscript, but i really want to do this in codecharge for portability.','2001-04-19 10:32:54','2001-04-19 10:32:54',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (836,802,802,'Re: Re: Large number of fields','ADW','TVM for the info. As an experiment, I tried the same web on my machine under Windows 2000 & it is still slow when handling the forms with large numbers of fields, but the screen corruption doesn''t happen.','2001-04-19 14:14:38','2001-04-19 14:14:38',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (837,766,766,'Re: Re: Re: Re: about the language setting','eric fu','that is for big5 not for gb2312, I think modify the Chinese big5 to gb2312 is much more easier for me. Thank you.','2001-04-19 17:29:19','2001-04-19 17:29:19',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (838,779,779,'Re: Re: Re: Re: about the html head','eric fu','I am wondering weather it will have this function  in CC''s new version.','2001-04-19 17:31:44','2001-04-19 17:31:44',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (839,NULL,NULL,'what about upload?','eric fu','how can I add <input type=\"file\"><br> into CC? How can I deal with these kind of input? The response will be appreciated.','2001-04-19 20:34:53','2001-04-19 20:34:53',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (840,NULL,NULL,'How to set/add other session variables ?','Bash Ad','How to set/add other session variables to use in some other time like user_name? and how to use it form properties input. I have tried this but not working. OnLogin Event   set_session(\"u_name\", $db->f(\"u_name\")); and later in form   in form/properties/input as session variable  Please help,  (I''m using trial version)','2001-04-19 21:35:34','2001-04-19 21:35:34',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (841,NULL,NULL,'how to add link to page number ?','Bash Ad','<First> <Prev> <1> <2> <3> <Next> <Last>  Just like search engines  is this possible in CC','2001-04-19 21:55:47','2001-04-19 21:55:47',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (842,828,828,'Re: Link colour','Henrik Lorange','Removing the font color parameter (color: #000000;) info from DATA FONT did it:  style=\"font-size: 10pt; font-family: Arial, Tahoma, Verdana, Helvetica\"  I am not using CSS. Hope this is helpful to anyone out there. Henrik','2001-04-20 00:10:50','2001-04-20 00:10:50',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (843,840,840,'Re: How to set/add other session variables ?','CodeCharge Support','You should first get the value of the field, then put it  into session. E.g. $CID = dLookUp(\"Company\", \"CompanyID\", \"where_condition\"); set_session (\"ComID\", $CID); //dLookUp($table_name, $field_name, $where_condition) then you can use \"ComID\" as session variable, e.g.  $fldCompanyID = get_session(\"ComID\"); or set it as input parameter in Form Properties/ Input tab.','2001-04-20 00:45:06','2001-04-20 00:45:06',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (844,831,831,'Re: More Examples?','CodeCharge Support','CodeCharge Support System: support.codecharge.com','2001-04-20 01:27:50','2001-04-20 01:27:50',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (845,839,839,'Re: what about upload?','CodeCharge Support','You can add your form for file upload into Page|Form properties/Header&Footer section , if you want to add this to already existing codecharge form , add Label field , check \"html\" checkbox in field properties/common tab. and in default value enter :  input type=\"file\"><br>','2001-04-20 03:22:26','2001-04-20 03:22:26',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (846,841,841,'Re: how to add link to page number ?','CodeCharge Support','You need to implement this scroller manually , using codecharge events.','2001-04-20 03:31:11','2001-04-20 03:31:11',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (847,NULL,NULL,'Support Site return Link to CC','Ken Hardwick','I''ve noticed that there is no hyperlink anywhere on your support site back to www.codecharge.com   Not absolutely needed but would be easier for user to return to/or goto your main site.  Ken Hardwick Norman,Ok','2001-04-20 03:44:56','2001-04-20 03:44:56',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (848,831,831,'Re: More Examples?','Joachim Uersfeld','www.pc-team.de - Discussions and Support','2001-04-20 04:01:30','2001-04-20 04:01:30',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (849,831,831,'Re: More Examples?','Sam Moses','http://cort.evilpuppy.com CC and hand coding','2001-04-20 11:38:13','2001-04-20 11:38:13',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (850,831,831,'Re: Re: More Examples?','Jay Mackey','Wasn''t able to view the ''evilpuppy'' page.','2001-04-20 13:00:04','2001-04-20 13:00:04',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (851,NULL,NULL,'portal page layout questions','Marc','Taking your portal sample site with the default page as an example I have the following questions:  How can I increase the \"empty space\" between the columns?  How can align/resize the various form into one homogenous look like seen on my.netscape.com?  Thank you so much. Marc.','2001-04-21 06:40:05','2001-04-21 06:40:05',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (852,704,704,'Re: Re: Params problem','donsur','I want to include a non-table field in a URL,  but I can''t choose it in the Output Tab !','2001-04-21 08:32:28','2001-04-21 08:32:28',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (853,NULL,NULL,'PASSING and PRESERVING non-table fields','donsur','I have a problem about PARAMETERS.  ----------- WHAT I WANT TO DO ---------- I have 3 pages :  \"Order Page\" --->  \"Catalogue Page\" ---> \"New Order-Item Page\"  - When I want to add a product to my order, I use the link to \"Catalogue Page\".  - After I have choosen the product, I go to Order Item Page to choose the quantity  and other details.  --------- WHAT I NEED TO DO IT -------  When I move to \"Catalogue Page\", I would like to preserve the OrderID parameter, so that  I can pass it to the next page.  \"Order Page\" --- (IDOrder) ---> \"Catalogue Page\" --- (IDOrder,IDProduct) --> \"New Order-Item Page\"   --------- MY 2 PROBLEMS --------  Well , the \"Catalogue Page\" contains a Search Form and a Grid Form for the products.  Obviously the IDOrder is not useful in this page, I only need it here because I want to pass it to the next page.   1) I need to PRESERVE THE ORDERID after a search  The Search Form use some fields from the Products table. (Obviously it doesn''t contain a field called OrderID) When I use the Search button, I loose the IDOrder ! In fact it is not a parameter for the Search form, and after the search the OrderID disappear from the URL.  2) I need to TRANSFER THE ORDERID to a URL  The Grid Form use all the fields from the Products table. (Obviously it doesn''t contain a field called OrderID) In the Grid Form, each line contains a URL to the \"New Order-Item Page\" . But I can''t add the OrderID as output parameter to that URL, because the OrderID is not a field for the Product Table ! So when I click on that URL to go to the next page, I loose the OrderID !  --------- WHAT I ASK --------  Is there a way to PRESERVE and TRANSFER the OrderID field ?  Is there a good example that explains how to manage parameters ?   Thanks !','2001-04-21 08:31:46','2001-04-21 08:31:46',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (854,NULL,NULL,'Would anyone be willing to help me on my site','Jim','I want a PHP site instead of my HTML layout... http://www.gisterogue.co.uk/r4c/ Instead use PHP...If anyone wants to help me, i''d really appreciate it.  I''d link to your site...My last site got 14,400 hits/day and I''m expecting more out of this one. my email address is: referalman7@yahoo.com Thanks again!!!!!','2001-04-21 18:15:06','2001-04-21 18:15:06',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (855,839,839,'Re: Re: what about upload?','eric fu','thank you very much, just like  response.write <input type=\"\"file\"\"><br>','2001-04-22 17:51:53','2001-04-22 17:51:53',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (856,854,854,'Re: Would anyone be willing to help me on my site','eric fu','If you like, I can convert your website to Apptrix web site. Apptrix is a tool at Lotus platform. It is not very difficult for static website which contains a lof of information of web news.','2001-04-22 17:56:35','2001-04-22 17:56:35',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (857,704,704,'Re: Re: Re: Params problem','eric fu','so do I. I am wondering how can I solve this problem.','2001-04-22 18:00:26','2001-04-22 18:00:26',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (858,853,853,'Re: PASSING and PRESERVING non-table fields','CodeCharge Support','The most simple way is to put OrderID into session and get it from it. In one of the events of Order Page (e.g. ''Before Show'' event) put OrderID  into sesion: ASP Session(\"OID\") = fldOrderID PHP se_session(\"OID\", $fldOrderID); note, fld is the prefix to field name using in CC Then in ''Before Show'' event of New Order-Item Page get OrderId from Session: ASP fldyour_field = Session(\"OID\") PHP $fldyour_field = get_session(\"OID\");','2001-04-23 00:44:31','2001-04-23 00:44:31',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (859,851,851,'Re: portal page layout questions','CodeCharge Support','Mark, to increase empty space between columns  in generated .html file edit <table> tag like <table CELLSPACING=\"10\">. Coencerning align the advise is to generate  output files with CC and then create .html file using frameset like: <html> <head> </head> <frameset border=0  frameBorder=1 frameSpacing=0 cols=*,*,*> <frame src = \"left_frame_up.asp\"> <frame src = \"Default.asp\"> <frame src = \"right_frame_up.asp\"> </frameset> </html>','2001-04-23 00:57:45','2001-04-23 00:57:45',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (860,704,704,'Re: Re: Re: Re: Params problem','CodeCharge Support','you can do something like next. For grid form  define custom SQl: select *, '''' as empty from mytable  In ''Before Show'' event define its value (if need): PHP $fldempty = \"value\"; ASP fldempty = 456 Then you can select \"empty\" as output parameter for URL field','2001-04-23 02:10:01','2001-04-23 02:10:01',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (861,NULL,NULL,'Pre-Filling fields on a new record','ADW','1. What is the best way of pre-Filling some of the fields on a new record?  For example, a user logs into the system, so you know their UserID from the login.  They then want to add a new record, and as you already know who they are some of the fields can be pre-filled, (Name, Address, etc).  There doesn''t seem to be an obvious way of doing this in CC, so in the fields I want to pre-fill I''m using DLookUP in the Default value.  This uses the UserID to lookup the required value from an appropriate table.  I''ve checked the resulting ASP code & it works ok, but I was wondering if there is a better way.  2. Is there a simple way to change the value that is displayed on the login form once a user has logged in, say their Name rather than their LoginID.  3. Is it possible to make some of the fields on a form ReadOnly from within CC, or do I have to edit the code directly.','2001-04-23 04:02:55','2001-04-23 04:02:55',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (862,861,861,'Re: Pre-Filling fields on a new record','CodeCharge Support','1) You can do it using CodeCharge events mechanism. Open \"Form properties\"/Events/\"Before show\" type in your code , like  fldname = dlookup(\"members\",\"name\",\"memberid=\" & session(\"userID\"))  fldname - is automatically created CC variable representing form field named \"name\" , cc simply adds prefix \"fld\" to field names.  2)  Try to do it with Javascript , using browser''s object model. Or change generated code.  3) You can change from TextBox or TextArea type to Label type , which is not editable. Or play around with read-only properties using Javascript.  Javascript is usually placed into Footer section of appropriate form , or page/footer','2001-04-23 05:45:42','2001-04-23 05:45:42',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (863,NULL,NULL,'Operation must use an updateable query','StiCK','Help!  I''ve been having a helluva time configuring my database connection properly, it seems like I''m being sent in circles. :)  The connection I''ve currently established is a DSN-less connection to an Access 2000 database on a Windows 2000 server at my host (Verio)  Any read-only functions performed on the database work perfectly, however any type of write operation results in the following error message:  \"Operation must use an updateable query. (Microsoft JET Database Engine)\"  I''ve been told that I need to modify permissions on my database and/or database folder, but my host is telling me that permissions have already been set to read-write by default, since it is a pre-dedicated ''data'' directory.  Instead, they''re trying to tell me I have to set up a DSN for the database; which seems to go against the grain of the advice presented on this support site.  I have no idea how to integrate the DSN I''ve set up through my host''s ''control panel'' into the CodeCharge ASP code.  It appears that my DSN is supposed to be: \"parame.smdata\"  Here is my current connection string (from common.asp):  strConn = \"Provider=Microsoft.Jet.OLEDB.4.0;Data Source=\" & Server.MapPath(\"smdata.mdb\") & \";Persist Security Info=False\"  and the URL for the staging site:  http://www.paramedia.ca/start.asp  Last but not least, I''m developing the app on a remote, hosted server, so I don''t have physical access to this machine.  Thanks so much for any assistance!','2001-04-23 08:03:00','2001-04-23 08:03:00',4);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (864,NULL,NULL,'Image Catalog','M Scott','Anyone have an example of an image catalog? I''m wanting to reference images from a relative directory path. Not sure how to link my records with the images and then display them on an html page.  Any ideas?  Thanks','2001-04-23 09:03:25','2001-04-23 09:03:25',9);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (865,831,831,'Re: Re: Re: More Examples?','Sam Moses','Sorry about that. Here''s the direct link. http://home.domaindlx.com/cort2/database/cort2/epx/tier1.asp?action=view&moulder=5&category_moulder=27 Beware of the popup, it''s on a free hosting site right now.','2001-04-23 12:18:48','2001-04-23 12:18:48',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (866,854,854,'Re: Would anyone be willing to help me on my site','sam@s1k.net','If you wanted to do it in ASP, I''d be your man. I''m always happy to help. But if you''re on unix hosting ASP probably won''t work.','2001-04-23 12:21:42','2001-04-23 12:21:42',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (867,NULL,NULL,'Editing display order from a grid','Sam Moses','Hello, I''ve been working on a huge project last few weeks. It has everything from a shopping cart to a news system and message boards. It''s been some real work, even with codecharge, and I''m almost done. Here''s my problem. I have an administration menu where you view content on the site, link to edit it, or delete it on the spot. I have a field in my db called orderfield which contains a number. This number is called by the application and displayed accordingly. The problem I seem to be having is that I want to be able to edit this one field from a grid without editing any other information about the item. I also want to be able to change all of the fields at once. Is this possible with codecharge?','2001-04-23 12:48:14','2001-04-23 12:48:14',7);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (868,864,864,'Re: Image Catalog','Sam','I don''t know if this helps at all, but the book store example has a feature like that built in','2001-04-23 12:58:33','2001-04-23 12:58:33',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (869,867,867,'Re: Editing display order from a grid','eric fu','Can not catch up your meanings. pls give much more details and I am wondering wether your question is  about SQL update string.','2001-04-23 17:39:26','2001-04-23 17:39:26',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (870,867,867,'Re: Re: Editing display order from a grid','Sam','Sure, 1. I have a grid which I would like to edit 2. There is a field in the db called orderingfield 3. eveything on the grid is ordered by orderingfield 4. I want to make orderfield into a text box rather than a hidden variable and edit all instances of orderingfield one from the grid.  Hope that helps','2001-04-23 18:01:24','2001-04-23 18:01:24',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (871,867,867,'Re: Re: Re: Editing display order from a grid','sam','sorry typo I mean to say that I would like to edit all instances from one grid. Is this possible with Codecharge?','2001-04-23 18:07:09','2001-04-23 18:07:09',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (872,779,779,'Re: Re: Re: Re: Re: about the html head','Sam Moses','Doesn''t sound like it. You might want to try using dreamweaver 4 for that. The search and replace feature cuts time and is more accurate than older versions of the program. I would do a search for <HEAD> within a directory, and replace it with <HEAD><YOUR TAGS></YOUR TAGS> you know what I mean. It usually takes under thirty seconds.','2001-04-23 18:10:20','2001-04-23 18:10:20',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (873,NULL,NULL,'This should be easy','Sam Moses','Hey all, Just started rennovating a message board I created a few months ago with codecharge.  It''s pretty much done, but I was wondering how to count responses to a message. I tried the snippet of code from the bookstore example, and created extra fields in my db, but I generated an error. So I rewrote it. More errors. It should only take one like of code to do this, but I''m lost as to how.','2001-04-23 18:14:14','2001-04-23 18:14:14',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (874,867,867,'Re: Re: Re: Editing display order from a grid','eric fu','oh??? why not change hidden to textbox? I think you defind the orderfield in DB as a key, and it will display in CC''s record form as hidden for default. You are easily change it to textbox and input the new data into the textbox. But that is not a action for update only for insert, and becare of your unique value for that field. wish you lucky, wish that will help you.','2001-04-23 22:49:36','2001-04-23 22:49:36',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (875,867,867,'Re: Re: Re: Editing display order from a grid','eric fu','oh??? why not change hidden to textbox? I think you defind the orderfield in DB as a key, and it will display in CC''s record form as hidden for default. You  easily change it to textbox and input the new data into the textbox. But that is not a action for update only for insert, and becare of your unique value for that field. wish you lucky, wish that will help you.','2001-04-23 22:49:36','2001-04-23 22:49:36',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (876,867,867,'Re: Re: Re: Editing display order from a grid','eric fu','oh??? why not change hidden to textbox? I think you defind the orderfield in DB as a key, and it will display in CC''s record form as hidden for default. You  can easily change it to textbox and input the new data into the textbox. But that is not a action for update only for insert, and becare of your unique value for that field. wish you lucky, wish that will help you.','2001-04-23 22:49:36','2001-04-23 22:49:36',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (877,779,779,'Re: Re: Re: Re: Re: Re: about the html head','eric fu','I know it is very conviniet to modify outside. But it will not contain the html sample. //sigh, I am not femiliar with DW 4, maybe you can help me. I will study it later. :) The tool I always use is EditPlus, that is a really very good small tools for programming even better than UltraEdit in some way.   P.S Strongly recommand CC to add the FUNCTION of modifying html head','2001-04-23 23:13:39','2001-04-23 23:13:39',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (878,NULL,NULL,'Parameter Passing in Menues','sinisa','Problem:  I have a form that has input parameter \"userid\"from the previous form, on this form I want to write out user details and give user a set of personalized menu options (add your record,  see your record). I use Menu form type to do that and I try to pass the input parameter (user id) to every option but parameter is always lost (it calls next form without any parameter).   Have looked into the code and there is no double transfers or whatsoever.','2001-04-23 23:13:41','2001-04-23 23:13:41',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (879,NULL,NULL,'inserting environment vars into db records','sinisa','Problem:  How can I use HTTP_REFERER, REMOTE_USER and other to me important variables within the program. Specific: I need to make a program that will be available to anyone on the Intranet (WinNT/Win2k infrastructure) where everybody has unique username and machine dedicated. I wish to use vars passed to the web server to traqck which user does what. (i.e. if someone ads a record in the database, i want to insert the machine name and username to that record for future reference)','2001-04-23 23:25:13','2001-04-23 23:25:13',4);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (880,863,863,'Re: Operation must use an updateable query','CodeCharge Support','Jason, you can use 2 ways:  - reinstall JET4.0 and MDAC on server side.  Ask your host company about JET and MDAC they use. MDAC http://www.microsoft.com/data/download_260rtm.htm         JET http://www.microsoft.com/data/   - try to use DSN connection to server.  Create System DSN on the server to connect to  your db. Use in CC ''Microsoft OLE DB Provider for  ODBC Drivers'' as Provider and select your DSN  form dropdown list to establish connection.','2001-04-24 00:01:57','2001-04-24 00:01:57',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (881,879,879,'Re: inserting environment vars into db records','CodeCharge Support','Define event using variables  HTTP_REFERER, REMOTE_USER to get their values and put them into other variables or insert into table','2001-04-24 00:30:03','2001-04-24 00:30:03',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (882,878,878,'Re: Parameter Passing in Menues','CodeCharge Support','when user logs in value of his Login field  puts to session variable UserID. In every form tyr to define input parameter UserID to get  its value like: Field |VariableName|Type   |DataType|Operation|Required|Transfered UserID|UserID      |Session|Number  |=        |','2001-04-24 00:34:45','2001-04-24 00:34:45',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (883,878,878,'Re: Re: Parameter Passing in Menues','sinisa','as I could understand what you are talking refers to the use of Login and security. I don''t want my users to login with user / password. I want to transfer a walue received by a form so some other form by using Menu form for linking. In the example I gave you we are talking about \"userid\" but in some other case we would be talking about i.e. property_id. (Let''s say you have a property administration module where in the main form you select the property and you get linked to another firm which gives property details and links to other actions (using Menu form type) like, Sell property, Bid for property, Add Maintenace Record) what then?','2001-04-24 01:01:36','2001-04-24 01:01:36',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (884,879,879,'Re: Re: inserting environment vars into db records','sinisa','if I have a field in the database:  remote_user varchar(10)  and I want to put $ENV{''REMOTE_USER''}  in that field for the record I am working on,  can you write me a sample what to do?   CodeCharge Support wrote:   >Define event using variables  >HTTP_REFERER, REMOTE_USER to get their values and >put them into other variables or insert into table >','2001-04-24 01:09:16','2001-04-24 01:09:16',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (885,863,863,'Re: Re: Operation must use an updateable query','kmc','Have your provider make sure the ''public'' user  (IIS_name in NT) has write permissions to your database AND the directory which contains it.  I had this problem too and it  is permissions to your tables by the default user which must be changed.  Good luck.','2001-04-24 01:36:22','2001-04-24 01:36:22',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (886,863,863,'Re: Operation must use an updateable query','joe','Use -  Control panel: ODBC icon: Second Tab - DSN','2001-04-24 01:55:23','2001-04-24 01:55:23',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (887,879,879,'Re: Re: Re: inserting environment vars into db rec','CodeCharge Support','Open  \"Form properties\"/Events/\"Before  insert\" , enter code :  fldremote_user = $ENV{''REMOTE_USER''}   Note : fldremote_user is automatically created CC variable containing value of remote_user field. Fld is a standard cc prefix. Make this field of \"Hidden\" type.','2001-04-24 05:16:25','2001-04-24 05:16:25',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (888,879,879,'Re: Re: Re: Re: inserting environment vars into db','sinisa','won''t do,  in case I do that field as hidden the insert statement created by CC doesn''t include that field and everything falls into water.  CodeCharge Support wrote:  >Open  >\"Form properties\"/Events/\"Before  insert\" , >enter code : > >fldremote_user = $ENV{''REMOTE_USER''}  > >Note : fldremote_user is automatically created CC >variable containing value of remote_user field. >Fld is a standard cc prefix. >Make this field of \"Hidden\" type. >','2001-04-24 05:50:30','2001-04-24 05:50:30',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (889,835,835,'Re: Admin Module for the Forum Example','Dean Murphy','Dereck,  I''ve not thought this through but I think it would work.  Firstly, add a new column to your article record called delete me. Make this a boolean/eval field i.e Y/N. Display this field as part of your article admin record.  Now, instead of using the ''DELETE'' feature, use ''UPDATE''. Any articles ticked and then updated will have their ''Delete me'' field set to ''Y'' (or equivalent)  All you need to do now is add a piece of SQL to your admin form under the ''After Update'' event which deletes all records that have their ''Delete Me'' field set to ''Y''.  --  Dean deanpm@ntlworld.com','2001-04-24 06:04:56','2001-04-24 06:04:56',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (890,NULL,NULL,'UpLoading Pages','Popee','In an earlier post Eric Fu asked:  \"...how can I add <input type=\"file\"><br> into CC? How can I deal with these kind of input?...\"  And the response was given:  \"...if you want to add this to already existing  codecharge form , add Label field , check \"html\" checkbox in field properties/common tab. and in default value enter : <input type=\"file\"><br>...\"  I did this to an existing form and it came out looking great.  When I ran the page the UpLoad field showed with a Browse button, It allowed me to browse for the page I wanted to upload, but when I hit the insert button my page failed to upload.  Is there something I''m missing here?  I would really appreciate any help.  This is exactly what I''ve been trying to do.  Thank you;  Popee','2001-04-24 09:59:37','2001-04-24 09:59:37',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (891,NULL,NULL,'location of my perl','Todd Smith','How do I set the location of my perl executable to /usr/bin/perl instead of #!\\Perl\\bin\\perl.exe ?','2001-04-24 10:23:27','2001-04-24 10:23:27',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (892,863,863,'Re: Operation must use an updateable query','StiCK','Got it!  Thanks everyone!!  StiCK','2001-04-24 10:37:49','2001-04-24 10:37:49',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (893,NULL,NULL,'bizarre login bug','alexander m','if anybody can offer any sort of advice with this, i would be very grateful indeed, as it has me tearing out my hair in frustration...  i built a login page for a restricted part of my site (database updating/editing) while in belgium last week, using the latest version of CC. within a short space of time i had it running exactly as i wanted. i have now returned to london, logged on to the page, and now CANNOT access my DB admin page!   if i enter incorrect user/pass, then i get the expected error message of \"Login or Password is incorrect.\"  however, the bug arises when i enter the CORRECT user/pass. i enter them, press ''login'', and... find myself back at the login page with a strange URL in the address bar. this is a page that was working 100% perfectly only a day or two ago.  the correct pages are: http://blah.com/administration/login.php http://blah.com/administration/administration.php  and the page i get AFTER i enter the CORRECT user/pass is:  http://blah.com/administration/login.php?querystring=&ret_page=%2Fadministration%2Fadministration.php  what on earth is going on? i have tried using internet explorer 5.5 and netscrape 4.7, both get the same error.  :(  i am tearing my hair out here... help much appreciated.','2001-04-24 17:06:48','2001-04-24 17:06:48',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (894,NULL,NULL,'how can I edit it in this way?','eric fu','The edit in CC''s Example named EmplDir, it will jump to another page to fill the details of that. I am wondering how can I edit in the display or search''s result page. i.e Edit the clerk I want and display the others at the same time, and the look is like search result.  more details like this:     EDIT   NAME   POSITION      MAIL    [edit]  Eric   Programmer    ericfu@etang.com    [edit]  White  EMM           whiteli@21cn.com    [edit]  jack   MM            jackson@sina.com  just click edit button, and it will edit the clerk in this row and no change at the other rows,and after edit just confirm then the display changed. The response will be appreciated.','2001-04-24 17:49:03','2001-04-24 17:49:03',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (895,NULL,NULL,'about the button and the layout','eric fu','How can I add the button on the page? e.g I want to add a button beside the search button, but unfortunately it is not easy to do so.  I am wondering how can I design the layout of the page wich CC. Just add the form above or under the other form is not enough, I also want to array them as I like. But I can''t.   The response will be appreciated.','2001-04-24 19:59:09','2001-04-24 19:59:09',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (896,NULL,NULL,'about the time search','eric fu','I have created a website for a commpany''s intranet, CC really helps me a lot. But when I want to have a seach engine which has the condition of the time between, I find it difficult and I don''t know how to accomplish. Any idears will be appreciated.','2001-04-24 20:17:55','2001-04-24 20:17:55',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (897,891,891,'Re: location of my perl','CodeCharge Support','Todd, you probably use FTPUpload to upload files to  server. If so you`ll get the same output file  format for Unix and Win. It`ll be fixed in next  version. As a temporary decision to upload files  in Unix format follow the next: - select FTP define all settings (Server,  Path/Folder, etc.) - select Local/Network and set output file  format to Unix - switch to FTP and click generate','2001-04-25 01:48:54','2001-04-25 01:48:54',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (898,864,864,'Re: Image Catalog','Louie','Hi I have written a quick-and-dirty image catalog using CodeCharge.  Give me your email and I will email you the codecharge and mdb file  Thanks Louie velsto@ananzi.co.za','2001-04-25 02:24:25','2001-04-25 02:24:25',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (899,893,893,'found solution','alexander m','ahhh... i have found the problem. in belgium the computer i was using had no cookie filtering. seems login uses a session cookie, which is being filtered. allowing per-session cookies has fixed the problem. however, is there no way of having secure login WITHOUT cookies? i just... don''t like them, hehe.  :)','2001-04-25 02:36:49','2001-04-25 02:36:49',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (900,NULL,NULL,'Uploading images','Tony Swaby','Any way to integrate a browser based image upload facility in an administration section without the use of components?','2001-04-25 07:59:17','2001-04-25 07:59:17',14);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (901,610,610,'Re: Calendar Popup','Tracy','I''m in the process now of adding a calendar popup for date selection.  I think it would be of great assistance to have this process automated.  I love the idea!  Tracy','2001-04-25 12:08:50','2001-04-25 12:08:50',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (902,900,900,'Re: Uploading images','David Baril','In what language?  PHP4 handles this natively.  Here''s a link to a script that will do the trick for you in APS (requires the latest version of vbscript to be installed on the host): http://www.asp101.com/articles/jacob/scriptupload.asp  I have no idea about PERL, JSP, or Cold Fusion.  David','2001-04-25 12:22:13','2001-04-25 12:22:13',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (903,900,900,'Re: Re: Uploading images','David Baril','That should read ASP, not APS.  David','2001-04-25 12:30:26','2001-04-25 12:30:26',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (904,900,900,'Re: Re: Re: Uploading images','Tony Swaby','Fantastic!!! how easy is that........... Thanks man.  Tony','2001-04-25 13:10:24','2001-04-25 13:10:24',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (905,NULL,NULL,'Error: Unable to open the file. The file is empty.','Peter','When I start Code Charge and try to open an example ... I get the following error message \"Error: Unable to open the file. The file is empty.\" How can I solve it???  When is the release date for the version 2.0???','2001-04-25 13:32:39','2001-04-25 13:32:39',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (906,867,867,'Re: Re: Re: Re: Editing display order from a grid','Sam Moses','Actually, I did it by hand. Ordering field is not the primaroy key, but the SQL statement uses it to display the objects accordingly. It wasn''t hard, but it would be nice if I could have done it with codecharge. There would have been less debugging.','2001-04-25 20:36:25','2001-04-25 20:36:25',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (907,864,864,'Re: Re: Image Catalog','Sam Moses','Wow, sounds interesting. You can get a hold of me at sam@s1k.net Talk to you later, -Sam','2001-04-25 20:39:32','2001-04-25 20:39:32',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (908,894,894,'Re: how can I edit it in this way?','Sam Moses','Here''s what you do. Take note of the fields and form properties of the page. Then, use the page wizard to create at Grid Edit (one page) it''s in the options that will come up with the wizard. Then, put the same fields and properties into the new page. If you do it right, you will have two forms on the page: 1: view 2: eidt  and that should solve your problem.','2001-04-25 20:41:39','2001-04-25 20:41:39',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (909,NULL,NULL,'determining aborted sessions','Abu Abdullah','In the BookStore example, if a user adds some items to the shopping cart and then just logs off, the records are still in the orders table. Is there a way to find out if a particular session was aborted and then by storing the session id in the database, delete such records.  Regards','2001-04-26 00:09:25','2001-04-26 00:09:25',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (910,NULL,NULL,'Searching on lookup field','clarion','I have a table of book names and author ids. Another table holds the author id and author names. In the grid displaying the books, it is possible to display the corresponding author names using lookup. But in the search, I want to be able to search by both book name and author name. How can I do it as the search field for the author is in the other table?','2001-04-26 00:18:29','2001-04-26 00:18:29',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (911,894,894,'Re: Re: how can I edit it in this way?','eric fu','sorry, you don''t catch up my means. This will be better: not edit in the edit form, but still in the same form as it displayed. only one form is displayed on this page. Like \"aspfile\" object, then you will know what I mean.','2001-04-26 00:23:58','2001-04-26 00:23:58',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (912,NULL,NULL,'I want to buy CC, but how?','eric fu','I get some problems in buying CC, I am wondering  is there any partner off CC in China. Since there is some finace problem about invoice, I only can buy the product in mainlang of China. Please help me, I have no idear.:(','2001-04-26 00:53:44','2001-04-26 00:53:44',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (913,NULL,NULL,'where to put move_uploaded_files (PHP)?','clarion','I have a field to allow the user to upload an image file using <input type=file>. This form also has other fields and updates a table. Where do I put the move_uploaded_files call?','2001-04-26 01:55:47','2001-04-26 01:55:47',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (914,NULL,NULL,'win2000','aymen','hi, it is my first time to use CC , does anyone help me to how to deploy my work using CC. i men wht i need on the server-side to deploy my work(ASP,JSP-....), and from where i can get it? thanks','2001-04-26 02:39:05','2001-04-26 02:39:05',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (915,NULL,NULL,'Separate SQL code from the rest','don','What about to enchance the flexibility of CC modifying the template so that the SQL code is separated and encapsulated in a class or file ?   I think it is a good idea because in this way that someone who wants to modify the SQL code can do it easily.','2001-04-26 05:29:35','2001-04-26 05:29:35',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (916,909,909,'Re: determining aborted sessions','CodeCharge Support','When user logs in you should e.g. add a new record to \"special\" table (it will containt info about  user login and logout): for instance his  Session(UserID), session_id (let`s make it  autoincremental) and time of log in. Add also a  field \"session_id\" to orders table. When user adds  items to ShoppingCart session_id field should  fill.   When user logs out the record in \"special\" table is updating and his logout time is added.  Then when the user logs in again you can check if you have any records in \"special\" table without logout time. If yes, delete records orders table where session_id equals proper session_id value from \"special\" table','2001-04-26 06:14:02','2001-04-26 06:14:02',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (917,905,905,'Re: Error: Unable to open the file. The file is em','CodeCharge Support','Peter, you probably use old version. Download newer one: http://www.codecharge.com/download/files/CodeCharge1_1_17.exe Did you open examples before with success?','2001-04-26 06:40:34','2001-04-26 06:40:34',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (918,896,896,'Re: about the time search','CodeCharge Support','In your form add 2 fields , they may be either of  date type or of text type. These are for start and end time. In your target form''s properties/\"events\" tab ,  select \"Open\" event , enter similar code  (let''s form custom sql condition): sWhere=\"time between\" & GetParam(\"starttime\") & \" AND \" & GetParam(\"endtime\") This sql will filter out records not statisfying  given condition. Note that time handling depends on your database  server.','2001-04-26 06:55:46','2001-04-26 06:55:46',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (919,912,912,'Re: I want to buy CC, but how?','CodeCharge Support','You can contact reseller in China: joe@ntbus.net','2001-04-26 07:48:23','2001-04-26 07:48:23',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (920,905,905,'Re: Re: Error: Unable to open the file. The file i','Peter','The examples worked and were opened with success before.  My version is 1.1.16. Isn''t this strange?  Regards  P.S. When is V.2.0 going to be released??','2001-04-26 12:17:19','2001-04-26 12:17:19',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (921,864,864,'Re: Re: Image Catalog','NirvanaZ','Hi! me2 plzzz  thanx vvmuch  z@z6478.org','2001-04-26 15:45:23','2001-04-26 15:45:23',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (922,NULL,NULL,'News Server dead. :(','Jeff Stuart','Hey Codecharge folks... FYI... looks like it''s time to do some archiving on the news server. :(  I can''t get into it any more.  I get the following error message from Outlook Express:   400 No space (newslib) [innwatch:38] 24888 lt 25000','2001-04-26 17:55:03','2001-04-26 17:55:03',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (923,896,896,'Re: Re: about the time search','eric fu','The search form is either horizontal or vertical,   I am wondering how can I add 2 fields in a row of a vertical form. i.e  <Form> Name <TextBox>  Num  <TextBox> Dept <TextBox> Time <TextBox> To <TextBox>..............? </Form>  Thank You.','2001-04-27 04:23:45','2001-04-27 04:23:45',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (924,864,864,'Re: Re: Image Catalog','eric fu','hohoo, so do I. ericfu@etang.com thx','2001-04-27 04:34:55','2001-04-27 04:34:55',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (925,910,910,'Re: Searching on lookup field','eric fu','create a view links the two tables.','2001-04-27 04:36:57','2001-04-27 04:36:57',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (926,910,910,'Re: Re: Searching on lookup field','clarion','by rewriting the SQL statement? what should go in the form  properties input where the search variables are  trasferred to the grid form?','2001-04-28 04:46:37','2001-04-28 04:46:37',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (927,900,900,'Re: Re: Re: Re: Uploading images','clarion','PHP does have support in the lanugage to upload files.  I am still trying to fiugre out where to put the  move_uploaded_file function that a PHP script must call in order to move the file from the temporary space to  the desired location. Anybody tried to do this with  codecharge and PHP?','2001-04-28 05:01:34','2001-04-28 05:01:34',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (928,864,864,'Re: Re: Re: Image Catalog','Tony Swaby','My client wants an online image gallery with browser based upload maintenance. I''ve given up trying to use CC as integrating the file upload code is far too dificult!  So the answer.......go here http://www.dastrup.com/html/my_photo_album.asp  This app is full of features and easy to customize, i''d never do anything like this in CC! eric fu wrote:  >hohoo, >so do I. >ericfu@etang.com >thx','2001-04-28 05:03:04','2001-04-28 05:03:04',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (929,NULL,NULL,'DSN less connection','Tony Swaby','Anyone been able to do this?  I only half works for me.','2001-04-28 05:16:21','2001-04-28 05:16:21',4);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (930,NULL,NULL,'Warning: Missing argument 2 in call to tosql() in','Anthony','Any ideas what may be causing this?  Warning: Missing argument 2 in call to tosql() in ./common.php3 on line 131  Warning: Missing argument 2 in call to tosql() in ./common.php3 on line 131','2001-04-28 19:36:59','2001-04-28 19:36:59',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (931,718,718,'Re: Help on event','Alfredo Cueto','I agree with Daniel, and also with PHP examples. Thanks','2001-04-28 20:25:03','2001-04-28 20:25:03',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (932,803,803,'Re: Discussion Group','Marc','I usually use IE 5.5 while surfing, today I used Opera checking out CodeCharge website, I feel that it goes much faster. Give it a try. Marc.','2001-04-29 02:10:53','2001-04-29 02:10:53',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (933,803,803,'Re: Discussion Group','Marc','I usually use IE 5.5 while surfing, today I used Opera checking out CodeCharge website, I feel that it goes much faster. Give it a try. Marc.','2001-04-29 02:10:53','2001-04-29 02:10:53',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (934,803,803,'Re: Discussion Group','Marc','I usually use IE 5.5 while surfing, today I used Opera checking out CodeCharge website, I feel that it goes much faster. Give it a try. Marc.','2001-04-29 02:10:53','2001-04-29 02:10:53',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (935,NULL,NULL,'Required Flag','ADW','In a Record type form, what is the function of the Required flag on the Input tab?  I''ve found that if the Required flag is ticked, the input field gets added into the SQL statement that inserts a new record into the data table.  If it is an AutoNumber field, this causes the following error when attempting to insert a new record: \"You tried to assign the Null value to a variable that is not a Variant data type. (Microsoft JET Database Engine)\".  Is this correct behaviour, or am I missing something?','2001-04-29 12:22:13','2001-04-29 12:22:13',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (936,NULL,NULL,'Queries Vs Tables','ADW','Whilst evaluating CodeCharge, I''ve been using select queries as the basis for some Grid & Record forms that require values from related tables, instead of using tables & the Join function.  Does anyone know of any drawbacks to this approach, other than the obvious one of having to create the queries in the first place.','2001-04-29 12:56:26','2001-04-29 12:56:26',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (937,651,651,'Re: Re: CF Error in CC','swhenson@pacbell.net','I have the exact same error in bugtrack. I upgraded to 4.01  and still yje same problem... Any suggestions??  Thanks in advance','2001-04-29 21:51:03','2001-04-29 21:51:03',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (938,708,708,'Re: Re: Re: Re: Re: Re: Bug report','sinisa',' Now() is not a perl function but a MySQL time function!  CodeCharge Support wrote:  >I don''t know if function now() is present in any >standard Perl disrtibution , same as sysdate. >Please use some functions from standard modules , >like localtime() function etc.','2001-04-30 00:01:11','2001-04-30 00:01:11',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (939,864,864,'CC IMAGE CATALOGUE','Louie Storm','Hi I just need a few days to clean up my code. Nobody but me can understand it at this point. When I am finished I will post it on a website where you can FTP it down  Thanks louie','2001-04-30 02:14:33','2001-04-30 02:14:33',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (940,NULL,NULL,'bug when using join on a custom SQL','sinisa','1. I use a customer select:  select e.id as e_id, e.name as e_name, e.surname as e_surname, c.id as c_id, c.loan_type, c.type, c.address1, c.address2,c.city,c.zip,c.id,c.userid from employees e, certificates c  2. as a required input e_id and c_id are received  3. the select generated for the form is OK and is:  SELECT e.id as e_id, e.name as e_name, e.surname as e_surname, c.id as c_id, c.loan_type, c.type, c.address1, c.address2,c.city,c.zip,c.id,c.userid FROM employees e, certificates c WHERE (c.id=4 and e.id=1000000869)   4. BUT if I decide to add a join on loan_type field to the loan_type table the systekm returns errorneous SELECT and nothing works (notice AND insetad of WHERE):  SELECT e.id as e_id, e.name as e_name, e.surname as e_surname, c.id as c_id, c.loan_type, c.type, c.address1, c.address2,c.city,c.zip,c.id,c.userid FROM employees e, certificates c AND (c.id=4 and e.id=1000000869)  5. if instead of using a table join I definie a listof values everytjhing works fine!  Any idea?','2001-04-30 02:36:22','2001-04-30 02:36:22',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (941,864,864,'Re: Re: Re: Re: Image Catalog','Dean Murphy','Apart from the lack up file upload facilities, there is absolutely nothing to prevent you from developing this sort of application in CodeCharge.  I don''t understand why you wouldn''t do this in CC.  --  Dean deanpm@ntlworld.com','2001-04-30 03:04:46','2001-04-30 03:04:46',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (942,936,936,'Re: Queries Vs Tables','Dean Murphy','I don''t think there are any drawbacks. The easiest way to convince yourself is to produce two test pages, one using the front end join and the other using a custom SQL query. Simply compare the resulting output code to see the differences. I don''t think you''ll find much.  --  Dean deanpm@ntlworld.com','2001-04-30 03:14:01','2001-04-30 03:14:01',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (943,803,803,'Re: Re: Discussion Group','Dean Murphy','Looks like Opera might have some problems with form submission though ;-)  --  Dean','2001-04-30 03:25:59','2001-04-30 03:25:59',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (944,NULL,NULL,'BUG: Global functions not exported','sinisa','when adding global functions (module section), function is defined only internally within common.pm and is not exported.','2001-04-30 04:24:53','2001-04-30 04:24:53',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (945,NULL,NULL,'Use of DB functions within update / Insert','sinisa','I found a way how to \"override\" the impossibiliy to specifiy a DB function as a default value, by adding a global sunction that woulr return the name of the function in the database, i.e.   sub CreateNow { return \"Now()\" } would do just good. But CC doesnt export the function in global.pm as it should so you have to edit common.pm each time you recompile.   furthermore, you use it in the way that you edit field properties and put into Defautl Value \"=CreateNow()\". Problem starts when there is no suitable data type (you have Numeric, Date or Text=), while Date and Text are unsuitable as they put output between '''', Numeric doesn''t do that but it checks if data really is of a numeric type and returns error on tis check. So eh tme a form is recompuled yu need to edit manually. Additional type that doesnt check for numeric value would solve the problem!','2001-04-30 04:35:26','2001-04-30 04:35:26',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (946,NULL,NULL,'Record Form - Needs Tabular Display, N/A yet.','Alfredo Cueto','Hi, In order to allow visitors a faster way to update multiple records of a data base in one screen, it would be great if CodeCharge developers add extra functionality to the Record Form allowing to choose between, columnar and TABULAR (new feature) display. This would be very useful i.e. displaying products records to visitors and let them to enter the quantity and click to \"Add to shopping cart\" in a group for those products who have a number in Quantity field. It would be excellent if the Record Form allows to choose among fields of not one, but at least to tables of a data base, i.e. products and orders. Thank you very much for this great product that is Code Charge and hope you can include this new features in a near future release.','2001-04-30 06:01:03','2001-04-30 06:01:03',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (947,NULL,NULL,'Cold Fusion Error','swhenson@pacbell.net',' I continually get this error when using Cold Fusion. I have upgraded to 4.01 and am using NT with IIS 4. any suggestions??? Thanks     --------------------------------------------------------------------------------  Error Occurred While Processing Request Error Diagnostic Information Just in time compilation error  An unknown attribute ''SCOPE'' has been encountered at document position (19:9) to (19:13) while processing tag CFLOCK. This tag can only take the following attributes:   NAME THROWONTIMEOUT TIMEOUT TYPE The last successfully parsed CFML construct was a CFLOCK tag occupying document position (19:1) to (19:7).  The specific sequence of files included or processed is: C:\\INETPUB\\WWWROOT\\BUGTRACK1\\DEFAULT.CFM         C:\\INETPUB\\WWWROOT\\BUGTRACK1\\COMMON.CFM      CFInclude  The error occurred while processing an element with a general identifier of (CFINCLUDE), occupying document position (1:1) to (1:33).   Date/Time: 04/30/01 06:37:22 Browser: Mozilla/4.0 (compatible; MSIE 5.5; Windows NT 4.0) Remote Address: xx.xx.xx.xx Template: C:\\Inetpub\\wwwroot\\bugtrack1\\default.cfm       --------------------------------------------------------------------------------','2001-04-30 06:33:43','2001-04-30 06:33:43',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (948,NULL,NULL,'Persisting Sessions','Steve','I briefly tried the trial version and could not find anything on registration and providing the ability to retain user name and passwords using either NT or cookies.    Did I miss something?  Thanks, Steve','2001-04-30 09:55:29','2001-04-30 09:55:29',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (949,651,651,'Re: Re: Re: CF Error in CC','Peter','This is what is listed as System Requirements for CC on this site:  Server Requirements (for deployment):  <../images/icons/Gen-icon.gif> ASP 2.0, ColdFusion 4.5, JSP 1.1, PHP 4.0 or Perl 5.0 server, or higher   ... so upgrade to ColdFusion 4.5 ...','2001-04-30 11:40:44','2001-04-30 11:40:44',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (950,946,946,'Re: Record Form - Needs Tabular Display, N/A yet.','Ian Doni','i agree. it is an exelent idea!!','2001-04-30 14:40:37','2001-04-30 14:40:37',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (951,692,692,'Re: Re: shbang generation','Perl path when will','Hi, I just download the trial version and want to make a decision asap as it looks promising but I cannot publish to my unix sever since there is no way for me to insert the proper perl path.   In a forum messag eof approx 2 weeks ago it was said it would be fixed. Could you get back to me on this asap as I really want to try out your software and at the moment it''s of no use to me.  Best regards,  cdv @ belgamedia.be','2001-04-30 17:45:36','2001-04-30 17:45:36',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (952,692,692,'Re: Re: Re: shbang generation','me again','By the way,  My perl path is /usr/local/perl  so not the standard one so it should be a good idea to let an administrator decide','2001-04-30 18:59:52','2001-04-30 18:59:52',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (953,NULL,NULL,'Event - PHP code for mail sending','Roger','Hi, Any suggestion how it should be done. I know I should use the PHP mail() function but I have no idea how to use it in CC.  Thanks.','2001-05-01 07:16:48','2001-05-01 07:16:48',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (954,900,900,'Re: Re: Re: Re: Re: Uploading images','BradleyMiller','Actually, I''m doing this on several sites, and pages.   I got around things by doing it this way:  Code charge is used to keep track of my form.  On a form I have a picture field and thumbnail field.   When the user clicks a link for the upload routine, it opens a small window and allows them to browse for the file they want to upload.   The form is called with the parameters of what the form name is to be passed back to. Then when the file is uploaded, I have a routine create a thumbnail of the uploaded file.  Those two file names are passed back to the calling form and that form can then be submitted by the user.   It works really slick.   I''m reconstructing a few things right now, but if you are interested in some demos, I could give you an URL.  -- Bradley Miller','2001-05-01 07:36:58','2001-05-01 07:36:58',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (955,953,953,'Re: Event - PHP code for mail sending','BradleyMiller','As a matter of fact, I did this yesterday on a form.  When the user fills it out, I have an \"After Insert\" that sends an email off to let me know someone input data for the file.   You can view the mail function here:  http://www.php.net/manual/en/function.mail.php  -- Bradley Miller','2001-05-01 07:42:17','2001-05-01 07:42:17',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (956,929,929,'Re: DSN less connection','j.schneider@fraport','<%  Dim MyConn, MySQL, rs, i  Set MyConn=Server.CreateObject(\"ADODB.Connection\") Set rs = Server.CreateObject(\"ADODB.Recordset\") MyConn = \"Provider=SQLOLEDB; Data Source=Your SQL Server; Initial Catalog=Your Database; User ID=Your SQL Login; Password=Your Password\" MYSQL = \"SELECT Column Name you want data entered into FROM Your Table Name\" rs.Open MySQL, MyConn, 1, 3  %>','2001-05-01 08:41:25','2001-05-01 08:41:25',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (957,NULL,NULL,'ASP - File Upload','Imran','I''m having trouble integrating any kind of ASP file upload method with CodeCharge.  Anyone have any luck with this?  Ideally, I''d like to be able to not only upload the file, but at the same time put information into an Images table in my database.  Anyone try this yet?','2001-05-01 08:50:42','2001-05-01 08:50:42',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (958,929,929,'Re: DSN less connection','Joachim Schneider','Set MyConn=Server.CreateObject(\"ADODB.Connection\") MyConn.Open \"PROVIDER=MSDASQL;\" & \"DRIVER={Microsoft Access Driver (*.mdb)}; \" & \"DBQ=\" & MyLoginDB MySQL=\"Select  * from Your_table\"   Set MyRs=MyConn.Execute(MySQL)  j.schneider@fraport.de','2001-05-01 08:50:26','2001-05-01 08:50:26',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (959,953,953,'Re: Re: Event - PHP code for mail sending','Roger','Thanks Bradley,  Finally got it to work.  Roger','2001-05-01 10:00:27','2001-05-01 10:00:27',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (960,NULL,NULL,'auto hyperlink for email and URL','Roger','Hi, I am trying to make my email and URL fields with a hyperlink. I saw the solution on somewhere but now I cannot find it.  Can anyone please help?','2001-05-01 10:10:15','2001-05-01 10:10:15',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (961,610,610,'Re: Re: Calendar Popup','Earl','Yes!  I told CC that a long time ago. What business app does not use dates??? Date text entry by a user is nuts.  I''m planning on using: ''File Name: calpop.asp ''   Author: Rama Ramachandran ''           Imperium Solutions ''           http://www.imperium.com ''           Internet: rama@imperium.com from: http://gethelp.devx.com/techtips/asp_pro/10min/10min1200/10min1200.asp  Earl','2001-05-01 12:50:13','2001-05-01 12:50:13',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (962,NULL,NULL,'PHP to Perl','Roger','I have done my app in PHP without problem. How do I get it to work in PERL? What are the things to watch out for? I am on a share unix host.  Thanks.','2001-05-01 13:30:50','2001-05-01 13:30:50',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (963,NULL,NULL,'Why? custom SQL','sinisa','Problem:  have this SQL  select e.id as e_id, e.name as e_name, e.surname as e_surname, c.id as c_id, c.type, c.address1, c.address2,c.city,c.zip,c.id,c.userid, l.name_hr as namehr,c.jmbg from employees e, certificates c, loan_type l where (l.id = c.loan_type)  all fetched data are used in the form, everything works fine, only ''name_hr'' value has problems. Generated code:      my $flde_name = GetValue($ref_db_record, \"e_name\");     my $flde_surname = GetValue($ref_db_record, \"e_surname\");     my $flde_id = GetValue($ref_db_record, \"e_id\");     my $fldid = GetValue($ref_db_record, \"id\");     my $flduserid = GetValue($ref_db_record, \"userid\");     my $fldtype = GetValue($ref_db_record, \"type\");     my $fldnamehr = GetValue($ref_db_record, \"\");     my $fldaddress1 = GetValue($ref_db_record, \"address1\");     my $fldaddress2 = GetValue($ref_db_record, \"address2\");     my $fldcity = GetValue($ref_db_record, \"city\");     my $fldzip = GetValue($ref_db_record, \"zip\");     my $fldjmbg = GetValue($ref_db_record, \"jmbg\");  Note:      my $fldnamehr = GetValue($ref_db_record, \"\");  where there is not hash key specified  any idea why?','2001-05-02 01:33:30','2001-05-02 01:33:30',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (964,864,864,'Re: Re: Re: Re: Re: Image Catalog','Louie','Ok it is ready.  Please download it from www.datax.co.za/ccgall/gall.zip  Please note: 1. There should be a /gallery directory to store the large images and /gallery/thumbnails to store the thumbnail images 2. You only need to change the gall_photo table in the database 3. The number of records shown in Codecharge should be a multiple of the images displayed in a row  Please mail me at louie@datax.co.za for any questions  Thanks Louie','2001-05-02 02:41:41','2001-05-02 02:41:41',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (965,948,948,'Re: Persisting Sessions','CodeCharge Support','What scripting language do you use ? For PHP4 you''ll need to call  session_set_cookie_params to set cookie''s lifetime. In ASP it''s \"expires\" attribute of cookie value in response object.','2001-05-02 04:26:58','2001-05-02 04:26:58',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (966,960,960,'Re: auto hyperlink for email and URL','CodeCharge Support','If you mean storing urll in a database and displaying them as hypperlinks , you need to set field type to \"URL\"  and check \"Use url field\" checkbox in \"Common\" tab .','2001-05-02 04:33:20','2001-05-02 04:33:20',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (967,960,960,'Re: auto hyperlink for email and URL','CodeCharge Support','If you mean storing url in a database and displaying them as hypperlinks , you need to set field type to \"URL\"  and check \"Use url field\" checkbox in \"Common\" tab .','2001-05-02 04:33:20','2001-05-02 04:33:20',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (968,NULL,NULL,'Why >= AND <= don''t work for dates ?','donsur','There is any solution ? The solutions proposed in the FAQ doesn''t work.','2001-05-02 04:35:31','2001-05-02 04:35:31',3);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (969,962,962,'Re: PHP to Perl','CodeCharge Support','To get it to work in Perl you''ll need to select  \"Perl\" in Language tab , set database parameters like hostname/password , dbi connection string  in Site/properties/database , check if session_files subdirctory is created in upload directory. If not , create it and give it read-write permissions for \"others\" group.','2001-05-02 04:49:47','2001-05-02 04:49:47',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (970,968,968,'Re: Why >= AND <= don''t work for dates ?','CodeCharge Support','Date handling is extremely dtabase dependent , please specify what kind of database you use.','2001-05-02 04:53:52','2001-05-02 04:53:52',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (971,NULL,NULL,'Jsp Generator by Chinese,Have Bug,....Pls.','RuRu','Set CodeCharge  Options/Site Translation/Chinese ________________________________________________ Result to appear is disorder code, Please,replay to me,3Q','2001-05-02 05:14:42','2001-05-02 05:14:42',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (972,963,963,'Re: Why? custom SQL','CodeCharge Support','Is primary key checked on your form ? Check if database field is specified in Form/Fields for namehr field.','2001-05-02 05:03:01','2001-05-02 05:03:01',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (973,968,968,'Re: Re: Why >= AND <= don''t work for dates ?','donsur','I use MS Access , thanks','2001-05-02 06:25:46','2001-05-02 06:25:46',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (974,968,968,'Re: Re: Why >= AND <= don''t work for dates ?','donsur','I use MS Access 2000, thanks','2001-05-02 06:25:46','2001-05-02 06:25:46',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (975,947,947,'Re: Cold Fusion Error','CodeCharge Support','ColdFusion 4.0 doesn''t support scope attribute  for CFLOCK tag, but ColdFusion 4.0.1 does, and  probably you use old CC version. If so  download and install new one: http://www.codecharge.com/download/files/CodeCharge1_1_18.exe','2001-05-02 07:05:04','2001-05-02 07:05:04',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (976,971,971,'Re: Jsp Generator by Chinese,Have Bug,....Pls.','CodeCharge Support','In Regional Options set Your Locale to  Chinese(Taiwan), click SetDefault and also  select Chinese. If you haven`t Chinese language in Locale select TraditionalChinese in ''Language  Settings for your system''. Then select in  CodeCharge Options/Site Translation/Chinese','2001-05-02 07:57:31','2001-05-02 07:57:31',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (977,NULL,NULL,'Searching Multiple Tables','Ryan Kelley','I am trying to create a vehicle locator.  To where a user can go and pick a model of a vehicle and it will search the same field in multiple tables to output results.  I have it working fine if it searches one table but i have to search more than 1. Please help if you can.','2001-05-02 14:52:58','2001-05-02 14:52:58',3);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (978,947,947,'Re: Re: Cold Fusion Error','steve','Actually you have to have Cold Fusion 4.5 or higher. I installed it and it works fine thanks.','2001-05-02 17:03:53','2001-05-02 17:03:53',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (979,NULL,NULL,'site made with codecharge','guarez','hi, i like to see what codecharge can do, tell me some site made with this excelent program  bye!  adiux','2001-05-03 00:17:21','2001-05-03 00:17:21',3);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (980,935,935,'Re: Required Flag','CodeCharge Support','Your note about if Required checkbox is checked this field added to insert sql statement is rigth. ok.I suppose your autonumber field is probably a  primary key. When PK value pass to record form it switches to ''update mode''. If you have  ''insert mode'' no PK value transferred. But it checked as Required. So it added into sql  statment and CC tries to insert record with NULL PK value. And PK is AutoNumber and can`t  be NULL. You get the error. You don''t need to transfer PK as Required from  grid to record form when you want to insert  record.','2001-05-03 00:52:27','2001-05-03 00:52:27',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (981,940,940,'Re: bug when using join on a custom SQL','CodeCharge Support','If you use custom sql you shouldn''t use join tab at field/properties. You should add into sql statement a part corncerning join fields. Like: select b.*, c.c_name from books as b, customers as c where b.id = c.id  So in column c_name you''ll see customer''s names.','2001-05-03 04:27:33','2001-05-03 04:27:33',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (982,979,979,'Re: site made with codecharge','newbie','codecharge.com support.codecharge.com www.pc-team.de','2001-05-03 08:37:08','2001-05-03 08:37:08',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (983,977,977,'Re: Searching Multiple Tables','CodeCharge Support','You can dynamically build sql statement in Form properties/sql/where box , like : name = \"& get_param(\"name\") & \" other_name = \" & get_param(\"other_name\") & \" or build it in Proeprties/events/Open event , filling sSQL variable with custom made sql statement.','2001-05-03 08:40:56','2001-05-03 08:40:56',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (984,977,977,'Re: Re: Searching Multiple Tables','Ryan Kelley','Could you please elaborate more.  I go into Form Properties and there is no sql tab or box as well as there is no where box either.  Could you please help me.','2001-05-03 10:40:05','2001-05-03 10:40:05',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (985,935,935,'Re: Re: Required Flag','ADW','Thanks for the clarification.','2001-05-03 16:45:28','2001-05-03 16:45:28',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (986,NULL,NULL,'multiple fields in text files.','Sam Moses','I''ve been experimenting with perl and flat text files over the last few days, and I''ve figured out how to use them. It''s a good challenge. I''m an ASP guy for the most part, and I''m used to using SQL and Access Db''s. My question is how do you establish multiple fields in a single text file?','2001-05-03 20:45:50','2001-05-03 20:45:50',4);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (987,971,971,'Re: Re: Jsp Generator by Chinese,Have Bug,....Pls.','RuRu','I already set it,But can not display chinese','2001-07-05 11:40:14','2001-07-05 11:40:14',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (988,986,986,'Re: multiple fields in text files.','CodeCharge Support','I suggest you to use CSV file format , but yet not sure if there is DBI driver for CSV.','2001-05-04 05:58:20','2001-05-04 05:58:20',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (989,NULL,NULL,'Exclusive lock with codecharge','Fred','How can I use Exclusive lock with codecharge : I have to prevent other users from modifying entries.  For example, when I have a simultaneous change (by different users) in the same entry like (yellowpages Entries) I don?t want the entry change after the last submit because it depend of hazard.   You know, this mechanism exist in several database like oExclusive lockso for postgres.','2001-05-04 09:12:38','2001-05-04 09:12:38',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (990,NULL,NULL,'translation','frederic@altiva.fr','how can I create a codecharge application who manage different language. I think about field depending to language dictionnary  :  {first_name} =>   eng : 	oFirst Nameo fr:	oPr?nomo it: ...','2001-05-04 09:13:57','2001-05-04 09:13:57',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (991,NULL,NULL,'Unable to Update & Delete Records','chief@hbvac.org','Any help with this problem would be appreciated. The problem is that I''m using a mySQL DB and creating a PHP4 front end to an application, but when I create a form as a record the resulting HTML page does not contain the Update and Delete buttons. However, these pages do contain the Insert and Cancel buttons.  I''ve verified that the database user has r/w permissions for this DB and the application connects to the DB just fine. I''ve also verified that the form properties in CodeCharge have been selected and the resultant PHP code contains the requisite Update and Delete record information. Thanks for the help in advance.','2001-05-04 09:28:47','2001-05-04 09:28:47',3);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (992,986,986,'Re: Re: multiple fields in text files.','Sam Moses','Actually there is, But I still don''t know how to add tables to a text file.','2001-05-04 15:37:06','2001-05-04 15:37:06',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (993,621,621,'Re: Re: Problem Memo fields - Text areas','Richard at 21ao','Hi Guys, Im having problems with memo fields. I can enter information into a Text area fine, but when I try to view the information or reedit it , it is gone!  I know it is still there as I can still view it in Access but doesnt appear in my label or textbox/area fields.  Regards   Richard email richard@21ao.com  My system is IBM Thinkpad Celeron 700  64MB RAM Windoze 2000 Professional Edition and COdecharge is 1.1.16','2001-05-05 07:34:36','2001-05-05 07:34:36',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (994,NULL,NULL,'Can Someone Help a Beginner?','New2Progamming','Hi,  I want to know what my prerequisites are before I use code charge.  When I tried to use the demo, I was totally lost.  For instance, the \"properties\" section asks to input the databse connection and I see all this ODBC stuff.  I have no clue, can someone convince me that I can still use codecharge with no database and programming knowledge?  Or at least point me in the right direction to learn the basics.  Thanks!','2001-05-05 08:00:49','2001-05-05 08:00:49',4);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (995,994,994,'Re: Can Someone Help a Beginner?','Ryan kelley','I am also fairly new to programming but i have had no problem with code charge. The ODBC stuff is just to get your connection to the the database.  Windows supports most types. I am using MySQL and PHP so i had to download MyODBC from www.mysql.com I found codecharge fairly simple but you just have to remember that it is not like FrontPage in that it only shows you the setup for the form and then you have to publish or preview the pages to see what the finished product looks like.  Hope i have been of some help.','2001-05-05 08:51:49','2001-05-05 08:51:49',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (996,NULL,NULL,'Inserting SQL Statements In CodeCharge','RyanKelley@freightliner.com','I am trying to insert some SQL Statements into codecharge.  I know that they are good statements because i can go into phpMyAdmin and run them on my database and they work just perfect.  I am using MySQL database and PHP 4.   Here is my SQL statement.  DELETE FROM tblinventory; INSERT INTO tblinventory SELECT tblwest.* FROM tblwest; INSERT INTO tblinventory SELECT tblnc.* FROM tblnc; INSERT INTO tblinventory SELECT tblsc.* FROM tblsc;  This statement deletes all the records from tbl1 and then fills it back in with data from tbl2,tbl3, and tbl4.  I want it to auto update the table like that every time my form is loaded.  I have a search form and i put the statement in my grid form so that when you search it updates the table.  Users would be searching for trucks.    When i put the code in the custom SQL box in Form Properties/SQL tab/  CodeCharge gives me this error.  Invalid SQL Query. Error: Class does not support Automation or does not support expected interface.  Please Help i know that the sql statement is good and i just cant get codecharge to take the darn thing.  Thanks,  Ryan Kelley','2001-05-05 08:57:59','2001-05-05 08:57:59',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (997,NULL,NULL,'I need help setting up this ODBC','Mike Lessar','Thanks ahead of time for your help.  I am using MySQL with php 3.0  I have downloaded the mysql odbc driver from www.mysql.com.  It says I have installed the driver.   I guess I have not set it up right.  when I am using code charge in properties -> database -> connection string.  I select MySQL and fill in the information, and when i test the connection, I get the error of:  Test connection failed because of an error in initializing provider. %1.   What does this mean and how do I correct it?  Thanks','2001-05-05 12:21:46','2001-05-05 12:21:46',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (998,NULL,NULL,'hiding fields, depending on the action upd/del/ins','Emile','Hi,  Is it possible to hide some fields depending on the incoming action? If go to the page with the IN variables it knows it''s an update or delete. No IN variables means an insert.   I want the page to be insert some values, but some of the values may not be changed afterwards. That''s why I don''t want to show that values, or show them as an label.   One option is to create two templates and take the right one at the open page event. I have not tried that yet, because I think that there must be a better way. Is this working anyway?  Does someone has another idea?   I''m working with PHP4 and Oracle 8i.  Greetings,  Emile','2001-05-05 12:42:12','2001-05-05 12:42:12',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (999,621,621,'Re: Re: Re: Problem Memo fields - Text areas','ADW','Hi,  I''m having the same problem as Richard, If I place an Access memo filed on a form, I can update it ok, but the text does not appear.  If I change the field type to Text in the data table, it works as expected. I get these problems under both Win 98 SE & Win 2000.  System Details: AMD Athlon 800 256 MB RAM, Win 98 SE / Win 2000 Professional Access 97 COdecharge 1.1.16','2001-05-05 14:22:41','2001-05-05 14:22:41',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1000,914,914,'Re: win2000','rossy','Just need to install iis that comes with win2000 and you''ve got asp 2.0 enabled host','2001-05-05 15:49:36','2001-05-05 15:49:36',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1001,NULL,NULL,'PWS vs Apache','Roger','I have successfully installed PHPTriad on my Win98 system for developing CC on.  Now I am finding myself having to stop Apache and startup PWS so that I can study the tutorial files on ASP/Jet/MDB  I believe there must be a better way to go about. Maybe I should forget Apache and just use PWS/PHP using PHP EasyWindows Installer from http://php.weblogs.com/easywindows. So that I can have a ASP/PHP/MySQL/MDB envoirment.  Anyone have any good suggestions? e.g. which is a better?  Thanks. Rgds Roger','2001-05-06 00:24:00','2001-05-06 00:24:00',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1002,989,989,'Re: Exclusive lock with codecharge','CodeCharge Support','Fred, if you use PostgreSQL you can use Exclusive locks in CodeCharge. You should define ''Open'' event for Record form and include there Exclusive locks statement and its execution.','2001-05-07 01:04:44','2001-05-07 01:04:44',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1003,990,990,'Re: translation','CodeCharge Support','Frederic, for the time being CodeCharge generates one site for one language (English, Chinese, etc).  But for different forms you can set different languages in Tools/Options and you''ll get buttons and links captions on language you selected. But to have different pages on different  languages at all you should in generated .html  files change charset in string: <meta http-equiv=\"Content-Type\" content=\"text/html; charset=windows-1251\"> NOTE! this way may cause errors corncern to  regional settings and displaying field''s values on national languages.','2001-05-07 01:26:21','2001-05-07 01:26:21',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1004,991,991,'Re: Unable to Update & Delete Records','CodeCharge Support','Hi, if ''Allow Insert'', ''Allow Update'', etc.  in Record form/Properties are selected then when you insert new record on the form there are  buttons:Add, Cancel; when you update record -  Update, Delete, Cancel.','2001-05-07 02:27:04','2001-05-07 02:27:04',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1005,996,996,'Re: Inserting SQL Statements In CodeCharge','CodeCharge Support','Ryan, on SQL tab you can define only one sql statement; if you need some of them, define ''Open'' event for Grid form like: $sSQL = \"DELETE FROM tblinventory\"; $db->query($sSQL); $sSQL = \"INSERT INTO tblinventory SELECT tblwest.* FROM tblwest\"; $db->query($sSQL); $sSQL = \"INSERT INTO tblinventory SELECT tblnc.* FROM tblnc\"; $db->query($sSQL); $sSQL = \"INSERT INTO tblinventory SELECT tblsc.* FROM tblsc\"; $db->query($sSQL);  Corncerning Error: Class does not support Automation or does not  support expected interface you should reinstall MDAC2.6: http://www.microsoft.com/data/download_260rtm.htm','2001-05-07 03:36:08','2001-05-07 03:36:08',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1006,996,996,'Re: Inserting SQL Statements In CodeCharge','CodeCharge Support','Ryan, on SQL tab you can define only one sql statement; if you need some of them, define ''Open'' event for Grid form like: $sSQL = \"DELETE FROM tblinventory\"; $db->query($sSQL); $sSQL = \"INSERT INTO tblinventory SELECT tblwest.* FROM tblwest\"; $db->query($sSQL); $sSQL = \"INSERT INTO tblinventory SELECT tblnc.* FROM tblnc\"; $db->query($sSQL); $sSQL = \"INSERT INTO tblinventory SELECT tblsc.* FROM tblsc\"; $db->query($sSQL);  Corncerning Error: Class does not support Automation or does not  support expected interface you should reinstall MDAC2.6: http://www.microsoft.com/data/download_260rtm.htm','2001-05-07 03:36:08','2001-05-07 03:36:08',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1007,997,997,'Re: I need help setting up this ODBC','CodeCharge Support','Mike, to establish correct connection setup your ODBC connection name (DSN) in Start ->  Control Panel -> ODBC. In CodeCharge, click on Properties -> Database,  and on the Yellow icon that opens OLE Database  Providers. Select ODBC and then your ODBC  connection name.','2001-05-07 05:39:59','2001-05-07 05:39:59',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1008,991,991,'Re: Re: Unable to Update & Delete Records','chief@hbvac.org','For whatever reason that doesn''t seem to be the case. The variables appear to be passing on the either the next page or itself just fine, but I''m still not having any luck. In addition there should be the ability to have a administration page that links off to seperate pages for  adding records, or delete/updating records without running  into this problem. For testing purposes I''ve got all options enabled on the following page and only the Insert and Cancel  buttons are coming up. http://media.hbvac.org/losap/member_maintenance.php','2001-05-07 06:08:45','2001-05-07 06:08:45',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1009,621,621,'Re: Re: Re: Re: Problem Memo fields - Text areas','DB','I have experienced the same problem with memo fiels  and text areas, but it seems the problem is with  Access 97 not Access 2000.  The BugTrack example  uses Access 2000.  I can add a new table to that .mdb file and the memo fields in text areas work fine.  Same table, Access 97 format, empty text areas after saving.  Codecharge 1.1.16, Access 97, Windows 98','2001-05-07 06:43:18','2001-05-07 06:43:18',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1010,NULL,NULL,'Sending data from a form via Email','Ryan Kelley','I am wanting to automatically send 3 fields to a form where the user is required to input their contact information and then when they submit the form it emails to a designated email adress.  Can anyone help?','2001-05-07 08:59:09','2001-05-07 08:59:09',6);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1011,621,621,'Re: Re: Re: Re: Re: Problem Memo fields - Text are','Richard at 21ao','Hi Guys  Just so you all know, my problem was fixed by version 1.1.18 download.  Rich','2001-05-07 15:33:36','2001-05-07 15:33:36',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1012,NULL,NULL,'Jsp Generator by Chinese,Have Bug,....Pls.','RuRu','I already set chinese,But can''t display Chinese~~ Pls,test as below :   Tools/Options/Site Translation/Chinese   Site/Properties/Language : JSP 1.1  Go Live : Can''t normal display chinese~   pls to answer,thanks','2001-05-07 18:38:45','2001-05-07 18:38:45',7);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1013,NULL,NULL,'How to implement mult-select lists?','Darren Pamatat','I have a schema (Postgres 7.1) where I have a products, category, and product_category table where a product is 1 to many with product_category and category is 1 to many with product_category (i.e. a product can have more than one category and a category applies to many products).  I would like to display a grid for display with product records and there associated categories in one row, maybe with the category names in a comma sep list, or maybe with the first category in a col and a more... link to display the other categories which apply to this product. How can this be done?  Also when adding a new product, a multi-select list box of category names would be the optimal selection mechanism, how can this be done? Any alternatives?  On a seperate question: How can I use custom sql to create new fields, since the form only allows inserting fields from the given table pick list?  Thanks, Darren','2001-05-07 20:48:59','2001-05-07 20:48:59',3);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1014,986,986,'Re: Re: Re: multiple fields in text files.','Adam Stock','CSV files are usually made of text fields in quotes, separated by commas, like \"code\",\"name\" \"007\",\"james bond\" Not sure if this applies to the particular format/driver you found.','2001-05-07 21:37:13','2001-05-07 21:37:13',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1015,NULL,NULL,'Pls tell me about cc Purchase','eric fu','Pls tell me the affiliate of CC in China, I have mailed him through the e_mail you have mentioned before, but unfortunately no response. I don''t know why. I am eagerly to buy it. Pls check the e_mail and help me to puchase CC. Thank you','2001-05-07 21:37:49','2001-05-07 21:37:49',3);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1016,1013,1013,'Re: How to implement mult-select lists?','Adam Stock','Currently you cannot create multi-select listboxes with CC. As for the other points, you may use your own SQL queries instead of the tables, to achieve most of what you need. A table is an equivalent of: SELECT * FROM table_name;  You can use your own SQL statement variations that will include data from multiple tables, for example: SELECT * FROM table1, table2; You may also use Events to update 2nd table or send email, using information entered by the user on the form. This is shown in CC \"Tell-A-Friend\" example.','2001-05-07 21:45:23','2001-05-07 21:45:23',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1017,1012,1012,'Re: Jsp Generator by Chinese,Have Bug,....Pls.','Adam Stock','Are your Regional settings in Control Panel set to Chinese ? Also, you may try editing the file called Chinese.xml in \"c:\\Program Files\\CodeCharge\\Translations\" directory. You can modify the \"Encoding\" to match the encoding that works OK on your computer.','2001-05-07 21:54:56','2001-05-07 21:54:56',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1018,1015,1015,'Re: Pls tell me about cc Purchase','Adam Stock','http://www.codecharge.com.tw/','2001-05-07 22:04:42','2001-05-07 22:04:42',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1019,991,991,'Re: Re: Re: Unable to Update & Delete Records','Adam Stock','chief@hbvac.org wrote:  >For whatever reason that doesn''t seem to be the case. >The variables appear to be passing on the either the next >page or itself just fine, but I''m still not having any >luck.  Please make sure that: a) your record form receives the Key to the main record in the Form Properties / Input section b) \"required\" checkbox is checked in the Input properties setup as above  > In addition there should be the ability to have >a administration page that links off to seperate pages for  >adding records, or delete/updating records without running  >into this problem.  There is such ability. The same Record Form acts as a New Record Form, or as a Record Update Form, depending on if it receives the existing record key from previous form. You call the maintenance form with or without the parameters and that way can place different links to it from different places. However, you may always run into your problem if you don''t tell the maintenance form the key to your record.   > For testing purposes I''ve got all options >enabled on the following page and only the Insert and Cancel  >buttons are coming up. >http://media.hbvac.org/losap/member_maintenance.php  This URL doesn''t work for me at all. However, almost all examples included with CodeCharge, have a record maintenance form. For further analysis, you may email your project file (.ccs) to us by submitting it to our support system at http://support.codecharge.com','2001-05-07 22:12:19','2001-05-07 22:12:19',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1020,621,621,'Re: Problem Memo fields - Text are','CodeCharge Support','If this problem happens only when you use DNS/ODBC (instead of JET), then the fix will be available in the next release. In the meantime you may download this intermediate version: http://www.codecharge.com/download/files/CodeCharge1_1_18.exe','2001-05-07 22:25:43','2001-05-07 22:25:43',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1021,994,994,'Re: Re: Can Someone Help a Beginner?','Adam Stock','ODBC is just a big word (or shortcut) for a small thing. You may need to learn some of such terminology and functionality, but in the end it is not related to the knowledge of programming. Both MS Access and MS Excel also use ODBC to connect to other databases. CodeCharge uses something called \"Database connection string\", which is basically a number of paramters telling CodeCharge (and generated programs) where your database it, what kind of database it is, etc. Please look at the tutorials at http://support.codecharge.com/tutorials.asp for more information. Specially \"Understanding How it All Works\". Another \"Fast Track\" tutorial will be available this week.','2001-05-07 22:27:36','2001-05-07 22:27:36',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1022,1010,1010,'Re: Sending data from a form via Email','Adam Stock','This looks like \"Tell-A-Friend\" example included with CodeCharge. Please look at it, specially at the \"After Insert\" Event in Form Properties.','2001-05-07 22:36:16','2001-05-07 22:36:16',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1023,1015,1015,'Re: Re: Pls tell me about cc Purchase','eric fu','Thank you, Wish TaiWan come back to our China Big Family one day. But now I can''t purchuse directly from taiwan.Adam Stock wrote:  >http://www.codecharge.com.tw/','2001-05-07 23:39:07','2001-05-07 23:39:07',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1024,1012,1012,'Re: Re: Jsp Generator by Chinese,Have Bug,....Pls.','RuRu','My computer to set all normal,Because  I generator select by ASP or PHP,It''s normal, But I Change Properties/Language/JSP,It''s not ok! So, I think it''s CC of bug','2001-07-05 11:40:14','2001-07-05 11:40:14',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1025,1012,1012,'Re: Re: Re: Jsp Generator by Chinese,Have Bug,....','Helper-waker','Do you mean this message is shown on a web page in \"Go Live\" mode \"Can''t normal display chinese\" Or you see something else on this page ? Please give more details.','2001-05-08 03:26:41','2001-05-08 03:26:41',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1026,1012,1012,'Re: Re: Re: Re: Jsp Generator by Chinese,Have Bug,','RuRu','pls, you can see this url :  http://203.66.109.19:7000/6tom/bb_companyGrid.jsp  Result is wrong , chinese can''t display!!  As Bottom of chinese OR As Field of contant','2001-07-05 11:40:14','2001-07-05 11:40:14',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1027,NULL,NULL,'Uploading with PHP','clarion','I am trying to upload files with PHP but still wondering where to put the code. I got the <input file> part ok. But what about the rest of the code. Where do I put it?  Any pointers will be appreciated.','2001-05-08 04:44:12','2001-05-08 04:44:12',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1028,1013,1013,'Re: Re: How to implement mult-select lists?','Darren Pamatat','Thanks,  I still have a question about how to include fields from a SQL query in the grid. It looks as if only fields which are in a table specified in the table dropdown can be chosen. How do I add my own fields to this list which are columns returned in the resultset?  Thanks, Darren','2001-05-08 05:03:43','2001-05-08 05:03:43',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1029,900,900,'Re: Re: Re: Re: Re: Re: Uploading images','CExpert','where do you put the routine that handles the  ''when the file is uploaded'' part?','2001-05-08 05:04:47','2001-05-08 05:04:47',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1030,1027,1027,'Re: Uploading with PHP','CodeCharge Support','Depends on your app logic. For instance You may put it into  Form properties/Events/Before show of target page , this form will report success of failure of your upload.','2001-05-08 05:05:52','2001-05-08 05:05:52',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1031,NULL,NULL,'Sending with CDonts & getParam','Steve','I have a form which in the events (After Insert) sends a message containing the form contents. This works fine. My problem is that the first two fields in the form are Labels, obtained using \"UserID\". The first is \"Submitted_By\", which uses Join to get the persons name, and the second is \"submitted_by_email\", which uses Join to get the persons email address. If in the form I use for example \"getParam(submitted_by)\", the fields are blank in the mail message. Anyone know a way I can fix this? Thanks in advance.','2001-05-08 07:18:25','2001-05-08 07:18:25',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1032,1010,1010,'Re: Sending data from a form via Email','Roger','If you are using PHP, you sound look a the mail()function. You can make it send field data as per what you want.','2001-05-08 08:10:28','2001-05-08 08:10:28',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1033,1015,1015,'Re: Re: Re: Pls tell me about cc Purchase','Adam Stock','OK. In such case you may need to make the purchase online, using your credit card, or wire the money to us. Please reply at http://support.codecharge.com if you have further questions.','2001-05-08 10:33:31','2001-05-08 10:33:31',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1034,1031,1031,'Re: Sending with CDonts & getParam','Adam Stock','Try getParam(\"submitted_by\")','2001-05-08 10:41:22','2001-05-08 10:41:22',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1035,1012,1012,'Re: Re: Re: Re: Re: Jsp Generator by Chinese,Have','Adam Stock / CC','Please submit your issue to http://support.codecharge.com That way we can investigate it and you will receive reply through email.','2001-05-08 10:58:38','2001-05-08 10:58:38',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1036,1012,1012,'Re: Re: Re: Re: Re: Re: Jsp Generator by Chinese,H','Adam Stock / CC','By the way, are you generating JSP with templates or just JSP ? Please provide the answer when submitting your case to the support system.','2001-05-08 11:01:11','2001-05-08 11:01:11',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1037,1031,1031,'Re: Re: Sending with CDonts & getParam','Steve','Actually, that is what I''m currently using, I forgot the quotes in my first message. My event contains the following:  mail.Body = \"Description: \" & getParam(\"description\") & Chr(13) & _ \"Submitted By: \" & getParam(\"submitted_by\") mail.BodyFormat = 0 mail.Send Set mail = Nothing  In the form, the two inputs are Session variables using UserID. I get the values using join. Perhaps I am just doing this the wrong way?','2001-05-08 12:20:38','2001-05-08 12:20:38',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1038,977,977,'Re: Re: Re: Searching Multiple Tables','Garry Lowther','Just beneath the Forms (+icon) grey line,  you should see the word Search (>). There should be another word to the right of this representing the actual displayed grid. Select it. Then click the properties icon to the right of the Name field. This should open up a browser window with an SQL tab?  P.S. even though I have just downloaded this  product, I like it so much I thought I would chip in!!!','2001-05-08 13:33:50','2001-05-08 13:33:50',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1039,NULL,NULL,'cold fusion and events','Chris','I want to modify my login action page. When a user is successfully logged in, I want to redirect them to a different page. What is the correct syntax and should I use the \"onLogin Event\"?  Thanks in advance.','2001-05-08 14:29:06','2001-05-08 14:29:06',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1040,994,994,'Re: Re: Re: Can Someone Help a Beginner?','martin dorren','i have several customers that are on unix servers.  is there a way to use a simple comma-delimited  text file for a database on a unix server?','2001-05-08 19:27:44','2001-05-08 19:27:44',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1041,986,986,'Re: Re: Re: Re: multiple fields in text files.','sam moses','Oh, I get it Thanks for your time. It should work on the same driver.','2001-05-08 23:10:48','2001-05-08 23:10:48',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1042,994,994,'Re: Re: Re: Re: Can Someone Help a Beginner?','CodeCharge Support','You can download and install  download DBD::CSV perl module. Since CC uses DBI, it will work with flat csv file like with a usual database.','2001-05-09 04:15:02','2001-05-09 04:15:02',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1043,1039,1039,'Re: cold fusion and events','CodeCharge Support','Basically \"Form action\" attribute at Login page serves the purpose of such redirection , but if you still want to write your code in events I suggest to use \"Custom login\" event , where you should duplicate CC generated code for Login action , but change or apend redirection code to the end of this standard code. Code must be like below               <CF_GETPARAM NAME=\"Login\" TYPE=\"Text\">             <CFSET sLogin=PARAM_VAL>             <CF_GETPARAM NAME=\"Password\" TYPE=\"Text\">             <CFSET sPassword=PARAM_VAL>                          <CF_TOSQL VALUE=\"#sLogin#\" TYPE=\"Text\">             <CFSET sLoginToSql=TOSQL>              <CF_TOSQL VALUE=\"#sPassword#\" TYPE=\"Text\">             <CFSET sPasswordToSql=TOSQL>              <CFSET tmpWhere=\"member_login =\" & sLoginToSql & \" and member_password=\" & sPasswordToSql>             <CF_DlookUP APP_NAME=\"#APP_NAME#\" TABLE=\"members\" sField=\"count(*)\" sWHERE=\"#tmpWhere#\">              <CFIF (DLOOKUP NEQ 0) AND (DLOOKUP NEQ \"\")>               <CFSET tmpWhere=\"member_login =\" & sLoginToSql & \" and member_password=\" & sPasswordToSql>               <CF_DlookUP APP_NAME=\"#APP_NAME#\" TABLE=\"members\" sField=\"member_id\" sWHERE=\"#tmpWhere#\">               <CFSET Session.UserID=DLOOKUP>                                <CF_DlookUP APP_NAME=\"#APP_NAME#\" TABLE=\"members\" sField=\"member_level\" sWHERE=\"#tmpWhere#\">                 <CFSET Session.UserRights=DLOOKUP>                               <CFPARAM NAME=\"querystring\" DEFAULT=\"\">               <CFSET sQueryString = querystring>               <CFPARAM NAME=\"ret_page\" DEFAULT=\"\">               <CFSET sPage = ret_page>                <CFOUTPUT>               <PRE>               sPage=\"#sPage#\"               CGI.SCRIPT_NAME=\"#CGI.SCRIPT_NAME#\"               sQueryString = \"#sQueryString#\"               tmpURL=\"#sPage#?#sQueryString#\"               </PRE>               </CFOUTPUT>                              <CFIF CompareNoCase(sPage,CGI.SCRIPT_NAME) NEQ 0>                 <CFSET tmpURL=sPage&\"?\"&sQueryString>                 <CFLOCATION URL=#tmpURL#>               </CFIF>                                 <!--- CFLOCATION URL=\"ShoppingCart.cfm\"--->                            <CFELSE>                <CFPARAM NAME=\"querystring\" DEFAULT=\"\">               <CFPARAM NAME=\"ret_page\" DEFAULT=\"\">                <CFSET sLoginErr = \"Login or Password is incorrect\">             </CFIF>','2001-05-09 04:58:05','2001-05-09 04:58:05',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1044,998,998,'Re: hiding fields, depending on the action upd/del','Wakie','You can use Lable with \"HTML\" checkbox checked in \"Field properties\". Use \"Before show event\" in events tab.  if event=\"in\" then fldyourlabel=\"<input type=text name=yourlabel>\"  So it will only display value if it''s update and display textbox in case it''s insert. Fldyourlabel contains value of field named \"yourlabel\".  CC automatically creates variables for form/database fields. They contain field values that you can feel free to change. \"fld\" is a standard prefix for cc field variable. For instance if field name is price then corresponding cc variable is named fldprice. You can manipulate them through events.','2001-05-09 05:53:22','2001-05-09 05:53:22',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1045,NULL,NULL,'JSP and Access','alex','hi all,  i''ve got an access database and i''m wanting to make a jsp page with the data. but i don''t know where to start  any help would be greatly appreciated  Alexandra','2001-05-09 05:52:30','2001-05-09 05:52:30',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1046,1045,1045,'Re: JSP and Access','Adrian Lasso','If you are developing in Windows with JSP, you can use JDBC-ODBC bridge that comes with the JDK.','2001-05-09 06:29:39','2001-05-09 06:29:39',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1047,1039,1039,'Re: Re: cold fusion and events','Chris','I can''t believe it was that simple. My problem was that I created the login page before any other pages. It didn''t have any other options at the time I created the login page, so I guess it just defaults.  Thanks so much. You''ve been more than helpful.','2001-05-09 08:45:38','2001-05-09 08:45:38',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1048,NULL,NULL,'mailto:email','chris','If I''m only storing the email address and not the mailto hyperlink, how do I output mailto link for email?  Thanks','2001-05-09 09:44:45','2001-05-09 09:44:45',3);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1049,1048,1048,'Re: mailto:email','Jason','<a href=\"mailto:<%Response.form \"<%email_address%>\">Email me</a> I think this will work, ofcourse you must do the select from * table name.  good luck, let me know if that worked.','2001-05-09 11:03:47','2001-05-09 11:03:47',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1050,1048,1048,'Re: Re: mailto:email','Chris','Jason,  Actually, I was wondering how to do it in CodeCharge. There doesn''t seem to be a way to do it. From what I''ve seen so far you can hyperlink the email addresss to some page but not to mailto?  Any suggestions?','2001-05-09 11:19:05','2001-05-09 11:19:05',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1051,1010,1010,'Re: Re: Sending data from a form via Email','Ryan Kelley','I can not get this to work.  Will it work on a linux box with the cdont mail?','2001-05-09 11:50:33','2001-05-09 11:50:33',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1052,900,900,'Re: Re: Re: Re: Re: Re: Uploading images','Paul WOlsink','Hi there  Sounds very interesting and just what I would  like to do. An image and thumbnail. Do you have  some code or something?  regards Paul','2001-05-09 12:56:08','2001-05-09 12:56:08',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1053,1010,1010,'Re: Re: Sending data from a form via Email','Ryan Kelley','There is no GetParam function for php at least i cannot get it to work like it does in the tell a friend example','2001-05-09 13:17:46','2001-05-09 13:17:46',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1054,1013,1013,'Re: Re: Re: How to implement mult-select lists?','clarion','Actually, if you use the query tab, the columns returned  by the SQL query are available in the fields dropdown. Also note that the table dropdown is disabled if you enable the SQL query.  In short, no need to add your fields to the list. They  are automatically added to the list by codecharge. This is really good. It actually parses your SQL and  reports errors in it too.','2001-05-09 13:09:28','2001-05-09 13:09:28',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1055,NULL,NULL,'Copy or Paste to Windows Clipboard','Stan Sloan','Is it possible to copy / paste in the page properties Header and Footer fields?','2001-05-09 13:35:18','2001-05-09 13:35:18',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1056,1055,1055,'Re: Copy or Paste to Windows Clipboard','kmc','Yes, but not with mouse! Use the Ctrl_c,x,v combos and it works.','2001-05-09 14:52:45','2001-05-09 14:52:45',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1057,NULL,NULL,'Activation Code problem','Client','Hello CC team.. I have purchased the product which is very nice..and waiting for the new releases... My problem is that i have already used 3 activation code, through the website to install the software on my PC..And i cannot obtain another Activation Code to install it a fourth time... What is the problem..?I am often formatting my PC and i need to have an Activation Code for Once.. please Help..','2001-05-09 23:35:00','2001-05-09 23:35:00',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1058,NULL,NULL,'How to deal with remote MySQL Server','Angel Ivanov','I use PHP4 with MySQL. I do my projects on my PC using MS Access to design the database tables. When I''m ready with the pages I publish them onto my FTP. But nothing happens with the MySQL database on the remote server - it remains empty. Do I need to set the tables in the remote MySQL server by myself or CodeCharge does it for me using the Access tables?','2001-05-10 01:30:17','2001-05-10 01:30:17',5);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1059,1058,1058,'Re: How to deal with remote MySQL Server','Wakie','CodeCharge provider sql scripts that will create and fill database table for those examples. Sql scripts are located at  <path-to-cc>/CodeCharge/Examples/<Example-name>/SQL directory','2001-05-10 02:01:42','2001-05-10 02:01:42',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1060,1058,1058,'Re: How to deal with remote MySQL Server','Wakie','CodeCharge provider sql scripts that will create and fill database table for those examples. Sql scripts are located at  <path-to-cc>/CodeCharge/Examples/<Example-name>/SQL directory. Run proper sql script against your database.','2001-05-10 02:01:42','2001-05-10 02:01:42',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1061,1058,1058,'Re: Re: How to deal with remote MySQL Server','Angel Ivanov','This scripts work great! Does CodeCharge generates such  scripts for newly designed projects  or I''ll have to do them by myself?','2001-05-10 02:34:01','2001-05-10 02:34:01',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1062,1057,1057,'Re: Activation Code problem','CodeCharge Support','Please sumit this request to support.codecharge.com','2001-05-10 03:01:12','2001-05-10 03:01:12',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1063,979,979,'Re: site made with codecharge','Tom Fisk','www.marionrcflyers.org','2001-05-10 05:54:47','2001-05-10 05:54:47',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1064,1058,1058,'Re: Re: Re: How to deal with remote MySQL Server','CodeCharge Support','For new projects you should create sql scripts for creating and filling tables by yourself','2001-05-10 07:59:02','2001-05-10 07:59:02',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1065,1058,1058,' Re: How to deal with remote MySQL Server','Angel Ivanov','Thanks for the Help.','2001-05-10 08:16:22','2001-05-10 08:16:22',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1066,NULL,NULL,'Uploading Files with CC','Vorbis','Does somebody knows a way to create ''upload files'' form with CodeCharge? How can then the files URLs be used in forms?','2001-05-10 10:44:28','2001-05-10 10:44:28',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1067,930,930,'Re: Warning: Missing argument 2 in call to tosql()','Neil.','You need to ask support for an update - I got the same message and that fixed it.','2001-05-10 10:46:18','2001-05-10 10:46:18',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1068,1010,1010,'Re: Re: Re: Sending data from a form via Email','Joachim Uersfeld','At http://www.codecharge.com/download/?templ=examples&example_id=10 is a working example for PHP.','2001-05-10 11:44:04','2001-05-10 11:44:04',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1069,1010,1010,'Re: Re: Re: Re: Sending data from a form via Email','Ryan Kelley','I have gotten my form to send an email to me but now i also need it to send the same data to a table that i set up and i cannot get it to work.  I have tried the example in the tell-a-friend for this by adding more fields but it does not work.  Can anyone please help?','2001-05-10 14:47:08','2001-05-10 14:47:08',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1070,946,946,'Re: Re: Record Form - Needs Tabular Display, N/A y','Miguel Angel','How can we do that now? Make rutine or a Programing some event?','2001-05-10 19:31:43','2001-05-10 19:31:43',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1071,979,979,'Re: site made with codecharge','Vluhurg','If you would like to see an example of some heavily post-processed CodeCharge output, take a look at:  http://kaa.d2g.com/  The Members, Calendar, Results and News pages are all database driven. The rest is vanilla HTML.  Formatting was done using Dreamweaver.  --  V.','2001-05-11 02:01:26','2001-05-11 02:01:26',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1072,1048,1048,'Re: Re: Re: mailto:email','Dean Murphy','Chris,  CodeCharge does not have any way of automatically generating hyperlinks.  There is however an easy solution to the problem. The solution uses the ''Before Show'' event to trigger some code that will pre-process the field output. If you are not familiar with Events, don''t worry it''s pretty straight forward.  The ''Before Show'' event allows you to execute some server side code just before the page is displayed.  Let''s say your email addresses are stored in a field called Email. What we want to do is grab the contents of the Email field, wrap it with <A HREF=\"mailto:...\"></A> so the email address will be displayed as a hyperlink in the browser window.  In the Events tab for the Email field, click on ''Before Show''. Your code for the Before Show event should (if you are using ASP) look like this:  fldEmail = \"<A HREF=''mailto:\" & fldEmail & \"''>\" & fldEmail & \"</A>\"  That''s it. Simple.  Hope this helps  --  Dean deanpm@ntlworld.com','2001-05-11 02:09:57','2001-05-11 02:09:57',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1073,997,997,'Re: I need help setting up this ODBC','Angel Ivanov','I had the same problem in the beginning.  It works with the MySQL ODBC driver. Then I choosed to design my tables in Access,  and then to write SQL scripts that create  the proper tables on my remote MySQL database it works perfectly.','2001-05-11 04:07:08','2001-05-11 04:07:08',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1074,1066,1066,'Re: Uploading Files with CC','CodeCharge Support','There is no built-in upload facilities in CC. However you can easily add your upload html code through Header&Footer and script code to CC events on target script page. As to file''s urls there is a build-in feature for it , set field type to URL , click field properties icon , check \"Use url field\" box and selected db field containig url.','2001-05-11 03:56:00','2001-05-11 03:56:00',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1075,NULL,NULL,'Session UserID in Detail page','SPF','Hi,  I setup a Grid/Edit (Two Pages). The first page shows all entries and links by a field called description to the edit page. The edit page is used to get the current user''s ID,name, and email, enter them in the current record and also email that info. The problem is that I cannot seem to get the page to recognize UserID as long as the form param is present. For example, if I load the page WITHOUT ''\"?ID=100'', the fields display the current user''s info. It also has a field that should update on the edit page called \"Submit_Date\". This field contains no data unless I get rid of the \"?ID=100\". I have a before show event that looks like this: fldSubmit_Date=Now() Anyone else have this problem?','2001-05-11 07:25:42','2001-05-11 07:25:42',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1076,1075,1075,'Re: Session UserID in Detail page','SPF','Problem solved. I created my own field and assigned the default value as =Session(\"User_ID\") I then made my Before Show events assign the real field to this value and used DLookUP to assign the others.  If anyone has any better ideas, I''d like to hear them.','2001-05-11 08:13:19','2001-05-11 08:13:19',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1077,NULL,NULL,'how I could validate before eliminating.','cvargas',' how I could validate before eliminating. controlling two tables. that one could not eliminate a registration of the table chield if there is a related registration with the table parent.   Using PHP/Mysql/Apache','2001-05-12 02:36:11','2001-05-12 02:36:11',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1078,1066,1066,'Re: Re: Uploading Files with CC','hmm, the message is not clear acutallly, what does',NULL,'2001-05-12 14:07:34','2001-05-12 14:07:34',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1079,NULL,NULL,'Wouldn''t this be better in Java?','Anonymous Coward (-1 Troll)','Don''t get me wrong, CodeCharge is great.  I even got my boss to buy it.  But I would have been a lot happier if this was coded in Java.  Or a port to Linux and MacOS.  I hate having to run to a Windows box to use it.','2001-05-12 21:10:59','2001-05-12 21:10:59',7);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1080,1079,1079,'Re: Wouldn''t this be better in Java?','bananachunks','Ah, now that''s a feature request I would like to second....!  =D','2001-05-13 02:54:52','2001-05-13 02:54:52',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1081,NULL,NULL,'Getting the next number from another table','Jim R.','I have a entry screen to add records to a table named results. The field is called EWO. I want to look up the next number in a field called order in another table named nextnumber. I want to assign it to the results table and show it as a label so it can''t be changed. Upon completion of the entry form, I want to update both tables so the next time an order is entered it will increment the next number getting it from the nextnumber table. What is the best way to do this in ASP? I''m new to Codecharge and ASP. A detailed description would be greatly appreciated.','2001-05-13 09:05:34','2001-05-13 09:05:34',4);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1082,NULL,NULL,'Writing SQL','clarion','I have a grid that I want to search using fields from two tables. Case in point, the grid has book name and author name from tables books and authors respectively. The author name is displayed using the author id and using the join feature of CodeCharge. Now, in order to search using both these fields, I need to write my own SQL so that the ''author_name'' field from the ''authors'' table can be selected from the input tab of the grid form. I could not get this to work as CodeCharge assigns a prefix like b_bookname, b_authorid, a_authorname, etc. when it writes the SQL. The question is how do I write the SQL the way CodeCharge generates them?  Or is there a better way of accomplishing what I want?  I don''t want a drop down of authornames and search on authorid because it slows down the page as the authors can be in the hundreds or thousands.','2001-05-13 11:31:46','2001-05-13 11:31:46',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1083,NULL,NULL,'I get the following sesion error when I run...','Obirsen','CodeCharge generated PHP sites using Apache Web Server and a MSAccess database using an ODBC connection:  Warning: open(/tmp/sess_bf6805780cf5cc48acd1f162d65b90ab, O_RDWR) failed: m (2) in c:\\program files\\apache group\\apache\\htdocs\\default.php on line 11   It appears that the part of the code retrieving info from the database works fine but there is a problem starting a temp session or someting...Can anyone help?  Thanks, obirsen','2001-05-13 16:16:42','2001-05-13 16:16:42',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1084,1079,1079,'Re: Re: Wouldn''t this be better in Java?','markus','me too....  java or mac OSX version....','2001-05-13 21:11:57','2001-05-13 21:11:57',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1085,685,685,'Re: Re: Is it a good product ?','Garry Lowther','I agree with the above positive comments. For the price, it is extremely good value for money. I have zero ASP experience, but I do know databases and SQL. I have very little HTML too. CodeCharge generated my entire database app in ASP/HTML. I can easily tweak it using notepad/front page if I want. I can get the application in front of customers in a fraction of the time. I also know that I can generate the same app in ASP/JSP/PHP etc.. and it will run on any platform. For $149 you get all of this?  P.S. I also have no relationship with YesSoftware, other than being a happy customer.  Garry.','2001-05-13 23:32:25','2001-05-13 23:32:25',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1086,1081,1081,'Re: Getting the next number from another table','CodeCharge Support','You will need to use CodeCharge''s events mechanism. Select your form , open \"Form properties\"/Events/ \"Before insert\" event and type in code similar: ========================= fldmynumber = dlookup(\"mytable\",\"my field\",\"a=b\") ========================= This way we fill in one of fields subject to insertion. CC automatically creates variables for form/database fields. They contain field values that you can feel free to change. \"fld\" is a standard prefix for cc field variable. For instance if field name is price then corresponding cc variable is named fldprice. You can manipulate them through events. CC doesn''t automatically make multiple inserts so you must write another insert by yourself using already created by cc connection object variable named \"cn\" , like cn.execute (insert_statement)','2001-05-14 05:41:02','2001-05-14 05:41:02',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1087,1083,1083,'Re: I get the following sesion error when I run...','wakie','This kind of error means that PHP tries to store session information in unexisting directory. To set it up correctly you must open your php.ini file (usually residing in winnt or windows catalog) , find session_save_path variable and set to to existing directory where PHP will store seesion info , e.g c:/windows/temp','2001-05-14 06:47:52','2001-05-14 06:47:52',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1088,1082,1082,'Re: Writing SQL','CodeCharge Support','Just simply write your own custom sql statement , no need for special prefixes , I''d just  advice you to use aliases for the fields you want to fetch.','2001-05-14 07:04:44','2001-05-14 07:04:44',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1089,1083,1083,'Re: I get the following sesion error when I run...','Roger','I had this error when started. I just created a /tmp directory and PHP is happy.  Hope it helps.','2001-05-14 10:41:00','2001-05-14 10:41:00',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1090,NULL,NULL,'Search with Range of Values','lisa','Trying to search a date column for a range of dates and display the  output in the Grid on the same page.  In the search form, I have two fields named start_date and end_date.  I want to search the date column for all rows between start_date and end_date.  I have tried using an SQL Where/Between/And statements in the Grid Form > Properties > SQL using this statement in the Where box:   date_col BETWEEN ''start_date'' and ''end_date''  As soon as I insert an SQL statement, with the ASP & Access, the Grid is not displayed.  Using PHP & MySQl, the Grid is displayed (without any contents).  What am I doing incorrectly?  Is there an easier way to search for rows with a certain criteria inputted by the user?  Thanks, Lisa','2001-05-14 11:04:29','2001-05-14 11:04:29',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1091,1081,1081,'Re: Re: Getting the next number from another table','Jim R.','I tried inserting the statement in the form  under the form properties/Events/\"Before insert\" event. It''s not showing the number on the form.  Here''s the statement I''m using:  fldewo = dlookup(\"nextnumber\",\"order\")   The field name is \"ewo\" that is on the form that  will be input into the results table.  Nextnumber is the name of the table I''m trying to get the number from. The field \"order\" is the  name of the field in the nextnumber table.  Both tables are in the same database.   Is there an example of what i''m trying to  accomplish in one of the examples that came  with CC?  Please help!  P.S. Your reply seems to have been cut off in some parts.  \"must write another insert by yourself using  already created by cc connection object\"','2001-05-14 11:18:53','2001-05-14 11:18:53',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1092,1081,1081,'Re: Re: Re: Getting the next number from another t','clarion','Isn''t the third parameter to dlookup missing in your  example.  fldewo = dlookup(\"nextnumber\",\"order\")','2001-05-14 12:35:17','2001-05-14 12:35:17',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1093,1081,1081,'Re: Re: Re: Re: Getting the next number from anoth','Jim R.','I''ve tried them all. With spaces/with out spaces. adding the third parameter/without the third  parameter:  fldewo = DLookup(\"nextnumber\", \"order\", \"order_id = 1\")  fldewo = DLookup(\"[order]\", \"nextnumber\", \"[order_id] = 1\")  fldewo = DLookup(\"[nextnumber]\", \"order\", \"[order_id] = 1\")  etc......  According to MSDN, and the Microsoft Access help,  the third parameter is optional.  Also the way that MSDN explains the usage of  dlookup()is:  fldmynumber = dlookup(\"myfield\",\"my table\",\"a=b\")      DLookup(Expression, Domain [, Criteria])  The function has three arguments: expression,  domain, and criteria.  (Note that the criteria argument is optional.)   You use the expression argument to identify the  field that contains the data in the domain that  you want returned or to perform calculations  using the data in that field.   The domain argument is the name of the record  set that identifies the domain. It can be a  table or a query name.','2001-05-14 13:38:39','2001-05-14 13:38:39',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1094,NULL,NULL,'MULTIPLE FIELD PRIMARY KEY','sinisa','How can I suppot a table with primary key that consists of 2 or more fields (in my case 3). Each record in the table is unique (primary key set to) by ENTRY_DATE, USER_ID and PROMOTION_ID fields. CC can use only tables with simple primary keys.  Is there any way?','2001-05-15 01:21:39','2001-05-15 01:21:39',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1095,NULL,NULL,'Invalid SQL stetement created','Goran','Situation:  I have a list of records and I want to join one field so that insead of the field''s value - a value from another table is written (option join on the field properties, when form type Grid is used and field is of type Label)  The system generates invalid SQL statement in FROM part:  select D.ACCOUNT_ID as D_ACCOUNT_ID, D.DEAL_ID as D_DEAL_ID, D.FIRST_NAME as D_FIRST_NAME, D.LAST_NAME as D_LAST_NAME, D.USERNAME as D_USERNAME, D.USER_ID as D_USER_ID, D1.TISM_ID as D1_TISM_ID, D1.DEAL_DESC as D1_DEAL_DESC  from DIM_USER_DATA D, DIM_DEAL_TISM as D1  where D1.TISM_ID=D.DEAL_ID   note:  from DIM_USER_DATA D, DIM_DEAL_TISM as D1   where word ''as'' occurs. This of course won''t pass thru ORACLE and oracle returns error.  Help would be appreciated.','2001-05-15 05:35:45','2001-05-15 05:35:45',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1096,1095,1095,'Re: Invalid SQL stetement created','wakie','the quick solution is to type in oracle-correct statement right in \"form properties\"/sql tab','2001-05-15 07:41:09','2001-05-15 07:41:09',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1097,1090,1090,'Re: Search with Range of Values','wakie','0)>using this statement in the Where box:  >date_col BETWEEN ''start_date'' and ''end_date''  if start_date is variable use it like this :  BETWEEN \" & start_date& \" and \"& end_date& \"   this is how dynamic  parts of where clause are used in CC ,start_date should variables defined above.  1) Try to debug your sql statement in from sql command line . 2) Between may not include right boundary dates , I mean if end_date is 1/1/2000 you must change it to 1/1/2000 23:59:59 , otherwise whole day will be lost.','2001-05-15 07:46:27','2001-05-15 07:46:27',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1098,1077,1077,'Re: how I could validate before eliminating.','wakie','use form properpties/events/before delete event , check if child record exists by calling dlookup function  dlookup is a cc function for quick look into a database , 1st param is table , 2n is a field we fetch , 3rd is a condition  if child record exists , then redirect to another page.','2001-05-15 08:02:40','2001-05-15 08:02:40',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1099,1095,1095,'Re: Re: Invalid SQL stetement created','Goran','I know that, but what if I add another field, or change the for, besides this happens on all forms, so basically your method would request that I do changes each time I do some additional work. I got the select CC creates by printing the SQL statement before it get''s executed, I don''t know it before.  Now either this is a bug, or I''m doing something very wrong (both could be true) but the best thing is to get a correct answer without patches :)','2001-05-15 08:06:12','2001-05-15 08:06:12',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1100,NULL,NULL,'Own templates for projects','Mike','Is it possible to define your own web templates in CC. i.e. I''m workin on a portal that already has defind structure (menues on the eft, meues on the right, etc) and I would like to use that template and enter the tables CC creates somewhere in that template.  Is that possible?  Now every time I recompile my changed html files get overwritten...','2001-05-15 08:12:11','2001-05-15 08:12:11',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1101,NULL,NULL,'Search using date range parameters not in table','Garry Lowther','I have a search form and I want to search for all records in a table where a date field is between 2 dates entered by the user i.e. a start and end date. I create the start and end fields on the search form as they do not exist in the table, and specify them as input parameters to the grid form. When I compile the page, I get an Attribute: Field - Attribute required error. What am I doing wrong, or must the ASP be hand coded for range searches?  Garry.','2001-05-15 12:09:57','2001-05-15 12:09:57',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1102,1090,1090,'Re: Re: Search with Range of Values','lisa','Well, that was one problem - how to reference variables.   Have now done that as wakie stated, but still doesn''t work.  In the Where box of SQL properties of the Grid form, I changed the between statement to:   date_col BETWEEN \" & start_date& \" and \"& end_date& \"  This still doesn''t work and the GRID form is not displayed at all (same problem as before).   Any other suggestions?','2001-05-15 13:43:56','2001-05-15 13:43:56',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1103,1100,1100,'Re: Own templates for projects','Roland','In my opinion this _should_ be possible.  Try to put the elemts in {braces} in your own HTML-Template and uncheck \"Generate HTML\" in Page Properties. But be careful as long as you are still under development: CC doesn''t generate correct HTML-links as long as you don''t let create it the HTML-Template also.','2001-05-15 23:30:40','2001-05-15 23:30:40',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1104,1094,1094,'Re: MULTIPLE FIELD PRIMARY KEY','CodeCharge Support','Sinisa, you can use some fields as primary key, on the form select this fields as \"Key\". And note, if you select ENTRY_DATE,  USER_ID and PROMOTION_ID fields as primary key  on Grid form, you should select them as  primary key on Record form also.','2001-05-16 00:45:53','2001-05-16 00:45:53',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1105,1101,1101,'Re: Search using date range parameters not in tabl','CodeCharge Support','Garry, you shouldn''t set, let''s say, sart_date and  end_date as input parameters for grid.  - If the search on this fields is obligatory then you can add them in SQL tab ''Where'' clause  like: date_field > \"&GetParam(\"start_date\")& \" and date_filed <\" &GetParam(\"end_date\")   - If the search on this fields isn''t obligatory  and they may be empty then you''d better define ''Open'' event for grid form like: if not (GetParam(\"start_date\") = \"\") and not(GetParam(\"end_date\")= \"\") then sWhere = sWhere & \" and date_field > \"& GetParam(\"start_date\")& \" and date_filed < \" &GetParam(\"end_date\") end if','2001-05-16 01:00:38','2001-05-16 01:00:38',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1106,900,900,'Re: Re: Re: Re: Re: Re: Uploading images','Nils Teller','Pleeeaaase give us an URL ...','2001-05-16 02:33:03','2001-05-16 02:33:03',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1107,NULL,NULL,'Cold Fusion and CFQUERY type=\"odbc\"','Tom Fisk','Why does the template for the <CFQUERY> in the action.cfm file include the type=\"ODBC\" parameter?  This seems redundant with CF when you have to go into the CF Admin and define the datasource anyway.  I am hooking to a Sybase datasource and I have to remove the type=\"ODBC\" from each <CFQUERY> in the action.cfm files because I want to use the native driver.  Is there a way around this?','2001-05-16 08:55:43','2001-05-16 08:55:43',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1108,NULL,NULL,'Dan','Trying to connect to my Hosting SQL','Hi, I''m currently using the trial version of Code Charge.  I''m trying to connect to my SQL server under Data Link Properties. I entered my domain name, username and password. And the database name on the server.  But when I do Test Connection, it comes back \"Specified Server name not found\".  Isn''t the server name supposed to be the domain name of my website?','2001-05-16 14:14:44','2001-05-16 14:14:44',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1109,NULL,NULL,'How to make sessions only valid for a limited time','Maurits de Lo?','Problem: I need to use sessions that are only valid during the visit to the site. If a user goes to an external site the sessions should \"die\".  A user should still be able to logoff but...most people don''t...  Environment: linux and php4 AND linux and coldfusion  Any help would be appreciated.','2001-05-16 23:43:46','2001-05-16 23:43:46',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1110,1108,1108,'Re: Dan','CodeCharge Support','It''s not necessarily  so , it may be a different host. I suggest you to ask your ISP for full information about ip/login/password','2001-05-17 04:07:41','2001-05-17 04:07:41',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1111,1109,1109,'Re: How to make sessions only valid for a limited','wakie','1) session_set_cookie_params() u  Set the session cookie parameters  2) session.cookie_lifetime specifies the  lifetime of the cookie in seconds which is sent to the browser. The value 0 means \"until the browser is closed.\" Defaults to 0.  Add it to your login page open event','2001-05-17 04:24:22','2001-05-17 04:24:22',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1112,NULL,NULL,'On MouseOver or Drop down menu Supported in CC','Stan Sloan','Are the mouse over or drop down menu type of functions used for this site generated in Codecharge? If not, how are they incorporated?  Thanks','2001-05-17 04:58:29','2001-05-17 04:58:29',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1113,1107,1107,'Re: Cold Fusion and CFQUERY type=\"odbc\"','CodeCharge Support','Tom, probably you use old version of CodeCharge. This problem is alredy solved in newer one. Please download and install: http://www.codecharge.com/download/files/CodeChargePatch24.exe','2001-05-17 06:56:13','2001-05-17 06:56:13',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1114,1112,1112,'Re: On MouseOver or Drop down menu Supported in CC','CodeCharge Support','Stan, this dropdown menu isn''t generated by CodeCharge. JScript was used to create it. In CC project you can also use JScript.','2001-05-17 07:24:19','2001-05-17 07:24:19',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1115,900,900,'Re: Re: Re: Re: Re: Re: Re: Uploading images','BradleyMiller','Ok --- you can try it out at this page:  http://www.mopower.com  Follow the page in and select \"I''m already signed up\".  I have a username/password setup of: username: code password: code  You can go into the driver bios area and upload a photo.  (If you get the \"no records\" message, just click on a column to sort and it will show you the insert link.  I don''t know what is causing that little gem.)  You can also add a car with multiple pictures, and times with a scan of a timeslip.  (This is for drag racing FWD Dodge/Mopar  cars.)    I have a version of the upload program for PHP and now one for Cold Fusion also.  -- Bradley Miller','2001-05-17 07:36:20','2001-05-17 07:36:20',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1116,NULL,NULL,'User login only if approved?','BradleyMiller','Is there a way to allow the username/password to only work if it''s been approved?  I''m working on a site now that people can request a UserName/Password and specify what they want.  If they enter that info, then they can go to the login screen and login.  I need to check the \"Approved\" flag I have in the table to see if they''re really approved.  Any suggestions?','2001-05-17 07:42:27','2001-05-17 07:42:27',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1117,1116,1116,'Re: User login only if approved?','wakie','Yes , it''s possible , define your own security function in Modules section , this function will replace default check_security() function. It will check if \"Approve\" flag is on and if it''s off it will redirect to a different page. Call this function from Page/\"Custom secirity\" event if page is subject to authentication.','2001-05-17 07:56:26','2001-05-17 07:56:26',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1118,1079,1079,'Re: Re: Re: Wouldn''t this be better in Java?','wakie','btw , CC runs pretty smoothly under win emulator on MacOS','2001-05-17 08:34:37','2001-05-17 08:34:37',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1119,1116,1116,'Re: Re: User login only if approved?','BradleyMiller','Hmm -- actually, I think I know what you''re doing or suggesting, but I''m not quite that familliar with CodeCharge yet . . . YET.   Instead I got creative on this.  The form asks for username/password but stores password in RequestedPassword column of database.  When the admin person approves the person I have this statement execute \"after update\" in the database:  if ($fldApproved) { $sSQL = \"update Users set Password = ''\".$fldRequestedPassword.\"'' where \" . $sWhere;  $db->query($sSQL);  }  It works like a charm -- if your not approved, your RequestedPassword is never moved to the Password column, so you can never get in.    There''s always more than one way to skin a cat!    -- Bradley Miller','2001-05-17 16:50:51','2001-05-17 16:50:51',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1120,NULL,NULL,'Storing live hyperlinks','rgillies','Hi  I am attempting to build a database of web links.  I have field called URL where I have stored the fully qualified domain name.  In the grid/search box I can get the field to display with an apparently active hyperlink but when a user clicks on it strange things happen.  In particular the link the browser appears to follow is repeated three times, which of course leads the user nowhere.  In the page fields the field has the value of LABEL  What further info should I provide or is it _very_ obvious to someone who has used CodeCharge for more than an evening?  Ron Gillies','2001-05-17 19:07:36','2001-05-17 19:07:36',3);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1121,NULL,NULL,'Car Rental Booking','AVTAR','Hello,  please help me for creating a car rental booking in php with mysql database','2001-05-17 23:57:48','2001-05-17 23:57:48',3);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1122,1120,1120,'Re: Storing live hyperlinks','CodeCharge Support','Ron, to have correctly displaying and working links, you should of course have a table field stored full path links (http://www.codecharge.com), set field type to Label, on Field/Properties/ Common tab select ''HTML'' checkbox and define ''Before Show'' event like (for ASP): fldlink=\"<a href=\" & fldlink & \">\" & fldlink & \"</a>\"','2001-05-18 02:23:08','2001-05-18 02:23:08',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1123,1120,1120,'Re: Storing live hyperlinks','CodeCharge Support','Ron, to have correctly displaying and working links, you should of course have a table field stored full path links (http://www.codecharge.com), set field type to Label, on Field/Properties/ Common tab select ''HTML'' checkbox and define ''Before Show'' event like (for ASP): fldlink=\"<a href=\" & fldlink & \">\" & fldlink & \"</a>\"','2001-05-18 02:23:08','2001-05-18 02:23:08',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1124,1079,1079,'Re: Wouldn''t this be better in Java?','Kevin Donnelly','I agree as well.  I raised this at the beginning of the year, and was told that work was ongoing on a Java version.  Maybe that has been shelved ....?  With the explosion in open-source software use on the Web, it is a pity that such an excellent app can''t be run on Linux.','2001-05-18 06:36:46','2001-05-18 06:36:46',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1125,NULL,NULL,'need users to post meeting minutes, agendas','nelson@townofholden.net','Hi.  I want to be able to let users post agendas and minutes from many different meetings (planning, zoning, health, advisory boards,....) to the web.  Right now, they are doing everything in MS Word. I have them email me the file, I save it into html, and I then edit and post the files. This is too time consuming, and I want them to be able to either put the file somewhere, or copy/paste the info to post it to a formatted web site.  I want to have an index of the titles (meeting type and/or date) created on the fly as new agendas for future meetings are posted, and as minutes from past meetings are posted.  Is this a good way of doing it? If not, alternatives?  Email me also, as I am new to this site, and might not find my way back.  running Apache 1.3.19 on linux server  Doug Nelson nelson@townofholden.net','2001-05-18 07:01:34','2001-05-18 07:01:34',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1126,1120,1120,'Re: Re: Storing live hyperlinks','rgillies','Okay, that is a start.  Any suggestion on the syntax for PHP/mySQL?  the field name is URL, and on the grid search page it is also referred to as s_URL?   Ron','2001-05-18 11:32:54','2001-05-18 11:32:54',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1127,1079,1079,'Re: Re: Wouldn''t this be better in Java?','Cornell Rotc','Have you ever built a Java client?   Java sucks for building software and it takes too long. I''m sure these guys have better things to do with their limited time.','2001-05-18 17:02:42','2001-05-18 17:02:42',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1128,NULL,NULL,'computing totals','dante s.','When I limit the no. of records outputted on a grid, e.g. 10 records, the following navi links are added at the bottom: prev [n] next -- where n is the page no. Question: Is there a way of getting the total no. of records that are being paged on the grid?  I also need to get the total of a column on a grid form. Question: How is this done?  Thanks for any help in advance.  Best regards, Dante S.','2001-05-19 14:37:25','2001-05-19 14:37:25',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1129,NULL,NULL,'Prevent Blank Entries in Search','DB','First of all, I think Codecharge is an outstanding product and I am really enjoying it.  Excellent!  Now my question:  I have a search form set up that will let a person enter their name and find all records that match.  This is working fine, except if the person just clicks the Search button without entering any text, all records are displayed.  I have checked the Required box but this doesn''t seem to prevent a blank entry.  Is there an easy way to prevent a blank entry from being accepted?    Thanks.','2001-05-20 11:12:20','2001-05-20 11:12:20',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1130,NULL,NULL,'Do you accept Maestro or Visa Electron?','Boris','Do you accept Maestro or Visa Electron?','2001-05-20 13:49:42','2001-05-20 13:49:42',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1131,NULL,NULL,'Interbase connection','Paulo Machado','I''mm trying to connect codecharge with interbase, and althoug i can connect in design time, the generated web page can''t. I''m generating code in php, and i have used two ODBC drivers, and have no lucky with any of them.','2001-05-20 13:59:18','2001-05-20 13:59:18',4);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1132,1130,1130,'Re: Do you accept Maestro or Visa Electron?','webmaster nigeria','Don''t know if CodeCharge accept this, but it may interest you that PayPal does allow you to register your Electron card as a payment card. Once you have registered you can send CodeCharge a PayPal payment using it. Having said that most none UK merchants accept Electron as a VISA card!','2001-05-20 14:44:33','2001-05-20 14:44:33',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1133,1128,1128,'Re: computing totals','Wake','>Question: Is there a way of getting the total no. of records that are being  >paged on the grid?   Well , if you know sql statement for your grid (which you can look up from generated code) ,  you can add a grid form that will have almost the same  stetement in SQL tab , in form  select count(*) as mytotal from your-sql-stetement clauses and conditions  Add a field to your form , select mytotal from field list. Now this total will be displayed in this form.  >I also need to get the total of a column on a grid form.  >Question: How is this done?  Please see BookStore example provided with CodeCharge, ShoppingCart page, Total form. If you mean total of column at current page, you will need to use evets. You must get \"Page\" parameter and use it and number of items per page as recordset''s reference point,this way you can calculate total using your code in event.','2001-05-21 02:41:18','2001-05-21 02:41:18',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1134,1131,1131,'Re: Interbase connection','CodeCharge Support','Are you able to see resultset returned by those ODBC drivers from other applications such as Excel or Access ? It''s preferrable to use PHP''s interbase functions, in this case  your php must be compiled with interbase support.','2001-05-21 02:54:40','2001-05-21 02:54:40',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1135,1128,1128,'Re: computing totals','CodeCharge Support','If you mean total records on Grid form add a new form and create SQL statement for it like: select count(id_field) as rec_count from table  where condition_the_same_to_previous_Grid_form','2001-05-21 03:35:45','2001-05-21 03:35:45',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1136,1129,1129,'Re: Prevent Blank Entries in Search','Wake','You can check if the search string empty either at client side or at server side. 1) Place proper javascript at Form''s Footer. It must contain function checking if field''s string is empty and code that hooks this to onsubmit event. 2) At target page Grid Form / Open event , use similar code :  if IsEmpty(GetParam(\"name\")) then sWhere=\"1<>1\"  Thus , when \"name\" param is empty you will see no records since standard CC variable containing form''s sql condition now contains an impossible one.','2001-05-21 03:31:01','2001-05-21 03:31:01',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1137,NULL,NULL,'mySQL error','Louie','Hi I wonder if anyone can please help.  When I run my Codecharge application on mySQL on my PWS PC, everything works fine. However, when I copy it to my server (NT), I get the follwing error.  Microsoft OLE DB Provider for ODBC Drivers error ''80040e09''   [TCX][MyODBC]You have an error in your SQL syntax near ''[g].[GUD_AIR] as g_GUD_AIR, [g].[GUD_FUEL] as g_GUD_FUEL, [g].[GUD_PART] as g_GU'' at line 1   Can anyone help please? Thanks','2001-05-21 04:48:56','2001-05-21 04:48:56',3);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1138,1125,1125,'Re: need users to post meeting minutes, agendas','CodeCharge Support','Nelson, you can be advise to do the next: create a db with tables you need and in one of  the tables store information about meeting/agendas  (id, meeting_type, date, etc.). Using CodeCharge  you''ll let users add information about meetings  on site and they''ll be able to see  the other  customers propositions. Look at CodeCharge Forum  example, hope it''ll suit you as a basement.','2001-05-21 05:00:35','2001-05-21 05:00:35',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1139,NULL,NULL,'URL cannot be found on this server','James','Hey  I have xatimi web server, mysql and php and code charge. whilst designing an address book and testing it on my server I get the following error:  URL REQUESTED CANNOT BE FOUND ON THIS SERVER, etc...  Even when I change the pages generated in codecharge to return to the ''index (grid)'' page from a record page through the user interface it does not work  Cheers for your help  James','2001-05-21 06:44:43','2001-05-21 06:44:43',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1140,1137,1137,'Re: mySQL error','Wake','Please tell me what version of mysql server you use for development and what for production ? Or you use datasources poiting to the  the same database ? If so then it may be a connectivity problem caused by older version of MDAC or mysql ODBC driver , both available at http://www.microsoft.com/data/download_260rtm.htm and www.mysql.com recpectively.','2001-05-21 07:17:27','2001-05-21 07:17:27',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1141,1137,1137,'Re: mySQL error','Wake','What scripting language do you use ? Please tell me what version of mysql server you use for development and what for production ? Or you use datasources poiting to the  the same database ? If so then it may be a connectivity problem caused by older version of MDAC or mysql ODBC driver , both available at http://www.microsoft.com/data/download_260rtm.htm and www.mysql.com recpectively.','2001-05-21 07:17:27','2001-05-21 07:17:27',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1142,1139,1139,'Re: URL cannot be found on this server','CodeCharge Support','What is your CC version ? (Menu Help/About)','2001-05-21 07:46:49','2001-05-21 07:46:49',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1143,NULL,NULL,'jsp error','ugur','i am new on java programming ,  i installed tomcat on my NT machine, but when i am tried to run  jsp code that i generated with codecharge but i got errors ,   org.apache.jasper.JasperException: Unable to compile class for JSPE:\\TOMCAT_ROOT\\work\\localhost_8080%2Fexamples\\_0002fLINKPLUSDERGI_0002fdergisol_0002ejspdergisol_jsp_0.java:784: Incompatible type for =. Can''t convert int to java.lang.String.           sSQL = \"SELECT * FROM content WHERE active=1\" & sWhere & \"\";                 what is wrong with that code..','2001-05-21 08:30:07','2001-05-21 08:30:07',2);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1144,1143,1143,'Re: jsp error','CodeCharge Support','this expression uses inorrect symbols for concatenation, sSQL = \"SELECT * FROM content WHERE active=1\" & sWhere & \"\";  in jsp you must use not & but +  sSQL = \"SELECT * FROM content WHERE active=1\" + sWhere + \"\";','2001-05-21 09:10:26','2001-05-21 09:10:26',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1145,NULL,NULL,'(FIRST) prev [n] next (LAST)','Earl','Could someone suggest a good way to do/add the following for grids?  (FIRST) prev [n] next (LAST)  Most record based apps provide this.    TIA','2001-05-21 09:34:39','2001-05-21 09:34:39',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1146,1137,1137,'Re: Re: mySQL error','Louie','Hi I use the ASP that COdecharge generates. It seems to me that the problem is the select statements using  the following notation.  \"from table [t]\".  I cannot get these SQL selects to work using the [] notation.  Development machine version: mySQL version is Server version          3.23.38-max-debu OBDC 2.50.37.00 I am not sure of the MDAC version.  How do I find that?  Server versions: I will have to find that out.  THe Development database and the server database is not  physically the same one, the layouts are however 100% identical.  Is this enough information?  Thanks for the trouble. Louie','2001-05-21 10:12:17','2001-05-21 10:12:17',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1147,NULL,NULL,'Independent from server','b','Is it possible for me to use this to create a search engine for a CD catalog that does not connect to the internet?  I want the user to be able to search a database for keywords that will send them to a particular page.  Can I use this product to do so without going through a server and just using a stand alone database?','2001-05-21 10:56:50','2001-05-21 10:56:50',1);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1148,1121,1121,'Re: Car Rental Booking','h.luitjens@chello.nl','What can of help do you need  A Database Model B Install C functional D All of this','2001-05-21 11:08:05','2001-05-21 11:08:05',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1149,NULL,NULL,'Non Updateable Field','Andy Hanas','How do I make certain field non-updateable?  I''m using PHP  Thanks','2001-05-21 19:33:06','2001-05-21 19:33:06',3);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1150,1121,1121,'Re: Re: Car Rental Booking','AVTAR','Hi,  Thanks for your reply, well i need all of this','2001-05-21 20:58:42','2001-05-21 20:58:42',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1151,1121,1121,'Re: Re: Car Rental Booking','AVTAR','Hi,  Thanks for your reply.  I need a functional model which i can install and run it.  Regards,  Avtar','2001-05-21 20:58:42','2001-05-21 20:58:42',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1152,NULL,NULL,'Binary Upload','Richard Clement','I have made a Task Manager using the Codecharge Task Manager as a starting point which is working very well but I would like to be able to attach files to the records(eg Word and Excel) Im not bothered whether the files are stored separately or as BLOB types in the database but I do need to be able to upload them from the update page and access them from the main screen as a clickable link.  Any ideas anyone?','2001-05-21 22:00:10','2001-05-21 22:00:10',3);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1153,1147,1147,'Re: Independent from server','Wake','Yes , it''s possible as long as you know to what page redirect a user if he entered a certain keyword. What exactly do you mean by \"doesn not connect to internet\" ? Redirection and page display  requires some internet connection too.','2001-05-22 02:05:10','2001-05-22 02:05:10',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1154,1152,1152,'Re: Binary Upload','Wake','What kind of database/scriping language do you use ?','2001-05-22 02:21:51','2001-05-22 02:21:51',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1155,1152,1152,'Re: Binary Upload','Wake','What kind of database/scriping language do you use ?','2001-05-22 02:21:51','2001-05-22 02:21:51',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1156,1149,1149,'Re: Non Updateable Field','CodeCharge Support','Andy, for record form to forbid user to update certain  field set its type to ''Label''. If you don''t want to update this record in table  define own SQL statement for update in ''Before Update'' event like: $sSQL = \"update table set field1= \" .ToSQL(fldfield1, \"Text\");','2001-05-22 03:31:37','2001-05-22 03:31:37',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1157,NULL,NULL,'ERROR: getAlias argument?','cskelly@x-presso.com','This error appears for a listbox field that I have joined to a lookup table... has anyone seen this? thx','2001-05-22 05:50:30','2001-05-22 05:50:30',3);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1158,900,900,'Re: Re: Re: Uploading images','sfdfds','fdsffdd','2001-05-22 06:01:39','2001-05-22 06:01:39',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1159,1149,1149,'Re: Re: Non Updateable Field','Roger','Wouldn''t it be easier if I have a seperate form for another user to use that does not include those fields that I do not want them to update?','2001-05-22 09:43:40','2001-05-22 09:43:40',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1160,NULL,NULL,'GREAT SUPPORT !!!','h.luitjens@chello.nl','I started last week and had some questions. Never seen the reponse the give before, no matter what your question is.  Many company''s  can learn  SO IF you buy the product BUY SUPPORT You will think you in developersheaven  Keep up with the good  work Old chaps','2001-05-22 13:32:27','2001-05-22 13:32:27',5);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1161,900,900,'Re: Re: Re: Re: Uploading images','Boris','Really?','2001-05-22 13:39:59','2001-05-22 13:39:59',0);
GO

INSERT INTO messages (message_id,message_parent_id,Field3,topic,author,message,date_entered,last_reply_date,child_count) 
 VALUES (1162,1152